#!/bin/sh
# Copyright (c) 2012 Duong Vu Van <duongvu@greysonevn.com>
# This script loads driver for dfx machine
DEVICE_DIR="dev"
DEVICE_NAME="gdt2010"
DRIVER_NAME="gdt2010_asm1061"
GDSNB_KERNEL_VERSION=`uname -r`
COMMA=","

#####################################################
###### KERNEL LIST ##################################
KERNEL_1="3.1.5-gentoo"
KERNEL_2="3.10.32"
#####################################################

echo " "
echo "Remove gdt2010"
rm -f /DEVICE_DIR/${DEVICE_NAME}?
/sbin/rmmod -f $DEVICE_NAME $*

echo "Remove ahci"
/sbin/rmmod -f ahci

insmod -f /home/greystone/dfx/module/$GDSNB_KERNEL_VERSION/$DRIVER_NAME.ko
GDSNB_MAJOR=`cat /proc/devices | awk "\\$2==\"$DEVICE_NAME\" {print \\$1}"`
mknod /$DEVICE_DIR/$DEVICE_NAME c $GDSNB_MAJOR 0
