#ifndef TPMOPERATION_H
#define TPMOPERATION_H

#include <stdlib.h>	/* getenv, etc */
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>

#include "usb.h"
#include "linux.h"
#include "usbi.h"
#include "tpmdefine.h"

class TPMOperation
{
    private:
        //------------ Variables -----------------------------
        usb_dev_handle *dev_tpm;

        //------------- Functions ----------------------------
        usb_dev_handle* openTPMDevice();
        short reconnectTPMDevice();

    public:
        //------------ Variables -----------------------------
        TPM_KEYWORD_PACKAGE     tpmKeywordPackage;
        TPM_COMMAND_PACKAGE     tpmCommandPackage;

        TPM_RESPONSE_PACKAGE    tpmResponsePackage;

        //------------- Functions ----------------------------
        TPMOperation();
        ~TPMOperation();

        short   scanTPMDevice();
        void    closeTPMDevice();

        short   sendTPMKeywordPackage(unsigned char keyword, unsigned long packageLength, unsigned char* data);
        short   sendTPMCommandPackage(unsigned char commandCode, unsigned long packageLength, unsigned char* data);
        short   getTPMResponsePackage(unsigned short timeoutSec);
        short   getResponsePackage(unsigned short timeoutSec);
};

#endif // TPMOPERATION_H
