/**
 * @file tpmfunction.h
 * @author  Quang Tran <quangtran@greystonevn.com>
 * @version 1.04
 *
 * @section LICENSE
 *
 * Copyright (c) 2012-2015 Greystone Data Systems, Inc. All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF GDT.
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * @section DESCRIPTION
 *          This file describes TPM functions that are supported in DFX-G3 system.
 * @author Mr.QuangTran
 * @date Jan-22-2013
 *
 * The time class represents a moment of time.
 */

#ifndef TPMFUNCTION_H
#define TPMFUNCTION_H

#include "tpmoperation.h"

/**
  * This class contains TPM functions that are supported in DFX-G3 system.
  * @author QuangTran
  */
class TPMFunction
{
    private:
        //------------ Variables -----------------------------
        TPMOperation *tpmOperationObj;

        TPM_RESPONSE    *tpmResponse;

        //------------- Functions ----------------------------


    public:
        //------------ Variables -----------------------------


        //-------------Constructor/ Destructor---------------
        TPMFunction();
        ~TPMFunction();

        //-------------TPM Functions -------------------------
        unsigned long initTpmModule();
        unsigned long startup();
        unsigned long continueSelfTest();
        unsigned long createEKPair(unsigned short *pubKeyLength,unsigned char *pubKey);
        unsigned long takeOwnerShip(unsigned short ownerAuthLength, unsigned char *ownerAuth, unsigned short srkAuthLength, unsigned char *srkAuth, unsigned short *tpmKeyLength, unsigned char *tpmKey);
        unsigned long createWrapKey(unsigned long pakeyHandle, unsigned short pakeyAuthLength, unsigned char *pakeyAuth, unsigned short migraAuthLength, unsigned char *migraAuth, unsigned short usageAuthLength, unsigned char *usageAuth, unsigned short keytype, unsigned long keyflag, unsigned char authDataUsage, unsigned short *tpmKeyLength, unsigned char *tpmKey);
        unsigned long loadKey(unsigned long pakeyHandle, unsigned short pakeyAuthLength, unsigned char *pakeyAuth, unsigned short tpmKeyLength, unsigned char *tpmKey, unsigned long *keyHandle);
        unsigned long seal(unsigned long keyHandle, unsigned short keyAuthLength, unsigned char *keyAuth, unsigned short authDataLength, unsigned char *authData, unsigned short dataToSealLength, unsigned char *dataToSeal,unsigned short *encryDataLength, unsigned char *encryData);
        unsigned long unSeal(unsigned long keyHandle, unsigned short keyAuthLength, unsigned char *keyAuth,unsigned short authDataLength, unsigned char *authData, unsigned short encryDataLength, unsigned char *encryData,unsigned short *decryDataLength, unsigned char *decryData);
        unsigned long sign(unsigned long keyHandle, unsigned short keyAuthLength,unsigned char *keyAuth, unsigned short valueSignLength,unsigned char *valueSign, unsigned short *signatureLength,unsigned char *signature);
        unsigned long verifySign(unsigned short pubKeyLength, unsigned char * pubKey, unsigned short valueSignLength,unsigned char *valueSign, unsigned short signatureLength,unsigned char *signature);
        unsigned long getPubKey(unsigned long keyHandle,unsigned short keyAuthLength, unsigned char *keyAuth, unsigned short *pubKeyLength, unsigned char *pubKey);
        unsigned long reset();
        unsigned long flushSpecifc(unsigned long keyHandle);
        unsigned long forceClear();
        unsigned long enable();
        unsigned long disable();
        unsigned long getCapabilityVersion(unsigned short *capInfoLen, unsigned char *capInfo);
        unsigned long hardResetTPM();
        unsigned long readPubEk(unsigned short *keyLength, unsigned char *key);
        unsigned long resetMCU();
        unsigned long getSerialNumber(unsigned char serialNum[15]);
        unsigned long getRandom(unsigned long byteRequest,unsigned long* randomLen, unsigned char *random);

        unsigned long OIAP(unsigned long *authHandle, unsigned char *nonceEven);
        unsigned long OSAP(unsigned long entityValue,unsigned long *authHandle, unsigned char *nonceEven, unsigned char *nonceEvenOsap);
        unsigned long bindV20(unsigned short pubKeyLength, unsigned char *pubKey, unsigned short dataInLen, unsigned char *dataIn, unsigned short *encrydataLen, unsigned char *encrydata);
        unsigned long bindV20exam(unsigned short *encrydataLen, unsigned char *encrydata);
        unsigned long createWrapKey2(unsigned long pakeyHandle, unsigned short pakeyAuthLength, unsigned char *pakeyAuth, unsigned short migraAuthLength, unsigned char *migraAuth, unsigned short usageAuthLength, unsigned char *usageAuth, unsigned short keytype, unsigned long keyflag, unsigned char authDataUsage, unsigned short *tpmKeyLength, unsigned char *tpmKey);
};

#endif // TPMFUNCTIONS_H
