#ifndef TPMDEFINE_H
#define TPMDEFINE_H

//TPM Vendor ID and product ID
#define TPM_USB_VENDOR_ID   0x03EB
#define TPM_USB_PRODUCT_ID  0x2300

//Define endpoint in/out of USB for update FBGA
#define TPM_ENDPOINT_IN         0x01
#define TPM_ENDPOINT_OUT        0x02

//TPM package size
#define TPM_PACKAGE_SIZE        1024 //BYTE
#define PACKAGE_SIGNATURE       0xFF55


#define SUCCESS                     0x0000 /**< value if command is success  */
#define UNSUCCESS                   0x1000 /**< value if command is unsuccess  */

#define KW_PACKAGE_HEAD_SIZE        0x00000007
#define CM_PACKAGE_HEAD_SIZE        0x00000006
//define package type
#define UNKNOWN_PACKAGE             0x00
#define COMMAND_PACKAGE             0x01
#define DATA_PACKAGE                0x02
#define RESPONSE_PACKAGE            0x03
#define RESERVED_PACKAGE            0x04

//TPM Command Keyword
#define KW_STARUP              0x31
#define KW_SELFTEST            0x32
#define KW_CREATE_EK           0x33
#define KW_TAKE_OWNERSHIP      0x34
//#define KW_OIAP                0x35
//#define KW_OSAP_SRK            0x36
#define KW_CREATE_WRAP_KEY     0x37
#define KW_LOAD_KEY            0x38
#define KW_SEAL                0x39
#define KW_UNSEAL              0x61
#define KW_SIGN                0x62
#define KW_VERIFYSIGN          0x63
#define KW_GET_PUBLICKEY       0x64
#define KW_TPM_BINDV20         0x65
#define KW_GET_CAPABILITY      0x74
#define KW_RESET               0x75
#define KW_FLUSH_SPECIFC       0x76
#define KW_FORCE_CLEAR         0x77
#define KW_ENABLE              0x78
#define KW_DISABLE             0x79
//#define KW_CHECK_TPM_PRESE     0x70

//TPM Command Code
#define SEND_KEYWORD_COMMAND            0x40
#define SEND_PACKAGE_COMMAND            0x41
#define SEND_RESET_COMMAND              0x42
#define SEND_RESET_MCU                  0x43
#define REQUEST_SERIAL_NUMBER_COMMAND   0x50

//TPM Package Structure
typedef struct TPM_KEYWORD_PACKAGE
{
    unsigned long   length;
    unsigned char   type;
    unsigned char   code;
    unsigned char   keyword;
    unsigned char   data[TPM_PACKAGE_SIZE - 10];

} TPM_KEYWORD_PACKAGE;

typedef struct TPM_COMMAND_PACKAGE
{
    unsigned long   length;
    unsigned char   type;
    unsigned char   code;
    unsigned char   data[TPM_PACKAGE_SIZE - 10];

} TPM_COMMAND_PACKAGE;

//TPM Package Structure response
typedef struct TPM_RESPONSE_PACKAGE
{
    unsigned char   length[4];
    unsigned char   type;
    unsigned char   code;
    unsigned char   responseResult;
    unsigned char   data[TPM_PACKAGE_SIZE - 13];  // contain TPM Package data

} TPM_RESPONSE_PACKAGE;

//TPM Package data
typedef struct TPM_RESPONSE
{
    unsigned char   tag[2];
    unsigned char   paramSize[4];
    unsigned char   returnCode[4];
    unsigned char   payLoad[1024];

} TPM_RESPONSE;


typedef struct OSAP_HASH_BUF
{
    unsigned char   nonceEvenOSAP[20];
    unsigned char   nonceOddOSAP[20];
} OSAP_HASH_BUF;

//////////////////////////////////////////////////////////////////////////////
// TPM Main Part 2 TPM Structures Specification version 1.2

typedef struct TPM_KEY_PARMS{

    unsigned char   algorithmID[4] ;// exam 0x00000001 : RSA
    unsigned char   encScheme[2];   //
    unsigned char   sigScheme[2];   // exam 0x0002 : TPM_SS_RSASSAPKCS1v15_SHA1
    unsigned char   parmSize[4];    // size of the parms field in bytes.exam 0x0C for RSA
    unsigned char*  parms;          //depend  algorithmID

}TPM_KEY_PARMS;

typedef struct TPM_STORE_PUBKEY {

    unsigned char   keyLength[4];
    unsigned char*  key;            // normal 256 byte

} TPM_STORE_PUBKEY;

typedef struct TPM_KEY12_FIXED
{
    unsigned char   tag[2];
    unsigned char   fill[2];
    unsigned char   keyUsage[2];
    unsigned char   keyFlags[4];
    unsigned char   authDataUsage;
    //keyParms
    unsigned char   algoritmID[4];
    unsigned char   encScheme[2];
    unsigned char   sigScheme[2];
    unsigned char   parmSize[4];
    unsigned char   RSAParms[12];

} TPM_KEY12_FIXED;

//////////////////////////////////////////////////////////////////////////////
// the following defs are straight from the TCG published headers
// entity types
#define TPM_ET_KEYHANDLE               ((unsigned short)0x0001)     /* 1.1b */
#define TPM_ET_OWNER                   ((unsigned short)0x0002)     /* 1.1b */
#define TPM_ET_DATA                    ((unsigned short)0x0003)     /* 1.1b */
#define TPM_ET_SRK                     ((unsigned short)0x0004)     /* 1.1b */
#define TPM_ET_KEY                     ((unsigned short)0x0005)     /* 1.1b */
#define TPM_ET_REVOKE                  ((unsigned short)0x0006)
#define TPM_ET_DEL_OWNER_BLOB          ((unsigned short)0x0007)
#define TPM_ET_DEL_ROW                 ((unsigned short)0x0008)
#define TPM_ET_DEL_KEY_BLOB            ((unsigned short)0x0009)
#define TPM_ET_COUNTER                 ((unsigned short)0x000a)
#define TPM_ET_NV                      ((unsigned short)0x000b)
#define TPM_ET_RESERVED_HANDLE         ((unsigned short)0x0040)

// keyHandle types
#define TPM_KH_SRK                     ((unsigned long)0x40000000)
#define TPM_KH_OWNER                   ((unsigned long)0x40000001)
#define TPM_KH_REVOKE                  ((unsigned long)0x40000002)
#define TPM_KH_TRANSPORT               ((unsigned long)0x40000003)
#define TPM_KH_OPERATOR                ((unsigned long)0x40000004)
#define TPM_KH_ADMIN                   ((unsigned long)0x40000005)
#define TPM_KH_EK                      ((unsigned long)0x40000006)

//-------------------------------------------------------------------
// Part 2, section 5.8: Key usage values

/** @defgroup group2 TPM_KEY_USAGE values
 *  @{
 */
typedef unsigned short TPM_KEY_USAGE; /*1.1b*/
#define TPM_KEY_SIGNING                ((unsigned short)0x0010)      /**< This SHALL indicate a signing key. The [private] key SHALL be used for signing operations, only. This means that it MUST be a leaf of the Protected Storage key hierarchy */
#define TPM_KEY_STORAGE                ((unsigned short)0x0011)      /**< This SHALL indicate a storage key. The key SHALL be used to wrap and unwrap other keys in the Protected Storage hierarchy */
#define TPM_KEY_IDENTITY               ((unsigned short)0x0012)      ///**< This SHALL indicate an identity key. The key SHALL be used for operations that require a TPM identity, only */
#define TPM_KEY_AUTHCHANGE             ((unsigned short)0x0013)      ///**< This SHALL indicate an ephemeral key that is in use during the ChangeAuthAsym process, only. */
#define TPM_KEY_BIND                   ((unsigned short)0x0014)      ///**< This SHALL indicate a key that can be used for TPM_Bind and TPM_UnBind operations only. */
#define TPM_KEY_LEGACY                 ((unsigned short)0x0015)      ///**< This SHALL indicate a key that can perform signing and binding operations. The key MAY be used for both signing and binding operations. The TPM_KEY_LEGACY key type is to allow for use by applications where both signing and encryption operations occur with the same key */
#define TPM_KEY_MIGRATE                ((unsigned short)0x0016)      ///**< This SHALL indicate a key in use for TPM_MigrateKey */
/** @} */ // end of group2 command value

typedef unsigned short TPM_SIG_SCHEME;                              /* 1.1b */
#define TPM_SS_NONE                    ((unsigned short)0x0001)     /* 1.1b */
#define TPM_SS_RSASSAPKCS1v15_SHA1     ((unsigned short)0x0002)     /* 1.1b */
#define TPM_SS_RSASSAPKCS1v15_DER      ((unsigned short)0x0003)     /* 1.1b */
#define TPM_SS_RSASSAPKCS1v15_INFO     ((unsigned short)0x0004)

typedef unsigned short TPM_ENC_SCHEME;                              /* 1.1b */
#define TPM_ES_NONE                    ((unsigned short)0x0001)     /* 1.1b */
#define TPM_ES_RSAESPKCSv15            ((unsigned short)0x0002)     /* 1.1b */
#define TPM_ES_RSAESOAEP_SHA1_MGF1     ((unsigned short)0x0003)     /* 1.1b */
#define TPM_ES_SYM_CNT                 ((unsigned short)0x0004)
#define TPM_ES_SYM_OFB                 ((unsigned short)0x0005)
#define TPM_ES_SYM_CBC_PKCS5PAD        ((unsigned short)0x00ff)

//-------------------------------------------------------------------
// Part 2, section 5.9: TPM_AUTH_DATA_USAGE values

/** @defgroup group3 TPM_AUTH_DATA_USAGE values
 *  @{
 */
typedef unsigned char TPM_AUTH_DATA_USAGE;
#define TPM_AUTH_NEVER                 ((unsigned char)0x00)       /**< This SHALL indicate that usage of the key without authorization is permitted */
#define TPM_AUTH_ALWAYS                ((unsigned char)0x01)       /**< This SHALL indicate that on each usage of the key the authorization MUST be performed */
#define TPM_AUTH_PRIV_USE_ONLY         ((unsigned char)0x11)       ///**  */
/** @} */ // end of group3 command value

//-------------------------------------------------------------------
// Part 2, section 5.10: TPM_KEY_FLAGS flags

/** @defgroup group4 TPM_KEY_FLAGS values
 *  @{
 */
typedef unsigned long TPM_KEY_FLAGS;
#define TPM_REDIRECTION                ((unsigned long)0x00000001)   ///**< This mask value SHALL indicate the use of redirected output */
#define TPM_MIGRATABLE                 ((unsigned long)0x00000002)   /**< This mask value SHALL indicate that the key is migratable */
#define TPM_VOLATILE                   ((unsigned long)0x00000004)   ///**< This mask value SHALL indicate that the key MUST be unloaded upon execution of the TPM_Startup(ST_Clear). This does not indicate that a nonvolatile key will remain loaded across TPM_Startup(ST_Clear) events */
#define TPM_PCRIGNOREDONREAD           ((unsigned long)0x00000008)   ///**< When TRUE the TPM MUST NOT check digestAtRelease or localityAtRelease for commands that read the public portion of the key (e.g., TPM_GetPubKey) and MAY NOT check digestAtRelease or localityAtRelease for commands that use the public portion of the key (e.g. TPM_Seal.
                                                                     //  \n When FALSE the TPM MUST check digestAtRelease and localityAtRelease for commands that read or use the public portion of the key */
#define TPM_MIGRATEAUTHORITY           ((unsigned long)0x00000010)   ///**< When set indicates that the key is under control of a migration authority. The TPM MUST only allow the creation of a key with this flag in TPM_CMK_CreateKey */
// addes this def to TCG standard header
#define TPM_NONMIGRATABLE              ((unsigned long)0x00000000) /* 1.1b */ /**< This mask value SHALL indicate that the key is non-migratable */

/** @} */ // end of group4 command value
#endif // TPMDEFINE_H
