#ifndef __DESCRIPTORS_H__
#define __DESCRIPTORS_H__

#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include "usbi.h"

int usb_get_descriptor_by_endpoint(usb_dev_handle *udev, int ep,
								   unsigned char type, unsigned char index, void *buf, int size);
int usb_get_descriptor(usb_dev_handle *udev, unsigned char type,
					   unsigned char index, void *buf, int size);
int usb_parse_descriptor(unsigned char *source, const char *description, void *dest);
static int usb_parse_endpoint(struct usb_endpoint_descriptor *endpoint, unsigned char *buffer, int size);
static int usb_parse_interface(struct usb_interface *interface,
							   unsigned char *buffer, int size);
int usb_parse_configuration(struct usb_config_descriptor *config,
							unsigned char *buffer);
void usb_destroy_configuration(struct usb_device *dev);
void usb_fetch_and_parse_descriptors(usb_dev_handle *udev);


#endif

