#ifndef HASHFUNCTION_H
#define HASHFUNCTION_H

typedef struct {
        unsigned long h[5];
        unsigned long byteCount;
        unsigned long byteCountHi;
        unsigned char buf[64];
} hashContext;

// prototypes
void sha1Checksum(unsigned char *msg, int msgBytes, unsigned char *dest);
//void sha1Hmac(unsigned char *msg, int msgBytes, unsigned char *key, unsigned char keyBytes, unsigned char *dest);
void sha1Hmac(unsigned char *key, unsigned char keyBytes, unsigned char *msg, int msgBytes, unsigned char *dest);
void shaEngine(unsigned char *buf, unsigned long *h);

void sha1Start(hashContext *ctx);
void sha1Update(hashContext *ctx, unsigned char *src, int nbytes);
void sha1Finish(hashContext *ctx, unsigned char *dest);

void hmacStart(hashContext *ctx, unsigned char *key, unsigned char keyBytes);
void hmacUpdate(hashContext *ctx, unsigned char *src, int nbytes);
void hmacFinish(hashContext *ctx, unsigned char *key, unsigned char keyBytes, unsigned char *dest);

#endif
