#ifndef AUTHHANDLER_H
#define AUTHHANDLER_H

// #defines

#define SZ_ORD				4
#define ORD_OFFSET			6

#define SZ_RETCODE			4
#define RETCODE_OFFSET		6

#define SZ_DIGEST			20
#define SZ_AUTHVAL			20

#define SZ_INAUTH 			45
#define AUTH1_SIZE  		SZ_INAUTH
#define AUTH2_SIZE 			(AUTH1_SIZE + AUTH1_SIZE)

#define SZ_HAND				4
#define HAND1_SIZE  		SZ_HAND
#define HAND2_SIZE  		(HAND1_SIZE + HAND1_SIZE)

#define PAYLOAD_START_OFF	10
#define SZ_OUTAUTH			41
#define SZ_CONT				1


typedef struct AUTH_SESSION
{
    unsigned long   handle;
    unsigned char   nonceEven[20];
    unsigned char   nonceOdd[20];
    unsigned char   HMACKey[20];

} AUTH_SESSION;

typedef struct HMAC
{
    unsigned char   paramDigest[20];
    unsigned char   nonceEven[20];
    unsigned char   nonceOdd[20];
    unsigned char   contAuth;
} HMAC;

// typedefs
typedef struct tdOutAuth
{
        unsigned char	nonceEven[20];
        unsigned char	contAuth;
        unsigned char	HMACout[20];
}	outAuth;

// prototypes
unsigned char inAuthHandler(unsigned char numAuths, unsigned char numInHandles,unsigned char *cmdOrdinal, unsigned char *data, unsigned short dataLen, AUTH_SESSION *auth1, AUTH_SESSION *auth2);
unsigned short outAuthHandler(unsigned char numAuths, unsigned char numOutHandles,unsigned char *cmdOrdinal, unsigned char *data, unsigned short dataLen, AUTH_SESSION *auth1, AUTH_SESSION *auth2);
void encAuthHandler(unsigned char *pNonceBuf, unsigned char *pHMACkey, unsigned char *outPtr);
void dumpHMACparms(unsigned char numAuthSession,unsigned char* HMACKey, HMAC HMACBuf, unsigned char *HMACoutBuf);

#endif
