/******************************************************************************
 * Copyright (c) 2004-2008 GREYSTONES DATA SYSTEM, Inc. All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF GDS.
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * File Name: csystemd105.cpp
 ******************************************************************************/
//Added by qt3to4:
#include <Q3TextStream>
#include <qdatetime.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "DFXMessageDisplay.h"
#include "csystemd105.h"
#include "csetuplilo.h"
#include "csetupgrub.h"
#include "cutility.h"
#include "Partition.h"
#include "cextsmartUtility.h"
#include "./exelOperation/cexceloperation.h"
#include "jsondata.h"

#define NEWPART_MODULE
#define printDFXLog Clog::GetInstance()->writeToLogFile

// Initialize for the 'instance' static variable
CSystemD105* CSystemD105::instance = NULL;		

bool DoneEXTSmart = false;
bool isCheckdisk[MAX_DISKS];
int value = 0;
unsigned short min_idx = 0;//DuongVu
unsigned long min_remain_sectors = 0;//DuongVu
PARTITION_STRUCT    partitionTemp; //TamHo

//////////////////////////////////////////////////////////////////////////
//
CSystemD105::CSystemD105 (Clog *dlog)
{
    short disk;
    this->log                = dlog;
    this->initRes            = true;
    this->gAbortFlag	     = 0;
    this->mMinUDMAMode	     = -1; // minimum UMDA mode that all drives can work
    this->mMinPIOMode	     = -1; // minimum PIO mode that all drives can work
    this->mUDMAMode	     = -1;
    this->mPIOMode	     = -1;
    this->mNeedToResetBoard  = false;
    this->checkFinishedDisk  = 0;
    //this->diskIOModule.hasXFRDriveInCopyProcess =  false;
    
    for (disk = 0; disk < MAX_DISKS;disk++)
    {
        this->diskIOModule.setInputOfDisk(disk, CHECKED);
        this->inputDiskList[disk]    = CHECKED;
        this->diskStruct[disk].index = disk;
        this->diskStruct[disk].setCDiskOperationObj(diskIOModule);
    }

    for (disk = 0; disk < MAX_TASKS;disk++)
    {
        this->gTaskList[disk].target.items            = 0;
        this->gTaskList[disk].none_error_target.items = 0;
        this->gTaskList[disk].verify_target.items     = 0;
    }

    this->gOperatingState    = OP_RESTART_DRIVES;

    for (disk = 0; disk < MAX_DISKS;disk++)
    {
        this->diskIOModule.powerDown(disk);
        this->diskIOModule.TurnLedMode(disk, LED_OFF, LED_GREEN);
    }

    this->securityOperation = new SecurityOperation();
    if (!securityOperation)
    {
        printDFXLog (PRI_INFO, "\n Cannot create securityOperation object. \n");
        this->initRes = false;
    }
    this->securityOperation->setSystemOptions(&this->systemOption);

    this->test_disk_params = (TEST_DISK_PARAM*) malloc(sizeof(TEST_DISK_PARAM));
    if (!this->test_disk_params)
    {
        printDFXLog (PRI_INFO, "Allocate memory for test_disk_params variable is failed with errno %d", errno);
        this->initRes = false;
    }

    this->mMBWE_MaxCapacity4SmartCopy = 0;
    this->fMBWE                       = false;

    this->systemOption.txt_power_up_delay   = DEFAULT_POWER_UP_DELAY_TIMES;
    this->systemOption.txt_settling_time    = DEFAULT_DRIVE_SETTLING_TIMES;
    this->systemOption.txt_spin_down_time   = DEFAULT_SPINDOWN_DELAY_TIMES;
    this->systemOption.txt_command_time_out = DEFAULT_COMMAND_TIMEOUT;
    this->systemOption.txt_command_delay    = DEFAULT_COMMAND_DELAY;
    this->systemOption.txt_command_retry    = DEFAULT_COMMAND_RETRY_TIMES;
    this->systemOption.transfer_mode        = DEFAULT_MAX_UDMA_MODE;
    this->systemOption.enable_brief_copy    = 1; // BriefCopy default

    this->diskIOModule.mDoSystemOption.txt_power_up_delay   = systemOption.txt_power_up_delay;
    this->diskIOModule.mDoSystemOption.txt_settling_time    = systemOption.txt_settling_time;
    this->diskIOModule.mDoSystemOption.txt_spin_down_time   = systemOption.txt_spin_down_time;
    this->diskIOModule.mDoSystemOption.txt_command_time_out = systemOption.txt_command_time_out;
    this->diskIOModule.mDoSystemOption.txt_command_delay    = systemOption.txt_command_delay;
    this->diskIOModule.mDoSystemOption.txt_command_retry    = systemOption.txt_command_retry;
    this->diskIOModule.mDoSystemOption.transfer_mode        = systemOption.transfer_mode;
    this->diskIOModule.mDoSystemOption.enable_brief_copy    = systemOption.enable_brief_copy;

    //////////////////////////////////////////////////////////////////////////
    // HuyHuynh adds here
    this->BUILD_IN_MODE	          = 0;
    this->gNtfsCopy               = NULL;
    this->gFAT32Smart             = NULL;
    this->gExt2Smart              = NULL;
    this->gMirrorOperation        = NULL;
    this->gHPAOperation	          = NULL;
    this->gDWOOperation           = NULL;
    this->gTestDiskOperation      = NULL;

    for (disk = 0; disk < MAX_DISKS; disk++)
    {
        this->gTotalTask[disk]   = 0;
        this->gCurrentTask[disk] = 0;
        this->g48BitAddressSupported[disk] = 0;
        this->gATAVersion[disk]            = 0;
        this->gSectorsToCopy[disk]         = 0;
        this->gSectorsToVerify[disk]       = 0;
        this->gSectorsCopied[disk]         = 0;

        this->gTarget[disk].standardOption = 0;
        this->gTarget[disk].enable         = 0;
        this->gTarget[disk].disk_mode      = DISK_MODE(DISK_SMART);
        this->gTarget[disk].target_start_sector	= 0;
        this->gTarget[disk].source_start_sector	= 0;
        this->gTarget[disk].source_end_sector   = 0;
        this->gTarget[disk].UserHpaABoth        = 1;
        this->gTarget[disk].clearMode           = 0;
        this->gTarget[disk].testMode            = 0;
        this->gTarget[disk].user_defined_partitions = 0;

        for (short i = 0; i < MAX_TARGET_PARTITIONS; i++)
        {
            this->gTarget[disk].partition[i].source_partition = 0;
            this->gTarget[disk].partition[i].copy_mode        = PARTITION_COPY_MODE(SMART_COPY);
            this->gTarget[disk].partition[i].action           = ACTION_TYPE (NULL_PAR);
            this->gTarget[disk].partition[i].partition_size   = 0;
        }

        this->gTarget[disk].userPartitionCount = 0;
        this->gTarget[disk].HPAEnable          = 0;
        this->gCopyResult[disk]                = COPY_RESULT (INCOMPLETE);
        this->gBestTransferMode[disk]          = TRANSFER_MODE (ULTRA_DMA_MODE);

        memset (&this->gDriveInfo[disk], 0x00, sizeof (ID_DEVICE_INFOR));
    }

    this->gLastError          = ERROR_ENUM (BAD_JOB_SETUP);

    memset (&this->gLiveTargetList, 0x00, sizeof (ITEM_LIST_STRUCT));

    for (disk = 0; disk < MAX_DISKS; disk++)
    {
        this->gStartupPercent[disk]  = 0;
        this->gPercentCopied[disk]   = 0;
        this->gPercentVerified[disk] = 0;
        this->gSectorsVerified[disk] = 0;
        this->gDriveState[disk]	= DRIVE_STATE (DISABLED);
        this->gDriveType[disk]	= DRIVE_TYPE (DT_PATA);
        this->gLargeDrive[disk]	= 0;
        this->gCapacity[disk]               = 0;
        this->gNumCylinders[disk]           = 0;
        this->gCapacityOrigin[disk]         = 0;
        this->gNativeMaxAddress[disk]       = 0;
        this->gNativeMaxAddressOrigin[disk] = 0;
        this->gBestMultiple[disk]           = 0;
        this->gBestTransferModeNumber[disk] = 0;
        this->gHPACapacity[disk]            = 0;
        this->gHPAFeatureSupported[disk]    = 0;
        this->gSupportedLBA[disk]           = 0;
        this->gSupportedMultiple[disk]	    = 0;
        this->gSupportedPIOModeNumber[disk] = 0;
        this->gSupportedMultiwordDMAModeNumber[disk] = 0;
        this->gSupportedUltraDMAModeNumber[disk]     = 0;
        this->listDrivesSetupLilo[disk]      = 0;
        this->listDrivesSetupGRUB[disk]      = 0;
        this->source[disk].partition_start   = 0;
        this->source[disk].partition_length  = 0;
        this->source[disk].entry_type        = ACTION_TYPE (NULL_PAR);
        this->source[disk].partition_type    = 0;
        this->source[disk].active_flag       = 0;
        this->source[disk].anchored_type     = 0;
        this->source[disk].ext_parent        = 0;
        this->source[disk].info	             = NULL;
        memset (&this->m_Translated_CHF[disk], 0x00, sizeof (TRANSLATED_CHF));
    }

    memset (&this->smartOption, 0x00, sizeof (SMART_OPTIONS));

    this->diskNeedStartUp = 0;
    this->mode_S_E        = 0;
    this->resultS         = 0;
    this->resultE         = 0;
    this->currentTask           = 0;
    this->totalTask             = 0;
    this->percentStartupDisks   = 0;
    this->standardOption        = 0;
    this->user_option           = 0;
    this->cancelStartupAllDisk	= 0;
    this->diskIOModule.setCopyMode();
    this->diskIOModule.clearVerifyMapSector();

    this->systemOption.percentReadBackVerify = 0;
    this->isVerified       = false;
    this->actionMode       = DUPLICATING_MODE;
    this->instance         = this;
    this->isBriefCopy      = false;
    this->isReviewCheckDisk = false;

    this->calTimeCopyType               = 0;
    this->startSectorBootLoaderFile     = 0;
    this->isCalTimeCopy                 = false;
    this->isSetupBootLoaderInBiefCopy   = false;

    printDFXLog (PRI_INFO, MES_CREATE_OBJ"CSystemD105");
}
//////////////////////////////////////////////////////////////////////////
//
CSystemD105::~CSystemD105()
{
    if (this->securityOperation)
    {
        delete(this->securityOperation);
        this->securityOperation = NULL;
    }

    if (this->test_disk_params != NULL)
    {
        free(this->test_disk_params);
        this->test_disk_params = NULL;
    }

    if (this->gNtfsCopy)
    {
        delete (this->gNtfsCopy);
        this->gNtfsCopy = NULL;
    }

    if (this->gFAT32Smart)
    {
        delete (this->gFAT32Smart);
        this->gFAT32Smart = NULL;
    }

    if (this->gExt2Smart)
    {
        delete (this->gExt2Smart);
        this->gExt2Smart = NULL;
    }

    if (this->gExt4Smart)
    {
        delete (this->gExt2Smart);
        this->gExt2Smart = NULL;
    }
    if (this->gMirrorOperation)
    {
        delete (this->gMirrorOperation);
        this->gMirrorOperation = NULL;
    }

    if (this->gHPAOperation)
    {
        delete (this->gHPAOperation);
        this->gHPAOperation = NULL;
    }

    if (this->gDWOOperation)
    {
        delete (this->gDWOOperation);
        this->gDWOOperation = NULL;
    }

    if (this->gTestDiskOperation)
    {
        delete (this->gTestDiskOperation);
        this->gTestDiskOperation = NULL;
    }

    this->isBriefCopy     = FALSE;
    this->calTimeCopyType = 0; //TamHo added to estimate copy time (Oct , 12, 2010)
    printDFXLog (PRI_INFO, MES_KILL_OBJ"CSystemD105");
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
 * Set up copy variables after all drives are ready and all drive
 * information is available.
 * Inputs: none
 * Output: none
 * Return: 1 if success or 0 if failed
 */
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::initializeCopy()
{
    unsigned char pio_multicap = 0;
    unsigned char num_secs_to_pio_trans = 0;
    unsigned long sectorsPerTrack = 0;
    unsigned long sectorsPerCylinder = 0;
    short disk = 0;
    short errorCode = 0;
    ITEM_LIST_STRUCT inlist;

    // PIO can not work
    this->diskIOModule.set_times_delay_command(systemOption.txt_command_delay);
    this->diskIOModule.SetRetryDelayTimeOut(	systemOption.txt_power_up_delay,
                                                systemOption.txt_settling_time,
                                                systemOption.txt_spin_down_time,
                                                systemOption.txt_command_time_out,
                                                systemOption.txt_command_delay,
                                                systemOption.txt_command_retry,
                                                systemOption.transfer_mode);

    sectorsPerTrack = sectorsPerCylinder = 0;

    if(this->systemOption.enable_brief_copy == 1)
    {
        this->isBriefCopy = TRUE;
        this->diskIOModule.mDoSystemOption.enable_brief_copy = 1;
    }
    else
    {
        this->isBriefCopy = FALSE;
    }

    this->diskIOModule.clearSectorCountCopied();

    //TamHo fixbug some disk with capcacity smaller is removed when execute verify or burning in (28-09-2011)
    if((this->isVerified == true) || (this->BUILD_IN_MODE != 0))
    {
        for (disk = 1;disk < MAX_DISKS;disk++)
        {
            if(this->gPercentCopied[disk] == 100)
            {
                this->gDriveState[disk] = DRIVE_READY;
                this->gTarget[disk].enable = 1;
            }
        }
    }
    //End add TamHo (28-09-2011)

    for (disk = 1;disk < MAX_DISKS;disk++)
    {
        if (this->gDriveState[disk] == DRIVE_READY && this->gTarget[disk].enable)
        {
            inlist.item[disk] = 1;
        }
        else
        {
            inlist.item[disk] = 0;
        }
    }

    // get number of sectors currently set to transfer on a READ/WRITE MULTIPLE command (for PIO)
    pio_multicap = 0xFF;

    for (disk = 0;disk < MAX_DISKS;disk++)
    {
        if (inlist.item[disk])
        {
            if (this->gDriveInfo[disk].Flags59 & 0x100)
            {
                num_secs_to_pio_trans = gDriveInfo[disk].MultiCap & 0xFF;
                if (pio_multicap > num_secs_to_pio_trans && num_secs_to_pio_trans > 0)
                {
                    pio_multicap = num_secs_to_pio_trans;
                }
            }
        }
    }

    if (pio_multicap == 0xFF)
    {
        pio_multicap = 1;
    }

    this->diskIOModule.set_sectors_count_per_transfer(systemOption.sectors_per_transfer, pio_multicap);
    for(short taskIdx = 0; taskIdx < MAX_TASKS; taskIdx++)
    {
        this->gTaskList[taskIdx].none_error_target.items	= 0;
        this->gTaskList[taskIdx].verify_target.items		= 0;
        if(this->gDriveState[0] == DRIVE_READY)
        {
            this->gTaskList[taskIdx].target.items	= 1;
            this->gTaskList[taskIdx].target.item[0] = 1;
            this->gTaskList[taskIdx].remain_sectors[0] = 0;
        }
        else
        {
            this->gTaskList[taskIdx].target.items	= 0;
            this->gTaskList[taskIdx].target.item[0] = 0;
        }
        for (disk = 1; disk < MAX_DISKS; disk++)
        {
            this->gTaskList[taskIdx].target.item[disk] = 0;
            this->gTaskList[taskIdx].remain_sectors[disk] = 0;
        }
    }

    this->currentTask = 0;
    this->totalTask   = 0;
    this->gLiveTargetList.items	  = 1;
    this->gLiveTargetList.item[0] = 0;

    for (disk = 0;disk < MAX_DISKS;disk++)
    {
        isCheckdisk[disk] = true;
        this->gTotalTask[disk]          = 0;
        this->gCurrentTask[disk]	= 0;
        this->gPercentCopied[disk]	= 0;
        this->totalOfCopiedSectors[disk] = 0;
        this->totalOfJobSectors[disk] = 0;
        this->listDrivesSetupLilo[disk]	= 0;
        this->listDrivesSetupGRUB[disk]	= 0;
        this->dbObj.resultCopyObj[disk].refresh();
        this->diskStruct[disk].index  = disk;
        this->diskStruct[disk].setCDiskOperationObj(this->diskIOModule);
    }

    this->gOperatingState = OP_RESTART_DRIVES;

    for (disk = 0; disk < MAX_DISKS; disk++)
    {
        if(this->gDriveState[disk] == DRIVE_READY)
        {
            if((this->diskIOModule.jobId == CORE_WIPE_DISK_JOB) && (disk == 0))
            {
                this->diskIOModule.TurnLedMode(disk, SLOW_BLINK, LED_GREEN);
            }
            else
            {
                this->diskIOModule.TurnLedMode(disk, FAST_BLINK, LED_GREEN);
            }

            this->gCopyResult[disk] = INCOMPLETE;
            this->diskIOModule.setPartitionStart(disk, 0);
            this->diskIOModule.setPartitionLength(disk, gCapacity[disk]);
        }
        else
        {
            this->gCopyResult[disk] = CANCELLED;
        }
    }

    this->gLiveTargetList.items   = 1;
    this->gLiveTargetList.item[0] = 0;
    this->currentTask = 0;
    this->totalTask   = 0;

    this->diskIOModule.totalTransactionFlushCacheForMirror = TRANS_MIRROR_FOR_FLUSHCACHE;
    this->diskIOModule.totalTransactionFlushCacheForWriteMemory = TRANS_WRITE_FOR_FLUSHCACHE;

    //Neu la SMART COPY thi chi chay tai GEN2-voi verilog 2.7 (add 11-10-2013)
    if((this->diskIOModule.jobId == CORE_SMART_COPY_JOB) && (this->isBriefCopy == FALSE)
            && (this->diskIOModule.usedGen == DT_SATA3) && (this->diskIOModule.curGen == DT_SATA3)){
        this->diskIOModule.setGen(DT_SATA2);
        this->diskIOModule.usedGen = DT_SATA2;
        this->diskIOModule.curGen = DT_SATA2;
    }
    //End add (11-10-2013)


    //Neu la verify smart tai GEN3 thi giam xuong GEN2
    if(this->actionMode == VERIFYING_MODE
            && (this->diskIOModule.usedGen == DT_SATA3) && (this->diskIOModule.curGen == DT_SATA3)
            && (this->diskIOModule.jobId == CORE_SMART_COPY_JOB)){
        this->diskIOModule.setGen(DT_SATA2);
        this->diskIOModule.usedGen = DT_SATA2;
        this->diskIOModule.curGen = DT_SATA2;
    }


    // DuongVu add here for dup first 2048 sectors from source to targets.
    this->copyFirstSectorsOfPartitionToTargets();

    for (disk = 1; disk < MAX_DISKS; disk++){
        if ((this->gDriveState[disk] == DRIVE_READY) && (this->gTarget[disk].enable)){
            errorCode = this->partnAddATask(disk, sectorsPerTrack, sectorsPerCylinder); // add task list
            if(errorCode == PAR_TYPE_LVM){
                this->gLastError = BAD_JOB_SETUP;
                return PAR_TYPE_LVM;
            }
            if (errorCode != SUCCESS){
                continue;
            }

            //gLiveTargetList.items++;
            this->gLiveTargetList.item[gLiveTargetList.items++] = disk;
        }
    }

    if (this->gLiveTargetList.items == 1){
        this->gLastError = BAD_JOB_SETUP;
        return UNSUCCESS;
    }

    for (disk = 0;disk < MAX_TASKS;disk++){
        this->gTaskList[disk].state = TASK_INIT;
    }

    if(this->diskIOModule.transfer_mode > (UDMA_MODE_MAX - UDMA_MODE_MIN)){
        printDFXLog(PRI_INFO, "The system run at GEN %d - PIO mode %d.", this->diskIOModule.usedGen, this->diskIOModule.originalTransferMode);
    }
    else{
        printDFXLog(PRI_INFO, "The system run at GEN %d - UDMA mode %d.", this->diskIOModule.usedGen, this->diskIOModule.transfer_mode);
    }

    //TamHo add (22-12-2011): Neu la dia DB32 thi giam xuong UDMA mode 4 de chay
    bool hasDB32Drive = false;
    bool hasXFRDrive = false;
    bool allSmartDrive = true;

    this->diskIOModule.writePatternMode = 0;
    for (disk = 1; disk < MAX_DISKS;disk++){
        if ((this->gDriveState[disk] == DRIVE_READY) && (this->gTarget[disk].enable)){
            if(this->diskIOModule.special_drive[disk] != SMART_DRIVE){
                allSmartDrive = false;
            }

            if(this->diskIOModule.special_drive[disk] == DB32_DRIVE){
                hasDB32Drive = true;
            }

            if(this->diskIOModule.special_drive[disk] == XFR_DRIVE){
                hasXFRDrive = true;
                this->diskIOModule.writePatternMode = 1;
            }
        }
    }

    //For 0->MAX_DISK, open setting exel file, compare and get setting for use; TamHo add (20-08-2012)
    //    CExelOperation *settingFile = new CExelOperation();
    //    if(settingFile != NULL)
    //    {
    //        if(settingFile->init() == SUCCESS)
    //        {
    //            SETTING_ROW_INFO rowInfo;
    //            for(disk = 0; disk < MAX_DISKS;disk++)
    //            {
    //                if ((this->gDriveState[disk] == DRIVE_READY) && (this->gTarget[disk].enable))
    //                {
    //                    if(settingFile->getRowWithDriveModel(QVariant((this->gDriveInfo[disk]).MfrName).toString(), rowInfo) == SUCCESS)
    //                    {
    //                        //Compare and detect UDMA mode
    //                        while(this->diskIOModule.currentTransferMode > rowInfo.UDMA_mode)
    //                        {
    //                            this->diskIOModule.reduce_speed();
    //                            this->diskIOModule.setCurrentTransferMode();
    //                            this->diskIOModule.originalTransferMode = this->diskIOModule.currentTransferMode;

    //                            if(this->diskIOModule.currentTransferMode == rowInfo.UDMA_mode) //UDMA4
    //                            {
    //                                break;
    //                            }
    //                        }

    //                        //Get sector per transaction of drive
    //                        if(systemOption.transfer_mode > rowInfo.sector_per_trans)
    //                        {
    //                            systemOption.transfer_mode = rowInfo.sector_per_trans;
    //                        }
    //                        //Get time delay of drive
    //                        if(systemOption.txt_power_up_delay < rowInfo.power_up_delay)
    //                        {
    //                            systemOption.txt_power_up_delay = rowInfo.power_up_delay;
    //                        }

    //                        if(systemOption.txt_spin_down_time < rowInfo.spin_down_delay)
    //                        {
    //                            systemOption.txt_spin_down_time = rowInfo.spin_down_delay;
    //                        }

    //                        if(systemOption.txt_command_time_out < rowInfo.command_timeout)
    //                        {
    //                            systemOption.txt_command_time_out = rowInfo.command_timeout;
    //                        }

    //                        if(systemOption.txt_command_delay < rowInfo.command_delay)
    //                        {
    //                            systemOption.txt_command_delay = rowInfo.command_delay;
    //                        }

    //                        if(systemOption.txt_command_retry < rowInfo.command_retry)
    //                        {
    //                            systemOption.txt_command_retry = rowInfo.command_retry;
    //                        }

    //                        //Setup time delay and
    //                        //this->diskIOModule.set_times_delay_command(systemOption.txt_command_delay);
    //                        this->diskIOModule.SetRetryDelayTimeOut(	systemOption.txt_power_up_delay,
    //                                                                    systemOption.txt_settling_time,
    //                                                                    systemOption.txt_spin_down_time,
    //                                                                    systemOption.txt_command_time_out,
    //                                                                    systemOption.txt_command_delay,
    //                                                                    systemOption.txt_command_retry,
    //                                                                    systemOption.transfer_mode);
    //                    }
    //                }
    //            }
    //        }
    //        else
    //        {
    //            while((hasDB32Drive == true) && (this->diskIOModule.currentTransferMode >= 0x45))
    //            {
    //                this->diskIOModule.reduce_speed();
    //                this->diskIOModule.setCurrentTransferMode();
    //                this->diskIOModule.originalTransferMode = this->diskIOModule.currentTransferMode;
    //                if(this->diskIOModule.currentTransferMode == 0x44) //UDMA4
    //                {
    //                    break;
    //                }
    //            }
    //        }

    //        delete(settingFile);
    //    }
    //TamHo end add (20-08-2012)

    //Neu co dia target DB32 tham gia qua trinh copy thi tu dong detect giam xuong UDMA mode4
    while((hasDB32Drive == true) && (this->diskIOModule.currentTransferMode >= 0x45))
    {
        this->diskIOModule.reduce_speed();
        this->diskIOModule.setCurrentTransferMode();
        this->diskIOModule.originalTransferMode = this->diskIOModule.currentTransferMode;
        if(this->diskIOModule.currentTransferMode == 0x44) //UDMA4
        {
            break;
        }
    }
    //End added TamHo (22-12-2011)

    //Neu la dia SMARTTECH tuy GEN cua dia la GEN1 nhung co the chay tai toc do GEN2
    //    if(allSmartDrive == true){
    //        this->diskIOModule.usedGen = DT_SATA2;
    //        if(this->diskIOModule.increaseGen() == SUCCESS)
    //            this->diskIOModule.usedGen = this->diskIOModule.curGen;
    //    }

    if(this->diskIOModule.jobId == CORE_WIPE_DISK_JOB){
        this->diskIOModule.totalTransactionFlushCacheForMirror = TRANS_MIRROR_FOR_FLUSHCACHE * 2;
    }

    //Tang so lan flush cache voi dia XFR khi thuc hien chuc nang DeltaSmart (100MB cho Mirror, 100 transaction cho ham write)
    //fprintf(stderr, "\n THDB here: tam thoi comment here, de giam so lan flush cache trong qua trinh copy");
    if((hasXFRDrive ==  true) && (this->diskIOModule.jobId == CORE_SMART_COPY_JOB) && (this->isBriefCopy == FALSE)){
        this->diskIOModule.totalTransactionFlushCacheForMirror = TRANS_MIRROR_FOR_FLUSHCACHE_XFR;
        this->diskIOModule.totalTransactionFlushCacheForWriteMemory = TRANS_WRITE_FOR_FLUSHCACHE_XFR;
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::initClusterArray (unsigned long* clusArray[MAX_DISKS])
{
    for (short disk = 0; disk < MAX_DISKS; disk++)
    {
        clusArray[disk] = NULL;
    }
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::run()
{
    QThread::currentThread()->setPriority(QThread::HighestPriority); //DuongVu set priority for this thread in high level
    printDFXLog (PRI_INFO, "%-50s %d", "The priority of d105 thread", QThread::currentThread()->priority());
    
    if (mode_S_E == 1)
    {
        resultS = 3;
        gOperatingState = OP_RESTART_DRIVES;
        cancelStartupAllDisk = 0;
        resultS = startupAllDisk();
    }
    else if (mode_S_E == 2)
    {
        resultE = 3;
        this->isVerified = false;
        //Set full capacity cua tat cac cac disk (nhung disk co HPA region)
        this->setFullCapacityAllDisk();

        //Khoi tao gia tri cac bien trong csystem105
        resultS = initializeCopy();

        //Tinh tong sector can copy cua tat ca cac task trong task list
        this->calTotalSectorCopyAllTask();
        this->insertPartitionInformationToDatabase(0);

        if(resultS == SUCCESS)
        {
            resultE = executeJob();
            msleep(500); //TanLe: delay 500ms for main thread update GUI
        }
        else if (resultS == UNSUCCESS)
        {
            resultE = UNSUCCESS;
        }
        else if(resultS == PAR_TYPE_LVM)
        {
            resultE = PAR_TYPE_LVM;
        }

        this->setInitAfterCopy();
        this->isReviewCheckDisk = false;
    }
    else if (mode_S_E == 3)
    {
        cancelStartupAllDisk = 0;
        resultS = startupOneDisk(diskNeedStartUp);
    }
    else if(mode_S_E == 4) //TamHo added to estimate copy time (Oct, 12, 2010)
    {
        this->isVerified = false;
        resultS = this->initializeCopy();

        if(resultS == SUCCESS)
        {
            this->guessTimeCopy();
        }
        else if (resultS == UNSUCCESS)
        {
            resultE = UNSUCCESS;
        }
        else if(resultS == PAR_TYPE_LVM)
        {
            resultE = PAR_TYPE_LVM;
        }

        this->setInitAfterCopy();
    }
    //End added TamHo
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : executeJob()
Description : This function execute all jobs after jobs are loaded.
Input : 1 if needed the job is executed immediately.
        0 if needed review job setup before executing.
Return : 1 if success or 0 if failed
*/
short CSystemD105::executeJob()
{
    short errorCode;
    while (!gAbortFlag)
    {
        errorCode = standbyHandleCopy();

        if (errorCode == ERRORED)
        {
            printDFXLog (PRI_INFO, "Out executeJob 1");
            return UNSUCCESS;
        }

        if (errorCode == FINISHED)
        {
            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if (this->gCopyResult[disk] == INCOMPLETE)
                {
                    this->gCopyResult[disk] = GOOD_COPY;
                }
            }

            printDFXLog (PRI_INFO, "Out executeJob 2");
            return SUCCESS;
        }
    }

    printDFXLog (PRI_INFO, "Out executeJob 4");
    return UNSUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::standbyHandleCopy ()
{
    if (this->totalTask == 0)
    {
        return FINISHED;
    }

    if ((this->gTaskList[this->currentTask].state == TASK_IDLE) || ((this->gOperatingState == OP_COPYING) && (this->gTaskList[this->currentTask].state == TASK_FINISH_COPY)))
    {
        if(this->setupFinishedTask() == UNFINISHED)
        {
            return UNFINISHED;
        }
        else
        {
            return FINISHED;
        }
    }

    if (this->gTaskList[this->currentTask].action == EMPTY_PAR)
    {
        printDFXLog (PRI_INFO, "Partition is empty.");
    }

    TASK_STATE state = this->gTaskList[this->currentTask].state;
    // Starting copy Job List
    switch (this->gTaskList[this->currentTask].action)
    {
    //############### FAT_32_PAR_SMART ##########################
    case FAT_32_PAR_SMART:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(FAT_32_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(FAT_32_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(FAT_32_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### EXT2_PAR_SMART ##########################
    case EXT2_PAR_SMART:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(EXT2_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(EXT2_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(EXT2_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        default :
            break;
        }
        break;

        //############### EXT4_PAR_SMART ##########################
    case EXT4_PAR_SMART:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(EXT4_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(EXT4_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(EXT4_PAR_SMART) == ERRORED)
            {
                return ERRORED;
            }
            break;

        default :
            break;
        }
        break;

        //############### LVM_PAR_SMART ##########################
    case LVM_PAR_SMART:
        printDFXLog (PRI_INFO, "LVM have NOT supported yet! ");
        return ERRORED;

        //############### FAT_32_FORMAT ##########################
    case FAT_32_FORMAT:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(FAT_32_FORMAT) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(FAT_32_FORMAT) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(FAT_32_FORMAT)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### FORMAT_DISK ##########################
    case FORMAT_DISK:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(FORMAT_DISK) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(FORMAT_DISK) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(FORMAT_DISK)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### NTFS_PAR_SOURCE_SMALLER_TARGET ##########################
    case NTFS_PAR_SOURCE_SMALLER_TARGET:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(NTFS_PAR_SOURCE_SMALLER_TARGET) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(NTFS_PAR_SOURCE_SMALLER_TARGET) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(NTFS_PAR_SOURCE_SMALLER_TARGET)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### MIRROR_PAR ##########################
    case MIRROR_PAR:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(MIRROR_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR:
            if(this->executeTask(MIRROR_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(MIRROR_PAR)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### CLEAR_PAR ##########################
    case CLEAR_PAR:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(CLEAR_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR:
            if(this->executeTask(CLEAR_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(CLEAR_PAR)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### CLEAR_PAR ##########################
    case FAST_PURGE_PAR:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(FAST_PURGE_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR:
            if(this->executeTask(FAST_PURGE_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(FAST_PURGE_PAR)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### WIPEOUT_PAR ##########################
    case WIPEOUT_PAR: //Action is DOD Wipe out
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(WIPEOUT_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR:
            if(this->executeTask(WIPEOUT_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(WIPEOUT_PAR)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### SANITIZE_PAR ##########################
    case SANITIZE_PAR:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(SANITIZE_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FIRST_SANITIZE:
            if(this->executeTask(SANITIZE_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SECOND_SANITIZE:
            if(this->executeTask(SANITIZE_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_THIRD_SANITIZE:
            if(this->executeTask(SANITIZE_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_VERIFY_SANITIZE:
            if(this->executeTask(SANITIZE_PAR)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### MIRROR_HPA ##########################
    case MIRROR_HPA:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(MIRROR_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SET_NATIVE_MAX_ADDRESS:
            if(this->executeTask(MIRROR_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR:
            if(this->executeTask(MIRROR_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->executeTask(MIRROR_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR_VERIFY:
            if(this->executeTask(MIRROR_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_RESET_MAX_ADDRESS:
            if(this->executeTask(MIRROR_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_RESET_DISKS:
            if(this->executeTask(MIRROR_HPA)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### SMART_HPA ##########################
    case SMART_HPA:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(SMART_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(SMART_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(SMART_HPA)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### TEST_PAR ##########################
    case TEST_PAR:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(TEST_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(TEST_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_FINISH_COPY:
            if(this->finishedTask(TEST_PAR)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### TEST_HPA ##########################
    case TEST_HPA:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(TEST_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SET_NATIVE_MAX_ADDRESS:
            if(this->executeTask(TEST_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR:
            if(this->executeTask(TEST_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_RESET_MAX_ADDRESS:
            if(this->executeTask(TEST_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_RESET_DISKS:
            if(this->executeTask(TEST_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### SCRTY_ERASE_PAR ##########################
    case SCRTY_ERASE_PAR:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(SCRTY_ERASE_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART:
            if(this->executeTask(SCRTY_ERASE_PAR) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SMART_VERIFY:
            if(this->finishedTask(SCRTY_ERASE_PAR)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### SCRTY_ERASE_HPA ##########################
    case SCRTY_ERASE_HPA:
        switch (state)
        {
        case TASK_INIT:
            if(this->initilizeTask(SCRTY_ERASE_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_SET_NATIVE_MAX_ADDRESS:
            if(this->executeTask(SCRTY_ERASE_HPA) == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR:
            if(this->executeTask(SCRTY_ERASE_HPA)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_MIRROR_VERIFY:
            if(this->executeTask(SCRTY_ERASE_HPA)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_RESET_MAX_ADDRESS:
            if(this->executeTask(SCRTY_ERASE_HPA)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        case TASK_RESET_DISKS:
            if(this->executeTask(SCRTY_ERASE_HPA)  == ERRORED)
            {
                return ERRORED;
            }
            break;

        default:
            break;
        }
        break;

        //############### NULL_PAR ##########################
    case NULL_PAR:
        gTaskList[currentTask].state = TASK_IDLE;
        break;
        //ACTION IS UNDEFINED -- THIS SHOULD NEVER HAPPEN

    default:
        break;
    }

    return UNFINISHED;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::initilizeTask(ACTION_TYPE action)
{
    static short errorCode;
    unsigned long startSector[MAX_DISKS], sectorCount[MAX_DISKS];
    ITEM_LIST_STRUCT outputErrorList;
    int i = 0, d = 0;

    switch (action)
    {
    //############### FAT_32_PAR_SMART ##########################
    case FAT_32_PAR_SMART:
        this->gTaskList[this->currentTask].remain_sectors[0] = this->gTaskList[this->currentTask].source_length;
        errorCode = SUCCESS;

        this->gFAT32Smart = new CFAT32Smart(this->gTaskList[this->currentTask].target, this, this->gTaskList[currentTask].remain_sectors, this->m_Translated_CHF, gTaskList[currentTask].hidden_sectors, this->gCopyResult);
        if (!this->gFAT32Smart)
        {
            printDFXLog (PRI_INFO, "Cannot create CFAT32Smart object.");
            errorCode = ERRORED;
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(this->isCancelWhileDup())
                    {
                        this->gCopyResult[disk] = CANCELLED;
                    }
                    this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                    this->dbObj.insertTbTaskInJob(disk, currentTask);
                    this->dbObj.errMsgObj.setErrorMessage("Can't create CFAT32Smart object");
                    this->dbObj.insertTbErrorMessage(disk);
                }
            }
            return ERRORED;
        }

        if ((gFAT32Smart->returnTheLastError() != DFX_ERR_SUCCESS) || (gFAT32Smart->format(gLiveTargetList, outputErrorList) == UNSUCCESS) || (gFAT32Smart->initialize() == UNSUCCESS)){
            errorCode = ERRORED;
        }

        this->gFAT32Smart->returnCopyResult(gCopyResult);

        if (errorCode == ERRORED)
        {
            if (this->gFAT32Smart)
            {
                delete this->gFAT32Smart;
                this->gFAT32Smart = NULL;
            }
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(this->isCancelWhileDup())
                    {
                        if(this->gCopyResult[disk] == INCOMPLETE)
                        {
                            this->gCopyResult[disk] = CANCELLED;
                        }
                    }
                    this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                    this->dbObj.insertTbTaskInJob(disk, currentTask);
                }
            }
            return ERRORED;
        }

        this->gTaskList[currentTask].state = TASK_SMART;
        break;

        //############### EXT2_PAR_SMART ##########################
    case EXT2_PAR_SMART:
        this->gTaskList[this->currentTask].remain_sectors[0] = this->gTaskList[this->currentTask].source_length;
        errorCode = SUCCESS;
        if (!fMBWE)
        {
            this->gExt2Smart = new CExt2Smart(this->gTaskList[this->currentTask].target, this, this->gTaskList[this->currentTask].remain_sectors, this->gCopyResult);
            if (!this->gExt2Smart)
            {
                printDFXLog (PRI_INFO, "Cannot create CExt2Smart object.");
                errorCode = ERRORED;
                for (short disk = 1; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[currentTask].target.item[disk])
                    {
                        if(this->isCancelWhileDup())
                        {
                            if(this->gCopyResult[disk] == INCOMPLETE)
                            {
                                this->gCopyResult[disk] = CANCELLED;
                            }
                        }
                        this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                        this->dbObj.insertTbTaskInJob(disk, currentTask);
                        this->dbObj.errMsgObj.setErrorMessage("Can't create CExt2Smart object");
                        this->dbObj.insertTbErrorMessage(disk);
                    }
                }
                return ERRORED;
            }

            this->gExt2Smart->setCopyMode();	//quick format
            errorCode = SUCCESS;

            if(this->gExt2Smart->initialize() == SUCCESS)
            {
                if(this->isBriefCopy == FALSE)
                {
                    if((this->gExt2Smart->copyRootInode()     == UNSUCCESS)	||
                            (this->gExt2Smart->copyBadInode()      == UNSUCCESS)	||
                            (this->gExt2Smart->copyResizeInode()   == UNSUCCESS)	||
                            (this->gExt2Smart->copyJournalInode()  == UNSUCCESS))
                    {
                        errorCode = ERRORED;
                    }
                }
            }
            else
            {
                errorCode = ERRORED;
            }

            this->gExt2Smart->returnCopyResult(this->gCopyResult);

            if (errorCode == ERRORED)
            {
                if (this->gExt2Smart)
                {
                    delete this->gExt2Smart;
                    this->gExt2Smart = NULL;
                }
                for (short disk = 1; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[currentTask].target.item[disk])
                    {
                        if(this->isCancelWhileDup())
                        {
                            if(this->gCopyResult[disk] == INCOMPLETE)
                            {
                                this->gCopyResult[disk] = CANCELLED;
                            }
                        }
                        this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                        this->dbObj.insertTbTaskInJob(disk, currentTask);
                    }
                }
                return ERRORED;
            }
        }
        else
        {
            this->gExt2Smart = new CExt2Smart(this->gTaskList[this->currentTask], this, this->gTaskList[this->currentTask].remain_sectors, this->fMBWE);
            if (!this->gExt2Smart)
            {
                printDFXLog (PRI_INFO, "Cannot create CExt2Smart object.");
                errorCode = ERRORED;
                for (short disk = 1; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[currentTask].target.item[disk])
                    {
                        if(this->isCancelWhileDup())
                        {
                            if(this->gCopyResult[disk] == INCOMPLETE)
                            {
                                this->gCopyResult[disk] = CANCELLED;
                            }
                        }
                        this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                        this->dbObj.insertTbTaskInJob(disk, currentTask);
                        this->dbObj.errMsgObj.setErrorMessage("Can't create CExt2Smart object");
                        this->dbObj.insertTbErrorMessage(disk);
                    }
                }
                return ERRORED;
            }
        }

        this->gTaskList[this->currentTask].state = TASK_SMART;
        break;

        //############### EXT4_PAR_SMART ##########################
    case EXT4_PAR_SMART:
        this->gTaskList[this->currentTask].remain_sectors[0] = this->gTaskList[this->currentTask].source_length;
        errorCode = SUCCESS;
        if (!this->fMBWE)
        {
            this->gExt4Smart = new CExt4Smart(this->gTaskList[currentTask].target, this, this->gTaskList[currentTask].remain_sectors, this->gCopyResult);
            if (!this->gExt4Smart)
            {
                printDFXLog (PRI_INFO, "Can not create CExt4Smart object.");
                errorCode = ERRORED;
                for (short disk = 1; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[currentTask].target.item[disk])
                    {
                        if(this->isCancelWhileDup())
                        {
                            if(this->gCopyResult[disk] == INCOMPLETE)
                            {
                                this->gCopyResult[disk] = CANCELLED;
                            }
                        }
                        this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                        this->dbObj.insertTbTaskInJob(disk, currentTask);
                        this->dbObj.errMsgObj.setErrorMessage("Can't create CExt4Smart object");
                        this->dbObj.insertTbErrorMessage(disk);
                    }
                }
                return ERRORED;
            }

            this->gExt4Smart->setCopyMode();	//quick format
            errorCode = SUCCESS;
            if(this->gExt4Smart->initialize() == SUCCESS)
            {
                if(this->isBriefCopy == FALSE)
                {
                    if((this->gExt4Smart->copyRootInode()     == UNSUCCESS)	||
                            (this->gExt4Smart->copyBadInode()      == UNSUCCESS)	||
                            (this->gExt4Smart->copyResizeInode()   == UNSUCCESS)	||
                            (this->gExt4Smart->copyJournalInode()  == UNSUCCESS))
                    {
                        errorCode = ERRORED;
                    }
                }
            }
            else
            {
                errorCode = ERRORED;
            }

            this->gExt4Smart->returnCopyResult(this->gCopyResult);

            if (errorCode == ERRORED)
            {
                if (this->gExt4Smart)
                {
                    delete this->gExt4Smart;
                    this->gExt4Smart = NULL;
                }
                for (short disk = 1; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[currentTask].target.item[disk])
                    {
                        if(this->isCancelWhileDup())
                        {
                            if(this->gCopyResult[disk] == INCOMPLETE)
                            {
                                this->gCopyResult[disk] = CANCELLED;
                            }
                        }
                        this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                        this->dbObj.insertTbTaskInJob(disk, currentTask);
                    }
                }
                return ERRORED;
            }
        }
        else
        {
            this->gExt4Smart = new CExt4Smart(this->gTaskList[this->currentTask], this, this->gTaskList[this->currentTask].remain_sectors, this->fMBWE);
            if (!this->gExt4Smart)
            {
                printDFXLog (PRI_INFO, "Can not create CExt4Smart object.");
                errorCode = ERRORED;
                for (short disk = 1; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[currentTask].target.item[disk])
                    {
                        if(this->isCancelWhileDup())
                        {
                            if(this->gCopyResult[disk] == INCOMPLETE)
                            {
                                this->gCopyResult[disk] = CANCELLED;
                            }
                        }
                        this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                        this->dbObj.insertTbTaskInJob(disk, currentTask);
                        this->dbObj.errMsgObj.setErrorMessage("Can't create CExt2Smart object");
                        this->dbObj.insertTbErrorMessage(disk);
                    }
                }
                return ERRORED;
            }
        }
        this->gTaskList[currentTask].state = TASK_SMART;
        break;

        //############### FAT_32_FORMAT ##########################
    case FAT_32_FORMAT:
        this->gFAT32Smart = new CFAT32Smart(this->gTaskList[currentTask].target, this, this->gTaskList[currentTask].remain_sectors, this->m_Translated_CHF, this->gTaskList[currentTask].hidden_sectors, this->gCopyResult);
        if (!this->gFAT32Smart)
        {
            printDFXLog (PRI_INFO, "Cannot create CFAT32Smart object.");
            errorCode = ERRORED;
            return ERRORED;
        }

        errorCode = this->gFAT32Smart->format(gLiveTargetList, outputErrorList);

        this->gFAT32Smart->returnCopyResult (this->gCopyResult);

        this->gTaskList[this->currentTask].state = TASK_SMART;
        break;

        //############### FORMAT_DISK ##########################
    case FORMAT_DISK:
        printDFXLog (PRI_INFO, "Begin format disk");
        this->gTaskList[currentTask].state = TASK_SMART;
        break;

        //############### NTFS_PAR_SOURCE_SMALLER_TARGET ##########################
    case NTFS_PAR_SOURCE_SMALLER_TARGET:
        this->gTaskList[this->currentTask].remain_sectors[0] = this->gTaskList[this->currentTask].source_length;

        this->gNtfsCopy = new NtfsCopy(this->gTaskList[this->currentTask].target, this, this->gTaskList[this->currentTask].remain_sectors, this->m_Translated_CHF, this->gTaskList[this->currentTask].hidden_sectors, this->gCopyResult);
        if (!this->gNtfsCopy)
        {
            printDFXLog (PRI_INFO, "Cannot create NtfsCopy object.");
            errorCode = ERRORED;
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(this->isCancelWhileDup())
                    {
                        if(this->gCopyResult[disk] == INCOMPLETE)
                        {
                            this->gCopyResult[disk] = CANCELLED;
                        }
                    }
                    this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                    this->dbObj.insertTbTaskInJob(disk, currentTask);
                    this->dbObj.errMsgObj.setErrorMessage("Can't create NtfsCopy object");
                    this->dbObj.insertTbErrorMessage(disk);
                }
            }
            return ERRORED;
        }

        this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_TRANSFER;
        this->gTaskList[this->currentTask].state = TASK_SMART;
        break;

        //############### MIRROR_PAR ##########################
    case MIRROR_PAR:
        errorCode = SUCCESS;

        startSector[0] = this->gTaskList[this->currentTask].source_sector;
        sectorCount[0] = this->gTaskList[this->currentTask].remain_sectors[1];

        for (i = 1;i < MAX_DISKS;i++)
        {
            startSector[i] = this->gTaskList[this->currentTask].target_sector[i];
            sectorCount[i] = this->gTaskList[this->currentTask].remain_sectors[i];

            if (gTaskList[currentTask].target.item[i])
            {
                min_idx = i;
                min_remain_sectors = this->gTaskList[this->currentTask].remain_sectors[i];
            }
        }

        for (i = 1;i < MAX_DISKS;i++)
        {
            if ((this->gTaskList[this->currentTask].remain_sectors[i] < min_remain_sectors) && (this->gTaskList[this->currentTask].target.item[i]))
            {
                min_idx = i;
                min_remain_sectors = this->gTaskList[this->currentTask].remain_sectors[i];
            }
        }
        for (i = 1;i < MAX_DISKS;i++)
        {
            if (this->gTarget[i].disk_mode == DISK_SMART)
            {
                if (min_remain_sectors < this->gTaskList[this->currentTask].source_length)
                {
                    sectorCount[i] = min_remain_sectors;
                }
                else
                {
                    sectorCount[i] = this->gTaskList[this->currentTask].source_length;
                }
            }
        }

        memcpy((char*)&this->gLiveTargetList, (char*)&this->gTaskList[currentTask], sizeof(ITEM_LIST_STRUCT));

        this->gMirrorOperation = new CMirrorOperation(this->gTaskList[this->currentTask].target, this, startSector, sectorCount, test_disk_params, this->gCopyResult);
        if (!this->gMirrorOperation)
        {
            printDFXLog (PRI_INFO, "Cannot create CMirrorOperation object.");
            errorCode = ERRORED;
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(this->isCancelWhileDup())
                    {
                        if(this->gCopyResult[disk] == INCOMPLETE)
                        {
                            this->gCopyResult[disk] = CANCELLED;
                        }
                    }
                    this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                    this->dbObj.insertTbTaskInJob(disk, currentTask);
                    this->dbObj.errMsgObj.setErrorMessage("Can't create CMirrorOperation object");
                    this->dbObj.insertTbErrorMessage(disk);
                }
            }
            return ERRORED;
        }

        if(this->gMirrorOperation->checkEnoughSpaceForTargetDisk() == UNSUCCESS)
        {
            errorCode = ERRORED;
            return ERRORED;
        }

        this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_TRANSFER;
        this->gTaskList[this->currentTask].state	 = TASK_MIRROR;
        break;

        //############### CLEAR_PAR ##########################
    case CLEAR_PAR:
        printDFXLog(PRI_INFO,"Begin Wipe DISK");
        startSector[0] = this->gTaskList[this->currentTask].source_sector;
        sectorCount[0] = this->gTaskList[this->currentTask].remain_sectors[1];

        for (i = 1;i < MAX_DISKS;i++)
        {
            startSector[i] = this->gTaskList[this->currentTask].target_sector[i];
            sectorCount[i] = this->gTaskList[this->currentTask].remain_sectors[i];
        }

        this->gLiveTargetList = this->gTaskList[this->currentTask].target;

        this->gMirrorOperation = new CMirrorOperation(this->gLiveTargetList, this, startSector, sectorCount, test_disk_params, this->gCopyResult);
        if (!this->gMirrorOperation)
        {
            printDFXLog (PRI_INFO, "Cannot create CMirrorOperation object.");
            errorCode = ERRORED;
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(this->isCancelWhileDup())
                    {
                        if(this->gCopyResult[disk] == INCOMPLETE)
                        {
                            this->gCopyResult[disk] = CANCELLED;
                        }
                    }
                    this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                    this->dbObj.insertTbTaskInJob(disk, currentTask);
                    this->dbObj.errMsgObj.setErrorMessage("Can't create CMirrorOperation object");
                    this->dbObj.insertTbErrorMessage(disk);
                }
            }
            return ERRORED;
        }

        this->gMirrorOperation->set_ClearMode(0);

        this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_TRANSFER;
        this->gTaskList[this->currentTask].state     = TASK_MIRROR;
        break;

        //############### FAST PURGE PAR ##########################
    case FAST_PURGE_PAR:
        printDFXLog(PRI_INFO,"Begin FAST Purge DISK");
        startSector[0] = this->gTaskList[this->currentTask].source_sector;
        sectorCount[0] = this->gTaskList[this->currentTask].remain_sectors[1];

        for (i = 1;i < MAX_DISKS;i++)
        {
            startSector[i] = this->gTaskList[this->currentTask].target_sector[i];
            sectorCount[i] = this->gTaskList[this->currentTask].remain_sectors[i];
        }

        this->gLiveTargetList = this->gTaskList[this->currentTask].target;

        this->gFASTPurgeOperation = new CFastPurge(this->gLiveTargetList, this, startSector, sectorCount, test_disk_params, this->gCopyResult);
        if (!this->gFASTPurgeOperation)
        {
            printDFXLog (PRI_INFO, "Cannot create CMirrorOperation object.");
            errorCode = ERRORED;
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(this->isCancelWhileDup())
                    {
                        if(this->gCopyResult[disk] == INCOMPLETE)
                        {
                            this->gCopyResult[disk] = CANCELLED;
                        }
                    }
                    this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                    this->dbObj.insertTbTaskInJob(disk, currentTask);
                    this->dbObj.errMsgObj.setErrorMessage("Can't create CMirrorOperation object");
                    this->dbObj.insertTbErrorMessage(disk);
                }
            }
            return ERRORED;
        }

        this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_TRANSFER;
        this->gTaskList[this->currentTask].state     = TASK_MIRROR;
        break;

        //############### WIPEOUT_PAR ##########################
    case WIPEOUT_PAR:
        printDFXLog(PRI_INFO,"Begin DOD WipeOut");
        startSector[0] = this->gTaskList[this->currentTask].source_sector;
        sectorCount[0] = this->gTaskList[this->currentTask].remain_sectors[1];

        for (i = 1;i < MAX_DISKS;i++)
        {
            startSector[i] = this->gTaskList[this->currentTask].target_sector[i];
            sectorCount[i] = this->gTaskList[this->currentTask].remain_sectors[i];
        }

        this->gLiveTargetList = this->gTaskList[this->currentTask].target;

        this->gDWOOperation = new CDODWipeOut(this->gLiveTargetList, startSector, sectorCount, this, this->gCopyResult);
        if (!this->gDWOOperation)
        {
            printDFXLog (PRI_INFO, "Cannot create CMirrorOperation object.");
            errorCode = ERRORED;
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(this->isCancelWhileDup())
                    {
                        if(this->gCopyResult[disk] == INCOMPLETE)
                        {
                            this->gCopyResult[disk] = CANCELLED;
                        }
                    }
                    this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                    this->dbObj.insertTbTaskInJob(disk, currentTask);
                    this->dbObj.errMsgObj.setErrorMessage("Can't create CMirrorOperation object");
                    this->dbObj.insertTbErrorMessage(disk);
                }
            }
            return ERRORED;
        }

        this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_TRANSFER;
        this->gTaskList[this->currentTask].state     = TASK_MIRROR;
        break;

        //############### SANITIZE_PAR ##########################
    case SANITIZE_PAR:

        for (i = 0;i < this->gTaskList[this->currentTask].target.items;i++)
        {
            d = this->gTaskList[this->currentTask].target.item[i];
            this->gTaskList[this->currentTask].target_sector[d] = this->gTaskList[this->currentTask].target_info[d].partition_start;
            this->gTaskList[this->currentTask].remain_sectors[d] = this->gTaskList[this->currentTask].target_info[d].partition_length;
        }

        this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_TRANSFER;
        this->gTaskList[this->currentTask].state = TASK_FIRST_SANITIZE;
        break;

        //############### MIRROR_HPA ##########################
    case MIRROR_HPA:
        this->gTaskList[this->currentTask].state = TASK_SET_NATIVE_MAX_ADDRESS;
        break;

        //############### SMART_HPA ##########################
    case SMART_HPA:
        this->gHPAOperation = new GDS_CLS_ND105_HPA(&this->diskIOModule);
        memcpy((char*)&gLiveTargetList, (char*)&this->gTaskList[this->currentTask], sizeof(ITEM_LIST_STRUCT));
        this->gHPAOperation->set_item_list_struct(this->gLiveTargetList);
        this->gTaskList[this->currentTask].state = TASK_SMART;
        break;

        //############### TEST_PAR ##########################
    case TEST_PAR:
        for (i = 1;i < MAX_DISKS;i++)
        {
            startSector[i] = this->gTaskList[this->currentTask].target_sector[i];
            sectorCount[i] = this->gTaskList[this->currentTask].remain_sectors[i];
        }

        memcpy((char*)&this->gLiveTargetList, (char*)&this->gTaskList[this->currentTask], sizeof(ITEM_LIST_STRUCT));

        this->gTestDiskOperation = new CTestDisk(this->gLiveTargetList, startSector, sectorCount, &this->diskIOModule, test_disk_params);
        if (!this->gTestDiskOperation)
        {
            printDFXLog(PRI_INFO,MES_ERR"create gTestDiskOperation error");
            return ERRORED;
        }

        if (this->gTestDiskOperation->initialize() != SUCCESS)
        {
            printDFXLog(PRI_INFO,MES_ERR"initialize CTestDisk error");
            delete this->gTestDiskOperation;
            this->gTestDiskOperation = NULL;
            return ERRORED;
        }
        this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_TRANSFER;
        this->gTaskList[this->currentTask].state = TASK_SMART;
        this->diskIOModule.setVerifyMode();
        break;

        //############### TEST_HPA ##########################
    case TEST_HPA:
        this->gTaskList[this->currentTask].state = TASK_SET_NATIVE_MAX_ADDRESS;
        break;

        //############### SCRTY_ERASE_PAR ##########################
    case SCRTY_ERASE_PAR:
        this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_TRANSFER;
        this->gTaskList[this->currentTask].state = TASK_SMART;
        break;

        //############### SCRTY_ERASE_HPA ##########################
    case SCRTY_ERASE_HPA:
        this->gTaskList[this->currentTask].state = TASK_SET_NATIVE_MAX_ADDRESS;
        break;

    default:
        break;
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::executeTask(ACTION_TYPE action)
{
    static short errorCode;
    short percentAction;
    int i = 0;

    switch (action)
    {
    //############### FAT_32_PAR_SMART ##########################
    case FAT_32_PAR_SMART:
    {
        errorCode = this->gFAT32Smart->copy();
        percentAction = this->gFAT32Smart->returnActionPercent();
        this->gFAT32Smart->returnCopyResult(gCopyResult);
        for (short disk = 1; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                if(this->isCancelWhileDup())
                {
                    if(this->gCopyResult[disk] == INCOMPLETE)
                    {
                        this->gCopyResult[disk] = CANCELLED;
                    }
                }
                this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                this->gPercentCopied[disk] = percentAction;
                this->dbObj.insertTbTaskInJob(disk, currentTask);
            }
        }

        if(errorCode == ERRORED)
        {
            if(gFAT32Smart)
            {
                delete this->gFAT32Smart;
                this->gFAT32Smart = NULL;
            }
            this->diskIOModule.setCopyMode();
            this->diskIOModule.clearVerifyMapSector();
            return ERRORED;
        }

        if(errorCode == FINISHED)
        {
            if(this->isBriefCopy == FALSE)
            {
                errorCode = this->updateBootConfigureDataFile(gTaskList[currentTask].action);
            }
            for (short disk = 1; disk < MAX_DISKS;disk++)
            {
                if(gCopyResult[disk] != GOOD_COPY)
                {
                    for (int j = currentTask; j < MAX_TASKS; j++)
                    {
                        gTaskList[j].target.item[disk] = 0;
                    }
                }

                if(gTaskList[currentTask].target.item[disk])
                {
                    gCurrentTask[disk]++;	// finish one task
                }

                if(gCurrentTask[disk] == gTotalTask[disk])
                {
                    gPercentCopied[disk] = 100;
                }
            }
            gTaskList[currentTask].sub_state	= PROC_PREPARE_VERIFY;
            gTaskList[currentTask].state		= TASK_FINISH_COPY;
            //diskIOModule.setCopyMode();
        }
    }
        break;

        //############### EXT2_PAR_SMART ##########################
    case EXT2_PAR_SMART:
    {
        if(!fMBWE)
        {
            errorCode = gExt2Smart->copy();
        }
        else
        {
            errorCode = gExt2Smart->DF5EXT2NORMAL_Copy(gTaskList[currentTask], gPercentCopied, gCurrentTask, gTotalTask);
        }
        // Update progress bar
        percentAction = gExt2Smart->returnActionPercent();
        gExt2Smart->returnCopyResult(this->gCopyResult);
        for (short disk = 1; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                if(this->isCancelWhileDup())
                {
                    if(this->gCopyResult[disk] == INCOMPLETE)
                    {
                        this->gCopyResult[disk] = CANCELLED;
                    }
                }
                this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                this->gPercentCopied[disk] = percentAction;
                this->dbObj.insertTbTaskInJob(disk, currentTask);
            }
        }

        if(errorCode == ERRORED)
        {
            if(gExt2Smart)
            {
                delete gExt2Smart;
                gExt2Smart = NULL;
            }
            this->diskIOModule.setCopyMode();
            this->diskIOModule.clearVerifyMapSector();
            return ERRORED;
        }

        if(errorCode == FINISHED)
        {
            for (short disk = 1;disk < MAX_DISKS;disk++)
            {
                if(gCopyResult[disk] != GOOD_COPY)
                {
                    for (int j = currentTask; j < MAX_TASKS; j++)
                    {
                        gTaskList[j].target.item[disk] = 0;
                        listDrivesSetupLilo[disk] = 0;
                        listDrivesSetupGRUB[disk] = 0;
                    }
                }

                if(gTaskList[currentTask].target.item[disk])
                {
                    gCurrentTask[disk]++;	//finish one task
                }

            }

            gTaskList[currentTask].sub_state	= PROC_PREPARE_VERIFY;
            gTaskList[currentTask].state		= TASK_FINISH_COPY;
            DoneEXTSmart = true;
            //diskIOModule.setCopyMode();
        }
    }
        break;

        //############### EXT4_PAR_SMART ##########################
    case EXT4_PAR_SMART:
    {
        if(!fMBWE)
        {
            errorCode = this->gExt4Smart->copy();
        }
        else
        {
            errorCode = this->gExt4Smart->DF5EXT2NORMAL_Copy(gTaskList[currentTask], gPercentCopied, gCurrentTask, gTotalTask);
        }
        // Update progress bar
        percentAction = gExt4Smart->returnActionPercent();
        this->gExt4Smart->returnCopyResult(gCopyResult);
        for (short disk = 1; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                if(this->isCancelWhileDup())
                {
                    if(this->gCopyResult[disk] == INCOMPLETE)
                    {
                        this->gCopyResult[disk] = CANCELLED;
                    }
                }
                this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                this->gPercentCopied[disk] = percentAction;
                this->dbObj.insertTbTaskInJob(disk, currentTask);
            }
        }
        if(errorCode == ERRORED)
        {
            if(this->gExt4Smart)
            {
                delete this->gExt4Smart;
                this->gExt4Smart = NULL;
            }
            this->diskIOModule.setCopyMode();
            this->diskIOModule.clearVerifyMapSector();
            return ERRORED;
        }

        if(errorCode == FINISHED)
        {
            for (short disk = 1;disk < MAX_DISKS;disk++)
            {
                if(gCopyResult[disk] != GOOD_COPY)
                {
                    for (int j = currentTask; j < MAX_TASKS; j++)
                    {
                        gTaskList[j].target.item[disk] = 0;
                        listDrivesSetupLilo[disk] = 0;
                        listDrivesSetupGRUB[disk] = 0;
                    }
                }

                if(gTaskList[currentTask].target.item[disk])
                {
                    gCurrentTask[disk]++;	//finish one task
                }

            }

            gTaskList[currentTask].sub_state	= PROC_PREPARE_VERIFY;
            gTaskList[currentTask].state		= TASK_FINISH_COPY;
            DoneEXTSmart = true;
            //diskIOModule.setCopyMode();
        }
    }
        break;

        //############### FORMAT_DISK ##########################
    case FORMAT_DISK:
        errorCode = handleFormatDisk(-1);

        if (errorCode == ERRORED)
        {
            return ERRORED;
        }
        else if(errorCode == PAR_TYPE_LVM)
        {
            return PAR_TYPE_LVM;
        }

        if (errorCode == FINISHED)
        {
            this->gTaskList[this->currentTask].sub_state = PROC_PREPARE_VERIFY;
            this->gTaskList[this->currentTask].state = TASK_FINISH_COPY;
        }

        for (i = 1;i < MAX_DISKS;i++)
        {
            if (this->gTaskList[currentTask].target.item[i])
            {
                this->gCurrentTask[i]++;
            }
        }
        break;

        //############### NTFS_PAR_SOURCE_SMALLER_TARGET ##########################
    case NTFS_PAR_SOURCE_SMALLER_TARGET:
    {
        errorCode = gNtfsCopy->Copy(gPercentCopied, currentTask, totalTask, gCopyResult);
        short percentAction = gNtfsCopy->ActionPercent();
        gNtfsCopy->ReturnCopyResult(gCopyResult);
        for (short disk = 1; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                if(this->isCancelWhileDup())
                {
                    if(this->gCopyResult[disk] == INCOMPLETE)
                    {
                        this->gCopyResult[disk] = CANCELLED;
                    }
                }
                this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                this->gPercentCopied[disk] = percentAction;
                this->dbObj.insertTbTaskInJob(disk, currentTask);
            }
        }
        if(errorCode == ERRORED)
        {
            if(gNtfsCopy)
            {
                delete gNtfsCopy;
                gNtfsCopy = NULL;
            }
            // set to copy mode
            printDFXLog(PRI_INFO, "NTFS smart: %-40s %s", "Set copy mode", MES_FAILED);
            this->diskIOModule.setCopyMode();
            this->diskIOModule.clearVerifyMapSector();
            return ERRORED;
        }

        if(errorCode == FINISHED)
        {
            if(this->isBriefCopy == FALSE)
            {
                errorCode = this->updateBootConfigureDataFile(gTaskList[currentTask].action);
            }
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if(gCopyResult[disk] != GOOD_COPY)
                {
                    for (short j = currentTask; j < MAX_TASKS; j++)
                    {
                        gTaskList[j].target.item[disk] = 0;
                    }
                }

                if(gTaskList[currentTask].target.item[disk])
                {
                    //printDFXLog(PRI_INFO,MES_WAR "NTFS smart:Finished: disk %d sucess",disk);
                    gCurrentTask[disk]++;	//	finish one task
                }
            }
            printDFXLog(PRI_INFO, "NTFS smart: %-40s %s", "Set copy mode", MES_OK);
            //diskIOModule.setCopyMode();
            gTaskList[currentTask].sub_state	= PROC_PREPARE_VERIFY;
            gTaskList[currentTask].state		= TASK_FINISH_COPY;
        }
    }
        break;

        //############### MIRROR_PAR ##########################
    case MIRROR_PAR:
        errorCode = gMirrorOperation->copy();
        gMirrorOperation->returnCopyResult(this->gCopyResult);
        for (short disk = 1; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                if(this->isCancelWhileDup())
                {
                    if(this->gCopyResult[disk] == INCOMPLETE)
                    {
                        this->gCopyResult[disk] = CANCELLED;
                    }
                }
                fprintf(stderr, "\n THDB here: Disk[%d]: gCopyResult = %d", disk, this->gCopyResult[disk]);
                this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                this->gPercentCopied[disk] = gMirrorOperation->returnActionPercent(disk);
                this->dbObj.insertTbTaskInJob(disk, currentTask);
            }
        }

        if((errorCode == ERRORED) || (errorCode == UNSUCCESS))
        {
            if(gMirrorOperation)
            {
                delete gMirrorOperation;
                gMirrorOperation = NULL;
            }
            return ERRORED;
        }


        if(errorCode == FINISHED)
        {
            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                // HOAHOANG: update BAD state copy
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(gCopyResult[disk] != GOOD_COPY)
                    {
                        for (int j = currentTask; j < MAX_TASKS; j++)
                        {
                            gTaskList[j].target.item[disk] = 0;
                        }
                    }
                }
                if(gTaskList[currentTask].target.item[disk])
                {
                    gCurrentTask[disk]++;	// finish one task
                }

            }

            //diskIOModule.setCopyMode();
            gTaskList[currentTask].state = TASK_FINISH_COPY;
        }

        break;

        //############### CLEAR_PAR ##########################
    case CLEAR_PAR: //WipeDisk
        errorCode = gMirrorOperation->copy();
        gMirrorOperation->returnCopyResult(gCopyResult);
        for (short disk = 1; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                if(this->isCancelWhileDup())
                {
                    if(this->gCopyResult[disk] == INCOMPLETE)
                    {
                        this->gCopyResult[disk] = CANCELLED;
                    }
                }
                this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                this->gPercentCopied[disk] = gMirrorOperation->returnActionPercent(disk);
                this->dbObj.insertTbTaskInJob(disk, currentTask);
            }
        }

        if((errorCode == ERRORED) || (errorCode == UNSUCCESS))
        {
            if(gMirrorOperation)
            {
                delete gMirrorOperation;
                gMirrorOperation = NULL;
            }
            this->diskIOModule.setCopyMode();
            this->diskIOModule.clearVerifyMapSector();
            return ERRORED;
        }

        if(errorCode == FINISHED)
        {
            //Update the number of copied sectors for job
            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    this->totalOfCopiedSectors[disk] +=  gMirrorOperation->getNumberSectorCopy();
                    //fprintf(stderr, "\n Disk[%d]: the number of copied sector %lu", disk, this->totalOfCopiedSectors[disk]);
                }
            }

            for (short disk = 1; disk < MAX_DISKS;disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(gCopyResult[disk] != GOOD_COPY)
                    {
                        gTaskList[currentTask].target.item[disk] = 0;
                    }
                }

                if(gTaskList[currentTask].target.item[disk])
                {
                    gCurrentTask[disk]++;	//	finish one task
                }
            }
            //diskIOModule.setCopyMode();
            if(gMirrorOperation)
            {
                delete gMirrorOperation;
                gMirrorOperation = NULL;
            }

            gTaskList[currentTask].state = TASK_IDLE;

        }
        break;

    case FAST_PURGE_PAR: //FAST Purge
        errorCode = gFASTPurgeOperation->copy();
        gFASTPurgeOperation->returnCopyResult(gCopyResult);
        for (short disk = 1; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                if(this->isCancelWhileDup())
                {
                    if(this->gCopyResult[disk] == INCOMPLETE)
                    {
                        this->gCopyResult[disk] = CANCELLED;
                    }
                }
                this->dbObj.taskInJobObj[disk][currentTask].setTaskResult(this->Result(this->gCopyResult[disk], disk));
                this->gPercentCopied[disk] = gFASTPurgeOperation->returnActionPercent(disk);
                this->dbObj.insertTbTaskInJob(disk, currentTask);
            }
        }

        if((errorCode == ERRORED) || (errorCode == UNSUCCESS))
        {
            if(gFASTPurgeOperation)
            {
                delete gFASTPurgeOperation;
                gFASTPurgeOperation = NULL;
            }
            this->diskIOModule.setCopyMode();
            this->diskIOModule.clearVerifyMapSector();
            return ERRORED;
        }

        if(errorCode == FINISHED)
        {
            //Update the number of copied sectors for job
            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    this->totalOfCopiedSectors[disk] +=  gFASTPurgeOperation->getNumberSectorCopy();
                    //fprintf(stderr, "\n Disk[%d]: the number of copied sector %lu", disk, this->totalOfCopiedSectors[disk]);
                }
            }

            for (short disk = 1; disk < MAX_DISKS;disk++)
            {
                if(gTaskList[currentTask].target.item[disk])
                {
                    if(gCopyResult[disk] != GOOD_COPY)
                    {
                        gTaskList[currentTask].target.item[disk] = 0;
                    }
                }

                if(gTaskList[currentTask].target.item[disk])
                {
                    gCurrentTask[disk]++;	//	finish one task
                }
            }
            //diskIOModule.setCopyMode();
            if(gFASTPurgeOperation)
            {
                delete gFASTPurgeOperation;
                gFASTPurgeOperation = NULL;
            }

            gTaskList[currentTask].state = TASK_IDLE;

        }
        break;

        //############### WIPEOUT_PAR ##########################
    case WIPEOUT_PAR:
        errorCode = this->gDWOOperation->dodWipeout();
        if (this->actionMode == VERIFYING_MODE){
            errorCode = FINISHED;//not veryfy
        }

        for (short disk = 1;disk < MAX_DISKS;disk++){
            //fprintf(stderr, "\n THDB here: +++++++++++++ Disk[%d] - Total task: %d", disk, this->gTotalTask[disk]);
            if (this->gTaskList[this->currentTask].target.item[disk] == 1){
                if (errorCode == FINISHED){
                    this->gPercentCopied[disk] = (((unsigned long)this->gCurrentTask[disk]) * 100) / this->gTotalTask[disk] + (100 / this->gTotalTask[disk]);
                }
                else{
                    this->gPercentCopied[disk] = (((unsigned long)this->gCurrentTask[disk]) * 100) / this->gTotalTask[disk] + (this->gDWOOperation->returnActionPercent(disk) / this->gTotalTask[disk]);
                }
            }
        }

        //fprintf(stderr, "\n THDB here: +++++++++++++ Finish dodWipeout1");
        this->gDWOOperation->returnCopyResult(this->gCopyResult);
        if (errorCode == ERRORED){
            return ERRORED;
        }

        if (errorCode == FINISHED){
            this->gTaskList[this->currentTask].state = TASK_IDLE;

            if (this->gDWOOperation){
                delete(this->gDWOOperation);
                this->gDWOOperation = NULL;
            }
        }
        break;

        //############### SMART_HPA ##########################
    case SMART_HPA:
        if (!this->gHPAOperation->smart_copy())
        {
            printDFXLog(PRI_INFO, "hpa_module: Smart copy is error.");
            errorCode = ERRORED;
            this->gTaskList[this->currentTask].state = TASK_FINISH_COPY;
        }

        if (errorCode == ERRORED)
        {
            errorCode = FINISHED;
        }
        else
        {
            if (this->gHPAOperation->m_cur_state_active == GDS_HPA_STATE_FINISHED)
            {
                printDFXLog(PRI_INFO, "FINISH HPA");
                errorCode = FINISHED;
            }
            else
            {
                errorCode = UNFINISHED;
            }

            for (i = 1;i < MAX_DISKS;i++)
            {
                if (this->gTaskList[this->currentTask].target.item[i])
                    this->gPercentCopied[i] = (((unsigned long)this->gCurrentTask[i]) * 100) / this->gTotalTask[i] + (this->gHPAOperation->get_completed_percent() / this->gTotalTask[i]);
            }

            if (errorCode == FINISHED)
            {
                for (int disk = 1;disk < MAX_DISKS;disk++)
                {
                    if (this->gTaskList[this->currentTask].target.item[disk])
                        this->gCurrentTask[disk]++;//finish a task
                }

                this->gTaskList[this->currentTask].state = TASK_FINISH_COPY;
            }
        }
        break;

        //############### TEST_PAR ##########################
    case TEST_PAR:
        errorCode = this->gTestDiskOperation->TestDisk();

        for (i = 1;i < MAX_DISKS;i++)
        {
            if (this->gTaskList[this->currentTask].target.item[i])
            {
                if (errorCode == FINISHED)
                {
                    this->gPercentCopied[i] = (((unsigned long)this->gCurrentTask[i]) * 100) / this->gTotalTask[i] + (100 / this->gTotalTask[i]);
                }
                else
                {
                    this->gPercentCopied[i] = (((unsigned long)this->gCurrentTask[i]) * 100) / this->gTotalTask[i] + (this->gTestDiskOperation->returnActionPercent(i) / this->gTotalTask[i]);
                }
            }
        }

        this->gTestDiskOperation->returnCopyResult(gCopyResult);

        if (errorCode == ERRORED)
        {
            delete this->gTestDiskOperation;
            this->gTestDiskOperation = NULL;
            this->diskIOModule.setCopyMode();
            this->diskIOModule.clearVerifyMapSector();
            //fprintf(stderr,"\ncase TEST_PAR: SMART_COPY: cancel here");
            return ERRORED;
        }

        if (errorCode == FINISHED)
        {
            for (short disk = 1; disk < MAX_DISKS;disk++)
            {
                if (this->gTaskList[this->currentTask].target.item[disk] == 1)
                {
                    if (this->gCopyResult[disk] != GOOD_COPY)
                    {
                        this->gTaskList[this->currentTask].target.item[disk] = 0;
                    }
                }
                if (this->gTaskList[this->currentTask].target.item[disk] == 1)
                {
                    this->gCurrentTask[disk]++;	//	finish one task
                }
            }
            this->gTaskList[this->currentTask].state = TASK_IDLE;
            delete this->gTestDiskOperation;
            this->gTestDiskOperation = NULL;
        }
        break;
    default:
        break;
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::finishedTask(ACTION_TYPE action)
{
    static short errorCode;
    switch (action)
    {
    //############### FAT_32_PAR_SMART ##########################
    case FAT_32_PAR_SMART:
        //Update the number of copied sectors for job
        for (short disk = 0; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                this->totalOfCopiedSectors[disk] +=  gFAT32Smart->getSectorCountCopied();
                //fprintf(stderr, "\n Disk[%d]: the number of copied sector %lu", disk, this->totalOfCopiedSectors[disk]);
            }
        }

        if (this->gFAT32Smart)
        {
            delete this->gFAT32Smart;
            this->gFAT32Smart = NULL;
        }
        this->gTaskList[currentTask].state = TASK_IDLE;
        break;

        //############### EXT2_PAR_SMART ##########################
    case EXT2_PAR_SMART:
        //Update the number of copied sectors for job
        for (short disk = 0; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                this->totalOfCopiedSectors[disk] +=  gExt2Smart->getNumberOfCopiedSectors();
                //fprintf(stderr, "\n Disk[%d]: the number of copied sector %lu", disk, this->totalOfCopiedSectors[disk]);
            }
        }

        if (this->gExt2Smart)
        {
            delete(this->gExt2Smart);
            this->gExt2Smart = NULL;
        }
        this->gTaskList[currentTask].state = TASK_IDLE;
        break;

        //############### EXT4_PAR_SMART ##########################
    case EXT4_PAR_SMART:
        //Update the number of copied sectors for job
        for (short disk = 0; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                this->totalOfCopiedSectors[disk] +=  gExt4Smart->getNumberOfCopiedSectors();
                //fprintf(stderr, "\n Disk[%d]: the number of copied sector %lu", disk, this->totalOfCopiedSectors[disk]);
            }
        }

        if (this->gExt4Smart)
        {
            delete(this->gExt4Smart);
            this->gExt4Smart = NULL;
        }
        this->gTaskList[this->currentTask].state = TASK_IDLE;
        break;

        //############### FAT_32_FORMAT ##########################
    case FAT_32_FORMAT:
        if (this->gFAT32Smart)
        {
            delete(this->gFAT32Smart);
            this->gFAT32Smart = NULL;
        }
        this->gTaskList[this->currentTask].state = TASK_IDLE;
        break;

        //############### FORMAT_DISK ##########################
    case FORMAT_DISK:
        errorCode = FINISHED;

        if (errorCode == ERRORED)
        {
            return ERRORED;
        }
        break;

        //############### NTFS_PAR_SOURCE_SMALLER_TARGET ##########################
    case NTFS_PAR_SOURCE_SMALLER_TARGET:
        //Update the number of copied sectors for job
        for (short disk = 0; disk < MAX_DISKS; disk++)
        {
            if(gTaskList[currentTask].target.item[disk])
            {
                this->totalOfCopiedSectors[disk] +=  gNtfsCopy->getSectorCountCopied();
                //fprintf(stderr, "\n Disk[%d]: the number of copied sector %lu", disk, this->totalOfCopiedSectors[disk]);
            }
        }

        if (this->gNtfsCopy)
        {
            delete this->gNtfsCopy;
            this->gNtfsCopy = NULL;
        }
        this->gTaskList[this->currentTask].state = TASK_IDLE;
        break;

        //############### MIRROR_PAR ##########################
    case MIRROR_PAR:
        //Update the number of copied sectors for job
        for (short disk = 0; disk < MAX_DISKS; disk++)
        {
            fprintf(stderr, "\n THDB here2: Disk[%d]: gCopyResult = %d", disk, this->gCopyResult[disk]);
            if(gTaskList[currentTask].target.item[disk])
            {
                this->totalOfCopiedSectors[disk] +=  gMirrorOperation->getNumberSectorCopy();
                //fprintf(stderr, "\n Disk[%d]: the number of copied sector %lu", disk, this->totalOfCopiedSectors[disk]);
            }
        }

        if (this->gMirrorOperation)
        {
            delete this->gMirrorOperation;
            this->gMirrorOperation = NULL;
        }
        this->gTaskList[this->currentTask].state = TASK_IDLE;
        break;

        //############### CLEAR_PAR ##########################
    case CLEAR_PAR:
        break;

        //############### FAST PURGE ##########################
    case FAST_PURGE_PAR:
        break;

        //############### WIPEOUT_PAR ##########################
    case WIPEOUT_PAR:
        break;

        //############### SANITIZE_PAR ##########################
    case SANITIZE_PAR:
        break;

        //############### MIRROR_HPA ##########################
    case MIRROR_HPA:
        break;

        //############### SMART_HPA ##########################
    case SMART_HPA:
        break;

        //############### TEST_PAR ##########################
    case TEST_PAR:
        break;

        //############### TEST_HPA ##########################
    case TEST_HPA:
        break;

        //############### SCRTY_ERASE_HPA ##########################
    case SCRTY_ERASE_HPA:
        break;

    default:
        break;
    }
    SLEEP(1);

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::setupFinishedTask()
{
    qDebug() << "SETUP FINISHED TASK >>>>>>>>>>>>>>>>>>>>>>>>>>";
    short i;
    short bootloader = GRUB_ERROR;
    CSetupGRUB *pSetupGrub = NULL;

    this->currentTask++;
    if (this->currentTask >= this->totalTask)
    {
        this->currentTask = 0;

        for (i = 0;i < MAX_DISKS;i++)
        {
            if (this->gDriveState[i] == DRIVE_READY)
            {
                this->gPercentCopied[i] = 99;
                this->diskIOModule.setPartitionStart(i, 0);
                this->diskIOModule.setPartitionLength(i, gCapacity[i]);
            }
        }

        if ((this->gDriveState[0] == DRIVE_READY) && (DoneEXTSmart))
        {
            if((this->isBriefCopy == FALSE) && (this->isSetupBootLoader() == true))
            {
                bootloader = this->DFXCheckBootLoader(SOURCE_HDD);
                if (GRUB_ERROR == bootloader)
                {
                    for (i = 0;i < MAX_DISKS;i++)
                    {
                        if (this->gDriveState[i] == DRIVE_READY)
                        {
                            this->gPercentCopied[i] = 100;
                        }
                    }

                    //TamHo add code here (July 06 2012): Doing flush cache before exec verify
                    ITEM_LIST_STRUCT inlist;
                    ITEM_LIST_STRUCT outlist;
                    memcpy(&inlist, &gTaskList[currentTask].target, sizeof(ITEM_LIST_STRUCT));
                    memcpy(&outlist, &gTaskList[currentTask].target, sizeof(ITEM_LIST_STRUCT));
                    this->diskIOModule.isFinishedCopy = true;

                    //Flush cache 28 bit area
                    for (i = 1; i < MAX_DISKS; i++)
                    {
                        if(this->diskIOModule.getInputOfDisk(i) == CHECKED)
                        {
                            this->diskIOModule.statusFlushCache[i] = SEGMENT_28_BIT;
                            inlist.item[i] = 1;
                        }
                        else
                        {
                            inlist.item[i] = 0;
                        }
                    }

                    this->diskIOModule.checkFlushCacheAllTarget(inlist, outlist);

                    //Flush cache 48 bit area
                    for (i = 1; i < MAX_DISKS; i++)
                    {
                        if(this->gNativeMaxAddress[i] > 0x0FFFFFFF)
                        {
                            this->diskIOModule.statusFlushCache[i] = SEGMENT_48_BIT;
                        }
                    }

                    this->diskIOModule.checkFlushCacheAllTarget(inlist, outlist);
                    this->diskIOModule.isFinishedCopy = false;
                    //End TamHo  (July 06 2012)

                    //Not verify in DOD Wipeout
                    if(this->diskIOModule.jobId == CORE_WIPE_DISK_JOB && this->actionMode == DUPLICATING_MODE &&
                            this->securityOperation->checkFeatureUnlocked(FEATURE_WIPEOUT) == 1){
                        printDFXLog(PRI_INFO, "setupFinishedTask > No verify in case DoD Wipeout - case 1");
                        this->isVerified = true;
                    }
                    //End

                    if((this->systemOption.verify_Mode == 1) && (this->isVerified == false))
                    {
                        if(this->diskIOModule.jobId == CORE_FAST_PURGE_JOB)
                        {
                            fprintf(stderr, "\n FAST Purge verify not supported");
                            return FINISHED;
                        }

                        this->writeCopyResultToLogFileAndDatabase();
                        printDFXLog(PRI_INFO, "setupFinishedTask > Starting verify disk after copying - case 1");
                        for (short disk = 0;disk < MAX_DISKS;disk++)
                        {
                            if (gDriveState[disk] == DRIVE_READY)
                            {
                                if(this->diskStepItem[disk].result.isEmpty())
                                {
                                    this->diskStepItem[disk].result.clear();
                                    this->diskStepItem[disk].stepName = "Verify";
                                    this->diskStepItem[disk].time.restart();
                                    this->diskStepItem[disk].startTime = QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss");
                                    this->diskStepItem[disk].writePattern = this->diskIOModule.mPattern;
                                    printDFXLog (PRI_INFO, "Start verification time for disk[%d] - Start time: %s", disk, this->diskStepItem[disk].startTime.toLatin1().data());
                                }
                            }
                        }
                        for (short disk = 0;disk < MAX_DISKS;disk++)
                        {
                            this->diskStepItem[disk].result.clear();
                            this->diskStepItem[disk].stepName = "Verify";
                            this->diskStepItem[disk].time.restart();
                            this->diskStepItem[disk].startTime = QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss");
                            this->diskStepItem[disk].writePattern = this->diskIOModule.mPattern;
                            printDFXLog (PRI_INFO, "Start verification time for disk[%d] - Start time: %s", disk, this->diskStepItem[disk].startTime.toLatin1().data());
                        }
                        qDebug() << "VERIFY JOB 1 STARTING >>>>>>>>>>>>>>>>>";
                        this->diskIOModule.setVerifyMode();
                        this->diskIOModule.totalRetry = 0;
                        this->actionMode = VERIFYING_MODE;
                        this->isVerified = true;
                        this->systemOption.percentReadBackVerify = 100;
                        currentTask = 0;
                        QDateTime startTime = QDateTime::currentDateTime();
                        this->curJobId++;
                        this->dbObj.jobInfoObj.setId(this->curJobId);
                        this->dbObj.jobInfoObj.setTimeStart(startTime);
                        this->log->job_name = "Verify Disks";
                        this->dbObj.jobInfoObj.setJobName(this->log->job_name);
                        this->dbObj.insertTbJobInformation();
                        this->initializeCopy();
                        this->calTotalSectorCopyAllTask();
                        return UNFINISHED;
                    }

                    if (BUILD_IN_MODE)
                    {
                        this->writeCopyResultToLogFileAndDatabase();
                        printDFXLog(PRI_INFO, "BUILD IN MODE : %lu times", BUILD_IN_MODE);
                        BUILD_IN_MODE++;
                        this->diskIOModule.setCopyMode();
                        this->diskIOModule.clearVerifyMapSector();
                        this->diskIOModule.totalRetry = 0;
                        this->actionMode = DUPLICATING_MODE;
                        this->isVerified = false;
                        this->systemOption.percentReadBackVerify = 0;
                        currentTask = 0;
                        QDateTime startTime = QDateTime::currentDateTime();
                        this->curJobId++;
                        this->dbObj.jobInfoObj.setId(this->curJobId);
                        this->dbObj.jobInfoObj.setTimeStart(startTime);
                        this->log->job_name = "Duplicate Disks";
                        this->dbObj.jobInfoObj.setJobName(this->log->job_name);
                        this->dbObj.insertTbJobInformation();
                        this->initializeCopy();
                        this->calTotalSectorCopyAllTask();
                        return UNFINISHED;
                    }

                    return FINISHED;
                }

                //Setup BOOTLOADER
                PARTITION_LIST_STRUCT *plist = NULL;
                if (GRUB_BOOTLOADER == bootloader)
                {
                    for (short disk = 1;disk < MAX_DISKS;disk++)
                    {
                        if (this->gDriveState[disk] == DRIVE_READY)
                        {
                            printDFXLog (PRI_INFO, "Disk [%u]: %-50s", disk, "Starting setup GRUB loader...");
                            if (this->listDrivesSetupGRUB[disk])
                            {
                                plist = &this->diskStruct[disk].partition_list;

                                for (int tt=0; tt<plist->number_of_partitions; tt++)
                                {
                                    plist->partition[tt].partition_type = this->diskStruct[0].partition_list.partition[tt].partition_type;
                                }

                                pSetupGrub = new CSetupGRUB(this, &this->diskIOModule);
                                if (!pSetupGrub)
                                {
                                    printDFXLog (PRI_INFO, "Disk [%u]: %-50s %s", disk, "Create CSetupGRUB object", MES_FAILED);
                                    continue;
                                }

                                if (pSetupGrub->setup (disk, plist))
                                {
                                    printDFXLog (PRI_INFO, "Disk [%u]: %-50s %s", disk, "Updating GRUB Loader", MES_OK);
                                }
                                else
                                {
                                    printDFXLog (PRI_INFO, "Disk [%u]: %-50s %s", disk, "Updating GRUB Loader", MES_FAILED);
                                    this->gCopyResult[disk] = SETUP_BOOT_LOADER_ERROR;
                                }

                                if (pSetupGrub)
                                {
                                    delete pSetupGrub;
                                    pSetupGrub = NULL;
                                }
                            }
                        }
                    }
                }
                else if (LILO_BOOTLOADER == bootloader)
                {
                    printDFXLog (PRI_INFO, "%-50s", "Starting setup LILO loader...");

                    CSetupLilo* pSetupLILO = new CSetupLilo(this->listDrivesSetupLilo, this);
                    if (!pSetupLILO)
                    {
                        printDFXLog (PRI_INFO, "%-50s %s", "Create CSetupLilo object", MES_FAILED);
                    }
                    else
                    {
                        if (pSetupLILO->setup() > 0)
                        {
                            printDFXLog (PRI_INFO, "%-50s %s", "Updating LILO Loader", MES_OK);
                        }
                        else
                        {
                            printDFXLog (PRI_INFO, "%-50s %s", "Updating LILO Loader", MES_FAILED);
                            for (short disk = 1;disk < MAX_DISKS;disk++)
                            {
                                if ((this->gDriveState[disk] == DRIVE_READY) && (this->listDrivesSetupLilo[disk]))
                                {
                                    this->gCopyResult[disk] = SETUP_BOOT_LOADER_ERROR;
                                }
                            }
                        }
                    }
                    if (pSetupLILO)
                    {
                        delete pSetupLILO;
                        pSetupLILO = NULL;
                    }
                }
                else if (GRUB2_BOOTLOADER_OUT_MBR == bootloader) //DuongVu fix bug can not boot Ubuntu11 (10-01-2012)
                {
                    for (short disk = 1;disk < MAX_DISKS;disk++)
                    {
                        if (gDriveState[disk] == DRIVE_READY)
                        {
                            printDFXLog(PRI_INFO, "Disk [%u]: %-50s", disk, "Starting setup GRUB2 loader...");
                            if (listDrivesSetupGRUB[disk])
                            {
                                plist = &diskStruct[disk].partition_list;

                                for (int tt=0; tt<plist->number_of_partitions; tt++)
                                {
                                    plist->partition[tt].partition_type = diskStruct[0].partition_list.partition[tt].partition_type;
                                }

                                pSetupGrub = new CSetupGRUB(this, &diskIOModule);
                                if (!pSetupGrub)
                                {
                                    printDFXLog(PRI_INFO, "Disk [%u]: %-50s %s", disk, "Create CSetupGRUB object", MES_FAILED);
                                    continue;
                                }

                                if (pSetupGrub->setupGrub2(disk, plist))
                                {
                                    printDFXLog(PRI_INFO, "Disk [%u]: %-50s %s", disk, "Updating GRUB2 Loader", MES_OK);
                                }
                                else
                                {
                                    printDFXLog(PRI_INFO, "Disk [%u]: %-50s %s", disk, "Updating GRUB2 Loader", MES_FAILED);
                                    this->gCopyResult[disk] = SETUP_BOOT_LOADER_ERROR;
                                }

                                if (pSetupGrub)
                                {
                                    delete pSetupGrub;
                                    pSetupGrub = NULL;
                                }
                            }
                        }
                    }
                }//End fix DuongVu (10-01-2012)
            }
            else if((this->isBriefCopy == TRUE) && (this->isSetupBootLoaderInBiefCopy == true))
            {
                PARTITION_LIST_STRUCT *plist = NULL;
                for (short disk = 1;disk < MAX_DISKS;disk++)
                {
                    if (this->gDriveState[disk] == DRIVE_READY)
                    {
                        printDFXLog (PRI_INFO, "Disk [%u]: %-50s", disk, "Starting setup GRUB loader...");
                        if (this->listDrivesSetupGRUB[disk])
                        {
                            plist = &this->diskStruct[disk].partition_list;

                            for (int tt=0; tt<plist->number_of_partitions; tt++)
                            {
                                plist->partition[tt].partition_type = this->diskStruct[0].partition_list.partition[tt].partition_type;
                            }

                            pSetupGrub = new CSetupGRUB(this, &diskIOModule);
                            if (!pSetupGrub)
                            {
                                printDFXLog (PRI_INFO, "Disk [%u]: %-50s %s", disk, "Create CSetupGRUB object", MES_FAILED);
                                continue;
                            }

                            if (pSetupGrub->setup (disk, plist))
                            {
                                printDFXLog (PRI_INFO, "Disk [%u]: %-50s %s", disk, "Updating GRUB Loader", MES_OK);
                            }
                            else
                            {
                                printDFXLog (PRI_INFO, "Disk [%u]: %-50s %s", disk, "Updating GRUB Loader", MES_FAILED);
                                this->gCopyResult[disk] = SETUP_BOOT_LOADER_ERROR;
                            }

                            if (pSetupGrub)
                            {
                                delete pSetupGrub;
                                pSetupGrub = NULL;
                            }
                        }
                    }
                }
            }

            DoneEXTSmart = false;
        } // Ended by Viet

        //////////// RAID disk only
        if (this->fMBWE)
        {
            //printf("RAID disk test only\n");
            ITEM_LIST_STRUCT inlist, outlist;

            memcpy(&inlist, &this->gTaskList[this->currentTask].target, sizeof(ITEM_LIST_STRUCT));
            memcpy(&outlist, &this->gTaskList[this->currentTask].target, sizeof(ITEM_LIST_STRUCT));

            for (short disk = 0;disk < MAX_DISKS;disk++)
            {
                if (this->gDriveState[disk] == DRIVE_READY)
                {
                    inlist.startSector[disk] = 1;
                }
            }

            inlist.sectorCount = this->gTaskList[this->currentTask].source_sector - 1;

            if (!this->diskIOModule.doTransferData(inlist, outlist))

            {
                return UNFINISHED;
            }

            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if ((inlist.item[disk] == 1) && (outlist.item[disk] == 0))
                {
                    HandleIOError(IO_WRITE_DISK, disk, 1, STANDBY_HANDLE_COPY); // write sector 1 -> p1's sector start-1: failed
                }
            }

            short TotalParts = this->diskStruct[0].partition_list.number_of_partitions;
            // End of disk, for backup

            for (short disk = 0;disk < MAX_DISKS;disk++)
            {
                if (gDriveState[disk] == DRIVE_READY)
                {
                    inlist.startSector[disk] = this->diskStruct[disk].partition_list.partition[TotalParts-1].start_sector + this->diskStruct[disk].partition_list.partition[TotalParts-1].number_of_sectors;
                }
            }

            inlist.sectorCount = gCapacity[0] - (this->diskStruct[0].partition_list.partition[TotalParts-1].start_sector + this->diskStruct[0].partition_list.partition[TotalParts-1].number_of_sectors); //5103;

            if (!this->diskIOModule.doTransferData(inlist, outlist))
            {
                return UNFINISHED;
            }

            mMBWE_MaxCapacity4SmartCopy = 0;

            fMBWE = false;
            //printf("END-->RAID disk only\n");
        }

        //////////// RAID disk only

        for (i = 0;i < MAX_DISKS;i++)
        {
            if (gDriveState[i] == DRIVE_READY)
                this->gPercentCopied[i] = 100;
        }

        //DuongVu add code here (Oct 05 2010)
        ITEM_LIST_STRUCT inlist;
        ITEM_LIST_STRUCT outlist;
        memcpy(&inlist, &gTaskList[currentTask].target, sizeof(ITEM_LIST_STRUCT));
        memcpy(&outlist, &gTaskList[currentTask].target, sizeof(ITEM_LIST_STRUCT));
        this->diskIOModule.isFinishedCopy = true;

        //Flush cache 28 bit area
        for (i = 1; i < MAX_DISKS; i++)
        {
            if(this->diskIOModule.getInputOfDisk(i) == CHECKED)
            {
                this->diskIOModule.statusFlushCache[i] = SEGMENT_28_BIT;
                inlist.item[i] = 1;
            }
            else
            {
                inlist.item[i] = 0;
            }
        }

        this->diskIOModule.checkFlushCacheAllTarget(inlist, outlist);

        //Flush cache 48 bit area
        for (i = 1; i < MAX_DISKS; i++)
        {
            if(this->gNativeMaxAddress[i] > 0x0FFFFFFF)
            {
                this->diskIOModule.statusFlushCache[i] = SEGMENT_48_BIT;
            }
        }

        this->diskIOModule.checkFlushCacheAllTarget(inlist, outlist);
        this->diskIOModule.isFinishedCopy = false;
        //End DuongVu (Oct 05 2010)

        //Not verify in DOD Wipeout
        if(this->diskIOModule.jobId == CORE_WIPE_DISK_JOB && this->actionMode == DUPLICATING_MODE &&
                this->securityOperation->checkFeatureUnlocked(FEATURE_WIPEOUT) == 1){
            printDFXLog(PRI_INFO, "setupFinishedTask > No verify in case DoD Wipeout - case 2");
            this->isVerified = true;
        }
        //End

        if((this->systemOption.verify_Mode == 1) && (this->isVerified == false))
        {
            this->writeCopyResultToLogFileAndDatabase();

            printDFXLog(PRI_INFO, "setupFinishedTask > Starting verify disk after copying - case 2");
            for (int i = 0;i < MAX_DISKS ;i++)
            {
                this->diskStepItem[i].result.clear();
                this->diskStepItem[i].stepName = "Verify";
                this->diskStepItem[i].time.restart();
                this->diskStepItem[i].startTime = QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss");
                this->diskStepItem[i].writePattern = this->diskIOModule.mPattern;
            }

            if( this->diskIOModule.jobId == CORE_FAST_PURGE_JOB)
            {
                JOB_STRUCT qtemp;
                for (int i = 0;i < MAX_DISKS ;i++)
                {
                    qtemp = jobstruct_standard(1, DISK_WIPE, 0, 0);
                    this->setJobStructure(i, qtemp);
                    if (gDriveState[i] == DRIVE_READY)
                    {
                        printDFXLog (PRI_INFO, "Start verification time for disk[%d] - Start time: %s", i, this->diskStepItem[i].startTime.toLatin1().data());
                    }
                }
                this->diskIOModule.jobId = CORE_WIPE_DISK_JOB;
            }


            qDebug() << "VERIFY JOB 2 STARTING >>>>>>>>>>>>>>>>>";

            this->diskIOModule.setVerifyMode();
            this->diskIOModule.totalRetry = 0;
            this->actionMode = VERIFYING_MODE;
            this->isVerified = true;
            this->systemOption.percentReadBackVerify = 100;
            currentTask = 0;
            QDateTime startTime = QDateTime::currentDateTime();
            this->curJobId++;
            this->dbObj.jobInfoObj.setId(this->curJobId);
            this->dbObj.jobInfoObj.setTimeStart(startTime);
            this->log->job_name = "Verify Disks";
            this->dbObj.jobInfoObj.setJobName(this->log->job_name);
            this->dbObj.insertTbJobInformation();
            this->initializeCopy();
            this->calTotalSectorCopyAllTask();
            return UNFINISHED;
        }

        if (BUILD_IN_MODE)
        {
            this->writeCopyResultToLogFileAndDatabase();
            printDFXLog(PRI_INFO, "BUILD IN MODE : %lu times", BUILD_IN_MODE);
            BUILD_IN_MODE++;
            this->diskIOModule.setCopyMode();
            this->diskIOModule.clearVerifyMapSector();
            this->diskIOModule.totalRetry = 0;
            this->actionMode = DUPLICATING_MODE;
            this->isVerified = false;
            this->systemOption.percentReadBackVerify = 0;
            currentTask = 0;
            QDateTime startTime = QDateTime::currentDateTime();
            this->curJobId++;
            this->dbObj.jobInfoObj.setId(this->curJobId);
            this->dbObj.jobInfoObj.setTimeStart(startTime);
            this->log->job_name = "Duplicate Disks";
            this->dbObj.jobInfoObj.setJobName(this->log->job_name);
            this->dbObj.insertTbJobInformation();
            this->initializeCopy();
            this->calTotalSectorCopyAllTask();
            return UNFINISHED;
        }

        return FINISHED;
    }
    else
    {
        int finished = 1;

        for (i = 1; i < MAX_DISKS; i++)
        {
            if (this->gTaskList[this->currentTask].target.item[i])
            {
                finished = 0;
                break;
            }
        }

        if (finished)
        {
            return FINISHED;
        }

        //TamHo comment here (27-09-2011)
        /*for (short disk = 0;disk < MAX_DISKS;disk++)
        {
            if ((this->gDriveState[disk] == DRIVE_READY) && (this->gCopyResult[disk] == GOOD_COPY))
            {
                this->diskIOModule.reset_drive(disk);
            }
        }*/

        return UNFINISHED;
    }

    return FINISHED;
}

//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::HandleIOError(int io, int disk, unsigned long sector, int moduleid)
{
    if (CSystemD105::isCancelWhileDup())
    {
        printDFXLog (PRI_INFO, "%s", IO_CANCEL_ERR_MSG);
        return;
    }

    if(this->inputDiskList[disk] == UNCHECKED)
    {
        io = IO_CANCELLED;
    }

    if (io != IO_READ_DISK && io != IO_WRITE_DISK && io != IO_NOT_ENOUGH_DISK && io != IO_SETUP_BOOT_LOADER_ERROR && io != IO_CANCELLED)
    {
        this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
        printDFXLog (PRI_INFO, "Disk [%u]: %s", disk, IO_UNDEF_ERR_MSG);
        return;
    }

    printDFXLog (PRI_INFO, "Module %d has error:", moduleid);
    this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);

    if(io == IO_CANCELLED)
    {
        printDFXLog (PRI_INFO,"Remove disk[%d] ",disk);
        this->gCopyResult[disk] = CANCELLED;
        this->diskIOModule.powerDown(disk);
        this->diskIOModule.diskStatus[disk] = DISK_FAILED;
    }
    else if(io == IO_SETUP_BOOT_LOADER_ERROR)
    {
        this->gCopyResult[disk] = SETUP_BOOT_LOADER_ERROR;
        printDFXLog (PRI_INFO, "Disk [%u]: %s", disk, IO_SETUP_BOOTLOADER_ERR_MSG);
    }
    else if (io == IO_WRITE_DISK)	// writing error
    {
        this->gCopyResult[disk] = BAD_WRITE;
        printDFXLog (PRI_INFO, "Disk [%u]: %s %s %lu", disk, IO_WRITE_DISK_ERR_MESG, "sector", sector);
    }
    else
    {
        if (io == IO_READ_DISK)		// reading error
        {
            this->gCopyResult[disk] = BAD_READ;
            printDFXLog (PRI_INFO, "Disk [%u]: %s %s %lu", disk, IO_READ_DISK_ERR_MSG, "sector", sector);
        }
        else	// allocating error
        {
            this->gCopyResult[disk] = DISK_SIZE_NOT_ENOUGH;
            printDFXLog (PRI_INFO, "Disk [%u]: %s", disk, IO_NOT_ENOUGH_DISK_ERR_MSG);
        }
    }
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::handleIOError(int io, int disk, const char* errorMesg)
{
    int result = SUCCESS;
    if(this->isCancelWhileDup())
    {
        printDFXLog(PRI_INFO, "%s", IO_CANCEL_ERR_MSG);
        return SUCCESS;
    }

    if(this->inputDiskList[disk] == UNCHECKED && this->gTaskList[currentTask].target.item[disk] == 1)
    {
        io = IO_CANCELLED;
    }

    if(io != IO_READ_DISK &&io != IO_WRITE_DISK &&io != IO_NOT_ENOUGH_DISK &&io != IO_ERR_FUNCTION && io == IO_VERIFY_DISK)
    {
        this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
        printDFXLog(PRI_INFO, "Disk [%u]: %s", disk, IO_UNDEF_ERR_MSG);
        return SUCCESS;
    }

    if(this->gTaskList[currentTask].target.item[disk] == 0 && this->inputDiskList[disk] != UNCHECKED)
    {
        io = IO_ERR_FUNCTION;
    }

    printDFXLog(PRI_INFO,"");
    // verify error
    if(io == IO_VERIFY_DISK)
    {
        //m_errno = (disk == 0 ? DFX_ERR_READ_SOURCE : DFX_ERR_READ_TARGET);
        fprintf(stderr,"\nHandleIOError: disk %d error verify",disk);
        this->gCopyResult[disk] = BAD_VERIFY;
        printDFXLog(PRI_INFO, "Disk [%u]: %s %s", disk, IO_VERIFY_DISK_ERR_MESG, errorMesg);
    }

    // writing error
    if(io == IO_WRITE_DISK)
    {
        if(disk == 0)
        {
            io = IO_READ_DISK;
        }
        else
        {
            result = DFX_ERR_WRITE_TARGET;
            this->gCopyResult[disk] = BAD_WRITE;
            printDFXLog(PRI_INFO, "Disk [%u]: %s %s", disk, IO_WRITE_DISK_ERR_MESG, errorMesg);
        }
    }

    // reading error
    if(io == IO_READ_DISK)
    {
        result = (disk == 0 ? DFX_ERR_READ_SOURCE : DFX_ERR_READ_TARGET);
        this->gCopyResult[disk] = BAD_READ;

        printDFXLog(PRI_INFO, "Disk [%u]: %s %s", disk, IO_READ_DISK_ERR_MSG, errorMesg);
    }

    // allocating error
    if(io == IO_NOT_ENOUGH_DISK)
    {
        result = DFX_ERR_NOT_ENOUGH;
        this->gCopyResult[disk] = DISK_SIZE_NOT_ENOUGH;

        printDFXLog(PRI_INFO, "Disk [%u]: %s %s", disk, IO_NOT_ENOUGH_DISK_ERR_MSG, errorMesg);
    }

    // function has fault
    if(io == IO_ERR_FUNCTION)
    {
        result = OVER_FLOW_CAPACITY;
        this->gCopyResult[disk] = OVER_FLOW_CAPACITY;
        printDFXLog(PRI_INFO, "Disk [%u]: %s %s", disk, IO_ERR_FUNCTION_ERR_MSG, errorMesg);
    }

    this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
    if(io == IO_CANCELLED)
    {
        printDFXLog(PRI_INFO,"Remove disk[%d] ",disk);
        this->gCopyResult[disk] = CANCELLED;
        result = DFX_CANCELLED;
        this->diskIOModule.powerDown(disk);
    }
    // reset status target disk
    if(this->gTaskList[currentTask].target.item[disk] == 1)
    {
        this->gTaskList[currentTask].target.item[disk] = 0;					// disable unavailable target drive.
        this->gTaskList[currentTask].target.items--;						// decrease available target drive.
    }

    //////////////////////////////////////////////////////////////////////////
    // HuyHuynh debugs here
    printDFXLog(PRI_INFO, "Total available target disks: %u.", this->gTaskList[currentTask].target.items - 1);
    for (short i = 0; i < MAX_DISKS; i++)
    {
        printDFXLog(PRI_INFO, ".Disk [%u] in state %u", i, this->gTaskList[currentTask].target.item[i]);
    }
    //////////////////////////////////////////////////////////////////////////

    if(disk == 0 || (this->gTaskList[currentTask].target.items == 0 && this->gCopyResult[disk] != CANCELLED))
    {
        return UNSUCCESS;
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::handleFormatDisk(short disk_number)
{

#ifdef NEWPART_MODULE
    Partition part;
#endif

    PARTITION_SECTOR_STRUCT partition_sector_target,
            partition_sector_source;
    unsigned long start_sector_logical = 0, based_logical_start = 0, src_start_sector_logical, src_based_logical_start;
    bool has_ext, mbwe = false;
    char buffer[512];
    short errorCode = 0;
    int i, j, k, l, iRet;

    PARTITION_STRUCT MBWEpart[4]; // for MBWE disks

    for (i = 0;i < diskStruct[0].partition_sector_list.number_of_partition_sectors;i++)
    {
        diskStruct[disk_number].partition_sector_list.partition_sector[i] = diskStruct[0].partition_sector_list.partition_sector[i];
        diskStruct[disk_number].partition_list.partition[i] = diskStruct[0].partition_list.partition[i];
    }

    //iRet = suggestPartitionsForTargetDisk(src_size, diskStruct[0].partition_entry_list, tg_size, diskStruct[disk_number].partition_entry_list);
#ifndef NEWPART_MODULE
    iRet = suggestPartitionsForTargetDisk(diskStruct[0].partition_entry_list, disk_number, diskStruct[disk_number].partition_entry_list);

#else
    part.Init(this);

    iRet = part.Resize(&diskStruct[0].partition_entry_list, &diskStruct[disk_number].partition_entry_list, disk_number);

#endif
    if (iRet != 1)
    {
        if (iRet == -1)
            printDFXLog (PRI_INFO, "Drive# %d not enough space", disk_number);
        else
            printDFXLog (PRI_INFO, "Source Drive no partition");

        gCopyResult[disk_number] = DISK_SIZE_NOT_ENOUGH;
        this->diskIOModule.TurnLedMode(disk_number, LED_ON, LED_RED);
        return ERRORED;
    }

    errorCode = this->diskIOModule.readSectors(0, 0, 1, (unsigned short *)&buffer);

    if (errorCode != 1)
    {
        HandleIOError(IO_READ_DISK, 0, 0, HANDLE_FORMAT_DISK);
        return ERRORED;
    }

    // update MBR of target
    memcpy(&partition_sector_source, &buffer, sizeof(PARTITION_SECTOR_STRUCT));
    memcpy(&partition_sector_target, &buffer, sizeof(PARTITION_SECTOR_STRUCT));

    //for MyBook World Edition - WD hard disk - VietNguyen added, Feb 20 2008
    if (DFXSYSTEM_CheckMBWE(partition_sector_source.boot_loader_code) == MBWE_SINGLE_DISK)
    {
        mbwe = true;
    }

    if (mbwe)
    {
        // Set default mode
        for (i = 0; i < 4; i++)
        {
            MBWEpart[i].copy_mode = MIRROR_COPY;
        }

        // Get mode
        DFXSYSTEM_MBWE_ChooseActionType(partition_sector_source, MBWE_SINGLE_DISK, MBWEpart);
    }

    //END-->for MyBook World Edition - WD hard disk - VietNguyen added, Feb 20 2008

    has_ext = false;

    for (i = 0; i < 4; i++)
    {
        if (diskStruct[disk_number].partition_entry_list.entry_not_empty[i])
        {
            memcpy(&partition_sector_target.partition_entry[i],
                   &diskStruct[disk_number].partition_entry_list.part_entry[i],
                   sizeof(PARTITION_ENTRY_STRUCT));

            if (partition_sector_target.partition_entry[i].partition_ID == EXTENDED_PARTITION ||
                    partition_sector_target.partition_entry[i].partition_ID == EXTENDED_LBA_PARTITION ||
                    partition_sector_target.partition_entry[i].partition_ID == HIDDEN_EXTENDED_PARTITION ||
                    partition_sector_target.partition_entry[i].partition_ID == HIDDEN_EXTENDED_LBA_PARTITION)
            {
                based_logical_start = start_sector_logical = partition_sector_target.partition_entry[i].start_sector;
                src_based_logical_start = src_start_sector_logical = partition_sector_source.partition_entry[i].start_sector;
                has_ext = true;
            }
        }
    }
    //fprintf(stderr," Write MBR to target disk[%d] at sector %lu\n", disk_number, 0);
    //showBufferInByte((unsigned short*) & partition_sector_target, 512, "");
    // write MBR to target drive
    errorCode = this->diskIOModule.writeSectors(disk_number, 0, 1, (unsigned short*) & partition_sector_target);

    if (errorCode != 1)
    {
        HandleIOError(IO_WRITE_DISK, disk_number, 0, HANDLE_FORMAT_DISK + 1);
        return ERRORED;
    }


    for (i = 1, j = 0; i < diskStruct[disk_number].partition_entry_list.number_logic_partitions + 1; j++)
    {
        /*
         * update partition entry 0 & 1 of partition boot sector
         */
        memcpy(&diskStruct[disk_number].partition_sector_list.partition_sector[i].partition_entry[0],
               &diskStruct[disk_number].partition_entry_list.part_entry[4+2*j], sizeof(PARTITION_ENTRY_STRUCT));

        memcpy(&diskStruct[disk_number].partition_sector_list.partition_sector[i].partition_entry[1],
               &diskStruct[disk_number].partition_entry_list.part_entry[5+2*j], sizeof(PARTITION_ENTRY_STRUCT));
        /*
         * write partition boot sector to target
         */
        //fprintf(stderr," Write EBR to target disk[%d] at sector %lu\n", disk_number, start_sector_logical);
        //showBufferInByte((unsigned short*)&diskStruct[disk_number].partition_sector_list.partition_sector[i], 512, "");
        if (!this->diskIOModule.writeSectors(disk_number, start_sector_logical, 1, (unsigned short*)&diskStruct[disk_number].partition_sector_list.partition_sector[i]))
        {
            HandleIOError(IO_WRITE_DISK, disk_number, start_sector_logical, HANDLE_FORMAT_DISK + 2);
            return ERRORED;
        }

        // get start_sector of the next logical partition from partition entry 1 of partition boot sector
        start_sector_logical = based_logical_start + diskStruct[disk_number].partition_entry_list.part_entry[5+2*j].start_sector;

        if (diskStruct[disk_number].partition_entry_list.entry_not_empty[4+2*j])
        {
            i++;
        }
    }

    /*
         * Kydinh: if the extended partition has no logical partition, also need
         * to reset partition entry 0 & 1 of boot sector of extended partition
         */
    if (has_ext && diskStruct[disk_number].partition_entry_list.number_logic_partitions == 0)
    {
        memset(&diskStruct[disk_number].partition_sector_list.partition_sector[1].partition_entry[0], 0, sizeof(PARTITION_ENTRY_STRUCT));
        memset(&diskStruct[disk_number].partition_sector_list.partition_sector[1].partition_entry[1], 0, sizeof(PARTITION_ENTRY_STRUCT));

        // write partition boot sector to target
        if (!this->diskIOModule.writeSectors(disk_number, start_sector_logical, 1, (unsigned short*)&diskStruct[disk_number].partition_sector_list.partition_sector[1]))
        {
            HandleIOError(IO_WRITE_DISK, disk_number, start_sector_logical, HANDLE_FORMAT_DISK + 2);
            return ERRORED;
        }
    }

    /*
     * Kydinh: partition for target disk 'disk_number' finishes.
     */

    // set partition_list info for target
    diskStruct[disk_number].partition_list.number_of_partitions = diskStruct[0].partition_list.number_of_partitions;

    for (i = 0, k = 0; k < 4;k++)
    {
        if (diskStruct[disk_number].partition_entry_list.entry_not_empty[k])
        {
            if (	partition_sector_target.partition_entry[k].partition_ID == EXTENDED_PARTITION ||
                    partition_sector_target.partition_entry[k].partition_ID == EXTENDED_LBA_PARTITION ||
                    partition_sector_target.partition_entry[k].partition_ID == HIDDEN_EXTENDED_PARTITION ||
                    partition_sector_target.partition_entry[k].partition_ID == HIDDEN_EXTENDED_LBA_PARTITION)
            {
                start_sector_logical = based_logical_start;

                for (j = 0, l = 0; l < diskStruct[0].partition_entry_list.number_logic_partitions; j++)
                {
                    if (diskStruct[disk_number].partition_entry_list.entry_not_empty[4+2*j])
                    {
                        diskStruct[disk_number].partition_list.partition[i].partition_ID = diskStruct[disk_number].partition_entry_list.part_entry[4+2*j].partition_ID;
                        diskStruct[disk_number].partition_list.partition[i].primary_flag = 0;
                        diskStruct[disk_number].partition_list.partition[i].start_sector = start_sector_logical + diskStruct[disk_number].partition_entry_list.part_entry[4+2*j].start_sector;
                        diskStruct[disk_number].partition_list.partition[i].hidden_sectors = diskStruct[disk_number].partition_entry_list.part_entry[4+2*j].start_sector;
                        diskStruct[disk_number].partition_list.partition[i].number_of_sectors = diskStruct[disk_number].partition_entry_list.part_entry[4+2*j].number_of_sectors;
                        diskStruct[disk_number].partition_list.partition[i].number_of_used_sectors = 0;
                        l++;
                        i++;
                    }

                    if (diskStruct[disk_number].partition_entry_list.entry_not_empty[5+2*j])
                    {
                        start_sector_logical = based_logical_start + diskStruct[disk_number].partition_entry_list.part_entry[5+2*j].start_sector;
                    }
                    else
                    {
                        break;
                    }
                }

                continue;
            }
            else
            {
                diskStruct[disk_number].partition_list.partition[i].partition_ID = diskStruct[disk_number].partition_entry_list.part_entry[k].partition_ID;
                diskStruct[disk_number].partition_list.partition[i].primary_flag = 1;
                diskStruct[disk_number].partition_list.partition[i].start_sector = diskStruct[disk_number].partition_entry_list.part_entry[k].start_sector;
                diskStruct[disk_number].partition_list.partition[i].hidden_sectors = diskStruct[disk_number].partition_entry_list.part_entry[k].start_sector;
                diskStruct[disk_number].partition_list.partition[i].number_of_sectors = diskStruct[disk_number].partition_entry_list.part_entry[k].number_of_sectors;
                diskStruct[disk_number].partition_list.partition[i].number_of_used_sectors = 0;
                i++;
            }
        }
    }

    //return FINISHED; // for test only

    enum ACTION_TYPE action_type;
    action_type = NULL_PAR;

#ifdef DEBUG_CSYSTEM105
    printf("----> handleFormatDisk #%d :: number_of_partitions %d \n", disk_number, diskStruct[0].partition_list.number_of_partitions);

#endif

    for (i = 0;i < diskStruct[0].partition_list.number_of_partitions;i++)
    {
#ifdef DEBUG_CSYSTEM105
        printf("----> handleFormatDisk :: part #%d --- ID 0x%X \n", i, diskStruct[0].partition_list.partition[i].partition_ID);
#endif

        switch (diskStruct[0].partition_list.partition[i].partition_ID)
        {

        case DOS_FAT16_SMALLER_32MB_PARTITION:
        case HIDDEN_DOS_FAT16_SMALLER_32MB_PARTITION:
        case HIDDEN_DOS_FAT16_LARGER_32MB_PARTITION:
        case HIDDEN_WIN9X_FAT16_LBA_PARTITION: //user for FAT16
        case WIN9X_FAT16_LBA_PARTITION :
        case DOS_FAT16_LARGER_32MB_PARTITION:
            action_type = MIRROR_PAR;
            break;

        case HIDDEN_WIN9X_FAT32_PARTITION:
        case WIN9X_FAT32_PARTITION :
        case WIN9X_FAT32_LBA_PARTITION:
            if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_UNFORMATED)
            {
                continue;
            }
            else
            {
                if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_FAT16 ||
                        diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_FAT32)
                {
                    action_type = FAT_32_PAR_SMART;
                    break;
                }
            }

        case IFS_PARTITION:
            if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_UNFORMATED)
            {
                continue;
            }
            else
            {
                if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_FAT16 ||
                        diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_FAT32)
                {
                    action_type = FAT_32_PAR_SMART;
                    break;
                }
            }

            if (securityOperation->checkFeatureUnlocked(FEATURE_NTFS) != 1)
            {
                action_type = MIRROR_PAR;
            }
            else
            {
                action_type = NTFS_PAR_SOURCE_SMALLER_TARGET;
            }

            break;

        case LINUX_RAID_PARTITION: // Viet Nguyen updated on Dec 24 2007
        case LINUX_NATIVE_PARTITION:
            //printf("Action: Part #%d: partition type %d \n", i+1, diskStruct[0].partition_list.partition[i].partition_type);
            if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_UNFORMATED)
            {
                continue;
            }
            else
            {
                if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_FAT16 ||
                        diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_FAT32)
                {
                    action_type = FAT_32_PAR_SMART;
                    break;
                }
            }

            if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_EXT2_3)
            {
                if (securityOperation->checkFeatureUnlocked(FEATURE_EXT2FS) != 1 ||
                        (checkExt2fsIsMountedBootDirectorty(diskStruct[0].partition_list.partition[i].start_sector)))
                {
                    action_type = MIRROR_PAR;
                    listDrivesSetupLilo[disk_number] = 1;
                    listDrivesSetupGRUB[disk_number] = 1;
                }
                else
                {

                    //printf("S.M.A.R.T COPY \n");
                    EXT4_SUPER_BLOCK sblock;
                    if(this->diskIOModule.readSectors(0, diskStruct[0].partition_list.partition[i].start_sector + SP_START_SEC, SP_SEC_CNT, (unsigned short*)&sblock) != 1)
                    {
                        HandleIOError(IO_READ_DISK, 0, 0, PART_N_ADD_DISK_PARTITION_ID);
                        return UNSUCCESS;
                    }
                    if(EXT2_INODE_SIZE(&sblock) > 128)
                    {
                        action_type = EXT4_PAR_SMART;
                    }
                    else
                    {
                        action_type = EXT2_PAR_SMART;
                    }

                    listDrivesSetupLilo[disk_number] = 1;
                    listDrivesSetupGRUB[disk_number] = 1; // Viet Nguyen added on Oct 22 2007

                    if (mbwe)
                    {
                        //printf("S.M.A.R.T COPY start_sector %lu \n", diskStruct[0].partition_list.partition[i].start_sector);

                        if ((diskStruct[0].partition_list.partition[i].number_of_sectors != mMBWE_MaxCapacity4SmartCopy)
                                && (MBWEpart[i].copy_mode == MIRROR_COPY))
                        {
                            //printf("M.I.R.R.O.R COPY start_sector %lu \n", diskStruct[0].partition_list.partition[i].start_sector);
                            action_type = MIRROR_PAR;
                        }
                        //getc(stdin);
                    }
                }
            }
            else if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_SWAP)
            {
                action_type = MIRROR_PAR;
            }

            //printf("END Linux COPY \n");
            break;

        case LINUX_LVM_PARTITION: // Viet Nguyen added on Apr 11 2008
            if (diskStruct[0].partition_list.partition[i].partition_type == PAR_TYPE_LVM)
            {
                return PAR_TYPE_LVM;
                //printf(" S.M.A.R.T COPY \n");
                /*	action_type = LVM_PAR_SMART;
                                        listDrivesSetupLilo[disk_number] = 1;
                                        listDrivesSetupGRUB[disk_number] = 1;
                                        //duongvu add this code segment August 05 2008
                                        iRet = createLVMPartitionForTargetDisk(i, disk_number);*/
            }

            break;
        case UNFORMATTED_PARTITION:
            diskStruct[0].partition_list.partition[i].partition_type = PAR_TYPE_UNFORMATED;
            action_type = NULL_PAR;
            break;

        default :
            action_type = MIRROR_PAR;
            break;
        }

#ifdef DEBUG_CSYSTEM105
        printf("----> handleFormatDisk #%d:: action_type %d \n", disk_number, action_type);

        //getc(stdin);
#endif
        if(action_type != LVM_PAR_SMART)
        {
            partnAddTask(disk_number,
                         diskStruct[0].partition_list.partition[i].start_sector,
                         diskStruct[disk_number].partition_list.partition[i].start_sector,
                         diskStruct[0].partition_list.partition[i].number_of_sectors,
                         diskStruct[disk_number].partition_list.partition[i].number_of_sectors,
                         diskStruct[disk_number].partition_list.partition[i].hidden_sectors,
                         action_type ,
                         PE_MIRROR_OVERLAP_SOURCE);
        }
    }

    // currentTask=1;
    return FINISHED;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : partnAddATask()
Description : adds a task for the target specified
Inputs : target drive;Sectors Per Track and Sectors Per Cylinder on target drive
Outputs : none
Returns : none
*/
short CSystemD105::partnAddATask(short d, unsigned long SectorsPerTrack, unsigned long SectorsPerCylinder)
{
    short errorCode;
    errorCode = SUCCESS;
    SectorsPerTrack = SectorsPerTrack;
    SectorsPerCylinder = SectorsPerCylinder;

    //Add appropriate tasks to task list.
    switch (gTarget[d].disk_mode)
    {
    //Task is Smart Copy.
    case DISK_SMART:

        if (diskStruct[0].partition_list.number_of_partitions){
            errorCode = partnAddDiskSmartTask(d, 0, 0);
        }
        else{
            errorCode = partnAddDiskMirrorTask(d);
        }

        break;

        //Task is Partition Disk.
    case DISK_PARTITION:

        errorCode = partnAddDiskPartition(d);
        break;

        //Task is Mirror Copy.
    case DISK_MIRROR:

        errorCode = partnAddDiskMirrorTask(d);
        break;

        //Task is DOD Wipeout.
    case DISK_SANITIZE:
        errorCode = partnAddDiskWipeOut(d);
        break;

        //Task is Clear Disk.
    case DISK_WIPE:
        errorCode = partnAddDiskErase(d);
        break;

        //Task is Test Disk.
    case DISK_TEST:
        errorCode = partnAddDiskTest(d);
        break;

        //Task is Purge Disk.
    case DISK_FAST_PURGE:
        errorCode = partnAddDiskFASTpurge(d);
        break;

    default:
        break;
    }

    return errorCode;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : partnAddDiskMirrorTask()
Description : Add a mirror copy task for target
Input : target disk number
Output : none
Return : 1 if success or 0 if failed.
*/
short CSystemD105::partnAddDiskMirrorTask(short d)
{
    POTENTIAL_ERRORS potentialError;//short potentialError;
    unsigned long S, T, sectorCount, sectorsToCopy;
    short errorCode;
    sectorsToCopy = 0;


    if (!matchGeometryToSource(d))
    {
        gCopyResult[d] = DIFFERENT_GEOMETRY;
        return UNSUCCESS;
    }

    potentialError = PE_NO_ERROR;

    if (gTarget[d].standardOption) //Mirror standard Jod
    {

        T = this->gNativeMaxAddress[d] + 1;
        S = this->gNativeMaxAddress[0] + 1;

        if (S == T) //Source Capacity equals Target Capacity
        {
            if (securityOperation->checkFeatureUnlocked(FEATURE_HPA) != 1) // HPA-copy lock in smart option
            {
                if (this->gHPAFeatureSupported[0] == 1) //Source has support HPA
                {
                    if(this->gHPACapacity[0] != 0) //Source has HPA area
                    {
                        S = this->gNativeMaxAddress[0] - gHPACapacity[0] + 1; //HPA area will not copy to target
                        fprintf(stderr, "\n Disk[ %d]: HPA StartSector--> %lu  SectorCount--> %lu ", 0, this->gNativeMaxAddress[0] - gHPACapacity[0], gHPACapacity[0]);
                    }
                }
            }

            sectorCount = minimum(S, T);
            potentialError = PE_NO_ERROR;

            errorCode = partnAddTask(d, 0, 0, sectorCount, sectorCount, 0, MIRROR_PAR, potentialError);
            if (errorCode == -1)
            {
                return UNSUCCESS;
            }
            sectorsToCopy += sectorCount;

            fprintf(stderr, "\n Add task: Task MIRROR COPY");
            fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu ", 0, 0, sectorCount);
            fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu ", d, 0, sectorCount);
        }
        else if (S < T) //Source Capacity less than Target Capacity
        {
            potentialError = PE_MIRROR_OVERLAP_SOURCE;

            if (securityOperation->checkFeatureUnlocked(FEATURE_HPA) != 1) // HPA-copy lock in smart option
            {
                if (this->gHPAFeatureSupported[0] == 1) //Source has support HPA
                {
                    if(this->gHPACapacity[0] != 0) //Source has HPA area
                    {
                        if(this->checkDataInHPARegion() == false) //Source khong co du lieu nam trong vung HPA
                        {
                            S = this->gNativeMaxAddress[0] - gHPACapacity[0] + 1; //HPA area will not copy to target
                        }
                        fprintf(stderr, "\n Disk[ %d]: HPA StartSector--> %lu  SectorCount--> %lu ", 0, this->gNativeMaxAddress[0] - gHPACapacity[0], gHPACapacity[0]);
                    }
                }

                sectorCount = minimum(S, T);
                errorCode = partnAddTask(d, 0, 0, sectorCount, sectorCount, 0, MIRROR_PAR, potentialError);
                if (errorCode == -1)
                {
                    return UNSUCCESS;
                }
                sectorsToCopy += sectorCount;

                fprintf(stderr, "\n Add task: Task MIRROR COPY");
                fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", 0, 0, sectorCount);
                fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", d, 0, sectorCount);
            }
            else // HPA-copy unlock in smart option
            {
                if (this->gHPAFeatureSupported[0] == 1) //Source has support HPA
                {
                    if(this->gHPACapacity[0] != 0) //Source has HPA area
                    {
                        //Add task MIRROR normal region
                        if(this->checkDataInHPARegion() == true) //Source co du lieu nam trong vung HPA (Bug: khi cai Ubuntu co mot partition chua ca vung HPA)
                        {
                            sectorCount = minimum(S, T);
                        }
                        else //Source khong co du lieu nam trong vung HPA
                        {
                            sectorCount = this->gNativeMaxAddress[0] - gHPACapacity[0] + 1;
                        }
                        errorCode = partnAddTask(d, 0, 0, sectorCount, sectorCount, 0, MIRROR_PAR, potentialError);
                        if (errorCode == -1)
                        {
                            return UNSUCCESS;
                        }
                        sectorsToCopy += sectorCount;

                        fprintf(stderr, "\n THDB5: Add task for MIRROR COPY");
                        fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", 0, 0, sectorCount);
                        fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", d, 0, sectorCount);

                        if(this->gHPAFeatureSupported[d] == 1) //Target co support HPA
                        {
                            if (this->checkDataInHPARegion() == false) // Vung HPA la doc lap voi vung data thuong
                            {
                                //Add task MIRROR HPA region
                                errorCode = partnAddTask(d, this->gNativeMaxAddress[0] - gHPACapacity[0] + 1, this->gNativeMaxAddress[d] - gHPACapacity[d] + 1, gHPACapacity[0], gHPACapacity[d], 0, MIRROR_PAR, potentialError);
                                if (errorCode == -1)
                                {
                                    return UNSUCCESS;
                                }
                                sectorsToCopy += gHPACapacity[0];

                                fprintf(stderr, "\n THDB5: Add task for MIRROR COPY HPA Region");
                                fprintf(stderr, "\n Disk[ %d]: Start Sector--> %lu  Sector Count--> %lu", 0, this->gNativeMaxAddress[0] - gHPACapacity[0] + 1, gHPACapacity[0]);
                                fprintf(stderr, "\n Disk[ %d]: Start Sector--> %lu  Sector Count--> %lu", d, this->gNativeMaxAddress[d] - gHPACapacity[d] + 1, gHPACapacity[d]);
                            }
                            else
                            {
                                this->gHPACapacity[d] = (T - S) + this->gHPACapacity[d];
                            }

                        }
                    }
                    else //Source has not HPA area
                    {
                        sectorCount = minimum(S, T);
                        errorCode = partnAddTask(d, 0, 0, sectorCount, sectorCount, 0, MIRROR_PAR, potentialError);
                        if (errorCode == -1)
                        {
                            return UNSUCCESS;
                        }
                        sectorsToCopy += sectorCount;

                        fprintf(stderr, "\n THDB5: Add task for MIRROR COPY");
                        fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", 0, 0, sectorCount);
                        fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", d, 0, sectorCount);
                    }
                }
                else //Source has not support HPA
                {
                    sectorCount = minimum(S, T);
                    errorCode = partnAddTask(d, 0, 0, sectorCount, sectorCount, 0, MIRROR_PAR, potentialError);
                    if (errorCode == -1)
                    {
                        return UNSUCCESS;
                    }
                    sectorsToCopy += sectorCount;

                    fprintf(stderr, "\n THDB5: Add task for MIRROR COPY");
                    fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", 0, 0, sectorCount);
                    fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", d, 0, sectorCount);
                }
            }
        }
        else //Source Capacity more than Target Capacity
        {
            potentialError = PE_MIRROR_OVERLAP_TARGET;

            if (securityOperation->checkFeatureUnlocked(FEATURE_HPA) != 1) // HPA-copy lock in smart option
            {
                if(this->gCapacity[0] >= T)
                {
                    sectorCount = T;
                }
                else
                {
                    if(this->checkDataInHPARegion() == false) //Source khong co du lieu nam trong vung HPA
                    {
                        sectorCount = this->gCapacity[0];
                    }
                    else
                    {
                        sectorCount = T;
                    }
                }
            }
            else // HPA-copy unlock in smart option
            {
                //Tinh lai HPA Capacity cua target
                if((this->gNativeMaxAddress[0] - this->gHPACapacity[0]) >= this->gNativeMaxAddress[d])
                {
                    this->gHPACapacity[d] = 0;
                }
                else
                {
                    this->gHPACapacity[d] = this->gNativeMaxAddress[d] - (this->gNativeMaxAddress[0] - this->gHPACapacity[0]);
                }

                sectorCount = T;
            }

            errorCode = partnAddTask(d, 0, 0, sectorCount, sectorCount, 0, MIRROR_PAR, potentialError);
            if (errorCode == -1)
            {
                return UNSUCCESS;
            }
            sectorsToCopy += sectorCount;

            fprintf(stderr, "\n THDB5: Add task for MIRROR COPY");
            fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", 0, 0, sectorCount);
            fprintf(stderr, "\n Disk[ %d]: Start Sector--> %d  Sector Count--> %lu", d, 0, sectorCount);
        }
    }
    else // mirror user job - User-Defined Job
    {
        S = gTarget[d].source_start_sector;
        T = gTarget[d].target_start_sector;
        sectorCount = gTarget[d].source_end_sector - S;
        partnAddTask(d, S, T, sectorCount, sectorCount, 0, MIRROR_PAR, potentialError);
        gSectorsToCopy[d] += sectorCount;
        gSectorsToVerify[d] += sectorCount;
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : partnAddDiskSmartTask()
Description : Add a smart copy task for target
Input : target disk number
Output : none
Return : 1 if success or 0 if failed.
*/
short CSystemD105::partnAddDiskSmartTask(short d, unsigned long sectorsPerTrack, unsigned long setorsPerCylinder)
{
    short errorCode;
    POTENTIAL_ERRORS potentialError;
    sectorsPerTrack = sectorsPerTrack;
    setorsPerCylinder = setorsPerCylinder;
    errorCode = 0;

    unsigned long S, T;// sectorCount;
    unsigned long sectorsToCopy;

    sectorsToCopy = 0;

    if (!matchGeometryToSource(d))
    {
        gCopyResult[d] = DIFFERENT_GEOMETRY;
        return UNSUCCESS;
    }

    potentialError = PE_NO_ERROR;

    T = (unsigned long)gCapacity[d]; // Target capacity
    S = (unsigned long)gCapacity[0]; // Source capacity

    errorCode = handleFormatDisk(d);
    if (errorCode == ERRORED)
    {
        return UNSUCCESS;
    }
    else if (errorCode == PAR_TYPE_LVM)
    {
        return PAR_TYPE_LVM;
    }

    if (securityOperation->checkFeatureUnlocked(FEATURE_HPA) == 1) // HPA-copy unlock in smart option
    {
        if ((this->gHPAFeatureSupported[0] == 1) && //Source support HPA
                (this->gHPAFeatureSupported[d] == 1) && //Target support HPA
                (this->gHPACapacity[d] != 0))
        {
            errorCode = partnAddTask(d, this->gNativeMaxAddress[0] - this->gHPACapacity[0] + 1, this->gNativeMaxAddress[d] - this->gHPACapacity[d] + 1, this->gHPACapacity[0], this->gHPACapacity[0], 0, MIRROR_PAR, potentialError);
            fprintf(stderr, "\n THDB5: Add task for MIRROR COPY HPA region");
            fprintf(stderr, "\n Disk[ %d]: HPA region start--> %lu    HPA region size--> %lu", 0, this->gNativeMaxAddress[0] - this->gHPACapacity[0] + 1, this->gHPACapacity[0]);
            fprintf(stderr, "\n Disk[ %d]: HPA region start--> %lu    HPA region size--> %lu", d, this->gNativeMaxAddress[d] - this->gHPACapacity[d] + 1, this->gHPACapacity[0]);
        }
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function: partnAddDiskWipeOut(...)
Description: use for adding DODWipe Out Task in Standard Jod and User Job
Input: d : ID of Disk
Return 1 if success, 0 if failed.
*/
short CSystemD105::partnAddDiskWipeOut(short d)
{
    POTENTIAL_ERRORS potentialError;//short potentialError;
    unsigned long S, T, sectorCount;
    short errorCode;
    potentialError = PE_NO_ERROR;
    S = 0;
    T = 0;
    sectorCount = gCapacity[d];
    // user data task
    //fprintf(stderr, "\n THDB here: Add task WIPEOUT ############################");
    errorCode = partnAddTask(d, S, T, sectorCount, sectorCount, 0, WIPEOUT_PAR, potentialError);

    if (errorCode == -1)
    {
        return UNSUCCESS;
    }

    // hpa task
    if (gHPACapacity[d] > 0 && gHPAFeatureSupported[d])
    {
        S = gCapacity[d];
        errorCode = partnAddTask(d, S, gCapacity[d], gHPACapacity[d], gHPACapacity[d], 0, WIPEOUT_HPA, potentialError);

        if (errorCode == -1)
        {
            return UNSUCCESS;
        }
    }

    gSectorsToCopy[d] += sectorCount;
    gSectorsToCopy[d] += gHPACapacity[d];
    gSectorsToVerify[d] = gSectorsToCopy[d];
    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function: partnAddDiskTest(...)
Description: Use for adding Disk Test task in standard Jod and User Job
Input: d: ID of disk
Return 1 if success, 0 if failed.
*/
short CSystemD105::partnAddDiskTest(short d)
{
    POTENTIAL_ERRORS potentialError;//short potentialError;
    unsigned long S, T, sectorCount;
    potentialError = PE_NO_ERROR ;
    short errorCode;


    //gTarget[d].standardOption=0;
#ifdef DEBUG_CSYSTEM105
    printf("Disk : %d Standard option: %d\n", d, gTarget[d].standardOption);
#endif

    if (gTarget[d].standardOption)
    {
        S = 0;
        T = 0;
        // test user data
        sectorCount = gCapacity[d];
        errorCode = partnAddTask(d, S, T, sectorCount, sectorCount, 0, TEST_PAR, potentialError);

        if (errorCode == -1)
        {
            return UNSUCCESS;
        }

        //test HPA
        if (gHPACapacity[d] > 0 && gHPAFeatureSupported[d])
        {
            errorCode = partnAddTask(d, S, gCapacity[d], gHPACapacity[d], gHPACapacity[d], 0, TEST_HPA, potentialError);

            if (errorCode == -1)
            {
                return UNSUCCESS;
            }
        }

        gSectorsToCopy[d] += (sectorCount + gHPACapacity[d]);
    }
    else
    {
        if (gTarget[d].testMode)
        {
            T = gTarget[d].target_start_sector;
            S = T;
            sectorCount = gTarget[d].source_end_sector - T;
            errorCode = partnAddTask(d, 0, T, sectorCount, sectorCount, 0, TEST_PAR, potentialError);

            if (errorCode == -1)
            {
                return UNSUCCESS;
            }

            gSectorsToCopy[d] += sectorCount;
        }
        else
            if (gTarget[d].clearMode)
            {
                printDFXLog (PRI_INFO, "CLEAR DISK");
                T = gTarget[d].target_start_sector;
                S = T;
                sectorCount = gTarget[d].source_end_sector - T;
                errorCode = partnAddTask(d, 0, T, sectorCount, sectorCount, 0, CLEAR_PAR, potentialError);

                if (errorCode == -1)
                {
                    return UNSUCCESS;
                }
            }

        // HPA task
        if (gTarget[d].testMode == 1 || gTarget[d].testMode == 2)
        {
            if (gHPACapacity[d] > 0 && gHPAFeatureSupported[d])
            {
                S = gCapacity[d];
                errorCode = partnAddTask(d, S, gCapacity[d], gHPACapacity[d], gHPACapacity[d], 0, TEST_HPA, potentialError);

                if (errorCode == -1)
                {
                    return UNSUCCESS;
                }

                gSectorsToCopy[d] += gHPACapacity[d];
            }

            // disk not support HPA
            else if (gTarget[d].clearMode == 1)
            {
                gCopyResult[d] = DISK_NOT_SUPPORT_HPA;
                return UNSUCCESS;
            }
        }
    }
    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::partnAddDiskErase(short d)
{
    if ((securityOperation->checkFeatureUnlocked(FEATURE_WIPEOUT) == 1) && this->actionMode != VERIFYING_MODE){
        return this->partnAddDiskWipeOut(d);
    }

    POTENTIAL_ERRORS potentialError;//short potentialError;
    unsigned long S, T, sectorCount;
    potentialError = PE_NO_ERROR;
    // user data Task

    if (gTarget[d].standardOption)
    {
        S = 0;
        T = 0;
        sectorCount = gNativeMaxAddress[d] + 1;
        partnAddTask(d, S, T, sectorCount, sectorCount, 0, CLEAR_PAR, potentialError);
    }
    else
    {
        S = gTarget[d].source_start_sector;
        T = gTarget[d].target_start_sector;
        sectorCount = gTarget[d].source_end_sector - S + 1;

        if (sectorCount + 2048 > gNativeMaxAddress[d])
            sectorCount = gNativeMaxAddress[d] + 1;

        partnAddTask(d, S, T, sectorCount, sectorCount, 0, CLEAR_PAR, potentialError);//DOD is not supported

        gSectorsToCopy[d] += sectorCount;
        gSectorsToVerify[d] += sectorCount;
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::partnAddDiskFASTpurge(short d)
{
    POTENTIAL_ERRORS potentialError;
    unsigned long S, T, sectorCount;
    potentialError = PE_NO_ERROR;
    // user data Task

    if (gTarget[d].standardOption)
    {
        S = 0;
        T = 0;
        sectorCount = gNativeMaxAddress[d] + 1;
        partnAddTask(d, S, T, sectorCount, sectorCount, 0, FAST_PURGE_PAR, potentialError);
    }
    else
    {
        S = gTarget[d].source_start_sector;
        T = gTarget[d].target_start_sector;
        sectorCount = gTarget[d].source_end_sector - S + 1;

        if (sectorCount + 2048 > gNativeMaxAddress[d]) sectorCount = gNativeMaxAddress[d] + 1;

        partnAddTask(d, S, T, sectorCount, sectorCount, 0, FAST_PURGE_PAR, potentialError);

        gSectorsToCopy[d] += sectorCount;
        gSectorsToVerify[d] += sectorCount;
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::partnAddDiskPartition(short d)
{
    // ky added on April 21, 2007 to fix bug
    unsigned long logicalPartitionSize, sstart_sector, tstart_sector, slength, tlength, hidden_sectors;
    ACTION_TYPE action ;
    action = EMPTY_PAR;
    short sourceIndexPartition;
    POTENTIAL_ERRORS potentialError;
    potentialError = PE_NO_ERROR;
    this->gCapacity[d] = this->gNativeMaxAddress[d] + 1;
    int iRet;

    logicalPartitionSize = 0;

    // ky fixed bug partitions disk
    unsigned long src_size, tg_size;
    PARTITION_SECTOR_STRUCT partition_sector_target,
            partition_sector_source;
    unsigned long start_sector_logical = 0,
            based_logical_start = 0,
            src_start_sector_logical = 0,
            src_based_logical_start = 0;
    short errorCode = 0;
    char buffer[512];
    int i, j, k;

    src_size = gCapacity[0];
    tg_size = gCapacity[d];

    for (i = 0;i < diskStruct[0].partition_sector_list.number_of_partition_sectors;i++)
    {
        diskStruct[d].partition_sector_list.partition_sector[i] = diskStruct[0].partition_sector_list.partition_sector[i];
        diskStruct[d].partition_list.partition[i] = diskStruct[0].partition_list.partition[i];
    }

    iRet = adjustPartitionsForTargetDisk(diskStruct[0].partition_entry_list, d, gTarget[d], diskStruct[d].partition_entry_list);

    if (iRet != 1)
    {
        if (iRet == -1)
        {
            printDFXLog (PRI_INFO, "Drive# %d not enough space", d);
        }
        else
        {
            printDFXLog (PRI_INFO, "Source Drive no partition");
        }

        gCopyResult[d] = DISK_SIZE_NOT_ENOUGH;
        this->diskIOModule.TurnLedMode(d, LED_ON, LED_RED);
        return UNSUCCESS;
    }

    errorCode = this->diskIOModule.readSectors(0, 0, 1, (unsigned short *) & buffer);

    if (errorCode != 1)
    {
        HandleIOError(IO_READ_DISK, 0, 0, PART_N_ADD_DISK_PARTITION_ID);
        return UNSUCCESS;
    }

    // update MBR of target
    memcpy(&partition_sector_source, &buffer, sizeof(PARTITION_SECTOR_STRUCT));
    memcpy(&partition_sector_target, &buffer, sizeof(PARTITION_SECTOR_STRUCT));

    for (i = 0; i < 4; i++)
    {
        if (diskStruct[d].partition_entry_list.entry_not_empty[i])
        {
            memcpy(&partition_sector_target.partition_entry[i], &diskStruct[d].partition_entry_list.part_entry[i], sizeof(PARTITION_ENTRY_STRUCT));

            if (partition_sector_target.partition_entry[i].partition_ID == EXTENDED_PARTITION ||
                    partition_sector_target.partition_entry[i].partition_ID == EXTENDED_LBA_PARTITION ||
                    partition_sector_target.partition_entry[i].partition_ID == HIDDEN_EXTENDED_PARTITION ||
                    partition_sector_target.partition_entry[i].partition_ID == HIDDEN_EXTENDED_LBA_PARTITION)
            {
                based_logical_start = start_sector_logical = partition_sector_target.partition_entry[i].start_sector;
                src_based_logical_start = src_start_sector_logical = partition_sector_source.partition_entry[i].start_sector;
            }
        }
        else
        {
            memset(&partition_sector_target.partition_entry[i], 0, sizeof(PARTITION_ENTRY_STRUCT));
        }
    }

    // write MBR to target drive
    errorCode = this->diskIOModule.writeSectors(d, 0, 1, (unsigned short*) & partition_sector_target);

    if (errorCode != 1)
    {
        HandleIOError(IO_WRITE_DISK, d, 0, PART_N_ADD_DISK_PARTITION_ID + 1);
        return UNSUCCESS;
    }

    for (i = 1, j = 0; i < diskStruct[d].partition_entry_list.number_logic_partitions + 1; i++, j++)
    {
        // update partition entry 0 & 1 of partition boot sector
        // update partition entry 0 & 1 of partition boot sector
        memcpy(&diskStruct[d].partition_sector_list.partition_sector[i].partition_entry[0], &diskStruct[d].partition_entry_list.part_entry[4+2*j], sizeof(PARTITION_ENTRY_STRUCT));
        memcpy(&diskStruct[d].partition_sector_list.partition_sector[i].partition_entry[1], &diskStruct[d].partition_entry_list.part_entry[5+2*j], sizeof(PARTITION_ENTRY_STRUCT));

        diskStruct[d].partition_sector_list.partition_sector[i].signature = MBR_SIGNATURE;
        // write partition boot sector to target

        if (!this->diskIOModule.writeSectors(d, start_sector_logical, 1, (unsigned short*)&diskStruct[d].partition_sector_list.partition_sector[i]))
        {
            HandleIOError(IO_WRITE_DISK, d, start_sector_logical, PART_N_ADD_DISK_PARTITION_ID + 2);
            return UNSUCCESS;
        }

        // get start_sector of the next logical partition from partition entry 1 of partition boot sector
        start_sector_logical = based_logical_start + diskStruct[d].partition_entry_list.part_entry[5+2*j].start_sector;
    }

    // return UNSUCCESS; // kydinh for test only
    // kydinh: partition for target disk 'd' finishes.
    // set partition_list info for target
    diskStruct[d].partition_list.number_of_partitions = diskStruct[d].partition_entry_list.number_of_partitions - diskStruct[d].partition_entry_list.number_extended_partitions;

    for (i = 0, k = 0; k < 4;k++)
    {
        if (diskStruct[d].partition_entry_list.entry_not_empty[k])
        {
            if (	partition_sector_target.partition_entry[k].partition_ID == EXTENDED_PARTITION ||
                    partition_sector_target.partition_entry[k].partition_ID == EXTENDED_LBA_PARTITION ||
                    partition_sector_target.partition_entry[k].partition_ID == HIDDEN_EXTENDED_PARTITION ||
                    partition_sector_target.partition_entry[k].partition_ID == HIDDEN_EXTENDED_LBA_PARTITION)
            {
                start_sector_logical = based_logical_start;

                for (j = 0; j < diskStruct[d].partition_entry_list.number_logic_partitions; j++)
                {
                    diskStruct[d].partition_list.partition[i].partition_ID = diskStruct[d].partition_entry_list.part_entry[4+2*j].partition_ID;
                    diskStruct[d].partition_list.partition[i].primary_flag = 0;
                    diskStruct[d].partition_list.partition[i].start_sector = start_sector_logical + diskStruct[d].partition_entry_list.part_entry[4+2*j].start_sector;
                    diskStruct[d].partition_list.partition[i].hidden_sectors = diskStruct[d].partition_entry_list.part_entry[4+2*j].start_sector;
                    diskStruct[d].partition_list.partition[i].number_of_sectors = diskStruct[d].partition_entry_list.part_entry[4+2*j].number_of_sectors;
                    diskStruct[d].partition_list.partition[i].number_of_used_sectors = 0;

                    start_sector_logical = based_logical_start + diskStruct[d].partition_entry_list.part_entry[5+2*j].start_sector;
                    i++;
                }

                continue;
            }
            else
            {
                diskStruct[d].partition_list.partition[i].partition_ID = diskStruct[d].partition_entry_list.part_entry[k].partition_ID;
                diskStruct[d].partition_list.partition[i].primary_flag = 1;
                diskStruct[d].partition_list.partition[i].start_sector = diskStruct[d].partition_entry_list.part_entry[k].start_sector;
                diskStruct[d].partition_list.partition[i].hidden_sectors = diskStruct[d].partition_entry_list.part_entry[k].start_sector;;
                diskStruct[d].partition_list.partition[i].number_of_sectors = diskStruct[d].partition_entry_list.part_entry[k].number_of_sectors;
                diskStruct[d].partition_list.partition[i].number_of_used_sectors = 0;
                i++;
            }
        }
    }

    // if Smart Option is not unlocked yet, change copy_mode to MIRROR
    for (int i = 0;i < gTarget[d].userPartitionCount;i++)
    {
        sourceIndexPartition = gTarget[d].partition[i].source_partition;
        sstart_sector = diskStruct[0].partition_list.partition[sourceIndexPartition].start_sector;

        if((unknowPartition(diskStruct[0].partition_list.partition[sourceIndexPartition].partition_ID)) ||
                (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_ID == LINUX_SWAP_PARTITION) ||
                (checkExt2fsIsMountedBootDirectorty(sstart_sector)))
        {
            gTarget[d].partition[i].copy_mode = (PARTITION_COPY_MODE)MIRROR_COPY;
        }
    }

    for (i = 0;i < gTarget[d].userPartitionCount;i++)
    {
        sourceIndexPartition = gTarget[d].partition[i].source_partition;
        sstart_sector = diskStruct[0].partition_list.partition[sourceIndexPartition].start_sector;
        tstart_sector = diskStruct[d].partition_list.partition[i].start_sector;

        // kydinh fixed bugs partition smart copy on April 20, 2007
        slength = diskStruct[0].partition_list.partition[sourceIndexPartition].number_of_sectors;
        tlength = diskStruct[d].partition_list.partition[i].number_of_sectors;//gTarget[d].partition[i].partition_size;

        hidden_sectors = diskStruct[d].partition_list.partition[i].hidden_sectors;

        switch (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_ID)
        {
        case DOS_FAT12_PARTITION:
        case HIDDEN_DOS_FAT12_PARTITION:
            // kydinh: should be MIRROR_PAR instead of FAT_12_PAR because we don't suppport FAT_12_PAR smart scopy);
            action = MIRROR_PAR;// FAT_12_PAR
            break;

        case HIDDEN_WIN9X_FAT32_PARTITION:
        case DOS_FAT16_SMALLER_32MB_PARTITION:
        case DOS_FAT16_LARGER_32MB_PARTITION:
        case HIDDEN_DOS_FAT16_SMALLER_32MB_PARTITION:
        case HIDDEN_DOS_FAT16_LARGER_32MB_PARTITION:
        case HIDDEN_WIN9X_FAT16_LBA_PARTITION:
            if (gTarget[d].partition[i].copy_mode == SMART_COPY &&
                    diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_UNFORMATED)
            {
                continue; // do nothing
            }
            action = MIRROR_PAR;
            break;

        case WIN9X_FAT16_LBA_PARTITION:
        case WIN9X_FAT32_PARTITION:
        case WIN9X_FAT32_LBA_PARTITION:
            switch (gTarget[d].partition[i].copy_mode)
            {
            case SMART_COPY:
                if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_UNFORMATED)
                {
                    continue; // do nothing
                }
                else if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_FAT16 ||
                         diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_FAT32)
                {
                    action = FAT_32_PAR_SMART;
                    break;
                }

                // it is NTFS
                if (securityOperation->checkFeatureUnlocked(FEATURE_NTFS) != 1)
                {
                    action = MIRROR_PAR;
                }
                else
                {
                    action = NTFS_PAR_SOURCE_SMALLER_TARGET;
                }
                break;

            case FORMAT_PART:
                action = FAT_32_FORMAT;
                break;

            case MIRROR_COPY:
                action = MIRROR_PAR;
                break;

            case MAKE_EMPTY :
                // ky modified on Aug 30, 2007
                action = NULL_PAR;
                continue; // do nothing

            default :
                break;
            }
            break;

        case IFS_PARTITION:
        case HIDDEN_IFS_PARTITION:
            switch (gTarget[d].partition[i].copy_mode)
            {
            case SMART_COPY:
                // Ky modified on May 25, 2007
                if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_UNFORMATED)
                {
                    continue;
                }
                else if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_FAT16 ||
                         diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_FAT32)
                {
                    action = FAT_32_PAR_SMART;
                    break;
                }

                if (securityOperation->checkFeatureUnlocked(FEATURE_NTFS) != 1)
                {
                    action = MIRROR_PAR;
                }
                else
                {
                    action = NTFS_PAR_SOURCE_SMALLER_TARGET;
                }
                break;

            case FORMAT_PART:
                action = NTFS_FORMAT;
                break;

            case MIRROR_COPY:
                action = MIRROR_PAR;
                break;

            case MAKE_EMPTY :
                action = CLEAR_PAR;
                break;

            default :
                break;
            }
            break;

        case LINUX_NATIVE_PARTITION:
            if (gTarget[d].partition[i].copy_mode == SMART_COPY)
            {
                if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_UNFORMATED)
                {
                    continue; // do nothing
                }
                else if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_FAT16 ||
                         diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_FAT32)
                {
                    action = FAT_32_PAR_SMART;
                    break;
                }

                if (securityOperation->checkFeatureUnlocked(FEATURE_EXT2FS) != 1)
                {
                    action = MIRROR_PAR;
                }
                else
                {
                    EXT4_SUPER_BLOCK sblock;
                    if (this->diskIOModule.readSectors(0, diskStruct[0].partition_list.partition[sourceIndexPartition].start_sector + SP_START_SEC, SP_SEC_CNT, (unsigned short*)&sblock) != 1)
                    {
                        HandleIOError(IO_READ_DISK, 0, 0, PART_N_ADD_DISK_PARTITION_ID);
                        return UNSUCCESS;
                    }
                    if(EXT2_INODE_SIZE(&sblock) > 128)
                    {
                        action = EXT4_PAR_SMART;
                    }
                    else
                    {
                        action = EXT2_PAR_SMART;
                    }
                }
            }
            else
            {
                action = MIRROR_PAR;
            }
            break;

        case LINUX_RAID_PARTITION: //Viet Nguyen updated Dec 24 2007
            if (gTarget[d].partition[i].copy_mode == SMART_COPY)
            {
                if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_UNFORMATED)
                {
                    continue; // do nothing
                }
                else if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_FAT16 ||
                         diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_FAT32)
                {
                    action = FAT_32_PAR_SMART;
                    break;
                }
                else if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_EXT2_3)
                {
                    if (securityOperation->checkFeatureUnlocked(FEATURE_EXT2FS) != 1)
                    {
                        action = MIRROR_PAR;
                    }
                    else
                    {
                        EXT4_SUPER_BLOCK sblock;
                        if (this->diskIOModule.readSectors(0, diskStruct[0].partition_list.partition[sourceIndexPartition].start_sector + SP_START_SEC, SP_SEC_CNT, (unsigned short*)&sblock) != 1)
                        {
                            HandleIOError(IO_READ_DISK, 0, 0, PART_N_ADD_DISK_PARTITION_ID);
                            return UNSUCCESS;
                        }
                        if(EXT2_INODE_SIZE(&sblock) > 128)
                        {
                            action = EXT4_PAR_SMART;
                        }
                        else
                        {
                            action = EXT2_PAR_SMART;
                        }
                    }
                }
            }
            else
            {
                action = MIRROR_PAR;
            }
            break;

        case LINUX_LVM_PARTITION: //Viet Nguyen added Apr 11 2008
            if (gTarget[d].partition[i].copy_mode == SMART_COPY)
            {
                if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_UNFORMATED)
                {
                    continue; // do nothing
                }
                else if (diskStruct[0].partition_list.partition[sourceIndexPartition].partition_type == PAR_TYPE_LVM)
                {
                    if (securityOperation->checkFeatureUnlocked(FEATURE_EXT2FS) != 1)
                    {
                        action = MIRROR_PAR;
                    }
                    else
                    {
                        EXT4_SUPER_BLOCK sblock;
                        if (this->diskIOModule.readSectors(0, diskStruct[0].partition_list.partition[sourceIndexPartition].start_sector + SP_START_SEC, SP_SEC_CNT, (unsigned short*)&sblock) != 1)
                        {
                            HandleIOError(IO_READ_DISK, 0, 0, PART_N_ADD_DISK_PARTITION_ID);
                            return UNSUCCESS;
                        }
                        if(EXT2_INODE_SIZE(&sblock) > 128)
                        {
                            action = EXT4_PAR_SMART;
                        }
                        else
                        {
                            action = EXT2_PAR_SMART;
                        }
                    }
                }

            }
            else
            {
                action = MIRROR_PAR;
            }
            break;

        default:
            //Partition type is unknown or is not same as above partition types.
            action = MIRROR_PAR;
            break;
        }

        // partnAddTask(d,S,T,sectorCount,gTarget[d].partition[i].action,potentialError);
        if (action != NULL_PAR)
        {
            partnAddTask(d, sstart_sector, tstart_sector, slength, tlength, hidden_sectors, action, potentialError);

            fprintf(stderr, "\n Add Task: Disk [%d]: PartitionStart--> %lu  PartitionSize-->%lu", 0, sstart_sector, slength);
            fprintf(stderr, "\n Add Task: Disk [%d]: PartitionStart--> %lu  PartitionSize-->%lu", d, tstart_sector, tlength);
        }
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
 Function: partnAddTask()
 Add a task to the task list. Combine with an existing task if possible.
 Inputs: d - target number
 src_idx - source partition index
 act - action for this task
 tstart - LBA address of starting target sector
 tlength - sectors in of target partition
 PotentialError - Current potential error state
 Return: Task Number or -1 if error
*/
short CSystemD105::partnAddTask(short d, unsigned long sstart, unsigned long tstart,
                                unsigned long slength, unsigned long tlength,
                                unsigned long hidden_sectors,
                                enum ACTION_TYPE act, POTENTIAL_ERRORS PotentialError)
{
    short i;
    short addloc;
    addloc = -1;
    short tLengthNeedEqual = 0;

    if (act == FAT_32_PAR || act == FORMAT_DISK || act == SMART_HPA){
        tLengthNeedEqual = 1;
    }

    for (i = 0; i < MAX_TASKS; i++){
        // maybe this is combined with the current task?
        //printf("Task %d items count: %d \n",i,gTaskList[i].target.items);
        short taskOnList = 0;

        for (short disk = 1;disk < MAX_DISKS;disk++){
            if (gTaskList[i].target.item[disk]) taskOnList = 1;
        }

        if (taskOnList){
            if (((act == WIPEOUT_PAR) && (gTaskList[i].action == act))  ||
                    ((gTaskList[i].action == act) && (gTaskList[i].source_sector == sstart)
                     && (((gTaskList[i].source_length < tlength + 0x100 && gTaskList[i].source_length + 0x100 > tlength))
                         || (!tLengthNeedEqual)) && !partnTgtInTask(i, d)))
            {
                addloc = i;
                break;
            }
        }

        // if not is the current task empty?
        else{
            if (addloc == -1){
                addloc = i;
                totalTask++;
            }
        }
    }

    if (addloc == -1){
        //Task list full (Toan Tran)
        return -1;
    }

    //fprintf(stderr, "\n THDB here: +++++++++++ Task[%d]: SourceLengh: %ld", addloc, slength);
    //fprintf(stderr, "\n THDB here: +++++++++++ Task[%d]: SectorCount: %ld", addloc, tlength);
    // kydinh modified June 25, 2007
    gTaskList[addloc].hidden_sectors[d] = hidden_sectors;
    gTaskList[addloc].target.startSector[d] = tstart;
    gTaskList[addloc].target.startSector[0] = sstart;
    gTaskList[addloc].source_sector = sstart;
    gTaskList[addloc].source_verify_sector = sstart;
    gTaskList[addloc].source_length = slength;
    gTaskList[addloc].action = act;
    gTaskList[addloc].state = TASK_INIT;
    gTaskList[addloc].target_sector[d] = tstart;
    gTaskList[addloc].remain_sectors[d] = tlength;
    gTaskList[addloc].target_verify_sector[d] = tstart;
    gTaskList[addloc].remain_verify_sectors[d] = tlength;
    gTaskList[addloc].target.items++;
    gTaskList[addloc].target.item[d] = 1;
    gTaskList[addloc].verify_target.item[gTaskList[addloc].verify_target.items++] = d;
    gTaskList[addloc].none_error_target.item[gTaskList[addloc].none_error_target.items++] = d;
    gTaskList[addloc].set_comon_transfer_mode_flag = 0;
    gTaskList[addloc].target_info[d].partition_start = tstart;
    gTaskList[addloc].target_info[d].partition_length = tlength;

    // overwrite current error if a potential error exists
    // otherwise leave current error estate alone.
    if (PotentialError != PE_NO_ERROR)
    {
        gTaskList[addloc].potential_error[d] = PotentialError;
    }
    gTotalTask[d]++;
    //fprintf(stderr, "\n THDB here: +++++++++++ Disk[%d]: Total Task: %ld", d, gTotalTask[d]);


    return addloc;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : partnTgtInTask()
Description : check for if a target disk is in a task of a task list
Inputs : task is task number
 d is target disk number
Output : none
Return :1 if the target disk is in task or 0 if otherwise
*/
short CSystemD105::partnTgtInTask(short task, short d)
{
    short i;
    short Result = 0;
    return gTaskList[task].target.item[d];

    for (i = 1; i < MAX_DISKS; i++)
    {
        if (gTaskList[task].target.item[i] == d)
        {
            Result = 1;
            break;
        }
    }

    printDFXLog (PRI_INFO, "EXIT PARTNADDTASK\n");
    return Result;
}
//////////////////////////////////////////////////////////////////////////
//
/*!< Function startupAllDisk duoc chia lam cac giai doan khac nhau:
Giai doan 1:  NONE
Giai doan 2:  STARTUP
Giai doan 3:  TURN_ON
Giai doan 4:  CHECK_READY
Giai doan 5:  GET_IDENTIFY
Giai doan 6:  READY
*/
short CSystemD105::startupAllDisk(void)
{
    int disk, ret=0;
    unsigned int n_power_delay = 0;
    short errorCode = 0;
    int udma_mode = 0;
    int is_Talent_retry = 0;
    int is_Adtron_disk = 0;
    // is_solid_state = 0x00: normal disk, = 0x01: the size of SSD > 128GB, = 0x2: the size of SSD < 128GB
    // neu source la solid state > 128GB, set fix UDMA chay mode 3
    // neu source la solid state < 128GB, set fix UDMA chay mode 2
    int is_solid_state = 0x00;
    int pio_mode = 0;
    bool mustRunInPIO = false;

    this->startTime = QDateTime::currentDateTime();
    //Insert job to database
    this->curJobId = this->dbObj.getMaxIDFromTableByQuery("SELECT MAX(id) FROM gds_dfx_job_information;") + 1;
    this->dbObj.jobInfoObj.setId(this->curJobId);
    this->dbObj.jobInfoObj.setJobName("Check Disk");
    this->dbObj.jobInfoObj.setTimeStart(startTime);
    this->dbObj.jobInfoObj.setStartTime(QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss"));
    this->dbObj.insertTbJobInformation();

    memset (&this->gLiveTargetList, 0x00, sizeof(ITEM_LIST_STRUCT));
    this->checkFinishedDisk = 0; // the check disk is really finished?
    for(disk = 0; disk < MAX_DISKS; disk++)
    {
        this->gStartupPercent[disk] = 0;
        isCheckdisk[disk] = false;
        this->dbObj.insertTbErrorMessage(disk);
        this->diskIOModule.special_drive[disk] = NORMAL_DRIVE;
        this->dbObj.resultCopyObj[disk].diskStepList.clear();

        this->diskStepItem[disk].result.clear();
        this->diskStepItem[disk].stepName = "Check Disk";
        this->diskStepItem[disk].time.restart();
        this->diskStepItem[disk].startTime = QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss");
    }

    gAbortFlag = 0;
    short diskCount = 0;
    this->actionMode = DUPLICATING_MODE;
    //##################### Giai doan 1 #################################
    printDFXLog(PRI_INFO, "Start checking disks");
    for(disk = 0; disk < MAX_DISKS; disk++)
    {
        this->checkStage[disk] = STARTUP;
        this->finishedCheckStage[disk] = STARTUP;
        this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, disk, STARTUP, "OK");
        this->gStartupPercent[disk] = 2;
    }

    // reset the target item number to zero
    this->gLiveTargetList.items = 0;
    // set all disk to PATA mode first
    this->displaySystemOption();
    this->diskIOModule.usedGen = NO_GEN;
    this->diskIOModule.curGen = NO_GEN;
    this->isSATAMode = true;
    this->diskIOModule.mPattern = DEFAULT_PATTERN;

    //TamHo fix bug khong the poweron dia STEC cho DFX10 (30-03-2012)
    //Set GEN1 de co the get identify cua cac SATA va PATA;
    this->diskIOModule.recoveryBoard(1);

    if(this->diskIOModule.setGen(DT_SATA1) == SUCCESS)
    {
        this->diskIOModule.curGen = DT_SATA1;
        this->diskIOModule.usedGen = DT_SATA1;
    }
    SLEEP(2);
    //TamHo end fix bug (30-03-2012)

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    //##################### Giai doan 2 #################################
    //n_power_delay = this->systemOption.txt_power_up_delay > 3 ? 3 : this->systemOption.txt_power_up_delay;
    n_power_delay = this->systemOption.txt_power_up_delay;

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            this->checkStage[disk] = TURN_ON;
            printDFXLog(PRI_INFO, "Disk [%u]: %-40s", disk, "Turning on...");
            this->gStartupPercent[disk] += 5;
            if(this->diskIOModule.powerUp(disk) == UNSUCCESS)
            {
                this->inputDiskList[disk] = UNCHECKED;
                this->diskIOModule.setInputOfDisk(disk, UNCHECKED);
                this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, disk, TURN_ON, "FAIL");
            }
            else
            {
                diskCount++;
                this->diskIOModule.TurnLedMode(disk, FAST_BLINK, LED_GREEN);
                SLEEP(n_power_delay);
                this->gStartupPercent[disk] += 30 / MAX_DISKS;
                isCheckdisk[disk] = true;
                this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, disk, TURN_ON, "OK");
            }

            for(short preDisk = 0; preDisk < disk; preDisk++)
            {
                if(this->inputDiskList[preDisk] == UNCHECKED)
                {
                    if(isCheckdisk[preDisk] == true)
                    {
                        this->turnOffOneDiskWhenCheckDisk(preDisk);
                    }
                }
                else
                {
                    if(this->checkStage[preDisk] == NONE)
                    {
                        this->checkOneDiskByStep(preDisk, TURN_ON);
                    }
                }
            }
            this->finishedCheckStage[disk] = TURN_ON;

        }
    }

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    //Delay mot khoang thoi gian de tat ca cac dia ready.
    for(unsigned int idxDelay = 0; idxDelay < 7; idxDelay++)
    {
        if(this->cancelStartupAllDisk)
        {
            return UNSUCCESS;
        }

        for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
        {
            if((this->inputDiskList[disk] == UNCHECKED) && (isCheckdisk[disk] == true))
            {
                this->turnOffOneDiskWhenCheckDisk(disk);
            }
        }
        sleep(1);
    }

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    // To ensure the percent is 20%
    for (disk = 0; (!this->cancelStartupAllDisk) && (disk < MAX_DISKS);disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if(this->finishedCheckStage[disk] < TURN_ON)
            {
                this->checkOneDiskByStep(disk, TURN_ON);
            }

            isCheckdisk[disk] = true;
            if(this->gStartupPercent[disk] < 20)
            {
                this->gStartupPercent[disk] = 20;
            }
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    int tmp_disks[MAX_DISKS];
    memset(tmp_disks, 0x00, sizeof(tmp_disks));
    //##################### Giai doan 3 #################################
    // DuongVu modified from here August,22 2008
    //scan source disk
    if(this->inputDiskList[0] == UNCHECKED){
        if(isCheckdisk[0] == true){
            this->turnOffOneDiskWhenCheckDisk(0);
        }
    }
    else if(this->inputDiskList[0] == CHECKED){
        if(isCheckdisk[0] == false){
            this->checkOneDiskByStep(0, TURN_ON);
            this->checkStage[0] = CHECK_READY;
            if(this->gStartupPercent[0] < 20){
                this->gStartupPercent[0] = 20;
            }

            isCheckdisk[0] = true;
        }
    }

    printDFXLog(PRI_INFO, "Disk [%u]: %-40s", 0, "Checking ready status...");
    this->checkStage[0] = CHECK_READY;

    ret = this->checkSourceDisk();
    if(ret == -1) // cancel
    {
        return UNSUCCESS;
    }
    else if(ret == 1) // ret > 0
    {
        printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", 0, "Check ready status", MES_OK);
        tmp_disks[0] = 1;
    }
    else if(ret == 0)// ret = 0
    {
        printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", 0, "Check ready status", MES_FAILED);
        this->turnOffOneDiskWhenCheckDisk(0);
    }

    this->finishedCheckStage[0] = CHECK_READY;

    //scan all target disks
    ret = this->checkTargetDisks(tmp_disks);
    if(ret == -1) // cancel
    {
        return UNSUCCESS;
    }
    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED && this->checkStage[disk] == CHECK_READY)
        {
            if(this->gStartupPercent[disk] < 60 || this->gStartupPercent[disk] > 60)
            {
                this->gStartupPercent[disk] = 60;
            }
        }
    }
    diskCount = MAX_DISKS;
    for (disk = 0; disk < MAX_DISKS; disk++)
    {
        if(this->inputDiskList[disk] != CHECKED)
        {
            tmp_disks[disk] = 0;
            diskCount--;
        }
    }
    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if(this->finishedCheckStage[disk] < CHECK_READY)
            {
                if(this->checkOneDiskByStep(disk, CHECK_READY) == SUCCESS)
                {
                    tmp_disks[disk] = 1;
                }
            }

            if(tmp_disks[disk] == 1)
            {
                // Quynh add 02June
                if(this->gLiveTargetList.items >= 0 && this->gLiveTargetList.items < MAX_DISKS)
                {
                    this->gLiveTargetList.item[this->gLiveTargetList.items] = disk;
                    this->gLiveTargetList.items++; // count the target number disk
                }
                else
                {
                    printDFXLog(PRI_INFO, "Ops!!!TOO BAD Total of disk =%d < 0\n", gLiveTargetList.items);
                }
                this->gDriveState[disk] = DRIVE_READY;
            }
            else
            {
                this->turnOffOneDiskWhenCheckDisk(disk);
                this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, disk, CHECK_READY, "FAIL");
            }

            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    //##################### Giai doan 4 #################################
    for (disk = 0; disk < MAX_DISKS; disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if(this->finishedCheckStage[disk] < CHECK_READY)
            {
                if(this->checkOneDiskByStep(disk, CHECK_READY) == SUCCESS)
                {
                    tmp_disks[disk] = 1;
                }
            }

            if(tmp_disks[disk] == 1)
            {
                this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, disk, CHECK_READY, "OK");
                //                if(diskCount > 5)
                //                {
                //                    SLEEP(1);
                //                }
                //                else
                //                {
                //                    SLEEP(2);
                //                }
                printDFXLog(PRI_INFO, "Disk [%u]: %-40s", disk, "Getting identify...");
                this->checkStage[disk] = GET_IDENTIFY;
                errorCode = this->diskIOModule.getIdentifyDevice(disk, this->gDriveInfo[disk]);
                if(this->cancelStartupAllDisk)
                {
                    return UNSUCCESS;
                }
                // try to get identify for Super Talent Disk
                // hoa hoang repair here for detect capble 40 pin
                /*if(this->diskIOModule.comm.err == 100)
    {
    this->gLiveTargetList.items--;
    this->gDriveState[disk] = DRIVE_NO_READY;
    tmp_disks[disk] = 0;
    diskCount--;
    this->turnOffOneDiskWhenCheckDisk(disk);
    continue;
    }*/

                if(errorCode != SUCCESS)
                {
                    this->diskIOModule.hardReset(disk, 1);
                    errorCode = this->diskIOModule.getIdentifyDevice(disk, this->gDriveInfo[disk]);
                    if(this->cancelStartupAllDisk){
                        return UNSUCCESS;
                    }

                    //                    int _n1_01 = 0;
                    //                    while (_n1_01 < 4 && this->inputDiskList[disk] == CHECKED)
                    //                    {
                    //                        SLEEP(n_power_delay);
                    //                        _n1_01++;
                    //                        errorCode = this->diskIOModule.getIdentifyDevice(disk, this->gDriveInfo[disk]);

                    //                        if(this->cancelStartupAllDisk)
                    //                        {
                    //                            return UNSUCCESS;
                    //                        }

                    //                        if(errorCode == SUCCESS)
                    //                        {
                    //                            break;
                    //                        }
                    //                    }
                }

                if(strstr(this->gDriveInfo[disk].MfrName, TALENT_DRIVE_SUBSTR_MODEL_NAME)!=NULL)
                {
                    if(disk == 0)
                        is_solid_state = 0x01; // giam xuong UDMA mode 3
                    is_Talent_retry = 1;
                }
                // HARD-CODE: Only run UDMA mode 3 for Adtron disk
                if(strstr(this->gDriveInfo[disk].MfrName, ADTRON_SUBSTR_MODEL_NAME) != NULL)
                {
                    is_Adtron_disk = 1;
                }

                if(errorCode == SUCCESS)
                {
                    /*
     * kydinh: Fixing bug checking disk.
     * When when checking disk Super Talent drive, the Identify of device gotten for the first
     * time is often not valid.
     */
                    int retryID = 0;
                    while(is_identify_valid(&this->gDriveInfo[disk]) == false)
                    {
                        printDFXLog(PRI_INFO, "Disk[%u]: Identify is not valid...", disk);
                        printDFXLog(PRI_INFO, "Disk[%u]: Try to get Identify for valid...", disk);
                        SLEEP(2);
                        errorCode = this->diskIOModule.getIdentifyDevice(disk, this->gDriveInfo[disk]);
                        retryID++;
                        if(retryID > 5)
                        {
                            gLiveTargetList.items--;
                            this->gDriveState[disk] = DRIVE_NO_READY;
                            tmp_disks[disk] = 0;
                            diskCount--;
                            this->turnOffOneDiskWhenCheckDisk(disk);
                            break;
                        }
                        if(this->cancelStartupAllDisk)
                        {
                            return UNSUCCESS;
                        }

                        if(strstr(this->gDriveInfo[disk].MfrName,TALENT_DRIVE_SUBSTR_MODEL_NAME)!=NULL)
                        {
                            if(disk == 0)
                                is_solid_state = 0x01; // giam xuong UDMA mode 3
                            is_Talent_retry = 1;
                        }
                        // HARD-CODE: Only run UDMA mode 3 for Adtron disk
                        if(strstr(this->gDriveInfo[disk].MfrName, ADTRON_SUBSTR_MODEL_NAME) != NULL)
                        {
                            is_Adtron_disk = 1;
                        }
                    }

                    //Qua so lan retry va khong the get identify
                    if(this->gDriveState[disk] == DRIVE_NO_READY)
                    {
                        this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
                        //this->turnOffOneDiskWhenCheckDisk(disk);// modify 2013-10-26 (TamHo)
                        continue;
                    }
                }
                else
                {
                    this->gDriveState[disk] = DRIVE_NO_READY;
                    tmp_disks[disk] = 0;
                    this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
                    this->setInputOfDisk(disk, UNCHECKED);
                    this->diskIOModule.setInputOfDisk(disk, UNCHECKED);
                    //this->turnOffOneDiskWhenCheckDisk(disk);// modify 2013-10-26 (TamHo)
                }
            }
            else
            {
                this->gDriveState[disk] = DRIVE_NO_READY;
                tmp_disks[disk] = 0;
                this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
                this->setInputOfDisk(disk, UNCHECKED);
                this->diskIOModule.setInputOfDisk(disk, UNCHECKED);
                //this->turnOffOneDiskWhenCheckDisk(disk);// modify 2013-10-26 (TamHo)
            }

            this->finishedCheckStage[disk] = GET_IDENTIFY;

            // put cancelling hook
            if(this->cancelStartupAllDisk)
            {
                return UNSUCCESS;
            }

            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    //////////////////////////////////////////////////////////////////////////
    // HoaHoang add code here check status of security password
    for (short i = 0; i < MAX_DISKS; i++)
    {
        if(this->inputDiskList[i] == CHECKED)
        {
            if(this->finishedCheckStage[i] < GET_IDENTIFY)
            {
                this->checkOneDiskByStep(i, GET_IDENTIFY);
            }

            if(this->gDriveInfo[i].SecurityStatus & 0x0001 ) // support security erase mode
            {

                if(this->gDriveInfo[i].SecurityStatus & 0x0002) // if password enable
                {
                    // disable disk
                    // if disk is source return if job is smart and mirror
                    if(i==0)
                    {
                        if(this->gTarget[i].disk_mode == DISK_SMART || this->gTarget[i].disk_mode == DISK_MIRROR)
                        {
                            printDFXLog(PRI_INFO, MES_ERR "Disk [%d] is lock mode (Set password)",i);
                            printDFXLog(PRI_INFO, MES_ERR "This job need source disk");
                            return UNSUCCESS;
                        }
                    }
                    //Set disk not ready if job != DISK_SECURITY_ERASE
                    if(this->gTarget[i].disk_mode != DISK_SECURITY_ERASE)
                    {
                        printDFXLog(PRI_INFO, MES_ERR "Disk [%d] is lock mode (Set password)",i);
                        this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
                        this->gDriveState[i] = DISABLED;
                    }

                }
            }
            isCheckdisk[i] = true;
        }
        else if(isCheckdisk[i] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(i);
        }
    }

    //end HoaHoang
    //////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////
    if(is_Talent_retry || is_Adtron_disk)
    {
        //if disk is supertalen increase time out for reset hard disk
        this->diskIOModule.delay_talent = 100;
    }
    else
    {
        this->diskIOModule.delay_talent = 0;
    }

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if((this->finishedCheckStage[disk] < GET_IDENTIFY) ||
                    ((this->checkStage[disk] == GET_IDENTIFY) && (this->checkStage[disk] != this->finishedCheckStage[disk])))
            {
                this->checkOneDiskByStep(disk, GET_IDENTIFY);
            }

            if(this->gDriveState[disk] == DRIVE_READY)
            {
                if(this->gStartupPercent[disk] < 80)
                {
                    this->gStartupPercent[disk] = 80;
                }
            }
            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if((this->finishedCheckStage[disk] < GET_IDENTIFY) ||
                    ((this->checkStage[disk] == GET_IDENTIFY) && (this->checkStage[disk] != this->finishedCheckStage[disk])))
            {
                this->checkOneDiskByStep(disk, GET_IDENTIFY);
            }

            if(this->gDriveState[disk] == DRIVE_READY)
            {
                this->gStartupPercent[disk] += 10;
                // 02June08 QuynhBui Add: k hieu sao dvoi truong hop Super64GB lam target,phai off,on source moi chay duoc. This is really a cheat.
                if(is_Talent_retry && disk == 0)
                {
                    is_Talent_retry = 0;
                }

                //--------------end modification------------------
                errorCode = startupIdentifyDevice(disk, 0);

                if(errorCode != 1)
                {
                    this->gDriveState[disk] = DEAD_DRIVE;
                    // ky fixed bug on Aug 15, 2007
                    gLiveTargetList.items--;
                    printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", disk, "Get identify device information", MES_FAILED);
                    this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, disk, GET_IDENTIFY, "FAIL");
                }
                else
                {
                    udma_mode = get_udma_mode(this->gDriveInfo[disk].Flags53, this->gDriveInfo[disk].UltraDmaMode);
                    if(udma_mode > -1)
                    {
                        printDFXLog(PRI_INFO, "%-40s %u", ".Support UDMA mode", udma_mode);
                        if(this->mMinUDMAMode == -1 || udma_mode < this->mMinUDMAMode)
                        {
                            this->mMinUDMAMode = udma_mode;
                        }
                    }
                    else
                    {
                        printDFXLog(PRI_INFO, "%-40s",".Not support UDMA mode");
                        mustRunInPIO = true;
                    }

                    pio_mode = get_pio_mode(this->gDriveInfo[disk].Flags53, this->gDriveInfo[disk].PIOmodes);
                    if(pio_mode > -1)
                    {
                        printDFXLog(PRI_INFO, "%-40s %u", ".Support PIO mode", pio_mode);
                        if(this->mMinPIOMode == -1 || pio_mode < this->mMinPIOMode)
                        {
                            this->mMinPIOMode = pio_mode;
                        }
                    }
                    else
                    {
                        printDFXLog(PRI_INFO, "%-40s", ".Not support PIO mode");
                    }
                    this->gDriveType[disk] = this->getDriveType(this->gDriveInfo[disk]);
                    this->diskIOModule.gDriveType[disk] = this->gDriveType[disk];
                    if(this->gDriveType[disk] != DT_PATA)
                    {
                        if(this->gDriveType[disk] == DT_SATA)
                        {
                            printDFXLog(PRI_INFO, "%-40s SATA", ".Drive Type");
                        }
                        else
                        {
                            printDFXLog(PRI_INFO, "%-40s SATA%d", ".Drive Type", gDriveType[disk]);
                        }
                    }
                    else
                    {
                        printDFXLog(PRI_INFO, "%-40s PATA", ".Drive Type");
                    }

                    printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", disk, "Get identify device information", MES_OK);
                    this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, disk, GET_IDENTIFY, "OK");
                }
                if(diskCount > 0)
                {
                    this->gStartupPercent[disk] += 10 / diskCount;
                }
                else
                {
                    this->gStartupPercent[disk] += 10 / MAX_DISKS;
                }
            }

            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }// for

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    this->diskIOModule.transfer_mode = systemOption.transfer_mode;
    this->mUDMAMode = systemOption.transfer_mode; //TanLe added - Fix bug: Software always run in low UDMA mode after applied a hard drive which support low UDMA mode
    if(systemOption.enable_brief_copy == 1)
    {
        this->isBriefCopy = TRUE;
        this->diskIOModule.mDoSystemOption.enable_brief_copy = 1;
    }
    else
    {
        this->isBriefCopy = FALSE;
    }

    if((this->diskIOModule.transfer_mode <= (UDMA_MODE_MAX - 0x40)) && (this->diskIOModule.transfer_mode >= (UDMA_MODE_MIN - 0x40)) && mustRunInPIO == false)
    {
        if(this->mMinUDMAMode != -1 && this->mMinUDMAMode < this->mUDMAMode)//if(this->mMinUDMAMode < systemOption.transfer_mode)
        {
            printDFXLog(PRI_INFO, "Some disks have just supported UDMA %d.", this->mMinUDMAMode);
            printDFXLog(PRI_INFO, "The system will automatically use the UDMA %d by default.\n", this->mMinUDMAMode);
            this->mUDMAMode = this->mMinUDMAMode;
        }

        if(this->mMinUDMAMode != -1)
        {
            // kiem tra dia SSD la source thi giam UDMA mode xuong
            if(is_Adtron_disk && (this->mUDMAMode >= 3))
            {
                this->mUDMAMode = 3;
            }
            if(is_solid_state && (this->mUDMAMode >= 3))
            {
                // kiem tra size cua dia~ ssd
                unsigned long cap = 0;
                unsigned long wtmp = this->gDriveInfo[0].MaxUserLbaAddr1_48Bit;
                wtmp <<= 16;
                wtmp |= this->gDriveInfo[0].MaxUserLbaAddr0_48Bit;
                cap = ((this->gDriveInfo[0].CommandSetsSupported & 0x0400) == 0x0400) ? wtmp : this->gDriveInfo[0].LBAuserSectors;
                if(cap > 250000000L) // disk size > 128GB
                {
                    this->mUDMAMode = 3;
                }
            }
            this->diskIOModule.setTransferMode(this->mUDMAMode);
            this->diskIOModule.setCurrentTransferMode();
        }
        else
        {
            printDFXLog(PRI_INFO, MES_WAR" None of disks supported UDMA.");
            for (disk = 0;disk < MAX_DISKS;disk++)
            {
                this->gDriveState[disk] = DRIVE_NO_READY;
            }

            return UNSUCCESS;
        }
    }
    else
    {
        if(this->mMinPIOMode != -1 && this->mPIOMode == -1)
        {
            printDFXLog(PRI_INFO, "Some disks have just supported PIO %d.", this->mMinPIOMode);
            printDFXLog(PRI_INFO, "The system will automatically use the PIO %d by default.\n", this->mMinPIOMode);
            this->mPIOMode = this->mMinPIOMode;
        }
        else if(this->mMinPIOMode != -1 && this->mMinPIOMode <= this->mPIOMode && this->mPIOMode > -1)
        {
            this->mPIOMode = this->mMinPIOMode;
        }

        if(this->mPIOMode != -1)
        {
            this->diskIOModule.setTransferMode(this->mPIOMode + 7);
            this->diskIOModule.setCurrentTransferMode();
        }
        else
        {
            printDFXLog(PRI_INFO, MES_WAR" None of disks supported PIO.");
            for (disk = 0;disk < MAX_DISKS;disk++)
            {
                this->gDriveState[disk] = DRIVE_NO_READY;
            }
            return UNSUCCESS;
        }
    }

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if((this->finishedCheckStage[disk] < GET_IDENTIFY) ||
                    ((this->checkStage[disk] == GET_IDENTIFY) && (this->checkStage[disk] != this->finishedCheckStage[disk])))
            {
                this->checkOneDiskByStep(disk, GET_IDENTIFY);
            }

            if(this->gDriveState[disk] == DRIVE_READY)
            {
                if(this->gStartupPercent[disk] < 90)
                {
                    this->gStartupPercent[disk] = 90;
                }
            }

            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    //##################### Giai doan 6 #################################
    // Scan disk reached to 80%
    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if(this->gDriveState[disk] == DRIVE_READY)
            {
                if(this->gStartupPercent[disk] < 80 || this->gStartupPercent[disk] > 80)
                {
                    this->gStartupPercent[disk] = 80;
                }
            }

            if((this->finishedCheckStage[disk] < GET_IDENTIFY) ||
                    ((this->checkStage[disk] == GET_IDENTIFY) && (this->checkStage[disk] != this->finishedCheckStage[disk])))
            {
                this->checkOneDiskByStep(disk, GET_IDENTIFY);
            }

            this->finishedCheckStage[disk] = GET_IDENTIFY;
            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if((this->finishedCheckStage[disk] < GET_IDENTIFY) ||
                    ((this->checkStage[disk] == GET_IDENTIFY) && (this->checkStage[disk] != this->finishedCheckStage[disk])))
            {
                this->checkOneDiskByStep(disk, READY);
            }
            this->finishedCheckStage[disk] = GET_IDENTIFY;
            isCheckdisk[disk] = true;
        }
        else
        {
            this->gDriveState[disk] = DRIVE_NO_READY;
        }
    }

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if((this->finishedCheckStage[disk] < GET_IDENTIFY) ||
                    ((this->checkStage[disk] == GET_IDENTIFY) && (this->checkStage[disk] != this->finishedCheckStage[disk])))
            {
                this->checkOneDiskByStep(disk, GET_IDENTIFY);
            }
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }

        if((this->gDriveState[disk] != DRIVE_READY) && (isCheckdisk[disk] == true))
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }
    //Duongvu add code here to set gen for disks (August 31 2011)
    short usedGen = NO_GEN;
    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED && this->gDriveState[disk] == DRIVE_READY)
        {
            //Neu la WipeDisk thi khong can quan tam GEN cua dia source
            if(disk == 0 && (this->diskIOModule.jobId == CORE_FAST_PURGE_JOB || this->diskIOModule.jobId == CORE_WIPE_DISK_JOB)){
                continue;
            }

            if(this->gDriveType[disk] != DT_SATA1 && this->gDriveType[disk] != DT_SATA2 && this->gDriveType[disk] != DT_SATA3){
                this->isSATAMode = false;
            }

            short diskGen = this->diskIOModule.getGenOfDisk(disk);
            if(diskGen < usedGen)
            {
                usedGen = diskGen;
            }

            if(strstr(this->gDriveInfo[disk].MfrName, STEC_SUBSTR_MODEL_NAME) != NULL)
            {
                this->diskIOModule.special_drive[disk] = STEC_DRIVE;
            }

            //Check drive if this is DB32 drive.
            if(strstr(this->gDriveInfo[disk].MfrName, DB32_SUBSTR_MODEL_NAME) != NULL)
            {
                this->diskIOModule.special_drive[disk] = DB32_DRIVE;
            }

            //Check drive if this is XFR drive.
            if(strstr(this->gDriveInfo[disk].MfrName, XFR_SUBSTR_MODEL_NAME) != NULL)
            {
                this->diskIOModule.special_drive[disk] = XFR_DRIVE;
            }

            //Check drive if this is SMART drive.
            if(strstr(this->gDriveInfo[disk].MfrName, SMART_SUBSTR_MODEL_NAME) != NULL)
            {
                this->diskIOModule.special_drive[disk] = SMART_DRIVE;
            }
        }
    }

    if(usedGen != NO_GEN)
    {
        if(usedGen > DT_SATA1)
        {
            bool hasDB32Drive = false;
            for (disk = 0; disk < MAX_DISKS;disk++)
            {
                if(disk == 0 && (this->diskIOModule.jobId == CORE_FAST_PURGE_JOB || this->diskIOModule.jobId == CORE_WIPE_DISK_JOB)){
                    continue;
                }

                //Neu co dia DB32 tham gia qua trinh copy thi setup GEN1
                if(this->diskIOModule.special_drive[disk] == DB32_DRIVE)
                {
                    hasDB32Drive = true;
                }
            }

            if((hasDB32Drive == false) || // khong co dia DB32 tham gia qua trinh copy
                    (this->diskIOModule.jobId == CORE_FAST_PURGE_JOB))
            {
                if(this->diskIOModule.setGen(usedGen) == SUCCESS)
                {
                    this->diskIOModule.usedGen = usedGen;
                    this->diskIOModule.curGen = usedGen;
                }
            }
            else
            {
                this->diskIOModule.usedGen = DT_SATA1;
                this->diskIOModule.curGen = DT_SATA1;
            }
        }
        else
        {
            this->diskIOModule.setGen(DT_SATA1);
            this->diskIOModule.usedGen = DT_SATA1;
            this->diskIOModule.curGen = DT_SATA1;
        }
    }
    else
    {
        this->diskIOModule.setGen(DT_SATA1);
        this->diskIOModule.usedGen = DT_SATA1;
        this->diskIOModule.curGen = DT_SATA1;
    }

    this->diskIOModule.orgCurGen = this->diskIOModule.curGen;
    SLEEP(2);
    //End Duongvu

    if(this->cancelStartupAllDisk)
    {
        return UNSUCCESS;
    }

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(disk == 0 && (this->diskIOModule.jobId == CORE_FAST_PURGE_JOB || this->diskIOModule.jobId == CORE_WIPE_DISK_JOB)){
            continue;
        }

        if(this->inputDiskList[disk] == CHECKED && this->gDriveState[disk] == DRIVE_READY)
        {
            // Check all disk ready (2013-10-08)
            // Fixing the bug: Cannot linkup with SATA drive is pluged via PATA adapter
            int retryCount = 5;
            while(retryCount > 0){
                if(this->diskIOModule.makeDiskReady(disk) == SUCCESS){
                    this->diskIOModule.usedGen = this->diskIOModule.curGen;
                    break;
                }else{
                    //Thuc hien giam GEN, neu dia ready thi GEN nay phu hop voi dia
                    if(retryCount < 4){
                        if(this->diskIOModule.curGen > DT_SATA1){
                            this->diskIOModule.reduceGen();
                        }else{
                            //Remove drive
                            this->turnOffOneDiskWhenCheckDisk(disk);
                            break;
                        }
                    }else{
                        this->diskIOModule.recoveryBoard(1);
                    }
                    retryCount--;
                }
            }
            this->gStartupPercent[disk] = 90;
        }
    }

    //Clear buffer recovery of previous process (2013-11-11)
    this->diskIOModule.clearSectorCountCopied();

    //Scan the partition list in source
    diskStruct[0].partition_list.number_of_partitions = 0;
    if(this->diskIOModule.jobId != CORE_FAST_PURGE_JOB && this->diskIOModule.jobId != CORE_WIPE_DISK_JOB){
        if((this->inputDiskList[0] == CHECKED) && (this->gDriveState[0] == DRIVE_READY))
        {
            this->diskIOModule.setPartitionStart(0, 0);
            this->diskIOModule.setPartitionLength(0, gCapacity[0]);

            //Check drive is SED drive and unlock it if need
            //            if(this->diskIOModule.isSEDdrive(0, this->gDriveInfo[0]) == true)
            //            {
            //                if(this->diskIOModule.unlockSED_Full(0) != SUCCESS)
            //                {
            //                    this->turnOffOneDiskWhenCheckDisk(0);
            //                }
            //            }

            //Read structure patition of disk
            errorCode = diskStruct[0].scanDiskStructure();
            if(errorCode == -1)
            {
                this->gDriveState[0] = DEAD_DRIVE;
                gLiveTargetList.items--;
                this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, 0, READY, "FAIL");
            }
        }
    }


    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if((this->finishedCheckStage[disk] < GET_IDENTIFY) ||
                    ((this->checkStage[disk] == GET_IDENTIFY) && (this->checkStage[disk] != this->finishedCheckStage[disk])))
            {
                this->checkOneDiskByStep(disk, GET_IDENTIFY);
            }

            if(this->gDriveState[disk] == DRIVE_READY)
            {
                if(this->gStartupPercent[disk] < 99)
                {
                    this->gStartupPercent[disk] = 99;
                }
            }

            this->finishedCheckStage[disk] = GET_IDENTIFY;
            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED && this->gDriveState[disk] == DRIVE_READY)
        {
            // Scan disk reached to 100%
            if(this->gStartupPercent[disk] < 100 || this->gStartupPercent[disk] > 100)
            {
                this->diskIOModule.TurnLedMode(disk, SLOW_BLINK, LED_GREEN);
                this->gTarget[disk].enable = 1;
                this->checkStage[disk] = READY;
                this->gStartupPercent[disk] = 100;
                this->diskIOModule.setInputOfDisk(disk, CHECKED);
                this->diskIOModule.setPartitionStart(disk, 0);
                this->diskIOModule.setPartitionLength(disk, this->gCapacity[disk]);
                this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, disk, READY, "OK");
                this->gDriveInfo[disk].MfrName[strlen(this->gDriveInfo[disk].MfrName)] = '\0';
                this->insertDiskInformationToDatabase(disk);
                if(this->diskStepItem[disk].result.isEmpty())
                {
                    this->diskStepItem[disk].result = "Passed";
                    this->diskStepItem[disk].elapsedTime = this->diskStepItem[disk].time.elapsed() / 1000;
                }
            }
        }
        else
        {
            this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
            this->diskIOModule.setInputOfDisk(disk, UNCHECKED);
            this->gTarget[disk].enable = 0;
            if(this->diskStepItem[disk].result.isEmpty())
            {
                this->diskStepItem[disk].result = "Failed";
                this->diskStepItem[disk].elapsedTime = this->diskStepItem[disk].time.elapsed() / 1000;
            }
        }

        this->dbObj.insertTbCheckDiskDetail(disk);
        this->dbObj.resultCopyObj[disk].diskStepList.append(diskStepItem[disk]);
    }
    this->checkFinishedDisk = 1; // the thread finished completely
    //Start time for job
    for (short disk = 0;disk < MAX_DISKS;disk++)
    {
        if(this->inputDiskList[disk] == CHECKED && this->gDriveState[disk] == DRIVE_READY)
        {
            this->diskStepItem[disk].elapsedTime = 0;
            this->diskStepItem[disk].result = "";
            this->diskStepItem[disk].stepName = "";
            this->diskStepItem[disk].writePattern = 0;
            this->diskStepItem[disk].time.restart();
            this->diskStepItem[disk].startTime = QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss");
            printDFXLog (PRI_INFO, "Start time for disk[%d] - Start time: %s", disk, this->diskStepItem[disk].startTime.toLatin1().data());
        }
    }
    SLEEP(1);
    if(this->cancelStartupAllDisk)
    {
        for (disk = 0; !this->cancelStartupAllDisk && disk < MAX_DISKS;disk++){
            if(this->inputDiskList[disk] == CHECKED && this->gDriveState[disk] == DRIVE_READY){
                this->turnOffOneDiskWhenCheckDisk(disk);
            }
        }
        return UNSUCCESS;
    }
    this->updateInformationForCheckDiskJob();
    return SUCCESS;
}

//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::startupOneDisk(short diskItem)
{
    unsigned int n_power_delay = 0;
    int is_Talent_retry = 0;
    int udma_mode, pio_mode;
    short TIME_OUT, time = 0;
    short errorCode = 0 ;
    bool mustRunInPIO = false;
    printDFXLog(PRI_INFO, "Start checking disk");
    this->gStartupPercent[diskItem] = 0;
    this->gAbortFlag = 0;
    this->checkStage[diskItem] = STARTUP;
    this->setInputOfDisk(diskItem, CHECKED);
    this->diskIOModule.setInputOfDisk(diskItem, CHECKED);
    TIME_OUT = this->systemOption.txt_settling_time < 5 ? (this->systemOption.txt_settling_time + 2) : 5;
    this->clearDriveInfo(diskItem);
    this->gDriveState[diskItem] = START_UP;
    this->gCopyResult[diskItem] = INCOMPLETE;
    this->dbObj.insertTbErrorMessage(diskItem);
    this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, STARTUP, "OK");
    if(this->diskIOModule.usedGen != DT_SATA1)
    {
        if(this->diskIOModule.setGen(DT_SATA1) == SUCCESS)
        {
            this->diskIOModule.curGen = DT_SATA1;
        }
        SLEEP(2);
    }

    printDFXLog(PRI_INFO, "Disk [%u]: %-40s", diskItem, "Turning on...");
    n_power_delay = this->systemOption.txt_power_up_delay < 5 ? 5 : this->systemOption.txt_power_up_delay;

    this->checkStage[diskItem] = TURN_ON;

    this->gDriveState[diskItem] = DRIVE_NO_READY;
    if(this->diskIOModule.powerUp(diskItem) == UNSUCCESS)
    {
        this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, TURN_ON, "FAIL");
        return UNSUCCESS;
    }
    this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, TURN_ON, "OK");
    SLEEP(3 + n_power_delay);
    this->gStartupPercent[diskItem] = 30;

    if(this->cancelStartupAllDisk)
    {
        this->diskIOModule.powerDown(diskItem);
        return 0;
    }

    printDFXLog(PRI_INFO, "Disk [%u]: %-40s", diskItem, "Checking ready status...");

    this->checkStage[diskItem] = CHECK_READY;
    time = 0;
    do
    {
        if(this->cancelStartupAllDisk)
        {
            this->diskIOModule.powerDown(diskItem);
            return UNSUCCESS;
        }
        time++;
        if(this->cancelStartupAllDisk)
        {
            this->diskIOModule.powerDown(diskItem);
            return UNSUCCESS;
        }
        if(this->diskIOModule.select_drive(diskItem) == 1)
        {
            this->gStartupPercent[diskItem] += 20;
            this->gDriveState[diskItem] = DRIVE_READY;
            printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Check ready status", MES_OK);
            this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, CHECK_READY, "OK");
            break;
        }
        this->gStartupPercent[diskItem] += 10 / TIME_OUT;
        SLEEP(2);//sleep(2);
    }
    while (time < TIME_OUT);


    if(this->cancelStartupAllDisk)
    {
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    // Percent is about 60%. Count the number of ready drives.
    if(this->gStartupPercent[diskItem] < 60 || this->gStartupPercent[diskItem] > 60)
    {
        this->gStartupPercent[diskItem] = 60;
    }

    if(this->cancelStartupAllDisk)
    {
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    if(this->gDriveState[diskItem] == DRIVE_READY)
    {
        SLEEP(2);
        printDFXLog(PRI_INFO, "Disk [%u]: %-40s", diskItem, "Getting identify...");
        this->checkStage[diskItem] = GET_IDENTIFY;
        errorCode = this->diskIOModule.getIdentifyDevice(diskItem, this->gDriveInfo[diskItem]);
        if(this->cancelStartupAllDisk)
        {
            this->gDriveState[diskItem] = DRIVE_NO_READY;
            this->diskIOModule.powerDown(diskItem);
            return UNSUCCESS;
        }

        if(errorCode == 1)
        {
            /*
   * Fixing bug checking disk.
   * When when checking disk Super Talent drive, the Identify of device gotten for the first
   * time is often not valid.
   */
            int retryID = 0;
            while(is_identify_valid(&this->gDriveInfo[diskItem]) == false)
            {
                printDFXLog(PRI_INFO, "Disk[%u]: Identify is not valid...", diskItem);
                printDFXLog(PRI_INFO, "Disk[%u]: Try to get Identify for valid...", diskItem);
                SLEEP(2);
                errorCode = this->diskIOModule.getIdentifyDevice(diskItem, this->gDriveInfo[diskItem]);
                if(this->cancelStartupAllDisk || retryID > 5)
                {
                    this->gDriveState[diskItem] = DRIVE_NO_READY;
                    this->diskIOModule.powerDown(diskItem);
                    return UNSUCCESS;
                }

                if(errorCode != 1 || !is_identify_valid(&this->gDriveInfo[diskItem]))
                {
                    printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Get identify device information", MES_FAILED);
                    this->gDriveState[diskItem] = DRIVE_NO_READY;
                }
            }
            if(strstr(this->gDriveInfo[diskItem].MfrName, TALENT_DRIVE_SUBSTR_MODEL_NAME)!=NULL)
            {
                is_Talent_retry = 1;
            }
        }
        else
        {
            this->gDriveState[diskItem] = DRIVE_NO_READY;
        }
    }
    else
    {
        this->diskIOModule.powerDown(diskItem);
        printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Check ready status", MES_FAILED);
        this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, CHECK_READY, "FAIL");
        return UNSUCCESS;
    }

    if(this->gDriveState[diskItem] == DRIVE_READY)
    {
        this->gStartupPercent[diskItem] += 10;
        //////////////////////////////////////////////////////////////////////////
        if(is_Talent_retry)
        {
            //if disk is supertalen increase time out for reset hard disk
            this->diskIOModule.delay_talent = 100;
        }
        else
        {
            this->diskIOModule.delay_talent = 0;
        }

        this->mNeedToResetBoard = false;
        //////////////////////////////////////////////////////////////////////////
        //HoaHoang add here
        if(this->gDriveInfo[diskItem].SecurityStatus & 0x0001 ) // support security erase mode
        {

            if(this->gDriveInfo[diskItem].SecurityStatus & 0x0002) // if password enable
            {
                //Set disk not ready if job != DISK_SECURITY_ERASE
                if(this->gTarget[diskItem].disk_mode != DISK_SECURITY_ERASE)
                {
                    printDFXLog(PRI_INFO, MES_ERR "Disk [%d] is lock mode (Set password)",diskItem);
                    this->gDriveState[diskItem] = DEAD_DRIVE;
                    this->diskIOModule.powerDown(diskItem);
                    return UNSUCCESS;
                }

            }
        }
        //////////////////////////////////////////////////////////////////////////
        errorCode = this->startupIdentifyDevice(diskItem, 0);
        if(errorCode != SUCCESS)
        {
            this->gDriveState[diskItem] = DEAD_DRIVE;
            this->diskIOModule.powerDown(diskItem);
            printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Get identify device information", MES_FAILED);
            return SUCCESS;
        }
        else
        {
            udma_mode = this->get_udma_mode(this->gDriveInfo[diskItem].Flags53, this->gDriveInfo[diskItem].UltraDmaMode);
            if(udma_mode > -1)
            {
                printDFXLog(PRI_INFO, "%-40s %u", ".Support UDMA mode", udma_mode);
                if(this->mMinUDMAMode == -1) // this->mMinUDMAMode is not set yet
                {
                    this->mMinUDMAMode = udma_mode;
                }
                else
                {
                    if(udma_mode < this->mMinUDMAMode)
                    {
                        this->mMinUDMAMode = udma_mode;
                    }
                }
            }
            else
            {
                printDFXLog(PRI_INFO, "%-40s", ".Not support UDMA mode");
                mustRunInPIO = true;
            }

            pio_mode = get_pio_mode(this->gDriveInfo[diskItem].Flags53, this->gDriveInfo[diskItem].PIOmodes);
            if(pio_mode > -1)
            {
                printDFXLog(PRI_INFO, "%-40s %u", ".Support PIO mode", pio_mode);
                if(this->mMinPIOMode == -1) // this->mMinPIOMode is not set yet
                    this->mMinPIOMode = pio_mode;
                else
                {
                    if(this->mMinPIOMode > pio_mode)
                    {
                        this->mMinPIOMode = pio_mode;
                    }
                }
            }
            else
            {
                printDFXLog(PRI_INFO, "%-40s", ".Not support PIO mode");
            }

            this->gDriveType[diskItem] = this->getDriveType(this->gDriveInfo[diskItem]);
            this->diskIOModule.gDriveType[diskItem] = this->gDriveType[diskItem];
            if(this->gDriveType[diskItem] != DT_PATA)
            {
                if(this->gDriveType[diskItem] == DT_SATA)
                {
                    printDFXLog(PRI_INFO, "%-40s SATA", ".Drive Type");
                }
                else
                {
                    printDFXLog(PRI_INFO, "%-40s SATA%d", ".Drive Type", gDriveType[diskItem]);
                }
            }
            else
            {
                printDFXLog(PRI_INFO, "%-40s PATA", ".Drive Type");
            }

            this->gStartupPercent[diskItem] += 10;
            this->gLiveTargetList.items++;
            printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Get identify device information", MES_OK);
            this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, GET_IDENTIFY, "OK");
            if((this->diskIOModule.transfer_mode <= (UDMA_MODE_MAX - 0x40)) && (this->diskIOModule.transfer_mode >= (UDMA_MODE_MIN - 0x40)) && mustRunInPIO == false)
            {
                //printDFXLog(PRI_INFO,"Checking the disk for UDMA mode...");
                if(udma_mode > -1)
                {
                    if(this->mMinUDMAMode < this->mUDMAMode)
                    {
                        printDFXLog(PRI_INFO, "UDMA mode %d is recommended", this->mMinUDMAMode);
                        this->mUDMAMode = min(this->mUDMAMode, this->mMinUDMAMode);
                        if(is_Talent_retry && (this->mUDMAMode >= 3))
                        {
                            // kiem tra size cua dia~ ssd
                            unsigned long cap = 0;
                            unsigned long wtmp = this->gDriveInfo[0].MaxUserLbaAddr1_48Bit;
                            wtmp <<= 16;
                            wtmp |= this->gDriveInfo[0].MaxUserLbaAddr0_48Bit;
                            cap = ((this->gDriveInfo[0].CommandSetsSupported & 0x0400) == 0x0400) ? wtmp : this->gDriveInfo[0].LBAuserSectors;
                            // printDFXLog(PRI_INFO,"cap = %lu\n",cap);
                            printDFXLog(PRI_INFO, "is_Talent_retry = 1 && cap = %lld",cap);
                            if(cap > 250000000L) // disk size > 128GB
                                this->mUDMAMode = 3;
                            else
                                this->mUDMAMode = 2;
                        }
                        this->diskIOModule.setTransferMode(this->mUDMAMode);
                        this->diskIOModule.setCurrentTransferMode();
                    }
                }
            }
            else
            {
                //printDFXLog(PRI_INFO,"Checking the disk for PIO mode...");
                if(pio_mode > -1)
                {
                    if(this->mMinPIOMode < this->mPIOMode)
                    {
                        printDFXLog(PRI_INFO, "PIO %d is recommended", pio_mode);
                        this->mPIOMode = min(this->mPIOMode, this->mMinPIOMode);
                        this->diskIOModule.setTransferMode(this->mPIOMode + 7);
                        this->diskIOModule.setCurrentTransferMode();
                    }
                }
            }
        }
    }
    else
    {
        this->diskIOModule.powerDown(diskItem);
        printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Get identify device information", MES_FAILED);
        this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, GET_IDENTIFY, "FAIL");
        return UNSUCCESS;
    }


    if(this->cancelStartupAllDisk)
    {
        this->gDriveState[diskItem] = DRIVE_NO_READY;
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    // Scan disk reached to 80%
    if(this->gStartupPercent[diskItem] < 80 || this->gStartupPercent[diskItem] > 80)
    {
        this->gStartupPercent[diskItem] = 80;
    }

    if(this->cancelStartupAllDisk)
    {
        this->gDriveState[diskItem] = DRIVE_NO_READY;
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }
    //Duongvu add code here to set gen for disks (August 31 2011)
    short usedGen = NO_GEN;
    if(this->inputDiskList[diskItem] == CHECKED && this->gDriveState[diskItem] == DRIVE_READY)
    {
        usedGen = this->diskIOModule.getGenOfDisk(diskItem);
    }
    if(this->cancelStartupAllDisk)
    {
        this->gDriveState[diskItem] = DRIVE_NO_READY;
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    //Check drive if this is DB32 drive.
    if(strstr(this->gDriveInfo[diskItem].MfrName, DB32_SUBSTR_MODEL_NAME) != NULL)
    {
        this->diskIOModule.special_drive[diskItem] = DB32_DRIVE;
    }

    if(this->diskIOModule.usedGen != DT_SATA1)
    {
        if((usedGen == NO_GEN) && (this->diskIOModule.special_drive[diskItem] != DB32_DRIVE))
        {
            if(this->diskIOModule.setGen(this->diskIOModule.usedGen) == UNSUCCESS)
            {
                return UNSUCCESS;
            }
        }
        else if(usedGen == DT_SATA1)
        {
            this->diskIOModule.usedGen = usedGen;
            this->diskIOModule.curGen = usedGen;
        }
        else if(usedGen < this->diskIOModule.usedGen)
        {
            if(this->diskIOModule.setGen(usedGen) == UNSUCCESS)
            {
                return UNSUCCESS;
            }
            this->diskIOModule.usedGen = usedGen;
            this->diskIOModule.curGen = usedGen;
        }
    }

    if(this->gDriveType[diskItem] != DT_SATA1 && this->gDriveType[diskItem] != DT_SATA2 && this->gDriveType[diskItem] != DT_SATA3){
        this->isSATAMode = false;
    }

    this->gStartupPercent[diskItem] += 10;
    SLEEP(2);
    //End Duongvu

    if(this->inputDiskList[diskItem] == CHECKED && this->gDriveState[diskItem] == DRIVE_READY)
    {
        if(strstr(this->gDriveInfo[diskItem].MfrName, STEC_SUBSTR_MODEL_NAME) != NULL)
        {
            this->diskIOModule.special_drive[diskItem] = STEC_DRIVE;
        }

        if(diskItem == 0)
        {
            this->diskIOModule.setPartitionStart(0, 0);
            this->diskIOModule.setPartitionLength(0, gCapacity[0]);

            //Check drive is SED drive and unlock it if need
            if(this->diskIOModule.isSEDdrive(0, this->gDriveInfo[0]) == true)
            {
                if(this->diskIOModule.unlockSED_Full(0) != SUCCESS)
                {
                    this->gDriveState[0] = DRIVE_NO_READY;
                    this->diskIOModule.TurnLedMode(0, LED_ON, LED_RED);
                    return UNSUCCESS;
                }
            }

            errorCode = diskStruct[0].scanDiskStructure();
            if(errorCode == -1)
            {
                this->gDriveState[0] = DEAD_DRIVE;
                this->gLiveTargetList.items--;
                this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, READY, "FAIL");
                return UNSUCCESS;
            }
        }
    }

    this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, READY, "OK");
    if(this->inputDiskList[diskItem] == CHECKED && this->gDriveState[diskItem] == DRIVE_READY)
    {
        this->insertDiskInformationToDatabase(diskItem);
    }
    this->checkStage[diskItem] = READY;
    this->gStartupPercent[diskItem] = 100;
    //End Duongvu
    this->diskIOModule.setPartitionStart(diskItem, 0);
    this->diskIOModule.setPartitionLength(diskItem, gCapacity[diskItem]);
    SLEEP(2);
    this->updateInformationForCheckDiskJob();

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////
//
/*!<
Y nghia cua Function checkOneDiskByStep nhu sau:
Trong qua trinh startupAllDisk, nguoi dung disable a disk thi ta se pause tien trinh check disk cua dia duoc chon, sau do enable again
thi ta se tiep tuc qua trinh checkdisk cua dia duoc chon cho den khi trang thai checkdisk cua dia duoc chon = voi trang
thai checkdisk cua tien trinh startupAllDisk thi ta tiep tuc tiep tuc tien trinh startupAllDisk.
*/
short CSystemD105::checkOneDiskByStep(short diskItem, CHECK_STAGE currentCheckStageOfProcess)
{
    unsigned int n_power_delay = 0;
    int is_Talent_retry = 0;
    int udma_mode, pio_mode;
    short TIME_OUT, time = 0;
    short errorCode = 0 ;
    bool mustRunInPIO = false;
    if(this->finishedCheckStage[diskItem] == currentCheckStageOfProcess)
    {
        return SUCCESS;
    }

    //printDFXLog(PRI_INFO, "Start checking disk");
    this->gStartupPercent[diskItem] = 0;
    this->gAbortFlag = 0;
    this->checkStage[diskItem] = STARTUP;
    this->setInputOfDisk(diskItem, CHECKED);
    this->diskIOModule.setInputOfDisk(diskItem, CHECKED);
    TIME_OUT = this->systemOption.txt_settling_time > 3 ? this->systemOption.txt_settling_time : 3;
    this->clearDriveInfo(diskItem);
    this->gDriveState[diskItem] = START_UP;
    this->dbObj.insertTbErrorMessage(diskItem);
    this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, STARTUP, "OK");
    this->gCopyResult[diskItem] = INCOMPLETE;

    if(this->diskIOModule.usedGen == DT_SATA2)
    {
        if(this->diskIOModule.setGen(DT_SATA1) == SUCCESS)
        {
            this->diskIOModule.curGen = DT_SATA1;
        }
        SLEEP(2);
    }

    printDFXLog(PRI_INFO, "Disk [%u]: %-40s", diskItem, "Turning on...");
    n_power_delay = this->systemOption.txt_power_up_delay > 5 ? 5 : this->systemOption.txt_power_up_delay;

    this->checkStage[diskItem] = TURN_ON;
    this->gDriveState[diskItem] = DRIVE_NO_READY;
    if(this->diskIOModule.powerUp(diskItem) == UNSUCCESS)
    {
        this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, TURN_ON, "FAIL");
        this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
        return UNSUCCESS;
    }

    //Set LED color and check disk ready
    this->diskIOModule.TurnLedMode(diskItem, FAST_BLINK, LED_GREEN);
    this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, TURN_ON, "OK");
    SLEEP(3 + n_power_delay);

    this->gStartupPercent[diskItem] = 30;
    if(this->cancelStartupAllDisk)
    {
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    printDFXLog(PRI_INFO, "Disk [%u]: %-40s", diskItem, "Checking ready status...");

    this->finishedCheckStage[diskItem] = TURN_ON;
    if(currentCheckStageOfProcess == TURN_ON)
    {
        return SUCCESS;
    }

    this->checkStage[diskItem] = CHECK_READY;
    time  = 0;
    do
    {
        time++;
        if(this->cancelStartupAllDisk)
        {
            this->diskIOModule.powerDown(diskItem);
            return UNSUCCESS;
        }

        if(diskIOModule.select_drive(diskItem) == 1)
        {
            this->gStartupPercent[diskItem] += 20;
            this->gDriveState[diskItem] = DRIVE_READY;
            printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Check ready status", MES_OK);
            this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, CHECK_READY, "OK");
            break;
        }
        this->gStartupPercent[diskItem] += 10 / TIME_OUT;
        SLEEP(2);//sleep(2);
    }
    while (time < TIME_OUT);

    if(this->cancelStartupAllDisk)
    {
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    // To ensure the percent is 30%
    // Percent is about 60%. Count the number of ready drives.
    if(this->gStartupPercent[diskItem] < 60 || this->gStartupPercent[diskItem] > 60)
    {
        this->gStartupPercent[diskItem] = 60;
    }

    if(this->cancelStartupAllDisk)
    {
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    this->finishedCheckStage[diskItem] = CHECK_READY;
    if(currentCheckStageOfProcess == CHECK_READY)
    {
        return SUCCESS;
    }

    if(this->gDriveState[diskItem] == DRIVE_READY)
    {
        SLEEP(2);
        printDFXLog(PRI_INFO, "Disk [%u]: %-40s", diskItem, "Getting identify...");
        this->checkStage[diskItem] = GET_IDENTIFY;
        errorCode = this->diskIOModule.getIdentifyDevice(diskItem, this->gDriveInfo[diskItem]);
        if(this->cancelStartupAllDisk)
        {
            this->gDriveState[diskItem] = DRIVE_NO_READY;
            this->diskIOModule.powerDown(diskItem);
            return UNSUCCESS;
        }
        // 10June08 QuynhBui add
        if(errorCode == SUCCESS)
        {
            /*
   * Fixing bug checking disk.
   * When when checking disk Super Talent drive, the Identify of device gotten for the first
   * time is often not valid.
   */
            int retryID= 0;
            while(is_identify_valid(&this->gDriveInfo[diskItem]) == false)
            {
                printDFXLog(PRI_INFO, "Disk[%u]: Identify is not valid...", diskItem);
                printDFXLog(PRI_INFO, "Disk[%u]: Try to get Identify for valid...", diskItem);
                SLEEP(2);
                errorCode = this->diskIOModule.getIdentifyDevice(diskItem, this->gDriveInfo[diskItem]);
                if(this->cancelStartupAllDisk || retryID > 5)
                {
                    this->gDriveState[diskItem] = DRIVE_NO_READY;
                    this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
                    this->diskIOModule.powerDown(diskItem);
                    return UNSUCCESS;
                }

                if(errorCode != 1 || !is_identify_valid(&this->gDriveInfo[diskItem]))
                {
                    printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Get identify device information", MES_FAILED);
                    this->gDriveState[diskItem] = DRIVE_NO_READY;
                }
            }

            if(strstr(this->gDriveInfo[diskItem].MfrName, TALENT_DRIVE_SUBSTR_MODEL_NAME)!=NULL)
            {
                is_Talent_retry = 1;
            }
        }
        else
        {
            this->gDriveState[diskItem] = DRIVE_NO_READY;
        }
    }
    else
    {
        this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
        this->diskIOModule.powerDown(diskItem);
        printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Check ready status", MES_FAILED);
        this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, CHECK_READY, "FAIL");
        return UNSUCCESS;
    }

    if(this->gDriveState[diskItem] == DRIVE_READY)
    {
        this->gStartupPercent[diskItem] += 10;
        if(is_Talent_retry)
        {
            //if disk is supertalen increase time out for reset hard disk
            this->diskIOModule.delay_talent = 100;
        }
        else
        {
            this->diskIOModule.delay_talent = 0;
        }

        this->mNeedToResetBoard = false;
        //////////////////////////////////////////////////////////////////////////
        //HoaHoang add here
        if(this->gDriveInfo[diskItem].SecurityStatus & 0x0001 ) // support security erase mode
        {
            if(this->gDriveInfo[diskItem].SecurityStatus & 0x0002) // if password enable
            {
                //Set disk not ready if job != DISK_SECURITY_ERASE
                if(this->gTarget[diskItem].disk_mode != DISK_SECURITY_ERASE)
                {
                    printDFXLog(PRI_INFO, MES_ERR "Disk [%d] is lock mode (Set password)", diskItem);
                    this->gDriveState[diskItem] = DEAD_DRIVE;
                    this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
                    this->diskIOModule.powerDown(diskItem);
                    return UNSUCCESS;
                }

            }
        }
        errorCode = this->startupIdentifyDevice(diskItem, 0);

        if(errorCode != 1)
        {
            this->gDriveState[diskItem] = DEAD_DRIVE;
            this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
            this->diskIOModule.powerDown(diskItem);
            printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Get identify device information", MES_FAILED);
            return SUCCESS;
        }
        else
        {
            udma_mode = this->get_udma_mode(this->gDriveInfo[diskItem].Flags53, this->gDriveInfo[diskItem].UltraDmaMode);
            if(udma_mode > -1)
            {
                printDFXLog(PRI_INFO, "%-40s %u", ".Support UDMA mode", udma_mode);
                if(this->mMinUDMAMode == -1) // this->mMinUDMAMode is not set yet
                {
                    this->mMinUDMAMode = udma_mode;
                }
                else
                {
                    if(udma_mode < this->mMinUDMAMode)
                    {
                        this->mMinUDMAMode = udma_mode;
                    }
                }
            }
            else
            {
                printDFXLog(PRI_INFO, "%-40s", ".Not support UDMA mode");
                mustRunInPIO = true;
            }

            pio_mode = get_pio_mode(this->gDriveInfo[diskItem].Flags53, this->gDriveInfo[diskItem].PIOmodes);
            if(pio_mode > -1)
            {
                printDFXLog(PRI_INFO, "%-40s %u", ".Support PIO mode", pio_mode);
                if(this->mMinPIOMode == -1) // this->mMinPIOMode is not set yet
                    this->mMinPIOMode = pio_mode;
                else
                {
                    if(this->mMinPIOMode > pio_mode)
                    {
                        this->mMinPIOMode = pio_mode;
                    }
                }
            }
            else
            {
                printDFXLog(PRI_INFO, "%-40s", ".Not support PIO mode");
            }

            this->gDriveType[diskItem] = this->getDriveType(this->gDriveInfo[diskItem]);
            this->diskIOModule.gDriveType[diskItem] = this->gDriveType[diskItem];
            if(this->gDriveType[diskItem] != DT_PATA)
            {
                if(this->gDriveType[diskItem] == DT_SATA)
                {
                    printDFXLog(PRI_INFO, "%-40s SATA", ".Drive Type");
                }
                else
                {
                    printDFXLog(PRI_INFO, "%-40s SATA%d", ".Drive Type", gDriveType[diskItem]);
                }
            }
            else
            {
                printDFXLog(PRI_INFO, "%-40s PATA", ".Drive Type");
            }
            if((this->diskIOModule.transfer_mode <= (UDMA_MODE_MAX - 0x40)) && (this->diskIOModule.transfer_mode >= (UDMA_MODE_MIN - 0x40)) && mustRunInPIO == false)
            {
                //printDFXLog(PRI_INFO,"Checking the disk for UDMA mode...");
                if(udma_mode > -1)
                {
                    if(this->mMinUDMAMode < this->mUDMAMode)
                    {
                        printDFXLog(PRI_INFO, "UDMA mode %d is recommended", this->mMinUDMAMode);
                        this->mUDMAMode = min(this->mUDMAMode, this->mMinUDMAMode);
                        if(is_Talent_retry && (this->mUDMAMode >= 3))
                        {
                            // kiem tra size cua dia~ ssd
                            unsigned long cap = 0;
                            unsigned long wtmp = this->gDriveInfo[0].MaxUserLbaAddr1_48Bit;
                            wtmp <<= 16;
                            wtmp |= this->gDriveInfo[0].MaxUserLbaAddr0_48Bit;
                            cap = ((this->gDriveInfo[0].CommandSetsSupported & 0x0400) == 0x0400) ? wtmp : this->gDriveInfo[0].LBAuserSectors;
                            // printDFXLog(PRI_INFO,"cap = %lu\n",cap);
                            printDFXLog(PRI_INFO, "is_Talent_retry = 1 && cap = %lld",cap);
                            if(cap > 250000000L) // disk size > 128GB
                                this->mUDMAMode = 3;
                            else
                                this->mUDMAMode = 2;
                        }
                        this->diskIOModule.setTransferMode(this->mUDMAMode);
                        this->diskIOModule.setCurrentTransferMode();
                    }
                }
            }
            else
            {
                //printDFXLog(PRI_INFO,"Checking the disk for PIO mode...");
                if(pio_mode > -1)
                {
                    if(this->mMinPIOMode < this->mPIOMode)
                    {
                        printDFXLog(PRI_INFO, "PIO %d is recommended", pio_mode);
                        this->mPIOMode = min(this->mPIOMode, this->mMinPIOMode);
                        this->diskIOModule.setTransferMode(this->mPIOMode + 7);
                        this->diskIOModule.setCurrentTransferMode();
                    }
                }
            }
            this->gStartupPercent[diskItem] += 10;
            this->gLiveTargetList.items++;
            printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Get identify device information", MES_OK);
            this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, GET_IDENTIFY, "OK");
            if((this->diskIOModule.transfer_mode <= (UDMA_MODE_MAX - 0x40)) && (this->diskIOModule.transfer_mode >= (UDMA_MODE_MIN - 0x40)) && mustRunInPIO == false)
            {
                //printDFXLog(PRI_INFO,"Checking the disk for UDMA mode...");
                if(udma_mode > -1)
                {
                    if(this->mMinUDMAMode < this->mUDMAMode)
                    {
                        printDFXLog(PRI_INFO, "UDMA mode %d is recommended", this->mMinUDMAMode);
                        this->mUDMAMode = min(this->mUDMAMode, this->mMinUDMAMode);
                        if(is_Talent_retry && (this->mUDMAMode >= 3))
                        {
                            // kiem tra size cua dia~ ssd
                            unsigned long cap = 0;
                            unsigned long wtmp = this->gDriveInfo[0].MaxUserLbaAddr1_48Bit;
                            wtmp <<= 16;
                            wtmp |= this->gDriveInfo[0].MaxUserLbaAddr0_48Bit;
                            cap = ((this->gDriveInfo[0].CommandSetsSupported & 0x0400) == 0x0400) ? wtmp : this->gDriveInfo[0].LBAuserSectors;
                            // printDFXLog(PRI_INFO,"cap = %lu\n",cap);
                            printDFXLog(PRI_INFO, "is_Talent_retry = 1 && cap = %lld",cap);
                            if(cap > 250000000L) // disk size > 128GB
                                this->mUDMAMode = 3;
                            else
                                this->mUDMAMode = 2;
                        }
                        this->diskIOModule.setTransferMode(this->mUDMAMode);
                        this->diskIOModule.setCurrentTransferMode();
                    }
                }
            }
            else
            {
                //printDFXLog(PRI_INFO,"Checking the disk for PIO mode...");
                if(pio_mode > -1)
                {
                    if(this->mMinPIOMode < this->mPIOMode)
                    {
                        printDFXLog(PRI_INFO, "PIO %d is recommended", pio_mode);
                        this->mPIOMode = min(this->mPIOMode, this->mMinPIOMode);
                        this->diskIOModule.setTransferMode(this->mPIOMode + 7);
                        this->diskIOModule.setCurrentTransferMode();
                    }
                }
            }
        }
    }
    else
    {
        this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
        this->diskIOModule.powerDown(diskItem);
        printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", diskItem, "Get identify device information", MES_FAILED);
        this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, GET_IDENTIFY, "FAIL");
        return UNSUCCESS;
    }

    this->finishedCheckStage[diskItem] = GET_IDENTIFY;
    if(currentCheckStageOfProcess == GET_IDENTIFY)
    {
        return SUCCESS;
    }

    if(this->cancelStartupAllDisk)
    {
        this->gDriveState[diskItem] = DRIVE_NO_READY;
        this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    // Scan disk reached to 95%
    if(this->gStartupPercent[diskItem] < 80 || this->gStartupPercent[diskItem] < 80)
    {
        this->gStartupPercent[diskItem] = 80;
    }

    if(this->cancelStartupAllDisk)
    {
        this->gDriveState[diskItem] = DRIVE_NO_READY;
        this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    short usedGen = NO_GEN;
    if(this->inputDiskList[diskItem] == CHECKED && this->gDriveState[diskItem] == DRIVE_READY)
    {
        usedGen = this->diskIOModule.getGenOfDisk(diskItem);
    }

    if(this->cancelStartupAllDisk)
    {
        this->gDriveState[diskItem] = DRIVE_NO_READY;
        this->diskIOModule.TurnLedMode(diskItem, LED_ON, LED_RED);
        this->diskIOModule.powerDown(diskItem);
        return UNSUCCESS;
    }

    //Check drive if this is DB32 drive.
    if(strstr(this->gDriveInfo[diskItem].MfrName, DB32_SUBSTR_MODEL_NAME) != NULL)
    {
        this->diskIOModule.special_drive[diskItem] = DB32_DRIVE;
    }

    if(this->diskIOModule.usedGen != DT_SATA1)
    {
        if((usedGen == NO_GEN) && (this->diskIOModule.special_drive[diskItem] != DB32_DRIVE))
        {
            if(this->diskIOModule.setGen(this->diskIOModule.usedGen) == UNSUCCESS)
            {
                return UNSUCCESS;
            }
        }
        else if(usedGen == DT_SATA1)
        {
            this->diskIOModule.usedGen = usedGen;
            this->diskIOModule.curGen = usedGen;
        }
        else if(usedGen < this->diskIOModule.usedGen)
        {
            if(this->diskIOModule.setGen(usedGen) == UNSUCCESS)
            {
                return UNSUCCESS;
            }
            this->diskIOModule.usedGen = usedGen;
            this->diskIOModule.curGen = usedGen;
        }
    }

    if(this->gDriveType[diskItem] != DT_SATA1 && this->gDriveType[diskItem] != DT_SATA2 && this->gDriveType[diskItem] != DT_SATA3){
        this->isSATAMode = false;
    }

    this->gStartupPercent[diskItem] += 10;
    SLEEP(2);
    //End Duongvu

    if(this->inputDiskList[diskItem] == CHECKED && this->gDriveState[diskItem] == DRIVE_READY)
    {
        if(strstr(this->gDriveInfo[diskItem].MfrName, STEC_SUBSTR_MODEL_NAME) != NULL)
        {
            this->diskIOModule.special_drive[diskItem] = STEC_DRIVE;
        }

        if(diskItem == 0)
        {
            this->diskIOModule.setPartitionStart(0, 0);
            this->diskIOModule.setPartitionLength(0, gCapacity[0]);

            //Check drive is SED drive and unlock it if need
            if(this->diskIOModule.isSEDdrive(0, this->gDriveInfo[0]) == true)
            {
                if(this->diskIOModule.unlockSED_Full(0) != SUCCESS)
                {
                    this->gDriveState[0] = DRIVE_NO_READY;
                    this->diskIOModule.TurnLedMode(0, LED_ON, LED_RED);
                    return UNSUCCESS;
                }
            }

            errorCode = this->diskStruct[0].scanDiskStructure();
            if(errorCode == -1)
            {
                this->gDriveState[0] = DEAD_DRIVE;
                this->gLiveTargetList.items--;
                this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, READY, "FAIL");
                return UNSUCCESS;
            }
        }
    }

    this->insertCheckDiskStageToCheckDiskDetailTable(this->curJobId, diskItem, CHECK_READY, "OK");
    this->checkStage[diskItem] = READY;
    this->gStartupPercent[diskItem] = 100;
    this->diskIOModule.setPartitionStart(diskItem, 0);
    this->diskIOModule.setPartitionLength(diskItem, this->gCapacity[diskItem]);
    this->finishedCheckStage[diskItem] = READY;
    SLEEP(2);
    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::checkSourceDisk()
{
    short TIME_OUT = 0, time = 0;
    // cho it nhat kiem tra 3 lan de chac chan dia source da ready
    TIME_OUT = systemOption.txt_settling_time > 3 ? systemOption.txt_settling_time : 3;
    //Check PATA

    while (!this->cancelStartupAllDisk && this->inputDiskList[0] == CHECKED)
    {
        if(diskIOModule.select_drive(0) == 1)
        {
            this->gStartupPercent[0] += 15;
            return SUCCESS;// source disk is ready
        }
        else
        {
            time++;

            //Hard reset
            this->diskIOModule.powerDown(0);
            SLEEP(1);
            this->diskIOModule.powerUp(0);
            this->gStartupPercent[0] += 8 / TIME_OUT;
            SLEEP(1);//sleep(1);
        }
        if(time > TIME_OUT)
        {
            break;
        }
    }
    if(this->cancelStartupAllDisk)
    {
        return -1;
    }

    printDFXLog(PRI_INFO, "No source found.");
    if(this->cancelStartupAllDisk)
    {
        return -1;
    }
    if(this->user_option == 1 || this->inputDiskList[0] == UNCHECKED) // dang o mode user defined job, k co source van tiep tuc thuc hien binh thuing
    {
        return 2;
    }
    // Dia source ko ready, kiem tra neu o mode SMART hay MIRROR thi thoat
    for(int disk = 1; disk < MAX_DISKS; disk++)
    {
        if(this->gTarget[disk].disk_mode == DISK_SMART || this->gTarget[disk].disk_mode == DISK_MIRROR)
        {
            return 0;
        }
    }
    return 2;// source disk k ready nhung van tiep tuc thuc hien check disk de dung cho cac tac vu: test dia,xoa dia,...
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::checkTargetDisks(int tmp_disks[])
{
    short TIME_OUT = 0, time = 0;
    short disk = 0;
    short diskCount = 0;
    TIME_OUT = this->systemOption.txt_settling_time > 3 ? this->systemOption.txt_settling_time : 3;
    // scan all disks
    for(disk = 0; disk < MAX_DISKS; disk++)
    {
        if(this->inputDiskList[disk] == CHECKED)
        {
            if(this->finishedCheckStage[disk] < TURN_ON)
            {
                this->checkOneDiskByStep(disk, TURN_ON);
            }
            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
    }

    disk = 0;
    do
    {
        time = 0;
        if(this->inputDiskList[disk] == CHECKED)
        {
            printDFXLog(PRI_INFO, "Disk [%u]: %-40s", disk, "Checking ready status...");

            if(this->finishedCheckStage[disk] < TURN_ON)
            {
                this->checkOneDiskByStep(disk, TURN_ON);
            }

            this->checkStage[disk] = CHECK_READY;
            while (!this->cancelStartupAllDisk && disk < MAX_DISKS)
            {
                if(diskIOModule.select_drive(disk) == 1)
                {
                    this->gStartupPercent[disk] += 15;
                    tmp_disks[disk] = 1;
                    printDFXLog(PRI_INFO, "Disk [%u]: %-40s %s", disk, "Check ready status", MES_OK);
                    diskCount++; // Count the number of ready drives
                    this->finishedCheckStage[disk] = CHECK_READY;
                    break;
                }
                else
                {
                    time++;
                    this->gStartupPercent[disk] += 8 / TIME_OUT;
                    SLEEP(1);//sleep(1);
                }

                if(time > TIME_OUT)
                {
                    this->finishedCheckStage[disk] = CHECK_READY;
                    break;
                }
            }// while
            isCheckdisk[disk] = true;
        }
        else if(isCheckdisk[disk] == true)
        {
            this->turnOffOneDiskWhenCheckDisk(disk);
        }
        disk++;
    }
    while (!this->cancelStartupAllDisk && disk < MAX_DISKS);

    if(this->cancelStartupAllDisk)
    {
        return -1; // truong hop cancel
    }
    return diskCount;
}

/////////////////////////////////////////////////////////////////////////
// 14Sep2011 TamHo add this function
void CSystemD105::turnOffOneDiskWhenCheckDisk(int disk)
{
    this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
    SLEEP(1);
    diskIOModule.powerDown(disk);
    this->gDriveState[disk] = DISABLED;
    this->inputDiskList[disk] = UNCHECKED;
    this->diskIOModule.setInputOfDisk(disk, UNCHECKED);
    this->finishedCheckStage[disk] = NONE;
    isCheckdisk[disk] = false;
}
/////////////////////////////////////////////////////////////////////////
//
/*!<
Function : startupProcessStartup()
Description : Processes drive startup sequence in discrete steps,
 gDriveState[d] is used to keep track of process stage.
Input : disk number
Output : none
Return : none
*/
short CSystemD105::startupProcessStartup(short d)
{
    short errorCode = SUCCESS;
    return SUCCESS;

    switch (gDriveState[d])
    {

    case DEAD_DRIVE:
        errorCode = UNSUCCESS;
        break;

    case DISABLED:
        errorCode = SUCCESS;
        break;

    case DRIVE_READY:
        break;

    case START_UP:
        // Doing nothing until power-up time

        if (d && (gTarget[d].enable == 0))
        {
            errorCode = SUCCESS;
            gDriveState[d] = DISABLED;
        }
        else
        {
            errorCode = diskIOModule.powerUp(d); // Switch on drive power

            if (errorCode != 1)
            {
                gDriveState[d] = DEAD_DRIVE;
                errorCode = UNSUCCESS;
                break;
            }

            gDriveState[d] = QUERY;
        }
        break;

    case DRIVE_DIAGNOSTIC:
        // Run drive diagnostic
        errorCode = diskIOModule.diagnostic(d);

        if (errorCode != 1)
        {
            // diskIOModule.powerDown(d);
            gDriveState[d] = DEAD_DRIVE;
            errorCode = UNSUCCESS;
            break;
        }

        gDriveState[d] = QUERY;
        break;

    case QUERY:
        // Read drive information
        errorCode = startupIdentifyDevice(d);

        if (errorCode != 1)
        {
            // diskIOModule.powerDown(d);
            gDriveState[d] = DEAD_DRIVE;
            errorCode = UNSUCCESS;
            break;
        }

        if (d == 0)
            diskStruct[0].scanDiskStructure();

        gDriveState[d] = DRIVE_READY;

        errorCode = SUCCESS;
        break;

        // --- Read Master Boot Record on Source drive

    case MBR_READ:
        errorCode = readBootStructure(0);

        if (errorCode != 1)
        {
            errorCode = UNSUCCESS;
            // diskIOModule.powerDown(0);
            gDriveState[d] = DEAD_DRIVE;
            break;
        }

        gDriveState[0] = DRIVE_READY;
        break;

    default:
        break;
    }

    return errorCode;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function: statupAndCheckDisk()
Description: use to startup all Disk on the Board and get
information of them
*/
short CSystemD105::startupAndCheckDisk()
{
    cancelStartupAllDisk = 0;
    return startupAllDisk();
}
//////////////////////////////////////////////////////////////////////////
//
int CSystemD105::getOperationSystemPartition(unsigned long start_sector)
{
    for(int idx=0; idx <diskStruct[0].partition_list.number_of_partitions; idx++)
    {
        if(diskStruct[0].partition_list.partition[idx].start_sector == start_sector)
        {
            return idx;
        }
    }
    return -1;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : getRandomByte
Description : get a random byte value
Input : none
Output : none
Return : a random byte value
*/
unsigned char CSystemD105::getRandomByte()
{
    int value;
    time_t *t;
    t = new time_t;
    time(t);
    srand((unsigned int)*t);
    value = rand();
    delete t;
    t = NULL;
    return (unsigned char)value % 256;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : getReversedByte
Description : get a byte value by reversing all bits of a value byte
Input : byteValue is a byte value to reverse bits from
Output : none
Return : reversed byte value
*/
unsigned char CSystemD105::getReversedByte(unsigned char byteValue)
{
    return (0x00FF ^ byteValue);
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : getMaxLBAAddress
Description : get Maximum of LBA address of a disk from CHS address
Input : d is disk number
 C is Cylinder address
 H is Head address
 S is Sector address
Output : none
Return : LBA address that relative with CHS address
*/
unsigned long CSystemD105::getMaxLBAAddress(short d)
{
    return gNativeMaxAddress[d];
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : getLBAAddress
Description : get LBA address of a disk from CHS address
Input : d is disk number
 C is Cylinder address
 H is Head address
 S is Sector address
Output : none
Return : LBA address that relative with CHS address
*/
unsigned long CSystemD105::getLBAAddress(short d, unsigned long C, unsigned short H, unsigned short S)
{
    unsigned long LBAsector;
    LBAsector = (((C * gDriveInfo[d].NumCurrHeads) + H) * gDriveInfo[d].NumCurrSectors) + S - 1;
    // printf("LBAsector:%d",LBAsector);
    return LBAsector;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : getCHSAddress
Description : get CHS address of a disk from LBA address
Input : d is disk number
 LBAAddress is LBA address
Output : C is Cylinder address
 H is Head address
 S is Sector address
Return : 1 if success or 0 if error in geometry of disk.
*/
short CSystemD105::getCHSAddress(short d, unsigned long LBAAddress, unsigned long &C, unsigned short &H, unsigned short &S)
{
    unsigned long x, y;

    if ((gDriveInfo[d].NumCurrHeads == 0) || (gDriveInfo[d].NumCurrSectors == 0))
    {
        return 0;
    }

    y = (unsigned long) gDriveInfo[d].NumCurrHeads * (unsigned long) gDriveInfo[d].NumCurrSectors;
    C = LBAAddress / y;
    x = LBAAddress - (C * y);
    H = (unsigned short)((x / gDriveInfo[d].NumCurrSectors) & 0x0F);
    S = (unsigned short)(((x - (H * gDriveInfo[d].NumCurrSectors)) + 1) & 0xFF);
    return 1;
}
//////////////////////////////////////////////////////////////////////////
//
unsigned long CSystemD105::get_real_part_start_sector(int d, int part_entry_id, PARTITION_ENTRY_LIST *part_entry_list)
{
    int part_struct_id = PARTITION_ENTRY_LIST_ID_to_PARTITION_STRUCT_ID(part_entry_id, part_entry_list);

    if (part_struct_id == -1)
    {
        return 0;
    }

    return diskStruct[d].partition_list.partition[part_struct_id].start_sector;
}
//////////////////////////////////////////////////////////////////////////
//
int CSystemD105::getInternalSerialNumber(unsigned short *hardwareSN, char *lowHex, char *highHex)
{
    int get_HW_result = 0;
    SecurityOperation* gSecurity = new SecurityOperation();
    if (!gSecurity)
    {
        printDFXLog(PRI_INFO, "getInternalSerialNumber->Cannot create object SecurityOperation.");
    }
    else
    {
        get_HW_result = gSecurity->getHardwareSN(hardwareSN);
        memcpy(lowHex, gSecurity->HDDLowHex, 9);
        memcpy(highHex, gSecurity->HDDHighHex, 9);
        delete(gSecurity);
        gSecurity = NULL;
    }
    return get_HW_result;
}
//////////////////////////////////////////////////////////////////////////
//
QString CSystemD105::getFirmwareAndInternalSerialNumber()
{
    char pFwVersion[10], pFwVersionHex[10], lowHex[9], highHex[9];
    unsigned short hardwareSN = 0;
    char buf_1[256];
    QString ret;

    memset(&pFwVersion, 0, 10);
    this->diskIOModule.major_minortoa(pFwVersion, pFwVersionHex);
    this->getInternalSerialNumber(&hardwareSN, lowHex, highHex);

    snprintf(buf_1, sizeof(buf_1), ": %s (%s), %u (0x%s-0x%s)", pFwVersion, pFwVersionHex, hardwareSN, highHex, lowHex);
    ret = QString((const char *)buf_1);
    return ret;
}
//////////////////////////////////////////////////////////////////////////
//
DRIVE_TYPE CSystemD105::getDriveType(ID_DEVICE_INFOR driveInfo)
{
    DRIVE_TYPE driveType = DT_PATA;
    unsigned short word = driveInfo.Reserved76[0];
    if(word & (1<<3))
    {
        driveType = DT_SATA3;//SATA 3
    }
    else if(word & (1<<2))
    {
        driveType = DT_SATA2;//SATA 2
    }
    else if(word & (1<<1))
    {
        if((word & (1<<10)) || (word & (1<<9)))
        {
            driveType = DT_SATA1;//SATA -1
        }
        else
        {
            driveType = DT_PATA;//PATA
        }
    }
    else
    {
        driveType = DT_SATA;
    }
    return driveType;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setresult()
{
    this->resultE = 3;
    this->resultS = 3;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setInputOfDisk(short d, unsigned short status)
{
    this->inputDiskList[d] = status;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setJobStructure(short d, JOB_STRUCT jobStr)
{
    this->gTarget[d] = jobStr;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setupStandardJob(DISK_MODE job)
{
    short i;

    switch (job)
    {

    case DISK_SMART:
        break;

    case DISK_MIRROR:
        for (i = 1;i < MAX_DISKS;i++)
        {
            gTarget[i].enable = 1;
            gTarget[i].disk_mode = DISK_MIRROR;
        }
        break;

    case DISK_TEST:
        break;

    case DISK_SANITIZE:
        break;

    default:
        break;
    }
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setVerifyForCurrentCopyJob(bool verifyFlag)
{
    this->isVerifyCurrentJob = verifyFlag;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function    : setMaxAddressForDisk()
Input       : none
Output      : none
Author      : TamHo
 */
short CSystemD105::setMaxAddressForDisk(short disk, unsigned long max_address)
{
    unsigned long nativeMaxAdd = 0;

    //Ket thuc copy thanh cong moi tien hanh hard reset
    if(this->resultE != 3)
    {
        this->diskIOModule.hardReset(disk);
    }

    if (((gLargeDrive[disk] &  SUPPORT_48) == SUPPORT_48))
    {
        //Phai get NativeMaxAdd truoc khi set moi co the set xuong duoc (phai theo protocol cua dia)
        this->diskIOModule.getNativeMaxAddress_Ext(disk, nativeMaxAdd);
        if(this->diskIOModule.setMaxAddress_None_Volatile_Ext(disk, max_address) == UNSUCCESS)
        {
            return UNSUCCESS;
        }
    }
    else
    {
        //Phai get NativeMaxAdd truoc khi set moi co the set xuong duoc (phai theo protocol cua dia)
        this->diskIOModule.getNativeMaxAddress(disk, nativeMaxAdd);
        if(this->diskIOModule.setMaxAddress_None_Volatile(disk, max_address) == UNSUCCESS)
        {
            return UNSUCCESS;
        }
    }

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function    : setFullCapacityAllDisk()
Input       : none
Output      : none
Author      : TamHo
 */
void CSystemD105::setFullCapacityAllDisk()
{
    for(short disk = 0; disk < MAX_DISKS; disk++)
    {
        if ((gDriveState[disk] == DRIVE_READY) && (gTarget[disk].enable == 1))
        {
            //Note : Capacity tinh tu 1; NativeMaxAddress tinh tu 0
            if (securityOperation->checkFeatureUnlocked(FEATURE_HPA) != 1) //HPA option in Smart option is unlock.
            {
                if(disk != 0) //Taget disk
                {
                    if(this->gHPAFeatureSupported[disk] == 1) //Target disk has support HPA.
                    {
                        if(this->setFullCapacityOfDisk(disk) == SUCCESS)//Set full capacity of target disk.
                        {
                            if(gHPAFeatureSupported[0] == 1)//Source disk is support HPA.
                            {
                                printDFXLog (PRI_INFO, "%-40s", INF_SUP_HPA_MSG);
                                this->gCapacity[disk]       = this->gNativeMaxAddress[disk] + 1 - this->gHPACapacity[0];
                                this->gHPACapacity[disk]    = this->gHPACapacity[0];
                            }
                            else //Source disk isn't support HPA.
                            {
                                this->gCapacity[disk]       = this->gNativeMaxAddress[disk] + 1;
                                this->gHPACapacity[disk]    = 0;
                            }
                        }
                        else //Cannot set full capacity of target disk
                        {
                            this->gHPACapacity[disk]    = 0;
                        }
                    }
                    else //Target disk isn't support HPA.
                    {
                        this->gHPACapacity[disk] = 0;
                    }
                }
                else //Source disk
                {
                    if (gHPAFeatureSupported[disk] == 1) //Source disk is support HPA.
                    {
                        if (gNativeMaxAddress[disk] != (gCapacity[disk] - 1)) // Disk has HPA area
                        {
                            this->gHPACapacity[disk] = this->gNativeMaxAddress[disk] + 1 - this->gCapacity[disk];
                        }
                        else
                        {
                            this->gHPACapacity[disk] = 0;
                        }
                    }
                    else //Source disk isn't support HPA.
                    {
                        this->gHPACapacity[disk] = 0;
                    }

                    if(this->setFullCapacityOfDisk(0) == SUCCESS) //Set full disk for source
                    {
                        this->gCapacity[disk] = this->gNativeMaxAddress[disk] + 1;
                    }
                    else
                    {
                        this->gHPACapacity[disk]    = 0;
                    }
                }
            }
            else //HPA option in Smart option is lock.
            {
                if(disk != 0) //Target disk
                {
                    if(this->setFullCapacityOfDisk(disk) == SUCCESS)//Set full capacity of target disk.
                    {
                        this->gCapacity[disk] = this->gNativeMaxAddress[disk] + 1;
                    }
                    this->gHPACapacity[disk] = 0;
                }
                else //Source disk
                {
                    if (gHPAFeatureSupported[disk] == 1)
                    {
                        this->gHPACapacity[disk] = this->gNativeMaxAddress[disk] + 1 - this->gCapacity[disk];
                        this->gCapacity[disk] = gNativeMaxAddress[disk] + 1 - this->gHPACapacity[disk];
                    }
                    else
                    {
                        this->gHPACapacity[0] = 0;
                        this->gCapacity[disk] = gNativeMaxAddress[disk] + 1;
                    }
                }
            }
        }
    }
    //SLEEP(10);
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function    : setFullCapacityOfDisk()
Input       : none
Output      : none
Author      : TamHo
 */
short CSystemD105::setFullCapacityOfDisk(short disk)
{
    short result = SUCCESS;

    bool isNeedSetAgain = false;
    if (gNativeMaxAddress[disk] > 0 && (gNativeMaxAddress[disk] != (gCapacity[disk] - 1) ||
                                        (strstr(this->gDriveInfo[disk].MfrName, "SSD") != NULL))) //Disk has HPA area
    {
        isNeedSetAgain = true;
    }

    unsigned long temp_addr = (gNativeMaxAddress[disk] > (gCapacity[disk] -1)) ? gNativeMaxAddress[disk]: (gCapacity[disk] -1);
    if (isNeedSetAgain == true)
    {
        if(this->setMaxAddressForDisk(disk, temp_addr) == SUCCESS)
        {
            //gNativeMaxAddress[disk] = temp_addr;
            this->gCapacityOrigin[disk] = temp_addr + 1;
            printDFXLog(PRI_INFO, "Disk [%d]: %-30s %lu %s", disk, "Set full capacity ", temp_addr, MES_OK);
        }
        else
        {
            //gNativeMaxAddress[disk] = gCapacity[disk] - 1;
            this->gCapacityOrigin[disk] = temp_addr + 1;
            printDFXLog(PRI_INFO, "Disk [%d]: %-30s %lu %s", disk, "Set full capacity", temp_addr, MES_FAILED);
            result = UNSUCCESS;
        }
    }

    return result;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function    : setHPAForFinishedJob()
Input       : none
Output      : none
Author      : TamHo
 */
void CSystemD105::setHPAForFinishedJob()
{
    if (securityOperation->checkFeatureUnlocked(FEATURE_HPA) != 1) //HPA option in Smart option is unlock.
    {
        for(short disk = 0; disk < MAX_DISKS; disk++)
        {
            if(disk == 0) //Set Capacity for source
            {
                if(gDriveState[disk] == DRIVE_READY)
                {
                    if((this->gHPAFeatureSupported[disk] == 1) && (this->gHPACapacity[disk] != 0))
                    {
                        int cout = 0;
                        while(cout < 5)
                        {
                            if(this->setMaxAddressForDisk(disk, this->gNativeMaxAddress[disk] - this->gHPACapacity[disk]) == UNSUCCESS)
                            {
                                printDFXLog(PRI_INFO, "Disk [%d]: %-31s %lu %s", disk, "Set original max address ",  this->gNativeMaxAddress[disk] - this->gHPACapacity[disk], MES_FAILED);
                                cout++;
                                this->diskIOModule.hardReset(disk);
                            }
                            else
                            {
                                printDFXLog(PRI_INFO, "Disk [%d]: %-31s %lu %s", disk, "Set original max address",  this->gNativeMaxAddress[disk] - this->gHPACapacity[disk], MES_OK);
                                break;
                            }
                        }
                    }
                }
            }
            else //Set Capacity for targets
            {
                if(this->gTarget[disk].disk_mode == DISK_MIRROR) //Job copy is MIRROR-COPY
                {
                    if ((gDriveState[disk] == DRIVE_READY) && (gTarget[disk].enable == 1) && ((this->gCopyResult[disk] == GOOD_COPY) || (this->isVerified == true)) &&
                            (this->gHPAFeatureSupported[disk] == 1) && (this->gHPAFeatureSupported[0] == 1) && (this->gHPACapacity[disk] != 0))
                    {
                        if(this->gNativeMaxAddress[disk] >= this->gNativeMaxAddress[0])
                        {
                            unsigned long tempMaxAdd = 0;
                            tempMaxAdd = this->gNativeMaxAddress[disk] - this->gHPACapacity[disk];
                            if(this->gNativeMaxAddress[disk] < this->gHPACapacity[disk]) //Truong hop loi set max add fail -> khi set lai thi bi tran so
                            {
                                //fprintf(stderr, "\n TamHo here ################## %lu #############", this->gNativeMaxAddress[disk]);
                                if (((gLargeDrive[disk] &  SUPPORT_48) == SUPPORT_48))
                                {
                                    this->diskIOModule.getNativeMaxAddress_Ext(disk, tempMaxAdd);
                                }
                                else
                                {
                                    this->diskIOModule.getNativeMaxAddress(disk, tempMaxAdd);
                                }

                                tempMaxAdd = this->gNativeMaxAddress[disk] - this->gHPACapacity[disk];
                            }

                            if(this->setMaxAddressForDisk(disk, tempMaxAdd) == UNSUCCESS)
                            {
                                printDFXLog(PRI_INFO, "Disk [%d]: %-30s %lu %s", disk, "Set max address ", this->gNativeMaxAddress[disk] - this->gHPACapacity[disk], MES_FAILED);
                            }
                            else
                            {
                                printDFXLog(PRI_INFO, "Disk [%d]: %-30s %lu %s", disk, "Set max address ", this->gNativeMaxAddress[disk] - this->gHPACapacity[disk], MES_OK);
                            }
                        }
                    }
                }
                else if(this->gTarget[disk].disk_mode == DISK_SMART) //Job copy is SMART-COPY
                {
                    if ((gDriveState[disk] == DRIVE_READY) && (gTarget[disk].enable == 1) && ((this->gCopyResult[disk] == GOOD_COPY) || (this->isVerified == true)) &&
                            (this->gHPAFeatureSupported[disk] == 1) && (this->gHPAFeatureSupported[0] == 1) && (this->gHPACapacity[disk] != 0))
                    {
                        unsigned long tempMaxAdd = 0;
                        tempMaxAdd = this->gNativeMaxAddress[disk] - this->gHPACapacity[disk];
                        if(this->gNativeMaxAddress[disk] < this->gHPACapacity[disk]) //Truong hop loi set max add fail -> khi set lai thi bi tran so
                        {
                            //fprintf(stderr, "\n TamHo here ################## %lu #############", this->gNativeMaxAddress[disk]);
                            if (((gLargeDrive[disk] &  SUPPORT_48) == SUPPORT_48))
                            {
                                this->diskIOModule.getNativeMaxAddress_Ext(disk, tempMaxAdd);
                            }
                            else
                            {
                                this->diskIOModule.getNativeMaxAddress(disk, tempMaxAdd);
                            }

                            tempMaxAdd = this->gNativeMaxAddress[disk] - this->gHPACapacity[disk];
                        }

                        if(this->setMaxAddressForDisk(disk, tempMaxAdd) == UNSUCCESS)
                        {
                            printDFXLog(PRI_INFO, "Disk [%d]: %-30s %lu %s", disk, "Set max address ", this->gNativeMaxAddress[disk] - this->gHPACapacity[disk], MES_FAILED);
                        }
                        else
                        {
                            printDFXLog(PRI_INFO, "Disk [%d]: %-30s %lu %s", disk, "Set max address ", this->gNativeMaxAddress[disk] - this->gHPACapacity[disk], MES_OK);
                        }
                    }
                }
            }
        }
    }
    else
    {
        printDFXLog (PRI_INFO,"Feature HPA Copy is locked");
    }
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
Function : setInitAfterCopy()
Description : Set lai vung HPA cho dia source va khoi tao lai gia tri cac bien
Input :
Output:
*/
void CSystemD105::setInitAfterCopy()
{
    printDFXLog (PRI_INFO,"setInitAfterCopy");
    this->setHPAForFinishedJob();

    this->actionMode = DUPLICATING_MODE;
    this->diskIOModule.setCopyMode();
    this->diskIOModule.clearVerifyMapSector();
    this->systemOption.percentReadBackVerify = 0;

    if(this->systemOption.verify_Mode == 1)
    {
        this->isVerifyCurrentJob = true;
    }
    else
    {
        this->isVerifyCurrentJob = false;
    }
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setCHSToPartitionsOfTargetDisk(PARTITION_ENTRY_LIST &tg_part_list, unsigned short sec_per_track, unsigned short head_per_cyl)
{
    short i, j;
    unsigned long based_logical_start = 0,
            start_sector_logical = 0,
            LBA, LBA2;
    unsigned char bysector, bycylinder, byhead;

    for (i = 0; i < 4; i++)
    {
        if (tg_part_list.entry_not_empty[i])
        {
            LBA = tg_part_list.part_entry[i].start_sector;
            get_CHS(LBA, bysector, bycylinder, byhead, sec_per_track, head_per_cyl, 1);
            tg_part_list.part_entry[i].begin_sector_number = bysector;
            tg_part_list.part_entry[i].begin_cylinder_number = bycylinder;
            tg_part_list.part_entry[i].begin_head_number = byhead;
            LBA2 = LBA + tg_part_list.part_entry[i].number_of_sectors - 1;
            get_CHS(LBA2, bysector, bycylinder, byhead, sec_per_track, head_per_cyl, 0);
            tg_part_list.part_entry[i].end_sector_number = bysector;
            tg_part_list.part_entry[i].end_cylinder_number = bycylinder;
            tg_part_list.part_entry[i].end_head_number = byhead;

            if (tg_part_list.part_entry[i].partition_ID == EXTENDED_PARTITION ||
                    tg_part_list.part_entry[i].partition_ID == EXTENDED_LBA_PARTITION ||
                    tg_part_list.part_entry[i].partition_ID == HIDDEN_EXTENDED_PARTITION ||
                    tg_part_list.part_entry[i].partition_ID == HIDDEN_EXTENDED_LBA_PARTITION)
            {
                based_logical_start = start_sector_logical = tg_part_list.part_entry[i].start_sector;
                j = 0;

                while (1)
                {
                    if (tg_part_list.entry_not_empty[4+2*j])
                    {
                        LBA = start_sector_logical + tg_part_list.part_entry[4+2*j].start_sector;
                        get_CHS(LBA, bysector, bycylinder, byhead, sec_per_track, head_per_cyl, 1);
                        tg_part_list.part_entry[4+2*j].begin_sector_number = bysector;
                        tg_part_list.part_entry[4+2*j].begin_cylinder_number = bycylinder;
                        tg_part_list.part_entry[4+2*j].begin_head_number = byhead;

                        LBA2 = LBA + tg_part_list.part_entry[4+2*j].number_of_sectors - 1;
                        get_CHS(LBA2, bysector, bycylinder, byhead, sec_per_track, head_per_cyl, 0);
                        tg_part_list.part_entry[4+2*j].end_sector_number = bysector;
                        tg_part_list.part_entry[4+2*j].end_cylinder_number = bycylinder;
                        tg_part_list.part_entry[4+2*j].end_head_number = byhead;

                        if (j > 0)
                        {
                            if (tg_part_list.part_entry[4+2*j].start_sector <= sec_per_track)
                                LBA = LBA - tg_part_list.part_entry[4+2*j].start_sector;

                            get_CHS(LBA, bysector, bycylinder, byhead, sec_per_track, head_per_cyl, 1);

                            tg_part_list.part_entry[3+2*j].begin_sector_number = bysector;

                            tg_part_list.part_entry[3+2*j].begin_cylinder_number = bycylinder;

                            tg_part_list.part_entry[3+2*j].begin_head_number = byhead;

                            tg_part_list.part_entry[3+2*j].end_sector_number = tg_part_list.part_entry[4+2*j].end_sector_number;

                            tg_part_list.part_entry[3+2*j].end_cylinder_number = tg_part_list.part_entry[4+2*j].end_cylinder_number;

                            tg_part_list.part_entry[3+2*j].end_head_number = tg_part_list.part_entry[4+2*j].end_head_number;
                        }
                    }

                    if (tg_part_list.entry_not_empty[5+2*j])
                    {
                        start_sector_logical = based_logical_start + tg_part_list.part_entry[5+2*j].start_sector;
                        j++;
                    }
                    else
                        break;
                }

                continue;
            }
        }
    }
}
//////////////////////////////////////////////////////////////////////////
//
bool CSystemD105::isCancelWhileDup()
{
    if (!instance)
    {
        return false;
    }

    return instance->gAbortFlag == 1;
}
//////////////////////////////////////////////////////////////////////////
// HuyHuynh adds new function
void CSystemD105::displaySystemOption ()
{
    printDFXLog (PRI_INFO, "%-50s", SYS_OPT_TRANS_SET);
    printDFXLog (PRI_INFO, "%-50s %s ", SYS_OPT_TRANS_SET_ENA_LBA, systemOption.lba_enable == 1 ? "Enable": "Disable");
    printDFXLog (PRI_INFO, "%-50s %s ", SYS_OPT_TRANS_SET_ENA_INT, systemOption.int13f8_enable == 1 ? "Enable": "Disable");

    printDFXLog (PRI_INFO, "%-50s %s ", SYS_OPT_TRANS_SET_BRIEF_COPY, systemOption.enable_brief_copy == 1 ? "Enable": "Disable");

    printDFXLog (PRI_INFO, "%-50s", SYS_OPT_TIME_SET);
    printDFXLog (PRI_INFO, "%-50s %u", SYS_OPT_TIME_SET_POW_DEL, systemOption.txt_power_up_delay);
    printDFXLog (PRI_INFO, "%-50s %u", SYS_OPT_TIME_SET_DRI_SET, systemOption.txt_settling_time);
    printDFXLog (PRI_INFO, "%-50s %u", SYS_OPT_TIME_SET_SPI_DEL, systemOption.txt_spin_down_time);
    printDFXLog (PRI_INFO, "%-50s %u", SYS_OPT_TIME_SET_CMD_TME, systemOption.txt_command_time_out);
    printDFXLog (PRI_INFO, "%-50s %u", SYS_OPT_TIME_SET_CMD_DEL, systemOption.txt_command_delay);
    printDFXLog (PRI_INFO, "%-50s %u", SYS_OPT_TIME_SET_CMD_RET, systemOption.txt_command_retry);

    printDFXLog (PRI_INFO, "");
    printDFXLog (PRI_INFO, "%-50s", SYS_OPT_TRA_MOD_SET);
    printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_TRA_MOD_SET_MUL_SEC, systemOption.rw_multi_optn_enable == 1 ? "Enable": "Disable");
    if (systemOption.transfer_mode <= (UDMA_MODE_MAX - 0x40))
    {
        printDFXLog (PRI_INFO, "%-50s UDMA %u", SYS_OPT_TRA_MOD_SET_TRA_MOD, systemOption.transfer_mode);
    }
    else
    {
        printDFXLog (PRI_INFO, "%-50s PIO %u", SYS_OPT_TRA_MOD_SET_TRA_MOD, systemOption.transfer_mode - (UDMA_MODE_MAX - 0x40 + 0x01));
    }
    printDFXLog (PRI_INFO, "%-50s %u", SYS_OPT_TRA_MOD_SET_SEC_TRA, systemOption.sectors_per_transfer);

    printDFXLog (PRI_INFO, "%-50s", SYS_OPT_DAT_LOG_SET);
    printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_DAT_LOG_SET_DIS_CON, systemOption.chk_talk_to_console == 1 ? "Enable": "Disable");
    if (systemOption.chk_log_file_size == 1)
    {
        printDFXLog (PRI_INFO, "%-50s %u", SYS_OPT_DAT_LOG_SET_LOG_SIZ, systemOption.txt_log_file_size);
    }
    else
    {
        printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_DAT_LOG_SET_LOG_SIZ, "Disable");
    }
    if (systemOption.log_level == 1) //TanLe defined - Replace by sound signal
    {
        printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_LOG_LEV_SET, "Disable");
    }else
    {
        printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_LOG_LEV_SET, "Enable");
    }

    if (systemOption.enable_key_sound == 1) //TamHo defined - Key sound when press buttons
    {
        printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_KEY_SOUND_SET, "Disable");
    }else
    {
        printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_KEY_SOUND_SET, "Enable");
    }

    if(this->systemOption.verify_Mode == 1)
    {
        printDFXLog (PRI_INFO, "%-50s %d", SYS_OPT_VER_SET, 100);
    }
    else
    {
        printDFXLog (PRI_INFO, "%-50s %d", SYS_OPT_VER_SET, 0);
    }

    if (systemOption.enable_dod_wipeout == 1)
    {
        printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_DOD_WIPEOUT_SET, "Enable");
    }else
    {
        printDFXLog (PRI_INFO, "%-50s %s", SYS_OPT_DOD_WIPEOUT_SET, "Disable");
    }

    printDFXLog (PRI_INFO, "%-50s", SYS_OPT_OTHER_SET);
    printDFXLog (PRI_INFO, "%-50s %s \n", SYS_OPT_OTHER_SET_USR_JOB, systemOption.enable_user_jobs_enable == 1 ? "Enable": "Disable");
}

/***************************************************************
 Function : allTargetsReady()
Description : check for whether all target disks are ready
Input : none
Output : none
Returns : 1 if all enabled target drives have finished their startup sequence
 ***************************************************************/
short CSystemD105::allTargetsReady(void)
{
    short d;
    short AllTargetsReady = 1;

    for (d = 1; d < MAX_DISKS; d++)
    {
        if (gTarget[d].enable && (gDriveState[d] != DRIVE_READY)
                && (gDriveState[d] != DEAD_DRIVE)
                && (gDriveState[d] != DISABLED))
        {
            AllTargetsReady = 0;
            break;
        }
    }

    return AllTargetsReady;
}

/****************************************
Function : clearDriveInfo()
Description : Erase gDriveInfo[] structure
Input : disk number
Output : none
Return : none
 ****************************************/
void CSystemD105::clearDriveInfo(short d)
{
    // Initialize job data structures
    strcpy(gDriveInfo[d].MfrName, "? ");
    strcpy(gDriveInfo[d].FirmwareRev, "? ");
    strcpy(gDriveInfo[d].SerialNumber, "? ");
    gDriveInfo[d].NumLogCylinders = 0;
    gDriveInfo[d].NumLogSectTrack = 0;
    gDriveInfo[d].NumLogHeads = 0;
    gDriveInfo[d].NumCurrCylinders = 0;
    gDriveInfo[d].NumCurrHeads = 0;
    gDriveInfo[d].NumCurrSectors = 0;

    gDriveInfo[d].CurrCapacity = 0;
    gCapacity[d] = 0L;

    gDriveInfo[d].Capabilities = 0;
    gDriveInfo[d].PIOmodeflags = 0;
    gDriveInfo[d].PIOmodes = 0;
    gDriveInfo[d].MultiCap = 0;
    gDriveInfo[d].ATAMajorVersion = 0;

}
/************************************************************************
Function : minimum()
Description : Return lower of two integers
Inputs : two long integers
Output : none
Return : minimum of two inputs
 ************************************************************************/
unsigned long CSystemD105::minimum(unsigned long a, unsigned long b)
{
    if (a < b) return a;

    return b;
}

/**********************************************************************
Function : readBootStructure()
Description : Read partition table(s) and boot sectors into tables and scan
 known FATs
Inputs : disk number
Output : none
Return : 1 if success or 0 if otherwise
*********************************************************************** */
short CSystemD105::readBootStructure(short d)
{
    if (!diskStruct[d].scanDiskStructure())
    {
        return UNSUCCESS;
    }

    return SUCCESS;
}
/**********************************************
Function : sectorsToMegaBytes
Description : Converts sectors to megabytes.
Input : sectors (512 bytes each)
Output : none
Return : megabytes
***********************************************/
unsigned long CSystemD105::sectorsToMegaBytes(unsigned long sectors)
{
    double divisor;
    unsigned long mbResult;

    divisor = (double)(1024L * 1024L / 512L);
    mbResult = (unsigned long) floor((double)sectors / divisor);
    return mbResult;
}

/*********************************************************
Function : ComputeBestTranfer
Description : Compute the best transfer mode and transfer mode number of disk
Input : disk number
Output : none
Return : none
**********************************************************/
void CSystemD105::computeBestTransfer(short d)
{
    gBestTransferMode[d] = PIO_FLOW_CONTROL_TRANSFER_MODE;
    gBestTransferModeNumber[d] = 0;
    //Compute best trandfer mode as PIO mode
    gBestTransferModeNumber[d] = gSupportedPIOModeNumber[d];
    //Compute best transfer mode as DMA mode

    if (gATAVersion[d] <= 3)
    {
        gBestTransferMode[d] = MULTIWORD_DMA_MODE;
        gBestTransferModeNumber[d] = gSupportedMultiwordDMAModeNumber[d];
    }

    //Compute best transfer mode as Ultra DMA mode
    if (gATAVersion[d] >= 4)
    {
        gBestTransferMode[d] = ULTRA_DMA_MODE;

        if (gDriveInfo[d].Flags53&0x0004)
            gBestTransferModeNumber[d] = gSupportedUltraDMAModeNumber[d];
        else
            gBestTransferModeNumber[d] = 0;
    }
}

/****************************************************
Function : startupComputeActualCapacity()
Description : Compute actual capacity in sector of disk
Input : disk number
Output : none
Return : none
*****************************************************/
void CSystemD105::startupComputeActualCapacity(short disk)
{
    unsigned long x, y;
    short ComputeCHScapacity;
    short drvataver;
    gLargeDrive[disk] = 0;

    this->gHPACapacity[disk] = 0;
    this->gNativeMaxAddress[disk] = 0;
    this->gHPAFeatureSupported[disk] = 0;
    this->gHPAFeatureSupported[disk] = (((gDriveInfo[disk].CommandSet) & (0x01 << 10)) ? 1 : 0) && (((gDriveInfo[disk].CommandSetEnabled) & (0x01 << 10)) ? 1 : 0);

    ComputeCHScapacity = 0;
    drvataver = gATAVersion[disk];

    /*
                        ATA6 added support for 48-bit addressing
                */

    printDFXLog (PRI_INFO, "Disk [%u] information:", disk);

    if (drvataver > 5)
    {
        /*
                                If word 83 - bit 10 is set then 48-bit address mode is supported.
                                Set appropriate bit in gLargeDrive[] for future reference.
                        */

        if ((gDriveInfo[disk].CommandSetsSupported & 0x0400) != 0)
        {
            printDFXLog (PRI_INFO, "%-40s", INF_SUP_BIT_MSG);
            gLargeDrive[disk] |= SUPPORT_48;
        }
        else
        {
            printDFXLog (PRI_INFO, "%-40s", INF_NON_SUP_BIT_MSG);
            gLargeDrive[disk] &= ~(SUPPORT_48);
        }
    }

    /*
                        If the ATA version is 6 or greater then ignore user choice on LBA. ATA6 and greater
                        no longer support CHS information reporting in the Identify Device information.
                */

    /*
                        All drives ATA3 and newer must support LBA mode
                 */

    if (drvataver > 2)
    {
        gNativeMaxAddress[disk] = 0;
        ComputeCHScapacity = 0;

        /*
                                If drive supports 48bit addressing then get maximum sectors up to 32-bits.
                        */

        if ((gLargeDrive[disk]& SUPPORT_48) == SUPPORT_48)
        {
            gCapacity[disk] = gDriveInfo[disk].MaxUserLbaAddr1_48Bit;
            gCapacity[disk] <<= 16;
            gCapacity[disk] |= gDriveInfo[disk].MaxUserLbaAddr0_48Bit;
            // gCapacity[disk] = gDriveInfo[disk].LBAuserSectors;

            if (gHPAFeatureSupported[disk])
            {
                diskIOModule.getNativeMaxAddress_Ext(disk, this->gNativeMaxAddress[disk]);
            }
        }
        else
        {
            gCapacity[disk] = gDriveInfo[disk].LBAuserSectors;

            if (gHPAFeatureSupported[disk])
            {
                diskIOModule.getNativeMaxAddress(disk, this->gNativeMaxAddress[disk]);
            }
        }
    }
    else
    {
        /*
                                Non-ATA-3 drives or those not reporting ATA3 version info should have the LBA support bit set before we use LBAuserSectors.
                        */

        if (gDriveInfo[disk].Capabilities & LBA_SUPP)
        {
            gCapacity[disk] = gDriveInfo[disk].LBAuserSectors;
        }
        else
        {
            ComputeCHScapacity = 1;
        }
    }
    this->gCapacityOrigin[disk] = this->gCapacity[disk];

    printDFXLog (PRI_INFO, "%-40s %lu (%lu MB)", INF_CAP_MSG, gCapacity[disk], gCapacity[disk] / 2048);
    printDFXLog (PRI_INFO, "%-40s %lu (%lu MB)", INF_MAX_ADD_MSG, gNativeMaxAddress[disk], gNativeMaxAddress[disk] / 2048);

    if (this->gNativeMaxAddress[disk] == 0)
    {
        //printDFXLog (PRI_INFO, "Disk %d gNativeMaxAddress[%d] = 0",disk);
        this->gNativeMaxAddress[disk] = this->gCapacity[disk] - 1;
    }

    /*
                        Only use this if LBA capacity can not be used or the user has turned off LBA mode
                */

    if (ComputeCHScapacity)
    {
        x = (long) gDriveInfo[disk].NumCurrCylinders * (long) gDriveInfo[disk].NumCurrHeads * (long) gDriveInfo[disk].NumCurrSectors;

        if (chk_vers(disk) < 3)
        {
            /*
                                        Some early drives had the end of the capacity swapped in the Current Capacity words (57-58).
                                        If the calculated capacity doesn't equal the value contained in words 57 and 58 (Current Capacity) then swap the words and see if a match can be found.
                                        If no match is found then leave Current Capacity as it is.
                                */

            y = (gDriveInfo[disk].CurrCapacity >> 16) | (gDriveInfo[disk].CurrCapacity << 16);

            if ((x != gDriveInfo[disk].CurrCapacity) && (x == y))
            {
                gDriveInfo[disk].CurrCapacity = x;
            }

            /*
                                        If gDriveInfo[Drive].CurrCapacity is being reported as 0 which occurs on some pre-ATA 3 drives
                                        and x has a value in it then set gDriveInfo.CurrCapacity to x
                                */

            if (!gDriveInfo[disk].CurrCapacity)
            {
                gDriveInfo[disk].CurrCapacity = x;
            }
        }

        /* Always compute the next value -- */
        /* Some drives don't store big nums right */
        gDriveInfo[disk].CurrCapacity = (long int) gDriveInfo[disk].NumCurrCylinders * (long int) gDriveInfo[disk].NumCurrHeads * (long int) gDriveInfo[disk].NumCurrSectors;

        // Record largest capacity of this drive
        gCapacity[disk] = gDriveInfo[disk].CurrCapacity;
    }

    /*
      If drive exceeds partition table limits then set the bit 16,515,072 = 1024 Cyls x 256 heads x 63 SPT 990723.1130] - mws
      Since the maximum allowable heads setting in the partition table is 255 the actual 8 GB limit is slightly reduced to
      the product of 1024 x 255 x63 = 16,450,560 sectors
     */

    if (gCapacity[disk] >= 16450560L)
    {
        gLargeDrive[disk] |= GREATER_THAN_8;
    }
    else
    {
        gLargeDrive[disk] &= ~(GREATER_THAN_8);
    }


    printDFXLog (PRI_INFO, "");
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::returnCapacityOrigin()
{
    for (short disk = 0; disk < MAX_DISKS; disk++)
    {
        this->gCapacity[disk] = this->gCapacityOrigin[disk];
    }
}
/*****************************************************************************
Function : startupIdentifyDevice
Description : Read Identify Device Information of disk and compute some parameters.
Input : disk number
Output : none
Return : 1 if success or 0 if otherwise
******************************************************************************/
short CSystemD105::startupIdentifyDevice(short d, int _is_get_id)
{
    short i = 0;
    short Drive = d;
    unsigned short low_byte;
    short data;
    short errorCode;
    unsigned long cyl_size;

#ifdef DEBUG_CSYSTEM105
    printDFXLog (PRI_INFO, "CSystemD105::startupIdentifyDevice-> _is_get_id=%d\n", _is_get_id);
#endif

    if (_is_get_id) // want to get indentify of the disk
    {
        errorCode = diskIOModule.getIdentifyDevice(d, gDriveInfo[d]);

        if (errorCode != 1)
        {

            return UNSUCCESS;
        }

#ifdef DEBUG_CSYSTEM105
        //printf("----> Identify Info disk: %d <----\n", d);
        //show_ide_identify(&gDriveInfo[d]);
#endif
    }

    for (i = 0;i < 20;i++)
    {
        data = gDriveInfo[d].MfrName[i*2];
        gDriveInfo[d].MfrName[i*2] = gDriveInfo[d].MfrName[i*2+1];
        gDriveInfo[d].MfrName[i*2+1] = data;
    }
    //////////////////////////////////////////////////////////////////////////
    // HoaHoang fix bug display serial Number not correct
    for (i = 0;i < 10;i++)
    {
        data = gDriveInfo[d].SerialNumber[i*2];
        gDriveInfo[d].SerialNumber[i*2] = gDriveInfo[d].SerialNumber[i*2+1];
        gDriveInfo[d].SerialNumber[i*2+1] = data;
    }

    char tempString[40];
    short position=0;
    memcpy(tempString,gDriveInfo[d].SerialNumber,20);
    // clear buffer
    memset(gDriveInfo[d].SerialNumber, ' ', 20);
    for (short i =0; i<20; i++)
    {
        if (tempString[i] != ' ')
        {
            position =i;
            //fprintf(stderr,"\ndisk %d SerialNumber position = %d",d,position);
            break;
        }
    }
    memcpy(gDriveInfo[d].SerialNumber,tempString+position,20-position);
    // for name of disk
    memcpy(tempString,gDriveInfo[d].MfrName,40);
    memset(gDriveInfo[d].MfrName,' ', 40);
    position=0;
    for (short i =0; i<20; i++)
    {
        if (tempString[i] != ' ')
        {
            position =i;
            //fprintf(stderr,"\ndisk %d MfrName position = %d",d,position);
            break;
        }
    }
    memcpy(gDriveInfo[d].MfrName,tempString+position,40-position);
    // end HoaHoang
    //////////////////////////////////////////////////////////////////////////

    gDriveInfo[d].SerialNumber[19] = '\0';
    gDriveInfo[d].MfrName[39] = '\0';
    if (!(gDriveInfo[d].Flags53 & 0x0001))
    {
        // word 54 == word 1
        gDriveInfo[d].NumCurrCylinders = gDriveInfo[d].NumLogCylinders;

        // word 55 == word 3
        gDriveInfo[d].NumCurrHeads = gDriveInfo[d].NumLogHeads;

        // word 56 == word 6
        gDriveInfo[d].NumCurrSectors = gDriveInfo[d].NumLogSectTrack;

        // if 54 through 56 are not valid then 57 and 58 are
        // not valid either and should be filled in so that
        // future capacity calculations can have a somewhat
        // reliable number.
        // words 57 and 58 equal the product of the CxHxS
        gDriveInfo[d].CurrCapacity = (long)((long)gDriveInfo[d].NumCurrCylinders * (long)gDriveInfo[d].NumCurrHeads * (long)gDriveInfo[d].NumCurrSectors);
    }

    // Compute ATA Version
    data = gDriveInfo[d].ATAMajorVersion;

    if (data < 1)
    {
        gATAVersion[d] = 0;
    }
    else
    {
        gATAVersion[d] = 14;
        data <<= 1;

        while (data > 0)
        {
            data <<= 1;
            gATAVersion[d]--;
        }
    }

    cyl_size = gDriveInfo[d].NumCurrSectors * gDriveInfo[d].NumCurrHeads;

    if (cyl_size == 0)
        return UNSUCCESS;

    gNumCylinders[d] = gCapacity[d] / cyl_size;

    this->startupComputeActualCapacity(d);

    // re-calculate number of cylinders
    gNumCylinders[d] = gCapacity[d] / cyl_size;

    //Compute maximum number of sectors that shall be transfered per interrupt
    //on READ/WRITE MULTIPLE commands
    gSupportedMultiple[d] = gDriveInfo[d].MultiCap & 0x00FF;

    gBestMultiple[d] = gSupportedMultiple[d];

    // Compute supported PIO mode number
    gSupportedPIOModeNumber[d] = (gDriveInfo[d].PIOmodeflags >> 8) & 0xFF;

    if (gSupportedPIOModeNumber[d] > 2)
    {
        // Set default if value is above 2
        gSupportedPIOModeNumber[d] = 0;
    }

    if (gDriveInfo[d].Flags53&0x0002)
    {
        if (gDriveInfo[d].PIOmodes & PIO3_SUPPORTED)
        {
            gSupportedPIOModeNumber[d] = 3;
        }

        if (gDriveInfo[d].PIOmodes & PIO4_SUPPORTED)
        {
            gSupportedPIOModeNumber[d] = 4;
        }
    }

    // Compute Supported Multiword DMA Mode Number
    gSupportedMultiwordDMAModeNumber[d] = 0;

    low_byte = gDriveInfo[d].MDMAflags & 0x00FF;

    do
    {
        low_byte >>= 1;

        if (low_byte)
            gSupportedMultiwordDMAModeNumber[d]++;
    }
    while (low_byte);

    // Compute Supported Ultra DMA Mode Number
    gSupportedUltraDMAModeNumber[d] = 0;

    low_byte = gDriveInfo[d].UltraDmaMode & 0x00FF;

    do
    {
        low_byte >>= 1;

        if (low_byte)
            gSupportedUltraDMAModeNumber[d]++;
    }
    while (low_byte);

    // Compute best transfer of disk.
    this->computeBestTransfer(d);

    // Check the 48 bit address feature set supported.
    if ((gATAVersion[d] > 5) && (gDriveInfo[Drive].CommandSetsSupported & SUPPORT_48_BIT_ADDRESS))
        g48BitAddressSupported[Drive] = 1;
    else
        g48BitAddressSupported[Drive] = 0;

    // Check the Host Protected Area Feature Set supported
    if ((gDriveInfo[Drive].CommandSet & HPA_FEATURE_SUPPORTED) && (gDriveInfo[Drive].CommandSetEnabled & 0x0400))
        gHPAFeatureSupported[Drive] = 1;
    else
        gHPAFeatureSupported[Drive] = 0;

    return 1;
}
/*****************************************************************************
Function : checkDataInHPARegion()
Description : Check source disk has data in HPA Region ?.
Input :
Output : true : if has data in HPA region else return false
******************************************************************************/
bool CSystemD105::checkDataInHPARegion()
{
    for(int idx=0; idx <diskStruct[0].partition_list.number_of_partitions; idx++)
    {
        if((diskStruct[0].partition_list.partition[idx].start_sector + diskStruct[0].partition_list.partition[idx].number_of_sectors) > (this->gNativeMaxAddress[0] - this->gHPACapacity[0]))
        {
            return true;
        }
    }
    return false;
}
/**********************************************************************
Function : calTotalSectorCopyAllTask()
Description : calculate total sector copy for all task in task list
Inputs : none
Output : none
Return : total sector copy
*********************************************************************** */
unsigned long CSystemD105::calTotalSectorCopyAllTask()
{
    short i;
    unsigned short result = SUCCESS;
    unsigned long numOfSecs = 0;
    for(short taskIdx = 0; taskIdx < this->totalTask; taskIdx++)
    {
        //fprintf(stderr, "\n DVDB->action %d", gTaskList[taskIdx].action);
        switch (gTaskList[taskIdx].action)
        {
        case FAT_32_PAR_SMART:
        {
            this->diskIOModule.setPartitionStart(0, gTaskList[taskIdx].target.startSector[0]);
            this->diskIOModule.setPartitionLength(0, gTaskList[taskIdx].source_length);
            unsigned char buffer[SECTOR_SIZE];
            memset(buffer, 0x00, SECTOR_SIZE);
            //fprintf(stderr, "\n 1 - DVDB->read source at sector %lu", gTaskList[taskIdx].target.startSector[0]);
            if(this->diskIOModule.readSectors(0, gTaskList[taskIdx].target.startSector[0], 1, (unsigned short*)buffer) != SUCCESS)
            {
                this->handleIOError(IO_READ_DISK, 0, "getTotalOfCopySectors");
                return UNSUCCESS;
            }
            else
            {
                BPB32_STRUCT bootSec;
                memcpy(&bootSec, buffer, sizeof(BPB32_STRUCT));
                //fprintf(stderr, "\n 2 - DVDB->read source at sector %lu", gTaskList[taskIdx].target.startSector[0] + bootSec.BPB_FSInfo);
                if(this->diskIOModule.readSectors(0, gTaskList[taskIdx].target.startSector[0] + bootSec.BPB_FSInfo, 1, (unsigned short *)buffer) != SUCCESS)
                {
                    this->handleIOError(IO_READ_DISK, 0, "getTotalOfCopySectors");
                    return UNSUCCESS;
                }

                // ky fixed bug: if total sectors is less than 65536
                numOfSecs = (bootSec.BPB_TotalSec2 != 0) ? bootSec.BPB_TotalSec2 : bootSec.BPB_TotalSec4;
                numOfSecs = numOfSecs - ((unsigned long *)buffer)[122] * bootSec.BPB_SecPerClus ;

                for(short disk = 0; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[taskIdx].target.item[disk] == 1)
                    {
                        this->totalOfJobSectors[disk] += numOfSecs;
                        //Set information for table
                        this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                        this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                        this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                        if(this->isBriefCopy == TRUE)
                        {
                            this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("FAT32 Twin Copy");
                        }
                        else
                        {
                            this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("FAT32 Auto Smart Copy");
                        }
                        this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(numOfSecs);
                    }
                }
            }

        }
            break;
        case EXT2_PAR_SMART:
        {
            this->diskIOModule.setPartitionStart(0, gTaskList[taskIdx].target.startSector[0]);
            this->diskIOModule.setPartitionLength(0, gTaskList[taskIdx].source_length);
            EXT4_SUPER_BLOCK sblock;
            if(this->diskIOModule.readSectors(0, gTaskList[taskIdx].target.startSector[0] + SP_START_SEC, SP_SEC_CNT, (unsigned short*)&sblock) != SUCCESS)
            {
                this->handleIOError(IO_READ_DISK, 0, "getTotalOfCopySectors");
                return UNSUCCESS;
            }
            else
            {
                numOfSecs = (2 << sblock.s_log_block_size) * (sblock.s_blocks_count - sblock.s_free_blocks_count);

                for(short disk = 0; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[taskIdx].target.item[disk] == 1)
                    {
                        this->totalOfJobSectors[disk] += numOfSecs;
                        //Set information for table
                        this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                        this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                        this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                        if(this->isBriefCopy == TRUE)
                        {
                            this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("EXT2/3 Twin Copy");
                        }
                        else
                        {
                            this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("EXT2/3 Auto Smart Copy");
                        }
                        this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(numOfSecs);
                    }
                }
            }
        }
            break;
        case EXT4_PAR_SMART:
        {
            this->diskIOModule.setPartitionStart(0, gTaskList[taskIdx].target.startSector[0]);
            this->diskIOModule.setPartitionLength(0, gTaskList[taskIdx].source_length);
            EXT4_SUPER_BLOCK sblock;
            if(this->diskIOModule.readSectors(0, gTaskList[taskIdx].target.startSector[0] + SP_START_SEC, SP_SEC_CNT, (unsigned short*)&sblock) != SUCCESS)
            {
                this->handleIOError(IO_READ_DISK, 0, "getTotalOfCopySectors");
                return UNSUCCESS;
            }
            else
            {
                numOfSecs = (2 << sblock.s_log_block_size) * (sblock.s_blocks_count - sblock.s_free_blocks_count);

                for(short disk = 0; disk < MAX_DISKS; disk++)
                {
                    if(gTaskList[taskIdx].target.item[disk] == 1)
                    {
                        this->totalOfJobSectors[disk] += numOfSecs;
                        //Set information for table
                        this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                        this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                        this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                        if(this->isBriefCopy == TRUE)
                        {
                            this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("EXT4 Twin Copy");
                        }
                        else
                        {
                            this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("EXT4 Auto Smart Copy");
                        }
                        this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(numOfSecs);
                    }
                }
            }
        }
            break;
        case LVM_PAR_SMART:
            printDFXLog(PRI_INFO, "LVM have NOT supported yet! ");
            for(short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[taskIdx].target.item[disk] == 1)
                {
                    this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                    this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("LVM Copy");
                    this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(0);
                }
            }
            return SUCCESS;

        case FAT_32_FORMAT:
            break;
        case FORMAT_DISK:
            printDFXLog(PRI_INFO, "Begin format disk");
            break;
        case NTFS_PAR_SOURCE_SMALLER_TARGET:
        {
            this->diskIOModule.setPartitionStart(0, gTaskList[taskIdx].target.startSector[0]);
            this->diskIOModule.setPartitionLength(0, gTaskList[taskIdx].source_length);
            gTaskList[taskIdx].remain_sectors[0] = gTaskList[taskIdx].source_length;

            this->gTaskList[taskIdx].remain_sectors[0] = this->gTaskList[taskIdx].source_length;
            this->gNtfsCopy = new NtfsCopy(gTaskList[taskIdx].target, this, gTaskList[taskIdx].remain_sectors, m_Translated_CHF, gTaskList[taskIdx].hidden_sectors, gCopyResult);

            if (this->gNtfsCopy != NULL)
            {
                numOfSecs =  this->gNtfsCopy->getSectorCountCopy();

                delete(this->gNtfsCopy);
                this->gNtfsCopy = NULL;
            }

            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[taskIdx].target.item[disk] == 1)
                {
                    this->totalOfJobSectors[disk] += numOfSecs;
                    //Set information for table
                    this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                    this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                    if(this->isBriefCopy == TRUE)
                    {
                        this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("NTFS Twin Copy");
                    }
                    else
                    {
                        this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("NTFS Auto Smart Copy");
                    }
                    this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(numOfSecs);
                }
            }
        }
            break;
        case MIRROR_PAR:
        {
            unsigned long startSector[MAX_DISKS], sectorCount[MAX_DISKS];
            startSector[0] = gTaskList[taskIdx].source_sector;
            sectorCount[0] = gTaskList[taskIdx].remain_sectors[1];

            for (i = 1;i < MAX_DISKS;i++)
            {
                startSector[i] = gTaskList[taskIdx].target_sector[i];
                sectorCount[i] = gTaskList[taskIdx].remain_sectors[i];

                if(gTaskList[taskIdx].target.item[i])
                {
                    min_idx = i;
                    min_remain_sectors = gTaskList[taskIdx].remain_sectors[i];
                }
            }

            for (i = 1;i < MAX_DISKS;i++)
            {
                if((gTaskList[taskIdx].remain_sectors[i] < min_remain_sectors) && (gTaskList[taskIdx].target.item[i]))
                {
                    min_idx = i;
                    min_remain_sectors = gTaskList[taskIdx].remain_sectors[i];
                }
            }

            //Find max sector count to set to source disk
            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[taskIdx].target.item[disk] == 1)
                {
                    if(sectorCount[0] < sectorCount[disk])
                    {
                        sectorCount[0] = sectorCount[disk];
                    }
                }
            }

            for (i = 1;i < MAX_DISKS;i++)
            {
                if(this->gTarget[i].disk_mode == DISK_SMART)
                {
                    if(min_remain_sectors < gTaskList[taskIdx].source_length)
                    {
                        sectorCount[i] = min_remain_sectors;
                    }
                    else
                    {
                        sectorCount[i] = gTaskList[taskIdx].source_length;
                    }
                }
            }

            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[taskIdx].target.item[disk] == 1)
                {
                    this->totalOfJobSectors[disk] += sectorCount[disk];
                    //Set information for table
                    this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                    this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("Mirror Copy");
                    this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(sectorCount[disk]);
                }
            }
        }
            break;
        case CLEAR_PAR:
        {
            unsigned long startSector[MAX_DISKS], sectorCount[MAX_DISKS];
            startSector[0] = gTaskList[taskIdx].source_sector;
            sectorCount[0] = gTaskList[taskIdx].remain_sectors[1];

            for (i = 1;i < MAX_DISKS;i++)
            {
                startSector[i] = gTaskList[taskIdx].target_sector[i];
                sectorCount[i] = gTaskList[taskIdx].remain_sectors[i];
            }

            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[taskIdx].target.item[disk] == 1)
                {
                    this->totalOfJobSectors[disk] += sectorCount[disk];
                    //Set information for table
                    this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                    this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("Wipe Disk");
                    this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(sectorCount[disk]);
                }
            }
        }
            break;

        case FAST_PURGE_PAR:
        {
            unsigned long startSector[MAX_DISKS], sectorCount[MAX_DISKS];
            startSector[0] = gTaskList[taskIdx].source_sector;
            sectorCount[0] = gTaskList[taskIdx].remain_sectors[1];

            for (i = 1;i < MAX_DISKS;i++)
            {
                startSector[i] = gTaskList[taskIdx].target_sector[i];
                sectorCount[i] = gTaskList[taskIdx].remain_sectors[i];
            }

            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[taskIdx].target.item[disk] == 1)
                {
                    this->totalOfJobSectors[disk] += sectorCount[disk];
                    //Set information for table
                    this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                    this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("FAST Purge");
                    this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(sectorCount[disk]);
                }
            }
        }
            break;
        case WIPEOUT_PAR:
        {
            unsigned long startSector[MAX_DISKS], sectorCount[MAX_DISKS];
            startSector[0] = gTaskList[taskIdx].source_sector;
            sectorCount[0] = gTaskList[taskIdx].remain_sectors[1];

            for (i = 1;i < MAX_DISKS;i++)
            {
                startSector[i] = gTaskList[taskIdx].target_sector[i];
                sectorCount[i] = gTaskList[taskIdx].remain_sectors[i];
            }

            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[taskIdx].target.item[disk] == 1)
                {
                    this->totalOfJobSectors[disk] += sectorCount[disk];
                    //Set information for table
                    this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                    this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("DOD Wipeout");
                    this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(sectorCount[disk]);
                }
            }
        }
            break;
        case SANITIZE_PAR:
            break;
        case MIRROR_HPA:
            break;
        case SMART_HPA:
            break;
        case TEST_PAR:
        {
            unsigned long startSector[MAX_DISKS], sectorCount[MAX_DISKS];
            startSector[0] = gTaskList[taskIdx].source_sector;
            sectorCount[0] = gTaskList[taskIdx].remain_sectors[1];

            for (i = 1;i < MAX_DISKS;i++)
            {
                startSector[i] = gTaskList[taskIdx].target_sector[i];
                sectorCount[i] = gTaskList[taskIdx].remain_sectors[i];
            }

            for (short disk = 0; disk < MAX_DISKS; disk++)
            {
                if(gTaskList[taskIdx].target.item[disk] == 1)
                {
                    this->totalOfJobSectors[disk] += sectorCount[disk];
                    //Set information for table
                    this->dbObj.taskInJobObj[disk][taskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                    this->dbObj.taskInJobObj[disk][taskIdx].setDiskIndex(disk);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskIndex(taskIdx + 1);
                    this->dbObj.taskInJobObj[disk][taskIdx].setTaskName("Test Disk");
                    this->dbObj.taskInJobObj[disk][taskIdx].setCopiedSectors(sectorCount[disk]);
                }
            }
        }
            break;
        case TEST_HPA:
            break;
        case SCRTY_ERASE_PAR:
            break;
        case SCRTY_ERASE_HPA:

        case NULL_PAR:
            break;

        default:
            break;
        }
        /*for (short disk = 0; disk < MAX_DISKS; disk++)
  {
   if(gTaskList[taskIdx].target.item[disk] == 1)
   {
    fprintf(stderr, "\n getTotalOfCopySectors->Disk[%d]: Total of copy sectors %lu", disk, this->totalOfJobSectors[disk]);
   }
  }*/
    }
    return result;
}
/*****************************************************************************
Function : commonCopiedSectorCount()
Description : get the minimum of number of remain not yet copied sectors of targets.
Input : task number
Output : none
Return : the minimum of number of remain not yet copied sectors of targets.
******************************************************************************/
unsigned long CSystemD105::commonCopiedSectorCount(short tasknumber)
{
    short i, d;
    unsigned long max = LARGEST_LINT;

    for (i = 0; i < gTaskList[tasknumber].target.items; i++)
    {
        d = gTaskList[tasknumber].target.item[i];
        max = minimum(max, gTaskList[tasknumber].remain_sectors[d]);
    }

    return max;
}

/*****************************************************************************
Function : commonVerifiedSectorCount()
Description : get the minimum of number of remain not yet verified sectors of targets.
Input : task number
Output : none
Return : the minimum of number of remain not yet verified sectors of targets.
******************************************************************************/
unsigned long CSystemD105::commonVerifiedSectorCount(short verifytasknumber)
{
    short i, d;
    unsigned long max = LARGEST_LINT;

    for (i = 0; i < gTaskList[verifytasknumber].verify_target.items; i++)
    {
        d = gTaskList[verifytasknumber].verify_target.item[i];
        max = minimum(max, gTaskList[verifytasknumber].remain_verify_sectors[d]);
    }

    return max;
}

/****************************************************************************************************
Function : translateCurrentCHS
Description : This function automatically computes the translation values for heads and cylinders.
Inputs : CurrHeads is current physical number of heads
 CurrCyls is current physical number of cylinders
Outputs : XHeads is new translated value of heads
 XCyls is new translated value of cylinders
Returns : 1 if translation successful, 0 if otherwise
****************************************************************************************************/

short CSystemD105::translateCurrentCHS(unsigned long CurrHeads, unsigned long CurrCyls,
                                       unsigned short &XHeads, unsigned short &XCyls)
{
    short result = 1; // assume everything will be ok
    short P2Arr[] = {16, 32, 64, 128, 256};
    short i;

    // Set initial values
    XHeads = CurrHeads;
    XCyls = CurrCyls;

    // No need to translate if cylinders are less than or equal to 1024

    if (CurrCyls > 1024)
    {
        // Perform 'standard' translation

        while ((XCyls > 1024) && (XHeads <= 128))
        {
            XCyls = XCyls / 2;
            XHeads = XHeads * 2;
        }

        // If the translated heads result must be a power of 2
        // then perform translation to produce appropriate result

        if (systemOption.heads_eq_pwr2_enable)
        {
            // Round up to the next power of 2 unless the XHeads value
            // is already a power of 2. In that case keep the original
            // value.

            for (i = 0; (i < 4) && (XHeads > P2Arr[i]); i++);

            // Perform adjusted translation
            XHeads = P2Arr[i];

            XCyls = (unsigned short)((unsigned long)((unsigned long) CurrHeads * (unsigned long) CurrCyls) /
                                     (unsigned long) XHeads);
        }

        // handle interrupt 13 situation
        if (systemOption.int13f8_enable)
        {
            if (XHeads > 240)
            {
                XHeads = 240;
                XCyls = (unsigned short)(unsigned long)(((unsigned long)CurrCyls * (unsigned long)CurrHeads) /
                                                        (unsigned long) XHeads);

                if (XCyls > 1023)
                    XCyls = 1023;
            }
        }

        // Head values >= 256 are not allowed so reduce heads to 255
        // recalculate

        if (XHeads >= 256)
        {
            XHeads = 255; // FDISK seems to do translation this way
            XCyls = (unsigned short)((unsigned long)((unsigned long) CurrHeads * (unsigned long) CurrCyls) /
                                     (unsigned long) XHeads);
        }

        // Reduce cylinder value to lower 10 bits

        XCyls &= 0x3FF;

    } // End of clause for condition Cylinders > 1024

    return result;
}

/************************************************************************
Function : matchGeometryToSource()
Description : compare the geometry of target disk to source disk's
Input : target disk number
Output : none
Return : 1 if target disk and source disk have same geometries; 0 if otherwise.
*************************************************************************/
short CSystemD105::matchGeometryToSource(short d)
{	
    return 1;

    if ((gDriveInfo[d].NumCurrSectors == gDriveInfo[0].NumCurrSectors) && (gDriveInfo[d].NumCurrHeads == gDriveInfo[0].NumCurrHeads))
    {
        return 1;
    }

    return 0;
}
//////////////////////////////////////////////////////////////////////////
//
inline unsigned long convert2long(char byte1, char byte2, char byte3, char byte4)
{
    unsigned long ltemp;

    ltemp = byte1 & 0x000000FF;
    ltemp += (byte2 & 0x000000FF)<<8;
    ltemp += (byte3 & 0x000000FF)<<16;
    ltemp += (byte4 & 0x000000FF)<<24;

    return ltemp;
}
//////////////////////////////////////////////////////////////////////////
//
inline int findSignatureOfDisk(char *buffer, unsigned long disk_signature, int pos[10])
{
    int idx = 0;
    int buf_length = SECTOR_SIZE;

    for(idx = 0; idx < 10; idx++)
    {
        pos[idx] = -1;
    }

    unsigned short i = 0;
    for(idx = 0; idx < buf_length; idx = idx + 4)
    {
        if(convert2long(buffer[idx],buffer[idx + 1],buffer[idx + 2],buffer[idx + 3]) == disk_signature)
        {
            pos[i] = idx;
            i++;
        }
    }
    if(i == 0)
    {
        return -1;
    }
    return 0;
}
//////////////////////////////////////////////////////////////////////////
//
inline void setStartSector(char *buffer, int pos , int selected_partition, unsigned long start_sector)
{
    selected_partition = selected_partition;
    unsigned long value = start_sector * 2;
    //printf("value in buffer %08lX\n",value);
    buffer[pos - 23] = (char)(value & 0x000000FF);
    buffer[pos - 22] = (char)((value & 0x0000FF00)>>8);
    buffer[pos - 21] = (char)((value & 0x00FF0000)>>16);
    buffer[pos - 20] = (char)((value & 0xFF000000)>>24);
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::releaseClusterArray (unsigned long* clusArray[MAX_DISKS])
{
    for (short disk = 0; disk < MAX_DISKS; disk++)
    {
        if (clusArray[disk])
        {
            free (clusArray[disk]);
            clusArray[disk] = NULL;
        }
    }
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::updateBootConfigureDataFile(int action)
{
    unsigned long *indexSectorsBCDFile[MAX_DISKS];
    unsigned long cluster_total[MAX_DISKS], disk_signature, cluster_count = 0;
    short disk;
    char buffer[512];
    char filename[50];
    unsigned long start_sector = 0, cluster_size;
    int selected_partition = 0;

    strcpy(filename,"/Boot/BCD");
    filename[strlen(filename)] = '\0';
    initClusterArray(indexSectorsBCDFile);

    if(action == FAT_32_PAR_SMART)
    {
        cluster_total[0] = gFAT32Smart->parseFileToSectors(0, filename, indexSectorsBCDFile[0]);
        if(cluster_total[0] == UNSUCCESS)
        {
            printDFXLog (PRI_INFO, "%s", "File system has none BCD file.");
            releaseClusterArray (indexSectorsBCDFile);
            return	UNSUCCESS;
        }
        else
        {
            printDFXLog (PRI_INFO, "%s", "File system has BCD file.");
        }
        //Read MBR to get signature of disk
        if (this->diskIOModule.readSectors(0, 0, 1, (unsigned short*)buffer) == UNFINISHED)
        {
            releaseClusterArray (indexSectorsBCDFile);
            return UNFINISHED;
        }
        disk_signature = convert2long(buffer[0x1B8],buffer[0x1B9],buffer[0x1BA],buffer[0x1BB]);
        //gTaskList[currentTask].target.partitionStart[disk];
        // Parse BCD file for targets disks
        for (disk = 1;disk < MAX_DISKS;disk++)
        {
            if (gTaskList[currentTask].target.item[disk])
            {
                indexSectorsBCDFile[disk] = NULL;
                strcpy(filename,"/Boot/BCD");
                filename[strlen(filename)] = '\0';
                cluster_total[disk] = gFAT32Smart->parseFileToSectors(disk, filename, indexSectorsBCDFile[disk]);
                cluster_count = 0;
                cluster_size = gFAT32Smart->getClusterSize(disk);
                //printf("parseFileToSectors of Target %d-------cluster_size %lu\n",disk, cluster_size);
                while(cluster_count < cluster_total[disk])
                {
                    for(unsigned long st = 0; st < cluster_size; st++)
                    {
                        if (this->diskIOModule.readSectors(disk,indexSectorsBCDFile[disk][cluster_count] + st, 1, (unsigned short*)buffer) == UNFINISHED)
                        {
                            return UNFINISHED;
                        }

                        // find signature in sector
                        int pos[10], idx = 0;
                        if(findSignatureOfDisk(buffer, disk_signature, pos) == 0)
                        {
                            while(pos[idx] >= 0)
                            {
                                //find start sector of partition
                                start_sector = convert2long(buffer[pos[idx] - 23],buffer[pos[idx] - 22],buffer[pos[idx] - 21],buffer[pos[idx] - 20]);
                                //printf("1--%02X---2--%02X---3--%02X---4--%02X\n",buffer[pos[idx] - 23],buffer[pos[idx] - 22],buffer[pos[idx] - 21],buffer[pos[idx] - 20]);
                                //printf("\nPos of signature of disk %d ---- start sector = 0x%08lX\n",pos[idx], start_sector);
                                start_sector /= 2;
                                if(start_sector != 0x3F)
                                {
                                    selected_partition = getOperationSystemPartition(start_sector);
                                    if(selected_partition != -1)
                                    {
                                        setStartSector(buffer, pos[idx], selected_partition, diskStruct[disk].partition_list.partition[selected_partition].start_sector);
                                        if (this->diskIOModule.writeSectors(disk, indexSectorsBCDFile[disk][cluster_count] + st, 1, (unsigned short*) buffer) != SUCCESS)
                                        {
                                            return UNSUCCESS;
                                        }

                                        if((this->diskIOModule.getActionMode() == DUPLICATING_MODE) && ((this->systemOption.verify_Mode == 1) || (this->isVerifyCurrentJob == true))) /*!< Sectors not verify in verify process (TamHo added 13/5/2011). */
                                        {
                                            this->diskIOModule.insertSectorListNotVerify(disk, indexSectorsBCDFile[disk][cluster_count] + st, 1);
                                        }
                                    }
                                }
                                idx++;
                            }
                        }
                    }
                    cluster_count++;
                }
            }
        }
    }
    else
        if (action == NTFS_PAR_SOURCE_SMALLER_TARGET)
        {
            indexSectorsBCDFile[0] = NULL;
            strcpy(filename,"/Boot/BCD");
            filename[strlen(filename)] = '\0';

            cluster_total[0] = gNtfsCopy->parseFileToSectors(0, filename, indexSectorsBCDFile[0]);
            if( cluster_total[0] == UNSUCCESS)
            {
                printDFXLog (PRI_INFO, "%s", "File system has none BCD file.");
                return	UNSUCCESS;
            }
            else
            {
                printDFXLog (PRI_INFO, "%s", "File system has BCD file.");
            }
            //Read MBR to get signature of disk
            if (this->diskIOModule.readSectors(0, 0, 1, (unsigned short*)buffer) == UNFINISHED)
            {
                releaseClusterArray (indexSectorsBCDFile);
                return UNFINISHED;
            }
            disk_signature = convert2long(buffer[0x1B8],buffer[0x1B9],buffer[0x1BA],buffer[0x1BB]);
            for (disk = 1;disk < MAX_DISKS;disk++)
            {
                if (gTaskList[currentTask].target.item[disk])
                {
                    indexSectorsBCDFile[disk] = NULL;
                    strcpy(filename,"/Boot/BCD");
                    filename[strlen(filename)] = '\0';
                    cluster_total[disk] = gNtfsCopy->parseFileToSectors(disk, filename, indexSectorsBCDFile[disk]);
                    cluster_count = 0;
                    cluster_size = gNtfsCopy->getClusterSize();
                    // printf("parseFileToSectors of Target %d-------cluster_total %lu\n",disk, cluster_total[disk] );
                    while(cluster_count < cluster_total[disk])
                    {
                        for(unsigned long st = 0; st < cluster_size; st++)
                        {
                            if(this->diskIOModule.readSectors(disk, indexSectorsBCDFile[disk][cluster_count] + st, 1, (unsigned short*)buffer) == UNFINISHED)
                            {
                                return UNFINISHED;
                            }

                            // find signature in sector
                            int pos[10], idx = 0;

                            if(findSignatureOfDisk(buffer, disk_signature, pos) == 0)
                            {
                                while(pos[idx] >= 0)
                                {
                                    //find start sector of partition
                                    start_sector = convert2long(buffer[pos[idx] - 23],buffer[pos[idx] - 22],buffer[pos[idx] - 21],buffer[pos[idx] - 20]);
                                    //printf("1--%02X---2--%02X---3--%02X---4--%02X\n",buffer[pos[idx] - 23],buffer[pos[idx] - 22],buffer[pos[idx] - 21],buffer[pos[idx] - 20]);
                                    //printf("\nPos of signature of disk %d ---- start sector = 0x%08lX\n",pos[idx], start_sector);
                                    start_sector /= 2;
                                    if(start_sector != 0x3F)
                                    {
                                        selected_partition = getOperationSystemPartition(start_sector);
                                        if(selected_partition != -1)
                                        {
                                            setStartSector(buffer, pos[idx], selected_partition, diskStruct[disk].partition_list.partition[selected_partition].start_sector);
                                            if (this->diskIOModule.writeSectors(disk, indexSectorsBCDFile[disk][cluster_count] + st, 1, (unsigned short*) buffer) != SUCCESS)
                                            {
                                                return UNSUCCESS;
                                            }
                                        }

                                        if((this->diskIOModule.getActionMode() == DUPLICATING_MODE) && ((this->systemOption.verify_Mode == 1) || (this->isVerifyCurrentJob == true))) /*!< Sectors not verify in verify process (TamHo added 13/5/2011). */
                                        {
                                            this->diskIOModule.insertSectorListNotVerify(disk, indexSectorsBCDFile[disk][cluster_count] + st, 1);
                                        }
                                    }
                                    idx++;
                                }
                            }
                        }
                        cluster_count++;
                    }
                }
            }

        }
    releaseClusterArray (indexSectorsBCDFile);
    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
// DUONGVU MODIFIED HERE
int CSystemD105::swapCheckHeader(const union SWAP_HEADER *sh)
{
    swap_partition swap_info;
    if(memcmp(sh->magic.magic,"SWAP-SPACE",10)==0)
    {
        swap_info.parttype = 1;
        return 0;
    }
    if(memcmp(sh->magic.magic,"SWAPSPACE2",10)==0)
    {
        if(sh->info.last_page==0)
            return 1;

        swap_info.parttype = 2;
        return 0;
    }
    return 1;
}
//////////////////////////////////////////////////////////////////////////
//
unsigned short CSystemD105::checkExt2fsIsSwapPartition(unsigned long start_sector)
{
    unsigned char swap_buf[SWAP_SIZE];
    int stat;
    stat = this->diskIOModule.readSectors(0, start_sector, 8, (unsigned short *) & swap_buf);
    if (stat != 1)
    {
        fprintf(stderr,"Can't read this area\n");
        return 0;
    }

    stat = swapCheckHeader((union SWAP_HEADER*)&swap_buf);
    if((stat==0)||(stat==2))
    {
        fprintf(stderr,"RAID: SWAP-SPACE \n");
        return 1;
    }
    return 0;
}
//////////////////////////////////////////////////////////////////////////
//
unsigned long CSystemD105::getNextFieldFromBuffer(char *buff, char *field, unsigned long &offset)
{
    unsigned long  i = offset;
    unsigned long  j = 0;
    while(buff[i] != 0x0A && buff[i] != '\0' && j < 255)
    {
        field[j]  = buff[i];
        i++;
        j++;
    }
    field[j]  = buff[i];
    field[j + 1] = '\0';
    offset += (j + 1);
    return j;

}
//////////////////////////////////////////////////////////////////////////
//
unsigned long CSystemD105::getDigitalFieldFromBuffer(char *buff, const char *field, unsigned long &offset)
{
    char result[20];
    unsigned long i = 0,j = 0;
    unsigned long field_value = 0;
    char *pointer = buff + offset;
    char  *strtmp = strstr(pointer,field);
    strcpy(result,"0");
    if(strtmp == NULL)
    {
        return 0;
    }
    offset += (unsigned long)(strtmp - pointer);
    while(strtmp[i] != 0x0A)
    {
        if(strtmp[i] >= 0x30 && strtmp[i] <= 0x39)
        {
            result[j] = strtmp[i];
            j++;
        }
        i++;
    }
    result[j] = '\0';
    printf("chuoi lay duoc %s---------so lay duoc %lu\n",result,atol(result));
    field_value = atol(result);
    if(field_value != 0)
    {
        offset += i;
    }
    return field_value;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::readLVMArea(short disk, unsigned long sectorStart, unsigned long sectorCount, char* buffer)
{
    char* pointer = buffer;
    unsigned long sectors;
    while (sectorCount)
    {
        sectors = min(sectorCount, 64);

        if (!this->diskIOModule.readSectors(disk, sectorStart, sectors, (unsigned short*) pointer))
        {
            //HandleIOError(IO_READ_DISK, 0, 0, HANDLE_FORMAT_DISK);
            return UNSUCCESS;
        }

        pointer += (sectors * 512) ;

        sectorStart += sectors;
        sectorCount -= sectors;
    }
    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//
void strimNull(char *str, unsigned long length,unsigned long &offset)
{
    while(offset < length && offset % 512 != 0)
    {
        str++;
        offset++;
    }
}

//////////////////////////////////////////////////////////////////////////
// Calculate an endian-independent CRC of supplied buffer
uint32_t calcCRC(uint32_t initial, void *buf, uint32_t size)
{
    static const uint32_t crctab[] =
    {
        0x00000000, 0x1db71064, 0x3b6e20c8, 0x26d930ac,
        0x76dc4190, 0x6b6b51f4, 0x4db26158, 0x5005713c,
        0xedb88320, 0xf00f9344, 0xd6d6a3e8, 0xcb61b38c,
        0x9b64c2b0, 0x86d3d2d4, 0xa00ae278, 0xbdbdf21c
    };
    uint32_t i, crc = initial;
    uint8_t *data = (uint8_t *) buf;

    for(i = 0; i < size; i++)
    {
        crc ^= *data++;
        crc = (crc >> 4) ^ crctab[crc & 0xf];
        crc = (crc >> 4) ^ crctab[crc & 0xf];
    }
    return crc;
}
//////////////////////////////////////////////////////////////////////////
//
unsigned long CSystemD105::getLastBuffOfLVMArea(char *buff,unsigned long buff_length)
{
    unsigned long seqno = 0, offset = 0;
    unsigned long max_seqno = 0,max_offset = 0;
    while(offset < buff_length)
    {
        seqno = getDigitalFieldFromBuffer(buff, "seqno", offset);
        if(seqno != 0)
        {
            if((seqno > max_seqno) && (getDigitalFieldFromBuffer(buff, "extent_count", offset) != 0))
            {
                max_seqno = seqno;
                max_offset = offset;
            }
            while(offset < buff_length && offset % SECTOR_SIZE != 0)
            {
                offset++;
            }
        }
        else
        {
            offset += SECTOR_SIZE;
        }
    }
    while((max_offset % SECTOR_SIZE) != 0)
        max_offset--;
    return max_offset;
}
//////////////////////////////////////////////////////////////////////////
//
unsigned short CSystemD105::getLogVolsOfVolGroupFromMasterDisk(char *buff,unsigned long buff_length)
{
    unsigned short number_of_log_vol = 0;
    unsigned long seqno = 0, offset = 0;
    while(offset < buff_length)
    {
        seqno = getDigitalFieldFromBuffer(buff, "seqno", offset);
        if(seqno != 0)
        {
            if(getDigitalFieldFromBuffer(buff, "extent_count", offset))
            {
                number_of_log_vol = seqno - 1;
            }
            while(offset < buff_length && offset % SECTOR_SIZE != 0)
            {
                offset++;
            }
        }
        else
        {
            offset += SECTOR_SIZE;
        }
    }

    return number_of_log_vol;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setPhysicalVolumeStructForMasterDisk(char* buff)
{
    unsigned long offset = 0;
    gPhysicalVolume[0].pe_size = getDigitalFieldFromBuffer(buff, "extent_size", offset);
    gPhysicalVolume[0].pv_size = getDigitalFieldFromBuffer(buff, "dev_size", offset);
    gPhysicalVolume[0].pe_allocated = getDigitalFieldFromBuffer(buff, "pe_start", offset);
    gPhysicalVolume[0].pe_total = getDigitalFieldFromBuffer(buff, "pe_count", offset);

    printf("-------Physical Volume of Master Disk----------\n");
    printf(" PV Size = %ul\n",gPhysicalVolume[0].pv_size);
    printf(" PE Size = %ul\n",gPhysicalVolume[0].pe_size);
    printf(" PE Total = %ul\n",gPhysicalVolume[0].pe_total);
    printf(" PE Allocated = %ul\n",gPhysicalVolume[0].pe_allocated);
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setPhysicalVolumeStructForTargetDisk(unsigned short tgdisk, unsigned long pv_size)
{
    gPhysicalVolume[tgdisk].pe_size = gPhysicalVolume[0].pe_size;
    gPhysicalVolume[tgdisk].pe_total = pv_size / gPhysicalVolume[tgdisk].pe_size;
    gPhysicalVolume[tgdisk].pe_allocated = gPhysicalVolume[0].pe_allocated;
    gPhysicalVolume[tgdisk].pv_size = pv_size;
    printf("-------Physical Volume of Target Disk %d----------\n", tgdisk);
    printf(" PV Size = %ul\n",gPhysicalVolume[tgdisk].pv_size);
    printf(" PE Size = %ul\n",gPhysicalVolume[tgdisk].pe_size);
    printf(" PE Total = %ul\n",gPhysicalVolume[tgdisk].pe_total);
    printf(" PE Allocated = %ul\n",gPhysicalVolume[tgdisk].pe_allocated);
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setLogicalVolumeStructForMasterDisk(char *buff,unsigned short idx_lvm, unsigned short num_of_logvol)
{
    char *pointer_buff = buff;
    int idx_log_vol = 0;
    unsigned long offset = 0;
    unsigned long start_sector_of_master_lvm = diskStruct[0].partition_list.partition[idx_lvm].start_sector;
    printf("-------------SOURC DISK --------------\n");

    for(idx_log_vol = 0; idx_log_vol < num_of_logvol; idx_log_vol++)
    {
        if(idx_log_vol == 0)
        {
            strcpy((char*)gLogicalVolume[0][idx_log_vol].log_vol_name ,"LogVol00");
            gLogicalVolume[0][idx_log_vol].extent_count = getDigitalFieldFromBuffer(pointer_buff, "extent_count", offset);
            //printf("extent count 1 %lu-----offset %lu\n",gLogicalVolume[0][idx_log_vol].extent_count,offset);
            gLogicalVolume[0][idx_log_vol].number_of_sectors = gLogicalVolume[0][idx_log_vol].extent_count * gPhysicalVolume[0].pe_size;
            gLogicalVolume[0][idx_log_vol].start_sector = start_sector_of_master_lvm + gPhysicalVolume[0].pe_allocated;
        }
        else
        {
            strcpy((char*)gLogicalVolume[0][idx_log_vol].log_vol_name ,"LogVol01");
            gLogicalVolume[0][idx_log_vol].extent_count = getDigitalFieldFromBuffer(pointer_buff, "extent_count", offset);
            //printf("extent count 2  %lu----------offset %lu\n",gLogicalVolume[0][idx_log_vol].extent_count,offset);
            gLogicalVolume[0][idx_log_vol].number_of_sectors = gLogicalVolume[0][idx_log_vol].extent_count * gPhysicalVolume[0].pe_size;
            gLogicalVolume[0][idx_log_vol].start_sector = gLogicalVolume[0][idx_log_vol - 1].start_sector + gLogicalVolume[0][idx_log_vol - 1].number_of_sectors;
        }

        printf(" Volume Name = %s\n",gLogicalVolume[0][idx_log_vol].log_vol_name);
        printf(" Start Sector= %lu\n",gLogicalVolume[0][idx_log_vol].start_sector);
        printf(" Number of Sector = %lu\n",gLogicalVolume[0][idx_log_vol].number_of_sectors);
        printf(" Extent Count = %lu\n",gLogicalVolume[0][idx_log_vol].extent_count);
        printf(" ----------------------------------------------------------\n");
    }
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setLogicalVolumeStructForTargetDisk(unsigned short tgdisk, unsigned short idx_lvm, unsigned short num_of_logvol, double ratio)
{
    int idx_log_vol = 0;
    unsigned long start_sector_of_target_lvm = diskStruct[tgdisk].partition_list.partition[idx_lvm].start_sector;
    unsigned long pe_size = gPhysicalVolume[tgdisk].pe_size;
    unsigned long extent_total = 0;

    for(idx_log_vol = 0; idx_log_vol < num_of_logvol; idx_log_vol++)
    {
        strcpy((char*)gLogicalVolume[tgdisk][idx_log_vol].log_vol_name,(char*)gLogicalVolume[0][idx_log_vol].log_vol_name);
        if(checkExt2fsIsSwapPartition(gLogicalVolume[0][idx_log_vol].start_sector))
        {
            gLogicalVolume[tgdisk][idx_log_vol].number_of_sectors = gLogicalVolume[0][idx_log_vol].number_of_sectors;
            gLogicalVolume[tgdisk][idx_log_vol].extent_count = gLogicalVolume[0][idx_log_vol].extent_count;
            extent_total += gLogicalVolume[tgdisk][idx_log_vol].extent_count;
        }
        else
        {
            gLogicalVolume[tgdisk][idx_log_vol].extent_count = (unsigned long)(gLogicalVolume[0][idx_log_vol].extent_count * ratio);
            gLogicalVolume[tgdisk][idx_log_vol].number_of_sectors = gLogicalVolume[tgdisk][idx_log_vol].extent_count * pe_size;
            extent_total += gLogicalVolume[tgdisk][idx_log_vol].extent_count;
        }
        if(idx_log_vol == 0)
        {
            gLogicalVolume[tgdisk][idx_log_vol].start_sector = start_sector_of_target_lvm + gPhysicalVolume[tgdisk].pe_allocated;
        }
        else
        {
            gLogicalVolume[tgdisk][idx_log_vol].start_sector = gLogicalVolume[tgdisk][idx_log_vol - 1].start_sector + gLogicalVolume[tgdisk][idx_log_vol - 1].number_of_sectors;
        }
        printf("1: Volume Name = %s\n",gLogicalVolume[tgdisk][idx_log_vol].log_vol_name);
        printf("2: Start Sector= %lu\n",gLogicalVolume[tgdisk][idx_log_vol].start_sector);
        printf("3: Number of Sector = %lu\n",gLogicalVolume[tgdisk][idx_log_vol].number_of_sectors);
        printf("4: Extent Count = %lu\n",gLogicalVolume[tgdisk][idx_log_vol].extent_count);
        printf(" ----------------------------------------------------------\n");
    }

    gLogicalVolume[tgdisk][0].extent_count -= 1;
    gLogicalVolume[tgdisk][0].number_of_sectors = gLogicalVolume[tgdisk][0].extent_count * pe_size;


    //gLogicalVolume[tgdisk][0].number_of_sectors += 2 * pe_size;
    //Update Logical Volume For TargetDisk
    /*unsigned long odd_extent = gPhysicalVolume[tgdisk].pe_total - extent_total - 1;
 gLogicalVolume[tgdisk][0].number_of_sectors += odd_extent * pe_size;
 unsigned long odd_sector = 0;
 unsigned long limit_sector = pe_size / 2;
 if(ratio != 1)
 {
  for(idx_log_vol = 0; idx_log_vol < num_of_logvol; idx_log_vol++)
  {
   if(idx_log_vol != 0)
   {
    gLogicalVolume[tgdisk][idx_log_vol].start_sector = gLogicalVolume[tgdisk][idx_log_vol - 1].start_sector + gLogicalVolume[tgdisk][idx_log_vol - 1].number_of_sectors;
   }
   gLogicalVolume[tgdisk][idx_log_vol].extent_count = gLogicalVolume[tgdisk][idx_log_vol].number_of_sectors / gPhysicalVolume[tgdisk].pe_size;

   printf(" Volume Name = %s\n",gLogicalVolume[tgdisk][idx_log_vol].log_vol_name);
                        printf(" Start Sector= %lu\n",gLogicalVolume[tgdisk][idx_log_vol].start_sector);
                        printf(" Number of Sector = %lu\n",gLogicalVolume[tgdisk][idx_log_vol].number_of_sectors);
                        printf(" Extent Count = %lu\n",gLogicalVolume[tgdisk][idx_log_vol].extent_count);
   printf(" ----------------------------------------------------------\n");
  }

 }*/
}
//////////////////////////////////////////////////////////////////////////
//
void updateField(char *field, unsigned long value)
{
    char tmp[20];
    snprintf(tmp, sizeof(tmp),"%lu",value);
    unsigned short i = 0,pos = 0;
    while(field[pos] != 0x3D) pos++;
    field[pos + 1] = 0x20;
    pos += 2;
    while(tmp[i] >= 0x30 && tmp[i] <= 0x39)
    {
        field[pos] = tmp[i];
        i++;
        pos++;
    }
    field[pos] = 0x0A;
    field[pos + 1] = '\0';
}
//////////////////////////////////////////////////////////////////////////
//
void setFieldForBuffer(char* buffer, char *field, unsigned long &offset)
{
    unsigned short i = 0;
    while(field[i] != '\0')
    {
        buffer[offset] = field[i];
        offset++;
        i++;
    }
}
//////////////////////////////////////////////////////////////////////////
//
int CSystemD105::createLVMBufferForTargetDisk(unsigned long tgdisk_number,char *source_buffer, char *target_buffer, unsigned long buff_length)
{
    char field[512];
    unsigned long next_offset = 0,target_offset = 0;
    //showBufferInByte((unsigned short*)source_buffer, 512*7, "");
    unsigned long count = 0;
    //printf(" buffer length %lu---next offset %lu---- field %s\n",buff_length,next_offset, field);
    int short count_logical_volume = 0, lvm_size = 0;
    unsigned long distance = 0;
    while(next_offset < buff_length)
    {

        count = getNextFieldFromBuffer(source_buffer, field, next_offset);
        if(field != 0)
        {
            if(strncmp(field, "dev_size", 8) == 0)
            {
                updateField(field, gPhysicalVolume[tgdisk_number].pv_size);
            }
            else if(strncmp(field, "pe_count", 8) == 0)
            {
                updateField(field, gPhysicalVolume[tgdisk_number].pe_total);
            }
            else if(strncmp(field, "extent_count", 12) == 0)
            {
                updateField(field, gLogicalVolume[tgdisk_number][count_logical_volume].extent_count);
                count_logical_volume++;
                lvm_size = (next_offset + SECTOR_SIZE - 1) / SECTOR_SIZE + 1;
            }
            else if(strncmp(field, "stripes", 7) == 0)
            {
                field[12] = '\0';
                //fprintf(stderr,"truong lay duoc la %s\n", field);
                setFieldForBuffer(target_buffer,field, target_offset);
                char stripes[20];
                snprintf(stripes, sizeof(stripes), "%lu",distance);
                count = getNextFieldFromBuffer(source_buffer, field, next_offset);
                int i = 0,j = 0, len;
                len = strlen(stripes);
                while(field[i] != 0x20) i++;
                i = i + 1;
                for(j = 0; j < len; j++)
                {
                    field[i] = stripes[j];
                    i++;
                }
                field[i] = 0x0A;
                field[i + 1] = '\0';
                setFieldForBuffer(target_buffer,field, target_offset);
                distance += gLogicalVolume[tgdisk_number][count_logical_volume - 1].extent_count;
                field[0] = '\0';
            }

            if(source_buffer[next_offset] == 0)
            {
                field[0] = 0x0A;
                field[1] = '\0';
                setFieldForBuffer(target_buffer,field, target_offset);

                while(next_offset < buff_length && next_offset % SECTOR_SIZE != 0)
                {
                    next_offset++;
                }

                count_logical_volume = 0;
                distance = 0;
                target_offset = next_offset;
                //fprintf(stderr," Next offset %lu---- target_offset %lu\n",next_offset, target_offset);
                field[0] = '\0';
            }

            if(field[0] != '\0' && strncmp(field, "stripes", 7) != 0)
            {
                setFieldForBuffer(target_buffer,field, target_offset);
            }
        }
    }
    return lvm_size;
}
//////////////////////////////////////////////////////////////////////////
//
int CSystemD105::createLVMPartitionForTargetDisk(unsigned short idx_par,unsigned long tgdisk_number)
{
    printf("\n------------ Test LVM---------------\n");
    char buffer[512];
    short errorCode = 0;
    int i;
    unsigned short num_of_logvol;
    // Process LVM area
    //LVM label header
    errorCode = this->diskIOModule.readSectors(0, diskStruct[0].partition_list.partition[idx_par].start_sector + 1, 1, (unsigned short *) & buffer);
    if (errorCode != 1)
    {
        HandleIOError(IO_READ_DISK, 0, diskStruct[0].partition_list.partition[idx_par].start_sector + 1, HANDLE_FORMAT_DISK);
        return  0;
    }

    lvm2_label_header lvm_header;
    memcpy(&lvm_header,&buffer,sizeof(lvm2_label_header));
    if(strncmp((char*)lvm_header.id,"LABELONE",8) != 0)
    {
        printf("------------There are not any volume group------------\n");
        return ERRORED;
    }
    printf("crc lvm %ul\n",lvm_header.crc_xl);
    printf("Offset from start of struct to contents %ul\n",lvm_header.offset_xl);

    uint32_t tam = calcCRC(INITIAL_CRC, buffer+0x14, LABEL_SIZE-0x14);
    printf("crc lvm %ul\n",tam);
    //LVM pv header

    errorCode = this->diskIOModule.readSectors(0, diskStruct[0].partition_list.partition[idx_par].start_sector + 8, 1, (unsigned short *) & buffer);
    if (errorCode != 1)
    {
        HandleIOError(IO_READ_DISK, 0, diskStruct[0].partition_list.partition[idx_par].start_sector + 8, HANDLE_FORMAT_DISK);
        return  0;
    }

    lvm2_pv_header lvm_pv_header;
    memcpy(&lvm_pv_header,&buffer,sizeof(lvm2_pv_header));
    /*printf("device_size_xl %llu\n",lvm_pv_header.device_size_xl);
 printf("offset %llu\n",lvm_pv_header.disk_areas_xl[0].offset);
 printf("size %llu\n",lvm_pv_header.disk_areas_xl[0].size);
 */
    showBufferInByte((unsigned short*)buffer,512 ,"");

    /////////////////////////////////////////////////////////////////////
    ///////////////////////////VOLUME GROUP//////////////////////////////
    /////////////////////////////////////////////////////////////////////
    errorCode = this->diskIOModule.readSectors(0, diskStruct[0].partition_list.partition[idx_par].start_sector + 9, 1, (unsigned short *) & buffer);
    if (errorCode != 1)
    {
        HandleIOError(IO_READ_DISK, 0, diskStruct[0].partition_list.partition[idx_par].start_sector + 9, HANDLE_FORMAT_DISK);
        return  0;
    }
    unsigned long off = 0;
    unsigned long lvm_information_buff_size = getDigitalFieldFromBuffer(buffer,"pe_start", off);
    printf("^^^^^number of lvm_information_buff_size: = %lu\n",lvm_information_buff_size);

    //Duplicate LVM structure area about 384 sector
    ITEM_LIST_STRUCT outputErrorList;
    for (i = 1; i < MAX_DISKS; i++)
    {
        gLiveTargetList.startSector[i] = diskStruct[tgdisk_number].partition_list.partition[idx_par].start_sector;
        //printf("gLiveTargetList.sectorStart[%d] %lu\n",tgdisk_number,gLiveTargetList.sectorStart[i]);
    }

    gLiveTargetList.startSector[0] = diskStruct[0].partition_list.partition[idx_par].start_sector;

    gLiveTargetList.sectorCount = lvm_information_buff_size;
    gLiveTargetList.item[0] = 1;
    gLiveTargetList.item[tgdisk_number] = 1;
    errorCode = diskIOModule.doTransferData(gLiveTargetList, outputErrorList);
    if (errorCode != 1)
    {
        printf("------------Duplicate error------------\n");
        return ERRORED;
    }

    char *lvm_information_source_buff = (char*)malloc(lvm_information_buff_size * SECTOR_SIZE );

    if(lvm_information_source_buff == NULL)
    {
        fprintf(stderr,"Source:  buffer of lvm information isn't allocated\n");
        return 0;
    }

    errorCode = this->diskIOModule.readSectors(0, diskStruct[0].partition_list.partition[idx_par].start_sector + 9, lvm_information_buff_size - 9, (unsigned short *)lvm_information_source_buff);
    //errorCode = readLVMArea(0, diskStruct[0].partition_list.partition[idx_par].start_sector + 9, lvm_information_buff_size, lvm_information_source_buff);
    if (errorCode != 1)
    {
        free(lvm_information_source_buff);
        HandleIOError(IO_READ_DISK, 0, diskStruct[0].partition_list.partition[idx_par].start_sector + 9, HANDLE_FORMAT_DISK);
        printf("duongvu: debug error\n");
        return  0;
    }
    //showBufferInByte((unsigned short*)lvm_information_source_buff, 512*4, "");
    num_of_logvol = getLogVolsOfVolGroupFromMasterDisk(lvm_information_source_buff,lvm_information_buff_size * SECTOR_SIZE);

    printf("number of logical volume in a Volume Group = %d\n",num_of_logvol);

    // calculate number of partition of LVM area
    setPhysicalVolumeStructForMasterDisk(buffer);

    unsigned long last_offset = getLastBuffOfLVMArea(lvm_information_source_buff,(lvm_information_buff_size - 9) * SECTOR_SIZE);

    setLogicalVolumeStructForMasterDisk(lvm_information_source_buff + last_offset, idx_par, num_of_logvol);
    double rate = 0.00;
    unsigned long source_free_space  = diskStruct[0].partition_list.partition[idx_par].number_of_sectors - gPhysicalVolume[0].pe_allocated;
    unsigned long target_free_space = diskStruct[tgdisk_number].partition_list.partition[idx_par].number_of_sectors - gPhysicalVolume[0].pe_allocated;

    for(i = 0; i < num_of_logvol; i++)
    {
        if(checkExt2fsIsSwapPartition(gLogicalVolume[0][i].start_sector) && gLogicalVolume[0][i].number_of_sectors > target_free_space)
        {
            fprintf(stderr,"Swap partition is too large\n");
            return 0;
        }
        if(checkExt2fsIsSwapPartition(gLogicalVolume[0][i].start_sector))
        {
            source_free_space -=  gLogicalVolume[0][i].number_of_sectors;
            target_free_space -=  gLogicalVolume[0][i].number_of_sectors;
        }
    }
    printf("S = %lu------T = %lu\n",source_free_space,target_free_space);
    rate =  (float)target_free_space / source_free_space;


    fprintf(stderr,"=============ratio = %3.4f\n",rate);
    printf("-------------DISK %lu--------------\n",tgdisk_number);

    setPhysicalVolumeStructForTargetDisk(tgdisk_number, diskStruct[tgdisk_number].partition_list.partition[idx_par].number_of_sectors);

    printf("--------Logical Volume----------\n");
    setLogicalVolumeStructForTargetDisk(tgdisk_number, idx_par, num_of_logvol, rate);
    //Write LVM buffer to target disk
    int lvm_sector_count = 0;

    char *lvm_information_target_buff;

    lvm_information_target_buff = (char*)malloc(lvm_information_buff_size * SECTOR_SIZE);
    if(lvm_information_target_buff == NULL)
    {
        fprintf(stderr,"Target %d: buffer of lvm information isn't allocated\n",i);
        free(lvm_information_source_buff);
        return 0;
    }
    memset(lvm_information_target_buff,0,lvm_information_buff_size * SECTOR_SIZE);

    lvm_sector_count = createLVMBufferForTargetDisk(tgdisk_number, lvm_information_source_buff, lvm_information_target_buff, (lvm_information_buff_size - 9) * SECTOR_SIZE);
    printf("Tong so sector trong vung lvm da thiet lap %dl \n", lvm_sector_count);
    showBufferInByte((unsigned short*)lvm_information_target_buff,lvm_sector_count * SECTOR_SIZE, "");
    errorCode = this->diskIOModule.writeSectors(tgdisk_number, diskStruct[tgdisk_number].partition_list.partition[idx_par].start_sector + 9, lvm_sector_count, (unsigned short*)*&lvm_information_target_buff);
    if (errorCode != 1)
    {
        HandleIOError(IO_WRITE_DISK, tgdisk_number, diskStruct[tgdisk_number].partition_list.partition[idx_par].start_sector + 9, HANDLE_FORMAT_DISK);
        return  ERRORED;
    }
    enum ACTION_TYPE action_type;
    for(i = 0; i< num_of_logvol; i++)
    {
        if(checkExt2fsIsSwapPartition(gLogicalVolume[0][i].start_sector))
        {
            action_type = MIRROR_PAR;
        }
        else
        {
            action_type = EXT2_PAR_SMART;
            //action_type = MIRROR_PAR;
        }
        partnAddTask(tgdisk_number,
                     gLogicalVolume[0][i].start_sector,
                     gLogicalVolume[tgdisk_number][i].start_sector,
                     gLogicalVolume[0][i].number_of_sectors,
                     gLogicalVolume[tgdisk_number][i].number_of_sectors,
                     0, action_type, PE_MIRROR_OVERLAP_SOURCE);
    }

    free(lvm_information_source_buff);

    free(lvm_information_target_buff);

    return 1;
}
//////////////////////////////////////////////////////////////////////////
// DuongVu add code here to copy system sectors from source to target (December 30 2010)
void CSystemD105::copyFirstSectorsOfPartitionToTargets()
{
    DISK_MODE jobType = DISK_SMART;
    for(short disk = 1; disk < MAX_DISKS; disk++)
    {
        if((this->gDriveState[disk] == DRIVE_READY) && (this->gTarget[disk].enable) && (this->gTarget[disk].disk_mode != DISK_SMART))
        {
            jobType = DISK_MIRROR;
            disk    = MAX_DISKS;
        }
    }

    if((jobType == DISK_SMART) || (jobType == DISK_PARTITION))
    {
        if(this->diskIOModule.getActionMode() != VERIFYING_MODE)
        {
            ITEM_LIST_STRUCT inputItemList, outputItemList;
            memset(&inputItemList, 0, sizeof(struct ITEM_LIST_STRUCT));

            inputItemList.startSector[0] = 0;
            inputItemList.item[0] = 1;
            this->diskIOModule.setPartitionStart(0, 0);
            this->diskIOModule.setPartitionLength(0, (unsigned long)gCapacity[0]);
            inputItemList.sectorCount = 2048;
            inputItemList.items = 1;

            for (short disk = 1; disk < MAX_DISKS; disk++)
            {
                if ((this->gDriveState[disk] == DRIVE_READY) && (this->gTarget[disk].enable))
                {
                    inputItemList.startSector[disk] = 0;
                    inputItemList.item[disk] = 1;
                    inputItemList.items++;
                    this->diskIOModule.setPartitionStart(disk, 0);
                    this->diskIOModule.setPartitionLength(disk, (unsigned long)gCapacity[disk]);
                    printDFXLog (PRI_INFO, "Setup 2048 system sectors to copy to target[%d]", disk);
                }
            }

            if(inputItemList.items > 1)
            {
                this->diskIOModule.doTransferData(inputItemList, outputItemList);

                for (short disk = 0; disk < MAX_DISKS; disk++)
                {
                    if ((inputItemList.item[disk] == 1) && (outputItemList.item[disk] == 0))
                    {
                        this->HandleIOError(IO_WRITE_DISK, disk, inputItemList.startSector[disk], 0);
                    }
                }
            }
        }
        //Tim start sector cua file stage2
        //Doc start sector cua file stage2 trong MBR
        //Compare neu giong nhau thi bo qua, nguoc lai thi goi setup bootloader
        char MBR_buff[512];
        unsigned long startSectorStage2InMBR = 0;
        this->diskIOModule.readSectors(0, 0, 1, (unsigned short*)MBR_buff);
        startSectorStage2InMBR = convert2long(MBR_buff[0x44], MBR_buff[0x45], MBR_buff[0x46], MBR_buff[0x47]);

        startSectorBootLoaderFile = this->getStartSectorOfFileBootLoader();

        if((startSectorStage2InMBR != 0)                            &&
                (startSectorBootLoaderFile != 0)                         &&
                (startSectorStage2InMBR != startSectorBootLoaderFile)    &&
                (startSectorStage2InMBR != 0x00000001))
        {
            isSetupBootLoaderInBiefCopy = true;
        }
    }
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
 * Adjust partition sizes for target disk and arrange them in list of disk partitions
 * Note: called when users do partition smart copy.
 *
 * [IN] src_size - size of the source disk in sectors
 * [IN] tg_size - size of the target disk in sectors
 * [IN] src_part_list - the PARTITION_ENTRY_LIST struct that contains list of partitions of source
 * [IN] jobstarget - the JOB_STRUCT describes size of partitions of targets that user wants like that.
 * However the size of partitions must be a multiple of disk cylinder size, so we need
 * adjust the values in this list
 * [OUT] tg_part_list - the list of partitions that are adjusted
 *
 * Return one of the followings:
 * 1: succeeded
 * 0: unknown error
 * -1: target not enough space
 */
int CSystemD105::adjustPartitionsForTargetDisk(PARTITION_ENTRY_LIST &src_part_list, unsigned long tgdisk_number,
                                               JOB_STRUCT jobstarget, PARTITION_ENTRY_LIST &tg_part_list)
{
    int i, j, k, first = -1,
            number_of_pri_partitions,
            iRet = 1;
    SEC_CYL_HD sec_cyl;
    int hastoMirror = 0;

    unsigned short sec_per_track,
            src_head_per_cyl,
            head_per_cyl;
    unsigned long long sec_per_cyl, total_src_num_cyls, total_tg_num_cyls;
    unsigned long long ext_tg_num_secs, based_logical_start, start_sector_logical;
    //unsigned char bysector, bycylinder, byhead;
    int src_partno;
    unsigned long src_size, tg_size, tg_CHS_num_cyls;
    int hasExtended = 0;

    if (jobstarget.userPartitionCount == 0)
        return 0;

    src_part_list.ext = 0;

    for (i = 0; i < 4; i++)
    {
        if (src_part_list.part_entry[i].partition_ID == EXTENDED_PARTITION ||
                src_part_list.part_entry[i].partition_ID == EXTENDED_LBA_PARTITION ||
                src_part_list.part_entry[i].partition_ID == HIDDEN_EXTENDED_PARTITION ||
                src_part_list.part_entry[i].partition_ID == HIDDEN_EXTENDED_LBA_PARTITION)
        {
            src_part_list.ext = i;
            hasExtended = 1;
        }
    }

    src_size = gCapacity[0];

    tg_size = gCapacity[tgdisk_number];
    tg_CHS_num_cyls = 0;

    memset(&tg_part_list, 0, sizeof(PARTITION_ENTRY_LIST));
    //if (jobstarget.userPartitionCount<5)
    fprintf(stderr, "\n DVDB->jobstarget.userPartitionCount %d", jobstarget.userPartitionCount);
    if ((jobstarget.userPartitionCount == 1) || (hasExtended == 0))// ky modified on July 26, 2007
    {
        tg_part_list.number_extended_partitions = 0;
        tg_part_list.number_logic_partitions = 0;
        tg_part_list.number_of_partitions = jobstarget.userPartitionCount;
    }
    else
    {
        tg_part_list.number_extended_partitions = 1;
        tg_part_list.number_logic_partitions = jobstarget.userPartitionCount - 1;
        tg_part_list.number_of_partitions = jobstarget.userPartitionCount + 1;
    }

    number_of_pri_partitions = tg_part_list.number_of_partitions - tg_part_list.number_logic_partitions;

    first = src_part_list.get_first_entry(); // get partition entry of MBR that has the smallest start_sector
    fprintf(stderr, "\n DVDB->The First Entry %d", first);
    if (first == -1)
    {
        return 0;
    }

    src_head_per_cyl = src_part_list.part_entry[first].end_head_number + 1;

    // First we need to check if there is any partition that needs to MIRROR.
    // If any, we won't do CHF translation because we want the targets and master must the same after MIRROR completed
    for (i = 0; i < jobstarget.userPartitionCount;i++)
    {
        src_partno = jobstarget.partition[i].source_partition;

        if((unknowPartition(diskStruct[0].partition_list.partition[src_partno].partition_ID)) ||
                (diskStruct[0].partition_list.partition[src_partno].partition_ID == LINUX_SWAP_PARTITION) ||
                (checkExt2fsIsMountedBootDirectorty(diskStruct[0].partition_list.partition[src_partno].start_sector)))
        {
            hastoMirror = 1;
        }

    }

    // sec_per_track = sec_cyl.bi_sec_cyl_hd.sector;
    sec_cyl.by_sec_cyl_hd.sector = src_part_list.part_entry[first].end_sector_number;

    if (!hastoMirror && (gDriveInfo[tgdisk_number].NumCurrSectors == sec_cyl.bi_sec_cyl_hd.sector))
    {
        sec_per_track = gDriveInfo[tgdisk_number].NumCurrSectors;
        TranslatDoTranslate(gDriveInfo[tgdisk_number].NumCurrHeads, gNumCylinders[tgdisk_number], &head_per_cyl, &tg_CHS_num_cyls);
    }
    else
    {
        head_per_cyl = src_head_per_cyl;
        sec_cyl.by_sec_cyl_hd.sector = src_part_list.part_entry[first].end_sector_number;
        sec_cyl.by_sec_cyl_hd.cylinder = src_part_list.part_entry[first].end_cylinder_number;
        sec_per_track = sec_cyl.bi_sec_cyl_hd.sector;
    }


    sec_per_cyl = head_per_cyl * sec_per_track;

    //printDFXLog (PRI_INFO,"sec_per_cyl = %d---head_per_cyl = %d--sec_per_track = %d\n",sec_per_cyl,head_per_cyl,sec_per_track);
    total_src_num_cyls = src_size / sec_per_cyl;
    total_tg_num_cyls = tg_size / sec_per_cyl;

    m_Translated_CHF[tgdisk_number].cyls = total_tg_num_cyls;
    m_Translated_CHF[tgdisk_number].sec_per_track = sec_per_track;
    m_Translated_CHF[tgdisk_number].head_per_cyl = head_per_cyl;

    // compute start_sector
    if(tg_part_list.number_logic_partitions == 0) //Only has 1 partition
    {
        for (i = 0; i < jobstarget.userPartitionCount; i++)
        {
            tg_part_list.part_entry[i].number_of_sectors = jobstarget.partition[i].partition_size;

            if (tg_part_list.part_entry[i].number_of_sectors == 0)
            {
                tg_part_list.number_of_partitions = i;
                return -1;
            }

            tg_part_list.entry_not_empty[i] = 1;

            j = PARTITION_STRUCT_ID_to_PARTITION_ENTRY_LIST_ID(jobstarget.partition[i].source_partition, &src_part_list);

            if(j == -1)
            {
                printf("Invalid PARTITION_STRUCT_ID\n");
                return 0;
            }

            // set partition boot flag, ID, start_sector and number_of_sectors of the first partition entry of MBR
            tg_part_list.part_entry[i].active = src_part_list.part_entry[j].active;

            tg_part_list.part_entry[i].partition_ID = src_part_list.part_entry[j].partition_ID;

            if(i == 0)
            {
                src_partno = jobstarget.partition[i].source_partition;
                if((src_part_list.part_entry[src_partno].start_sector == 0x3F) || (src_part_list.part_entry[src_partno].start_sector == 0x800))
                {
                    tg_part_list.part_entry[i].start_sector = src_part_list.part_entry[src_partno].start_sector;
                }
                else
                {
                    tg_part_list.part_entry[i].start_sector = 0x3F;
                }
                //tg_part_list.part_entry[i].number_of_sectors -= tg_part_list.part_entry[i].start_sector;
            }
            else
            {
                tg_part_list.part_entry[i].start_sector = tg_part_list.part_entry[i-1].start_sector +
                        tg_part_list.part_entry[i-1].number_of_sectors;
            }
        }

        for (i = jobstarget.userPartitionCount; i < 4; i++)
        {
            memset(&tg_part_list.part_entry[i], 0, sizeof(tg_part_list.part_entry[i]));
            tg_part_list.entry_not_empty[i] = 0;
        }
    }
    else
    {
        fprintf(stderr, "\n DVDB->Testing here.....");
        tg_part_list.part_entry[0].number_of_sectors = jobstarget.partition[0].partition_size;

        if (tg_part_list.part_entry[0].number_of_sectors == 0)
        {
            tg_part_list.number_of_partitions = 0;
            tg_part_list.number_logic_partitions = 0;
            tg_part_list.number_extended_partitions = 0;
            return -1;
        }

        j = PARTITION_STRUCT_ID_to_PARTITION_ENTRY_LIST_ID(jobstarget.partition[0].source_partition, &src_part_list);

        if (j == -1)
        {
            printf("Invalid PARTITION_STRUCT_ID\n");
            return 0;
        }

        tg_part_list.entry_not_empty[0] = 1;

        // set partition boot flag, ID, start_sector and number_of_sectors of the first partition entry of MBR
        tg_part_list.part_entry[0].active = src_part_list.part_entry[0].active;
        tg_part_list.part_entry[0].partition_ID = src_part_list.part_entry[0].partition_ID;
        tg_part_list.part_entry[0].start_sector = 0x3F;
        //tg_part_list.part_entry[0].number_of_sectors -= sec_per_track;
        fprintf(stderr, "\n DVDB->Entry[0]:start sector %lu- number of sector %lu", tg_part_list.part_entry[0].start_sector, tg_part_list.part_entry[0].number_of_sectors);
        ext_tg_num_secs = 0;

        for (i = number_of_pri_partitions;i < tg_part_list.number_of_partitions;i++)
        {
            // ky modified on July 26, 2007
            //ext_tg_num_secs += jobstarget.partition[i].partition_size;
            ext_tg_num_secs += jobstarget.partition[i-1].partition_size;
        }

        if (ext_tg_num_secs == 0)
        {
            tg_part_list.number_of_partitions = 4;
            tg_part_list.number_logic_partitions = 0;
            tg_part_list.number_extended_partitions = 0;
            return -1;
        }

        j = PARTITION_STRUCT_ID_to_PARTITION_ENTRY_LIST_ID(jobstarget.partition[0].source_partition, &src_part_list);

        if (j == -1)
        {
            printf("Invalid PARTITION_STRUCT_ID\n");
            return 0;
        }

        memcpy(&tg_part_list.part_entry[1], &src_part_list.part_entry[src_part_list.ext], sizeof(tg_part_list.part_entry[1]));
        tg_part_list.entry_not_empty[1] = 1;
        tg_part_list.part_entry[1].start_sector = tg_part_list.part_entry[0].start_sector + tg_part_list.part_entry[0].number_of_sectors;

        tg_part_list.part_entry[1].number_of_sectors = 0;
        start_sector_logical = based_logical_start = tg_part_list.part_entry[1].start_sector;

        //fprintf(stderr, "\n DVDB->Entry[1]:start sector %lu- number of sector %lu", tg_part_list.part_entry[1].start_sector, tg_part_list.part_entry[1].number_of_sectors);
        k = 4;
        tg_part_list.number_extended_partitions = 1;
        unsigned long num_secs_of_log_par = 0;
        for (i = 1;i < jobstarget.userPartitionCount;i++, k += 2)
        {
            tg_part_list.part_entry[k].number_of_sectors = jobstarget.partition[i].partition_size;

            if (tg_part_list.part_entry[k].number_of_sectors == 0)
            {
                tg_part_list.number_logic_partitions = i - number_of_pri_partitions;
                tg_part_list.number_extended_partitions = 1;
                return -1;
            }

            j = PARTITION_STRUCT_ID_to_PARTITION_ENTRY_LIST_ID(jobstarget.partition[i].source_partition, &src_part_list);

            if (j == -1)
            {
                printf("Invalid PARTITION_STRUCT_ID\n");
                return 0;
            }

            tg_part_list.entry_not_empty[k] = 1;

            tg_part_list.part_entry[k].number_of_sectors = jobstarget.partition[i].partition_size;
            // set partition boot flag, ID, start_sector and number_of_sectors of the first partition entry of MBR
            tg_part_list.part_entry[k].active = src_part_list.part_entry[j].active;
            tg_part_list.part_entry[k].partition_ID = src_part_list.part_entry[j].partition_ID;
            tg_part_list.part_entry[k].start_sector = 0x3F;
            num_secs_of_log_par += tg_part_list.part_entry[k].start_sector + tg_part_list.part_entry[k].number_of_sectors;
            //tg_part_list.part_entry[k].number_of_sectors -= tg_part_list.part_entry[k].start_sector;

            //fprintf(stderr, "\n DVDB->Entry[%d]:start sector %lu- number of sector %lu", k, tg_part_list.part_entry[k].start_sector, tg_part_list.part_entry[k].number_of_sectors);
            if (k > 4)
            {
                //fprintf(stderr, "\n DVDB->Testing here.....1");
                tg_part_list.entry_not_empty[k-1] = 1;
                tg_part_list.part_entry[k-1].partition_ID = EXTENDED_PARTITION;
                tg_part_list.part_entry[k-1].number_of_sectors = tg_part_list.part_entry[k].number_of_sectors + tg_part_list.part_entry[k].start_sector;
            }

            if (i < jobstarget.userPartitionCount - 1)
            {
                //fprintf(stderr, "\n DVDB->Testing here.....2");
                tg_part_list.part_entry[k+1].start_sector = num_secs_of_log_par;//tg_part_list.part_entry[k].number_of_sectors + tg_part_list.part_entry[k].start_sector;//first_relative_cyl * sec_per_cyl;
                start_sector_logical = based_logical_start + tg_part_list.part_entry[k+1].start_sector;
            }
            else
            {
                memset(&tg_part_list.part_entry[k+1], 0, sizeof(tg_part_list.part_entry[k]));
                tg_part_list.entry_not_empty[k+1] = 0;
            }
        }
        tg_part_list.part_entry[1].number_of_sectors = num_secs_of_log_par;
    }
    //setCHF:
    setCHSToPartitionsOfTargetDisk(tg_part_list, sec_per_track, head_per_cyl);

    return iRet;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::chk_vers(short d)
{
    short retval;
    short data;
    data = gDriveInfo[d].ATAMajorVersion;

    if (data < 1)
    {
        retval = 0;
    }
    else retval = 14;

    data <<= 1 ;

    while (data > 0)
    {
        data <<= 1;
        retval--;
    }

    return retval;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::findDiskExist()
{
    for (int i = 1;i < MAX_DISKS;i++)
        if (gDriveState[i] == DRIVE_READY)
            return i;

    return 0;

}
//////////////////////////////////////////////////////////////////////////
//
unsigned long CSystemD105::minCapacity()
{
    unsigned long min = 0x7FFFFFFF;

    for (int i = 1;i < MAX_DISKS;i++)
        if ((gDriveState[i] == DRIVE_READY) && (min > gCapacity[i]))
        {
            min = gCapacity[i];
            printDFXLog (PRI_INFO, "Disk: %d min: %lu Capacity:%luM", i, min / 2048, gCapacity[i] / 2048);
        }

    return min;
}
//////////////////////////////////////////////////////////////////////////
// 24June06 QuynhBui re-write this function
void CSystemD105::turn_off_disk(int d)
{
    unsigned int spindown_time = 1; // microsecond
    bool isResetBoard = false;

    if(this->systemOption.txt_spin_down_time >= 1)
    {
        spindown_time = this->systemOption.txt_spin_down_time;
    }

    this->diskIOModule.recoveryBoard(0);
    //    if(this->diskIOModule.recoveryBoard(0) == UNSUCCESS) //TamHo debug (05-10-2012)
    //    {
    //        //Do bi mat linkup giua 2 board nen khong the thuc hien them bat ki command nao -> tien hanh reset board ben FW
    //        DFXCommunication *objCom = new DFXCommunication();
    //        if(objCom != NULL)
    //        {
    //            isResetBoard = true;
    //            objCom->sendFPGAStart();
    //            sleep(15);

    //            delete objCom;
    //            objCom = NULL;
    //        }
    //    }

    for (int disk = 0;disk < MAX_DISKS;disk++)
    {
        //if(this->inputDiskList[disk] == CHECKED)
        {
            if(isResetBoard == true)
            {
                this->diskIOModule.TurnLedMode(disk, LED_OFF, LED_GREEN);
            }

            //            if((disk == 0) && (this->diskIOModule.jobId == CORE_WIPE_DISK_JOB))
            //            {
            //                fprintf(stderr, "\n DVDB->Disk[%d]: No set LED", disk);
            //                continue;
            //            }

            if((this->gCopyResult[disk] != GOOD_COPY) && (this->gCopyResult[disk] != GOOD_VERIFY)) // Disk copy failed
            {
                this->diskIOModule.TurnLedMode(disk, LED_ON, LED_RED);
            }
            else //Disk copy passed
            {
                this->diskIOModule.TurnLedMode(disk, LED_ON, LED_GREEN);
            }

            if (gDriveState[disk] == DRIVE_READY)
            {
                sleep(spindown_time);
            }
            else if(d != 0)
            {
                //sleep(1);
                msleep(500);
            }

            diskIOModule.powerDown(disk);
        }

        this->gCopyResult[disk] = INCOMPLETE;
    }
    this->checkFinishedDisk = 1;
}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::unknowPartition(unsigned short partitionID)
{
    short ret = 0;

    switch (partitionID)
    {

    case DOS_FAT16_SMALLER_32MB_PARTITION:

    case DOS_FAT16_LARGER_32MB_PARTITION:

    case WIN9X_FAT16_LBA_PARTITION:

    case WIN9X_FAT32_PARTITION:

    case WIN9X_FAT32_LBA_PARTITION:
        ret = 0;
        break;

    case IFS_PARTITION:

        if (securityOperation->checkFeatureUnlocked(FEATURE_NTFS) != 1)
        {
            printDFXLog (PRI_INFO, "End test unlocked. NTFS not support");
            ret = 1;

        }

        break;

        //case EXTENDED_PARTITION:
        //case EXTENDED_LBA_PARTITION :
        //case HIDDEN_EXTENDED_PARTITION:
        //case HIDDEN_EXTENDED_LBA_PARTITION:
    case LINUX_RAID_PARTITION: /* Viet Nguyen updated Dec 24 2007 */
    case LINUX_NATIVE_PARTITION:
    case LINUX_LVM_PARTITION: // Viet Nguyen added on Apr 11 2008
        if (securityOperation->checkFeatureUnlocked(FEATURE_EXT2FS) != 1)
        {
            printDFXLog (PRI_INFO, "End test unlocked. EXT2/3 not support");
            ret = 1;
        }

        break;

    default:
        //printDFXLog (PRI_INFO,"Filesystem NOT support yet");
        break;
    }

    return ret;

}
//////////////////////////////////////////////////////////////////////////
//
short CSystemD105::checkExt2fsIsMountedBootDirectorty(unsigned long startSector)
{
    char buffer_temp[512*2];
    int result = 0;
    if (this->diskIOModule.readSectors(0, startSector + 2, 2, (unsigned short*)&buffer_temp) != 1)
    {
        //printf("***IO_READ_DISK***\n");
        HandleIOError(IO_READ_DISK, 0, startSector + 2, CHECK_EXT2FS_IS_MOUNTED_BOOT_DIRECTORTY_ID);
        return 0;
    }

    QString qString((const char*) &buffer_temp[0x78]);
    //printf("HAHA : %s \n",qString.latin1());
    if (qString.find("/boot") != -1)
    {
        printf("\n Boot partition - Start Sector = %lu\n",startSector);
        return 1;
    }

    //duongvu add code here (April 20 2009)
    short bootloader;
    bootloader = DFXCheckBootLoader(SOURCE_HDD);

    if (GRUB_ERROR == bootloader)
    {
        //printf("***NOT BOOT DIRECTORY***\n");
        return 0;
    }
    else
    {
        if(bootloader == GRUB_BOOTLOADER)
        {
            CExtSmartUtility* extUti = new CExtSmartUtility (&this->diskIOModule, SOURCE_HDD, startSector);
            if (!extUti)
            {
                printDFXLog (PRI_INFO, "Cannot create CExtSmartUtility object.");
                return UNFINISHED;
            }

            if (extUti->initCExtSmartUtility () == false)
            {
                if(extUti)
                {
                    delete extUti;
                    extUti = NULL;
                }
                return UNFINISHED;
            }

            if(extUti->FindFileInPartition((char*)QString("/grub/stage2").latin1()) == true)
            {
                DoneEXTSmart = true;
                result = 1;
            }
            else
            {
                result = 0;
            }

            if(extUti)
            {
                delete extUti;
                extUti = NULL;
            }

        }
        else if(bootloader == LILO_BOOTLOADER)
        {
            CExtSmartUtility* extUti = new CExtSmartUtility (&this->diskIOModule, SOURCE_HDD, startSector);
            if (!extUti)
            {
                printDFXLog (PRI_INFO, "Cannot create CExtSmartUtility object.");
                return UNFINISHED;
            }

            if (extUti->initCExtSmartUtility () == false)
            {
                if(extUti)
                {
                    delete extUti;
                    extUti = NULL;
                }
                return UNFINISHED;
            }

            if(extUti->FindFileInPartition((char*)QString("/map").latin1()) == true)
            {
                DoneEXTSmart = true;
                result = 1;
            }
            else
            {
                result = 0;
            }

            if(extUti)
            {
                delete extUti;
                extUti = NULL;
            }
        }
        else if((bootloader == GRUB2_BOOTLOADER_OUT_MBR) || (bootloader == GRUB2_BOOTLOADER))
        {
            CExtSmartUtility* extUti = new CExtSmartUtility (&this->diskIOModule, SOURCE_HDD, startSector);
            if (!extUti)
            {
                printDFXLog (PRI_INFO, "Cannot create CExtSmartUtility object.");
                return UNFINISHED;
            }

            if (extUti->initCExtSmartUtility () == false)
            {
                if(extUti)
                {
                    delete extUti;
                    extUti = NULL;
                }
                return UNFINISHED;
            }

            if(extUti->FindFileInPartition((char*)QString("/grub/boot.mod").latin1()) == true)
            {
                DoneEXTSmart = true;
                result = 1;
            }
            else
            {
                result = 0;
            }

            if(extUti)
            {
                delete extUti;
                extUti = NULL;
            }

        }
    }
    // duongvu end
    //fprintf(stderr,"\nStart sector of partition checking....%lu Result of returning---------------%d\n",startSector, result);
    return result;

}
//////////////////////////////////////////////////////////////
//
short CSystemD105::checkNTFSfsIsMountedBootDirectorty(unsigned long startSector, unsigned long partitionLength, unsigned char partition_ID)
{
    //Not NTFS partition or Partition Lengh < 1GB
    if((partition_ID = IFS_PARTITION) && (partitionLength < (1024*1024*2))){
        fprintf(stderr, "\n THDB here: checkNTFSfsIsMountedBootDirectorty -> Start sector: %lu  SectorCount: %lu", startSector, partitionLength);
        return SUCCESS;
    }else{
        return UNSUCCESS;
    }

    //    unsigned long *indexSectorsBCDFile[MAX_DISKS];
    //    unsigned long cluster_total[MAX_DISKS];
    //    char filename[50];

    //    if(partition_ID != IFS_PARTITION){
    //        return UNSUCCESS;
    //    }

    //    strcpy(filename,"/Boot/BCD");
    //    filename[strlen(filename)] = '\0';
    //    initClusterArray(indexSectorsBCDFile);

    //    indexSectorsBCDFile[0] = NULL;
    //    strcpy(filename,"/Boot/BCD");
    //    filename[strlen(filename)] = '\0';

    //    NtfsCopy *ntfsObj = new NtfsCopy(this, startSector);
    //    if(ntfsObj == NULL){
    //        printDFXLog (PRI_INFO, "%s", "Cannot create NTFS object");
    //        return	UNSUCCESS;
    //    }

    //    cluster_total[0] = ntfsObj->parseFileToSectors(0, filename, indexSectorsBCDFile[0]);
    //    if( cluster_total[0] == UNSUCCESS){
    //        //printDFXLog (PRI_INFO, "%s", "File system has none BCD file.");
    //        delete ntfsObj;
    //        ntfsObj = NULL;
    //        return	UNSUCCESS;
    //    }
    //    else{
    //        printDFXLog (PRI_INFO, "%s", "File system has BCD file.");
    //    }

    //    releaseClusterArray (indexSectorsBCDFile);
    //    delete ntfsObj;
    //    ntfsObj = NULL;
    //    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//TamHo added (20/01/2011)
bool CSystemD105::isSetupBootLoader()
{
    bool result = true;
    unsigned long startSector = 0;

    for(short parIdx = 0; parIdx < diskStruct[0].partition_list.number_of_partitions; parIdx++)
    {
        startSector = diskStruct[0].partition_list.partition[parIdx].start_sector;
        if(checkExt2fsIsMountedBootDirectorty(startSector) == 1)
        {
            result = false;
            for(short disk = 1; disk < MAX_DISKS; disk++)
            {
                if((gDriveState[disk] == DRIVE_READY) && (gTarget[disk].enable == 1) &&
                        (diskStruct[disk].partition_list.partition[parIdx].start_sector != startSector))
                {
                    result = true;
                    break;
                }
            }

            break;
        }
    }

    return result;
}
//////////////////////////////////////////////////////////////////////////
//TamHo added (20/01/2011)
unsigned long  CSystemD105::getStartSectorOfFileBootLoader()
{
    unsigned long temp = 0;
    unsigned long result = 0;
    unsigned long startSector = 0;

    for(short parIdx = 0; parIdx < diskStruct[0].partition_list.number_of_partitions; parIdx++)
    {
        startSector = diskStruct[0].partition_list.partition[parIdx].start_sector;
        short bootloader;
        bootloader = DFXCheckBootLoader(SOURCE_HDD);

        if (GRUB_ERROR == bootloader)
        {
            //printf("***NOT BOOT DIRECTORY***\n");
            return 0;
        }
        else
        {
            if(bootloader == GRUB_BOOTLOADER)
            {
                CExtSmartUtility* extUti = new CExtSmartUtility (&this->diskIOModule, SOURCE_HDD, startSector);
                if (!extUti)
                {
                    printDFXLog (PRI_INFO, "Cannot create CExt2SmartUtility object.");
                    return UNFINISHED;
                }

                if (extUti->initCExtSmartUtility () == false)
                {
                    if(extUti)
                    {
                        delete extUti;
                        extUti = NULL;
                    }
                    return UNFINISHED;
                }

                temp = extUti->getStartSectorOfFileStage2InPartition((char*)QString("/boot/grub/stage2").latin1());
                if(temp != 0)
                {
                    result = temp;
                }

                if(extUti)
                {
                    delete extUti;
                    extUti = NULL;
                }

                if(result != 0)
                {
                    break;
                }

            }
            /*else if(bootloader == LILO_BOOTLOADER)
   {
   CExt2SmartUtility* extUti = new CExt2SmartUtility (this, SOURCE_HDD, startSector);
   if (!extUti)
   {
                        printDFXLog (PRI_INFO, "Cannot create CExt2SmartUtility object.");
   return UNFINISHED;
   }

   if (extUti->initCExt2SmartUtility () == false)
   {
   if(extUti)
   {
   delete extUti;
   extUti = NULL;
   }
   return UNFINISHED;
   }

   temp = extUti->getStartSectorOfFileStage2InPar("/boot/map");
   if(temp != 0)
   {
   result = temp;
   }

   if(extUti)
   {
   delete extUti;
   extUti = NULL;
   }
   }*/
        }
    }

    return result;
}
//////////////////////////////////////////////////////////////////////////
//
int CSystemD105::TranslatDoTranslate(unsigned short CurrHeads, unsigned long CurrCyls, unsigned short* XHeads, unsigned long* XCyls)
{
    int result = 0; // assume everything will be ok
    int P2Arr[] = {16, 32, 64, 128, 256};
    int i;

    // Set initial values
    *XHeads = CurrHeads;
    *XCyls = CurrCyls;

#ifdef DEBUG_TRANSLATION
    fprintf (stdaux, "\n CurrHeads : %u (0x%04X)", CurrHeads, CurrHeads);
    fprintf (stdaux, "\n CurrCyls : %u (0x%04X)", CurrCyls, CurrCyls);
#endif

    // No need to translate if cylinders are less than or equal to 1024

    if (CurrCyls > 1024)
    {

        // Perform 'standard' translation

        while ((*XCyls > _MAXCYLINDERS)
               && (*XHeads <= (_MAXHEADS / 2)))
        {
            *XCyls = *XCyls / 2;
            *XHeads = *XHeads * 2;
        }

        // If the translated heads result must be a power of 2
        // then perform translation to produce appropriate result
        if (systemOption.lba_enable)
        {
            // Round up to the next power of 2 unless the XHeads value
            // is already a power of 2. In that case keep the original
            // value.

            for (i = 0; (i < 4) && (*XHeads > P2Arr[i]); i++);

            // Perform adjusted translation

            *XHeads = P2Arr[i];

            *XCyls = (unsigned int)((unsigned long)((unsigned long) CurrHeads *
                                                    (unsigned long) CurrCyls) / (unsigned long) * XHeads);
        }

        // handle interrupt 13 situation
        // note this will overwrite HEADS_EQ_PWR2
        if (systemOption.int13f8_enable)
        {
            if (*XHeads > 240)
            {
                *XHeads = 240;
                *XCyls = (unsigned int)(unsigned long)(((unsigned long)CurrCyls *
                                                        (unsigned long)CurrHeads) / (unsigned long) * XHeads);

                if (*XCyls > 1023)
                    *XCyls = 1023;
            }
        }

        // Head values >= 256 are not allowed so reduce heads to 255
        // recalculate

        if (*XHeads >= _MAXHEADS)
        {
            *XHeads = _FATMAXHEADS; // FDISK seems to do translation this way
            *XCyls = (unsigned int)((unsigned long)((unsigned long) CurrHeads *
                                                    (unsigned long) CurrCyls) / (unsigned long) * XHeads);
        }

        // Reduce cylinder value to lower 10 bits

        *XCyls &= 0x3FF;

    } // End of clause for condition Cylinders > 1024

    return result;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::RefreshPerProgress()
{
    int i;
    TASK_STATE state = TASK_INIT;

    if (currentTask >= MAX_TASKS)
        return;

    state = gTaskList[currentTask].state;

    switch (gTaskList[currentTask].action)
    {

    case EXT2_PAR_SMART:
    {
        switch (state)
        {

        case TASK_SMART:
        {
            short percentAction;
            percentAction = 0;

            for (i = 1;i < MAX_DISKS;i++)
            {
                percentAction = gExt2Smart->returnActionPercent();

                if (gTaskList[currentTask].target.item[i])
                {
                    if (this->actionMode == DUPLICATING_MODE)
                        gPercentCopied[i] = (((unsigned long)gCurrentTask[i]) * 100) / gTotalTask[i] + (percentAction / gTotalTask[i]);
                    else
                    {
                        gPercentCopied[i] = (((unsigned long)gCurrentTask[i]) * 100) / gTotalTask[i] + (percentAction / gTotalTask[i]);
                    }
                }
            }

            break;
        }

        default:
            break;
        }

        break;
    }

    default:
        break;
    }
}
//////////////////////////////////////////////////////////////////////////
// DuongVu fix bug can not boot up Ubuntu11 (10-01-2012)
int CSystemD105::check_jmp_ins(unsigned char *bootinst, int flag)
{
    int jmp_code, ret;
    if (!flag) // Non-GRUB
    {
        if ((!bootinst[0]) && (!bootinst[1])) //Non-LILO
            return NON_BOOTLOADER;

    }

    jmp_code = ((unsigned int) bootinst[0]) + (((unsigned int) bootinst[1]) << 8);

    switch (jmp_code)
    {

    case GRUB_JMP_CODE:
        ret = GRUB_BOOTLOADER;
        break;

    case GRUB2_JMP_CODE:
        ret = GRUB2_BOOTLOADER;
        break;

    case GRUB2_2JMP_CODE:
        ret = GRUB2_BOOTLOADER_OUT_MBR;
        break;

    case LILO_JMP_CODE:
        ret = LILO_BOOTLOADER;
        break;

    default:
        printDFXLog(PRI_INFO, "Invalid bootloader!");
        ret = -1;
        break;
    }
    return ret;
}
//////////////////////////////////////////////////////////////////////////
// DuongVu fix bug can not boot up Ubuntu11 (10-01-2012)
int CSystemD105::DFXCheckBootLoader(short disk)
{
    return DFXSYSTEM_CheckMasterBootRecord(disk);
}
//////////////////////////////////////////////////////////////////////////
// DuongVu fix bug can not boot up Ubuntu11 (10-01-2012)
int CSystemD105::DFXSYSTEM_CheckMasterBootRecord(short disk)
{
    PARTITION_SECTOR_STRUCT mbr;
    PARTITION_ENTRY_STRUCT *part = NULL;
    short bootloader = BOOT_ERROR;

    //printf("------->Read SRC's MBR \n");

    if(this->diskIOModule.readSectors(disk, 0, 1, (unsigned short*)&mbr) == UNSUCCESS)
    {
        printDFXLog(PRI_INFO, "Cannot read SRC's MBR.");
        return GRUB_ERROR;
    }

    //diskIOModule.readbuf((char*)&mbr,SECTOR_SIZE,16);

    if (MBR_SIGNATURE != mbr.signature)
    {
        printDFXLog(PRI_INFO, "Invalid partition: none of signatures is 0x%X.", mbr.signature);
        return GRUB_ERROR;
    }

    part = (PARTITION_ENTRY_STRUCT *) & mbr.partition_entry[0];

    if (ACTIVE_PARTITION != part[0].active)
    {
        printDFXLog(PRI_INFO, "Partition is not activated (0x%X).", part[0].active);
    }

    // Make sure the MBR is a normal MBR and not a protective MBR.
    if (PART_GPT_DISK == part[0].partition_ID)
    {
        //http://en.wikipedia.org/wiki/GUID_Partition_Table
        printDFXLog(PRI_INFO, "This version has not supported GUID Partition Table (GPT) yet. (Id: 0x%X).", part[0].partition_ID);
        return GRUB_ERROR;
    }

    bootloader = DFXSYSTEM_WhatBootManager(mbr);

    //Searching 'GRUB' string in bootstrap code of Boot sector of partition
    if (bootloader == GRUB2_BOOTLOADER_OUT_MBR)
    {
        PARTITION_SECTOR_STRUCT BootSector;
        bool grub_flag = false;

        for (short i = 0; i < this->diskStruct[disk].partition_list.number_of_partitions; i++)
        {
            //printf("Part #%d --- sector start: %lu (0x%lX)\n", i, part[i].start_sector, part[i].start_sector);

            if (this->diskIOModule.readSectors(disk, part[i].start_sector, 1, (unsigned short*)&BootSector) == UNSUCCESS)
            {
                printDFXLog(PRI_INFO, "DF5CheckBootLoader: Read SRC's Boot sector failed!\n");
                return GRUB_ERROR;
            }

            //diskIOModule.readbuf((char*)&BootSector, SECTOR_SIZE, 16);

            if (MBR_SIGNATURE != BootSector.signature)
            {
                printDFXLog(PRI_INFO, "DF5CheckBootLoader->No signature 0x%X - Invalid partition\n", BootSector.signature);
                continue;
            }

            int j = 0;

            for (j = 0x176;j < 0x1BA;j++)
            {
                if (('G' == BootSector.boot_loader_code[j]) && ('R' == BootSector.boot_loader_code[j+1]) &&
                        ('U' == BootSector.boot_loader_code[j+2]) && ('B' == BootSector.boot_loader_code[j+3]))
                {
                    //printDFXLog(PRI_INFO, "%c%c%c%c boot loader in boot sector", BootSector.boot_loader_code[j], BootSector.boot_loader_code[j+1], BootSector.boot_loader_code[j+2], BootSector.boot_loader_code[j+3]);
                    grub_flag = true;
                    i = this->diskStruct[disk].partition_list.number_of_partitions;
                    break;
                }
            }
        }

        if (grub_flag == false)
        {
            return GRUB_ERROR;
        }
    }
    return bootloader;
}
//////////////////////////////////////////////////////////////////////////
// DuongVu fix bug can not boot up Ubuntu11 (10-01-2012)
int CSystemD105::DFXSYSTEM_WhatBootManager(PARTITION_SECTOR_STRUCT mbr)
{
    //short i,grub_flag=0,lilo_flag=0, ms_flag=0;
    short i, grub_flag = 0;
    short bootloader = BOOT_ERROR;

    //Searching 'GRUB' chars in bootstrap code of MBR

    for (i = 0x176;i < 0x1BA;i++)
    {
        if ('G' == mbr.boot_loader_code[i])
            if ('R' == mbr.boot_loader_code[i+1])
                if ('U' == mbr.boot_loader_code[i+2])
                    if ('B' == mbr.boot_loader_code[i+3])
                    {
                        //printDFXLog(PRI_INFO, "%c%c%c%c bootloader", mbr.boot_loader_code[i], mbr.boot_loader_code[i+1], mbr.boot_loader_code[i+2], mbr.boot_loader_code[i+3]);
                        grub_flag = 1;
                    }
    }

    //hex_dump((unsigned char*)&mbr, SECTOR_SIZE);
    bootloader = check_jmp_ins((unsigned char*) & mbr.boot_loader_code, grub_flag);
    return bootloader;
}
//////////////////////////////////////////////////////////////////////////
//
int CSystemD105::get_udma_mode(unsigned short w53, unsigned short w88)
{
    int bit,
            mode = UDMA_MODE_MAX - 0x40;

    if ((w53 & 0x04) == 0)
        return -1;

    for (bit = UDMAMODE_6_BIT; mode > -1; bit >>= 1, mode--)
    {
        if (w88 & bit)
            return mode;
    }

    return mode;
}
//////////////////////////////////////////////////////////////////////////
//
int CSystemD105::get_pio_mode(unsigned short w53, unsigned short w64)
{
    int mode = 0;

    if ((w53 & 0x02) == 0)
        return -1;

    mode = (w64 & 0x03) + 1;

    if ((w64&0x03) >= 2)
        mode = 4;

    if ((w64&0x03) == 1)
        mode = 3;

    if ((w64&0x03) == 0)
        mode = -1;

    return mode;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::reset()
{
    mMinUDMAMode = -1;
    mMinPIOMode = -1;
    mNeedToResetBoard = false;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
 Check MBR's bootcode to find MyBook World Edition (MBWE) disk surely
 return: 0 --> Not MBWE disk
 1 --> MBWE Single disk (500GB, 750GB, 1TB)
 2 --> MBWE Double disk (1TB, 1.5TB, 2TB) ...later...
 */
short CSystemD105::DFXSYSTEM_CheckMBWE(unsigned char* bootcode)
{
    short i = 0;
    bool flag1 = false, flag2 = false;
    unsigned long seg0 = 0, ofs0 = 0, seg1 = 0, ofs1 = 0;

    //printf("DFXSYSTEM_CheckMBWE: Module ID = %d \n", CHECK_MBWE_DISK_MODULE_ID);

    for (i = 0; i < 0x1B0; i++)
    {
        if (!bootcode[i])
            flag1 = true;
    }

    if (flag1)
    {
        seg0 = convert2long(bootcode[0x1BC], bootcode[0x1BD], bootcode[0x1BE], bootcode[0x1BF]);
        ofs0 = convert2long(bootcode[0x1B8], bootcode[0x1B9], bootcode[0x1BA], bootcode[0x1BB]);

        seg1 = convert2long(bootcode[0x1B4], bootcode[0x1B5], bootcode[0x1B6], bootcode[0x1B7]);
        ofs1 = convert2long(bootcode[0x1B0], bootcode[0x1B1], bootcode[0x1B2], bootcode[0x1B3]);



        if ((seg0 == MBWE_ADDR_JMP_CODE_SEGMENT0) && (ofs0 == MBWE_ADDR_JMP_CODE_OFFSET0) &&
                (MBWE_ADDR_JMP_CODE_SEGMENT1 == seg1) && (MBWE_ADDR_JMP_CODE_OFFSET1 == ofs1))
        {
            fMBWE = true;
            flag2 = true;
        }
    }

    if (flag2)
        return MBWE_SINGLE_DISK;

    return NON_MBWE_DISK;
}
//////////////////////////////////////////////////////////////////////////
//
/*!<
 Get MBWE MBR's partition table to choose action mode copy for each partitions
 return: 0 --> Not MBWE disk
 1 --> MBWE Single disk (500GB, 750GB, 1TB)
 2 --> MBWE Double disk (1TB, 1.5TB, 2TB) ...later...
 */

short CSystemD105::DFXSYSTEM_MBWE_ChooseActionType(PARTITION_SECTOR_STRUCT PartStruct, short TotalDisks, PARTITION_STRUCT part[4])
{
    short i = 0;

    unsigned long max_capacity1 = 0/*,max_capacity2=0*/;

    //max_capacity2=0;

    if (PartStruct.signature != MBR_SIGNATURE)
        return UNSUCCESS;

    // Get 'real' Data partition
    for (i = 0; i < 4; i++)
    {
        if (PartStruct.partition_entry[i].partition_ID == LINUX_RAID_PARTITION)
        {
            if (TotalDisks == MBWE_SINGLE_DISK)
            {
                //printf("Total %lu sectors \n", PartStruct.partition_entry[i].number_of_sectors);

                if (max_capacity1 < PartStruct.partition_entry[i].number_of_sectors)
                {
                    max_capacity1 = PartStruct.partition_entry[i].number_of_sectors;
                }
            }
            else if (TotalDisks == MBWE_DOUBLE_DISK)
            {
                // Add later...
                // ...
            }

        }
    }

    //printf("max_capacity1 = %lu \n", max_capacity1);
    //getc(stdin);

    // Set action type for big Data partition only
    if (TotalDisks == MBWE_SINGLE_DISK)
    {
        for (i = 0; i < 4; i++)
        {
            if (max_capacity1 == PartStruct.partition_entry[i].number_of_sectors)
                part[i].copy_mode = SMART_COPY;

        }
    }
    else if (TotalDisks == MBWE_DOUBLE_DISK)
    {
        // Add later...
        // ...
    }

    mMBWE_MaxCapacity4SmartCopy = max_capacity1;


    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
// Function nay hien tai khong su dung
short CSystemD105::DFXSYSTEM_DisableWhenError(short disk)
{
    short check_to_continue = 0, disk_enabled = 0;


    for (short type_hdd = 1; type_hdd < MAX_DISKS; type_hdd++) if (gLiveTargetList.item[type_hdd])
        disk_enabled++;

    //printf("-0- check_to_continue %d: disk_enabled %d\n", check_to_continue, disk_enabled);
    if (gLiveTargetList.item[disk])
    {
        printDFXLog (PRI_INFO, "Disk #%d: Error ", disk);

        check_to_continue++;
        gLiveTargetList.item[disk] = 0;
        gCopyResult[disk] = BAD_RESET_DISK;
        //mpDO->powerDown(disk);
    }

    //printf("-1- check_to_continue %d: disk_enabled %d\n", check_to_continue, disk_enabled);
    if (check_to_continue == disk_enabled)
        return UNSUCCESS;

    return SUCCESS;
}
//////////////////////////////////////////////////////////////////////////
//15Otc2008 QuynhBui added to make sure the d105obj thread has finished execution
bool CSystemD105::wait_thread(QWidget* parent)
{
    parent = NULL;
    if (checkFinishedDisk)
    {
        this->wait();
    }
    else
    {
        DFXMessageDisplay* msg = new DFXMessageDisplay();
        msg->setd105(this);
        msg->time_start(1);
        msg->run();
        delete msg;
    }
    return true;
}
//////////////////////////////////////////////////////////////////////////
//
QString CSystemD105::x_selectpartition(char part)
{
    QString t = "";
    unsigned char i = part;

    switch (i)
    {

    case EMPTY_PARTITION:
        t = "Empty Partition";
        break;

    case UNFORMATTED_PARTITION:
        t = "Unformatted Partition";
        break;

    case DOS_FAT12_PARTITION:
        t = "DOS";
        break;

    case DOS_FAT16_SMALLER_32MB_PARTITION:

    case DOS_FAT16_LARGER_32MB_PARTITION:

    case HIDDEN_DOS_FAT12_PARTITION:

    case HIDDEN_DOS_FAT16_SMALLER_32MB_PARTITION:

    case HIDDEN_DOS_FAT16_LARGER_32MB_PARTITION:
        t = "DOS";
        break;

    case EXTENDED_PARTITION:
        t = "extended partition";
        break;

    case IFS_PARTITION:
        t = "IFS";
        break;

    case WIN9X_FAT32_PARTITION:

    case WIN9X_FAT32_LBA_PARTITION:

    case WIN9X_FAT16_LBA_PARTITION:
        t = "Win9X";
        break;

    case EXTENDED_LBA_PARTITION:
        t = "Extended LBA Partition";
        break;

    case HIDDEN_EXTENDED_PARTITION:
        t = "Hidden extended";
        break;

    case HIDDEN_IFS_PARTITION:
        t = "Hidden IFS";
        break;

    case HIDDEN_WIN9X_FAT32_PARTITION:

    case HIDDEN_WIN9X_FAT32_LBA_PARTITION:

    case HIDDEN_WIN9X_FAT16_LBA_PARTITION:
        t = "Hidden Win9X";
        break;

    case HIDDEN_EXTENDED_LBA_PARTITION:
        t = "Hidden extended LBA";
        break;

    case LINUX_SWAP_PARTITION:
        t = "Linux swap";
        break;

    case LINUX_RAID_PARTITION:      //VietNguyen added Dec 27 2007

    case LINUX_NATIVE_PARTITION:
        t = "Linux native";
        break;

    case LINUX_LVM_PARTITION:
        t = "Linux LVM";
        break;

    case HPA_PARTITION:
        t = "HPA section";
        break;

    default:
        t = "Unknown partition";
        break;
    }

    return t;
}
//////////////////////////////////////////////////////////////////////////
//
QString CSystemD105::x_actiontype(char part)
{
    QString t = "";
    unsigned char i = part;
    switch (i)
    {

    case EMPTY_PARTITION:
        t = "EMPTY_PAR";
        break;

    case UNFORMATTED_PARTITION:
        t = "UNFORMATTED_PAR";
        break;

    case DOS_FAT12_PARTITION:

    case HIDDEN_DOS_FAT12_PARTITION:
        t = "FAT_12_PAR";
        break;

    case DOS_FAT16_SMALLER_32MB_PARTITION:

    case DOS_FAT16_LARGER_32MB_PARTITION:

    case HIDDEN_DOS_FAT16_SMALLER_32MB_PARTITION:

    case HIDDEN_DOS_FAT16_LARGER_32MB_PARTITION:

    case WIN9X_FAT16_LBA_PARTITION:

    case HIDDEN_WIN9X_FAT16_LBA_PARTITION:
        t = "FAT_16_PAR";
        break;

    case EXTENDED_PARTITION:
        t = "extended partition";
        break;

    case IFS_PARTITION:

    case HIDDEN_IFS_PARTITION:
        t = "NTFS_PAR";
        break;

    case WIN9X_FAT32_PARTITION:

    case WIN9X_FAT32_LBA_PARTITION:

    case HIDDEN_WIN9X_FAT32_PARTITION:

    case HIDDEN_WIN9X_FAT32_LBA_PARTITION:
        t = "FAT_32_PAR";
        break;

    case EXTENDED_LBA_PARTITION:
        t = "Extended LBA Partition";
        break;

    case HIDDEN_EXTENDED_PARTITION:
        t = "Hidden extended";
        break;

    case HIDDEN_EXTENDED_LBA_PARTITION:
        t = "Hidden extended LBA";
        break;

    case LINUX_SWAP_PARTITION:
        t = "SWAP_PAR";
        break;

    case LINUX_RAID_PARTITION:      //VietNguyen added Dec 27 2007

    case LINUX_NATIVE_PARTITION:
        t = "EXT_PAR";
        break;

    case LINUX_LVM_PARTITION:
        t = "LVM_PAR";
        break;

    case HPA_PARTITION:
        t = "HPA section";
        break;

    default:
        t = "Unknown partition";
        break;
    }

    return t;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertInformationToSystemOptionTable()
{
    this->dbObj.systemOpObj.setAllProperty(&this->systemOption);
    this->dbObj.insertTbSystemOption();
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertInformationToSmartOptionTable()
{
    if(this->dbObj.existSmartOptionNameInSmartOptionTable("NTFS") == false)
    {
        this->dbObj.smartOpObj.setId(1);
        this->dbObj.smartOpObj.setName("NTFS");
        this->dbObj.insertTbSmartOption();
    }

    if(this->dbObj.existSmartOptionNameInSmartOptionTable("Ext2/3/4") == false)
    {
        this->dbObj.smartOpObj.setId(2);
        this->dbObj.smartOpObj.setName("Ext2/3/4");
        this->dbObj.insertTbSmartOption();
    }

    if(this->dbObj.existSmartOptionNameInSmartOptionTable("DOD Wipeout") == false)
    {
        this->dbObj.smartOpObj.setId(3);
        this->dbObj.smartOpObj.setName("DOD Wipeout");
        this->dbObj.insertTbSmartOption();
    }

    if(this->dbObj.existSmartOptionNameInSmartOptionTable("Partition") == false)
    {
        this->dbObj.smartOpObj.setId(4);
        this->dbObj.smartOpObj.setName("Partition");
        this->dbObj.insertTbSmartOption();
    }

    if(this->dbObj.existSmartOptionNameInSmartOptionTable("Sector Copy") == false)
    {
        this->dbObj.smartOpObj.setId(5);
        this->dbObj.smartOpObj.setName("Sector Copy");
        this->dbObj.insertTbSmartOption();
    }

    if(this->dbObj.existSmartOptionNameInSmartOptionTable("Secure Erase") == false)
    {
        this->dbObj.smartOpObj.setId(6);
        this->dbObj.smartOpObj.setName("Secure Erase");
        this->dbObj.insertTbSmartOption();
    }

    if(this->dbObj.existSmartOptionNameInSmartOptionTable("HPA Copy") == false)
    {
        this->dbObj.smartOpObj.setId(7);
        this->dbObj.smartOpObj.setName("HPA Copy");
        this->dbObj.insertTbSmartOption();
    }
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertInformationToBoardTable()
{
    unsigned short hardwareSN;
    this->securityOperation->getHardwareSN(&hardwareSN);
    this->dbObj.boardInfoObj.setBoardSerialNumber((QString("").setNum(hardwareSN)));
    this->dbObj.insertTbBoardInformation();
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertInformationToCheckDiskStageTable()
{
    //Begin insert information to check disk stage table
    if(this->dbObj.existCheckDiskStageInTable("Startup") == false)
    {
        this->dbObj.chkDskStageObj.setId(1);
        this->dbObj.chkDskStageObj.setCheckDiskStage("Startup");
        this->dbObj.insertTbCheckDiskStage();
    }

    if(this->dbObj.existCheckDiskStageInTable("Turn on") == false)
    {
        this->dbObj.chkDskStageObj.setId(2);
        this->dbObj.chkDskStageObj.setCheckDiskStage("Turn on");
        this->dbObj.insertTbCheckDiskStage();
    }

    if(this->dbObj.existCheckDiskStageInTable("Check ready disk") == false)
    {
        this->dbObj.chkDskStageObj.setId(3);
        this->dbObj.chkDskStageObj.setCheckDiskStage("Check ready disk");
        this->dbObj.insertTbCheckDiskStage();
    }

    if(this->dbObj.existCheckDiskStageInTable("Get Identification") == false)
    {
        this->dbObj.chkDskStageObj.setId(4);
        this->dbObj.chkDskStageObj.setCheckDiskStage("Get Identification");
        this->dbObj.insertTbCheckDiskStage();
    }

    if(this->dbObj.existCheckDiskStageInTable("Ready") == false)
    {
        this->dbObj.chkDskStageObj.setId(5);
        this->dbObj.chkDskStageObj.setCheckDiskStage("Ready");
        this->dbObj.insertTbCheckDiskStage();
    }
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertInformationToAbountTable()
{
    char pFwVersion[10], pDrvVersion[16];
    memset(pFwVersion, 0, 10);
    memset(pDrvVersion, 0, 16);
    this->diskIOModule.get_driver_version(pDrvVersion);

    unsigned char firmwareVersion = this->diskIOModule.get_major_minor_version_number();
    this->diskIOModule.setFirmwareVersion(firmwareVersion);
    snprintf(pFwVersion, sizeof(pFwVersion), "%u.%u ", this->diskIOModule.getFirmwareVersion() >> 4, this->diskIOModule.getFirmwareVersion() & 0x0F);
    //Begin insert information to about, board information table
    this->dbObj.aboutInfoObj.setFirmwareVersion(LCD_MODULE_RELEASE_NO);
    this->dbObj.aboutInfoObj.setVerilogVersion(QString(pFwVersion));
    this->dbObj.aboutInfoObj.setDriverVersion(QString(pDrvVersion));
    this->dbObj.aboutInfoObj.setSoftwareVersion(QString(RELEASE_NO));
    this->dbObj.insertTbAboutInformation();
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertInformationToSmartOptionInBoardTable()
{
    this->dbObj.smartOpInBoardObj.setSmartOptionId(this->dbObj.getSmartOptionIDFromSmartOptionTable(QString("NTFS")));
    this->dbObj.smartOpInBoardObj.setBoardSerial(this->dbObj.boardInfoObj.getBoardSerialNumber());
    if(this->securityOperation->checkFeatureUnlocked(FEATURE_NTFS) == 1)
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Unlock"));
    }
    else
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Lock"));
    }
    this->dbObj.insertTbSmartOptionInBoard();

    this->dbObj.smartOpInBoardObj.setSmartOptionId(this->dbObj.getSmartOptionIDFromSmartOptionTable(QString("Ext2/3/4")));
    if(this->securityOperation->checkFeatureUnlocked(FEATURE_EXT2FS) == 1)
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Unlock"));
    }
    else
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Lock"));
    }
    this->dbObj.insertTbSmartOptionInBoard();

    this->dbObj.smartOpInBoardObj.setSmartOptionId(this->dbObj.getSmartOptionIDFromSmartOptionTable(QString("DOD Wipeout")));
    if(this->securityOperation->checkFeatureUnlocked(FEATURE_WIPEOUT) == 1)
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Unlock"));
    }
    else
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Lock"));
    }
    this->dbObj.insertTbSmartOptionInBoard();

    this->dbObj.smartOpInBoardObj.setSmartOptionId(this->dbObj.getSmartOptionIDFromSmartOptionTable(QString("Partition")));
    if(this->securityOperation->checkFeatureUnlocked(FEATURE_PARTITION) == 1)
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Unlock"));
    }
    else
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Lock"));
    }
    this->dbObj.insertTbSmartOptionInBoard();

    this->dbObj.smartOpInBoardObj.setSmartOptionId(this->dbObj.getSmartOptionIDFromSmartOptionTable(QString("Sector Copy")));
    if(this->securityOperation->checkFeatureUnlocked(FEATURE_SECTORCOPY) == 1)
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Unlock"));
    }
    else
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Lock"));
    }
    this->dbObj.insertTbSmartOptionInBoard();

    this->dbObj.smartOpInBoardObj.setSmartOptionId(this->dbObj.getSmartOptionIDFromSmartOptionTable(QString("Secure Erase")));
    if(this->securityOperation->checkFeatureUnlocked(FEATURE_SCRTYERASE) == 1)
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Unlock"));
    }
    else
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Lock"));
    }
    this->dbObj.insertTbSmartOptionInBoard();

    this->dbObj.smartOpInBoardObj.setSmartOptionId(this->dbObj.getSmartOptionIDFromSmartOptionTable(QString("HPA Copy")));
    if(this->securityOperation->checkFeatureUnlocked(FEATURE_HPA) == 1)
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Unlock"));
    }
    else
    {
        this->dbObj.smartOpInBoardObj.setIsEnable(QString("Lock"));
    }
    this->dbObj.insertTbSmartOptionInBoard();
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertDiskInformationToDatabase(short diskIdx)
{
    QString temp;
    ID_DEVICE_INFOR device;
    device = this->gDriveInfo[diskIdx];
    this->dbObj.diskInfoObj[diskIdx].setSerialNumber(QString::fromUtf8(device.SerialNumber));
    this->dbObj.diskInfoObj[diskIdx].setModel(QString::fromUtf8(device.MfrName));
    if(this->gDriveType[diskIdx] == DT_PATA)
    {
        this->dbObj.diskInfoObj[diskIdx].setType(QString("PATA"));
    }
    else if(this->gDriveType[diskIdx] == DT_SATA1)
    {
        this->dbObj.diskInfoObj[diskIdx].setType(QString("SATA1"));
    }
    else if(this->gDriveType[diskIdx] == DT_SATA2)
    {
        this->dbObj.diskInfoObj[diskIdx].setType(QString("SATA2"));
    }
    else
    {
        this->dbObj.diskInfoObj[diskIdx].setType(QString("SATA3"));
    }
    this->dbObj.diskInfoObj[diskIdx].setCapacity(this->gCapacity[diskIdx]);
    this->dbObj.diskInfoObj[diskIdx].setNativeMaxAddress(this->gNativeMaxAddress[diskIdx]);
    this->dbObj.diskInfoObj[diskIdx].setTotalSector(this->gNativeMaxAddress[diskIdx]);
    this->dbObj.diskInfoObj[diskIdx].setCylinder(this->gNumCylinders[diskIdx]);
    this->dbObj.diskInfoObj[diskIdx].setHead(device.NumCurrHeads);
    this->dbObj.diskInfoObj[diskIdx].setSectorPerTract(device.NumCurrSectors);
    this->dbObj.diskInfoObj[diskIdx].setRW_Multiple(device.Flags59 & 0xff);
    if(this->gHPAFeatureSupported[diskIdx])
    {
        temp = "Yes";
    }
    else
    {
        temp = "No";
    }
    this->dbObj.diskInfoObj[diskIdx].setHPA_Support(temp);
    this->dbObj.diskInfoObj[diskIdx].setFirmwareRev(QString::fromUtf8(device.FirmwareRev));
    this->dbObj.insertTbDiskInformation(diskIdx);
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertPartitionInformationToDatabase(short diskIdx)
{
    if(this->gDriveState[diskIdx] == DRIVE_READY)
    {
        ID_DEVICE_INFOR device;
        device = this->gDriveInfo[diskIdx];
        unsigned int mbrChecksum = this->dbObj.getMBRCheckSumFromPartitionInDiskTalbe(QVariant(device.SerialNumber).toString());
        fprintf(stderr, "\n MBR checksum from database %d\n", mbrChecksum);
        if(mbrChecksum != this->diskStruct[0].mbrChecksum)
        {
            QString sysType, system;
            int partitioncount = this->diskStruct[diskIdx].partition_list.number_of_partitions;
            if(partitioncount > 0)
            {
                PARTITION_STRUCT partition;
                for (int i = 0;i < partitioncount;i++)
                {
                    // partition = this->diskStruct[diskIdx].partition_list.partition[i];
                    memcpy(&partition, &(this->diskStruct[diskIdx].partition_list.partition[i]), sizeof(PARTITION_STRUCT));
                    unsigned int start_sector = partition.start_sector;
                    unsigned int size = partition.number_of_sectors / 2048;
                    unsigned long ul_start_sector = start_sector;
                    unsigned long ul_startC = 0;
                    unsigned short us_startH = 0;
                    unsigned short us_startS = 0;
                    this->getCHSAddress(diskIdx, ul_start_sector, ul_startC, us_startH, us_startS);
                    unsigned long ul_end_sector = start_sector + partition.number_of_sectors;
                    unsigned long ul_endC = 0;
                    unsigned short us_endH = 0;
                    unsigned short us_endS = 0;
                    this->getCHSAddress(diskIdx, ul_end_sector, ul_endC, us_endH, us_endS);
                    sysType = x_actiontype(partition.partition_ID);
                    system = x_selectpartition(partition.partition_ID);

                    unsigned int idKeyFromDB = this->dbObj.getIdKeyFromPartitionInformationTable();

                    fprintf(stderr, "\n Partition number ID - key from database %d\n", idKeyFromDB);
                    this->dbObj.parInfoObj.setIdKey(idKeyFromDB + 1);
                    this->dbObj.parInfoObj.setPartitionID(partition.partition_ID);
                    this->dbObj.parInfoObj.setStartC(ul_startC);
                    this->dbObj.parInfoObj.setStartH(us_startH);
                    this->dbObj.parInfoObj.setStartS(us_startS);
                    this->dbObj.parInfoObj.setEndC(ul_endC);
                    this->dbObj.parInfoObj.setEndH(us_endH);
                    this->dbObj.parInfoObj.setEndS(us_endS);
                    this->dbObj.parInfoObj.setStartLBA(start_sector);
                    this->dbObj.parInfoObj.setPartitionType(sysType);
                    this->dbObj.parInfoObj.setPartitionSystem(system);
                    this->dbObj.parInfoObj.setPartitionLength(size);
                    this->dbObj.insertTbPartitionInformation();

                    this->dbObj.parInDiskObj.setSourceSerial(QVariant(device.SerialNumber).toString());
                    this->dbObj.parInDiskObj.setMBRChecksum(this->diskStruct[diskIdx].mbrChecksum);
                    this->dbObj.parInDiskObj.setIdKey(idKeyFromDB + 1);
                    this->dbObj.insertTbPartitionInDisk();
                }

                if((this->gHPAFeatureSupported[diskIdx]) && (this->gCapacity[diskIdx] != this->gNativeMaxAddress[diskIdx]))
                {
                    sysType = "HPA";
                    system = "HPA section";
                    unsigned int start_sector = partition.start_sector;
                    unsigned int size = this->gHPACapacity[diskIdx] / 2048;
                    unsigned long ul_start_sector = this->gNativeMaxAddress[diskIdx] - this->gHPACapacity[diskIdx], ul_startC = 0;
                    unsigned short us_startH = 0, us_startS = 0;
                    this->getCHSAddress(diskIdx, ul_start_sector, ul_startC, us_startH, us_startS);
                    start_sector = ul_start_sector;
                    unsigned long ul_end_sector = this->gNativeMaxAddress[diskIdx], ul_endC = 0;
                    unsigned short us_endH = 0, us_endS = 0;
                    this->getCHSAddress(diskIdx, ul_end_sector, ul_endC, us_endH, us_endS);

                    unsigned int idKeyFromDB = this->dbObj.getIdKeyFromPartitionInformationTable();
                    this->dbObj.parInfoObj.setIdKey(idKeyFromDB + 1);
                    this->dbObj.parInfoObj.setPartitionID(partition.partition_ID);
                    this->dbObj.parInfoObj.setStartC(ul_startC);
                    this->dbObj.parInfoObj.setStartH(us_startH);
                    this->dbObj.parInfoObj.setStartS(us_startS);
                    this->dbObj.parInfoObj.setEndC(ul_endC);
                    this->dbObj.parInfoObj.setEndH(us_endH);
                    this->dbObj.parInfoObj.setEndS(us_endS);
                    this->dbObj.parInfoObj.setStartLBA(start_sector);
                    this->dbObj.parInfoObj.setPartitionType(sysType);
                    this->dbObj.parInfoObj.setPartitionSystem(system);
                    this->dbObj.parInfoObj.setPartitionLength(size);
                    this->dbObj.insertTbPartitionInformation();

                    this->dbObj.parInDiskObj.setSourceSerial(QVariant(device.SerialNumber).toString());
                    this->dbObj.parInDiskObj.setMBRChecksum(this->diskStruct[diskIdx].mbrChecksum);
                    this->dbObj.parInDiskObj.setIdKey(idKeyFromDB + 1);
                    this->dbObj.insertTbPartitionInDisk();
                }
            }
        }
        else
        {
            fprintf(stderr, "\n MBR checksum exist in database");
        }
    }
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertCheckDiskStageToCheckDiskDetailTable(unsigned long jobId, short diskIdx, short chkDskStgId, QString result)
{
    this->dbObj.chkDskDetailObj[diskIdx].setJobId(jobId);
    this->dbObj.chkDskDetailObj[diskIdx].setDiskIndex(diskIdx);
    this->dbObj.chkDskDetailObj[diskIdx].setCheckDiskStageId(chkDskStgId - 1, chkDskStgId);
    this->dbObj.chkDskDetailObj[diskIdx].setCheckDiskStageResult(chkDskStgId - 1, result);
    //fprintf(stderr, "\n Disk[%d][%d]: Result->%s", diskIdx, chkDskStgId, result.latin1());
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::updateInformationForCheckDiskJob()
{
    QDateTime endTime = QDateTime::currentDateTime();
    unsigned long elapsedTime = endTime.toTime_t() - startTime.toTime_t();
    unsigned long hour, min, sec, tail;
    hour = elapsedTime / 3600;
    tail = elapsedTime % 3600;
    min = tail / 60;
    tail = tail % 60;
    sec = tail;
    QTime qElapsedTime(hour, min, sec, 0);
    this->dbObj.jobInfoObj.setTimeEnd(endTime);
    this->dbObj.jobInfoObj.setElapseTime(qElapsedTime);
    this->dbObj.jobInfoObj.setGenerator(this->diskIOModule.usedGen);
    this->dbObj.jobInfoObj.setTotalDataTranfer(0);
    this->dbObj.updateTbJobInformation();
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::writeCopyResultToLogFileAndDatabase()
{
    int disk_count = 0;
    unsigned int dataCopied = 0;
    unsigned int failed_count = 0;
    QDateTime dt = QDateTime::currentDateTime();
    LOG_DISK_INFO diskInfo[MAX_DISKS];
    QTime jobElapsedTime = QVariant(this->log->elapsedTime).toTime();
    this->log->generator = this->diskIOModule.usedGen;
    this->dbObj.jobInfoObj.setJobName(this->log->job_name);
    this->dbObj.jobInfoObj.setTimeEnd(dt);
    this->dbObj.jobInfoObj.setElapseTime(jobElapsedTime);
    this->dbObj.jobInfoObj.setGenerator(this->log->generator);
    this->dbObj.jobInfoObj.setSpeed(this->log->speed);
    this->dbObj.jobInfoObj.setTotalDataTranfer(this->diskIOModule.sectorCountCopied[0]);
    this->dbObj.updateTbJobInformation();
    fprintf(stderr, "\n Elapsed time %llu - Total of sectors %lu - speed %d", this->log->elapsedTime, this->diskIOModule.sectorCountCopied[0], this->log->speed);
    // Transfer mode
    if(this->diskIOModule.transfer_mode < (UDMA_MODE_MAX - 0x40 + 1))
    {
        //this->log->transfer_mode = "UDMA"+ QVariant(d105obj->systemOption.transfer_mode).toString();
        this->log->transfer_mode = "UDMA"+ QVariant(this->diskIOModule.transfer_mode).toString();     // Viet Nguyen updated, Jan 30 2008
    }
    else
    {
        //this->log->transfer_mode = "PIO"+ QVariant(d105obj->systemOption.transfer_mode - 6).toString();
        this->log->transfer_mode = "PIO"+ QVariant(this->diskIOModule.transfer_mode - (UDMA_MODE_MAX - 0x40 + 1)).toString();     // Viet Nguyen updated, Jan 30 2008
    }

    this->log->diskInfo[0].part_nr = this->diskStruct[0].partition_list.number_of_partitions;

    for (int part = 0; part < this->log->diskInfo[0].part_nr; part++)
    {
        //this->log->diskInfo[0].part_list[part].part_type = part_type(d105obj->diskStruct[0].partition_list.partition[part].partition_ID);
        this->log->diskInfo[0].part_list[part].part_type = part_type(this->diskStruct[0].partition_list.partition[part]) ;
        this->log->diskInfo[0].part_list[part].capacity = this->diskStruct[0].partition_list.partition[part].number_of_sectors / 2048;
    }// for

    diskInfo[0] = this->log->diskInfo[0];
    this->gTarget[0].enable = 1;

    for (int disk = 0; disk < MAX_DISKS; disk++)
    {
        diskInfo[disk].active = FALSE;
        this->log->diskInfo[disk].active = FALSE;

        if(this->diskStepItem[disk].result.isEmpty())
        {
            this->diskStepItem[disk].result = "Failed";
        }

        if(this->log->job_name == "DoD Wipeout")
        {
            this->log->writeToLogFile(PRI_INFO, "No add diskStepItem to diskStepList for DoD Wipeout job");
        }
        else
        {
            this->diskStepItem[disk].speed = this->dbObj.jobInfoObj.getSpeed();
            this->dbObj.resultCopyObj[disk].diskStepList.append(this->diskStepItem[disk]);
        }

        if(this->gDriveState[disk] == DRIVE_READY)
        {
            disk_count++;

            if(disk)
            {
                dataCopied += (this->diskIOModule.sectorCountCopied[disk]) / 2048;
            }

            //if(d105obj->gCopyResult[disk]!=GOOD_COPY)
            if((this->gCopyResult[disk] != GOOD_COPY) && (this->gCopyResult[disk] != GOOD_VERIFY) && (disk))
            {
                failed_count++;
            }

            diskInfo[disk].active = TRUE;
            diskInfo[disk].name = QVariant((this->gDriveInfo[disk]).MfrName).toString();
            diskInfo[disk].serial_number = QVariant((this->gDriveInfo[disk]).SerialNumber).toString();
            diskInfo[disk].status = this->Result(this->gCopyResult[disk], disk);
            diskInfo[disk].capacity = this->gNativeMaxAddress[disk] / 2048;
            this->log->diskInfo[disk] = diskInfo[disk];
        }

        this->diskIOModule.sectorCountCopied[disk] = 0;

    }// End For

    //d105obj->diskIOModule.sectorCountCopied[0] = 0;

    this->log->targetEnable = disk_count;      //Viet Nguyen updated Dec 20 2007

    this->log->dataCopied = dataCopied ;

    this->log->targetFailed = failed_count;

    QString job_info, s_drive_info;

    job_info = this->log->getJobInformationInString();
    s_drive_info = this->log->getDriveInformationInString();

    this->log->writeToLogFile(PRI_INFO, "%s%s", job_info.latin1(), s_drive_info.latin1());
    //DuongVu add code here to update to database (June 15 06)
    this->insertJobResultToDatabase(diskInfo);
    //End DuongVu
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::insertJobResultToDatabase(LOG_DISK_INFO diskInfo[MAX_DISKS])
{
    /* [{"diskindex":0,"capacity":200, "maxaddress":"234441647","UDMAmode":5,
        "PIOmode":4,"drivetype":"SATA3","jobtype":"eraseDOD","elapsedtimeforreadydisk":20,
        "erasedetail":[{"stepname":"random", "elapsedtime":20,
            "writepattern":434343},{"stepname":"NOR", "elapsedtime":30, "writepattern":434343}]}]*/
    fprintf(stderr, "--------------------------this->systemOption.verify_Mode = %d\n", this->systemOption.verify_Mode);
    qDebug() << "VERIFY MODE >>>>>>>>>>>>>>>>>" << this->systemOption.verify_Mode;
    qDebug() << "ISVERIFY >>>>>>>>>>>>>>>>>" << this->isVerified;
    qDebug() << "JOB TYPE >>>>>>>>>>>>>>>>>" << this->diskIOModule.jobId;
    qDebug() << "JOB NAME >>>>>>>>>>>>>>>>>" << this->dbObj.jobInfoObj.getJobName();
    if(this->systemOption.verify_Mode != 1) // Not check verification mode
    {
        this->isVerified = true;
    }
    if((this->isVerified == true) && (
        (this->diskIOModule.jobId == CORE_WIPE_DISK_JOB)   ||
        (this->diskIOModule.jobId == CORE_FAST_PURGE_JOB)  ||
        (this->diskIOModule.jobId == CORE_MIRROR_COPY_JOB) ||
        (this->diskIOModule.jobId == CORE_SMART_COPY_JOB)  ||
        (this->diskIOModule.jobId == CORE_TWIN_COPY_JOB)))
    {
        fprintf(stderr, "\n insertJobResultToDatabase > Create JSON To Insert To Database\n");
        JsonData jsonObj;
        QVariantMap jobMap;
        QVariantList diskMapList;
        //if (this->diskIOModule.jobId == CORE_SMART_COPY_JOB) jobMap["jobname"] = "SMART COPY" ;
        jobMap["jobname"]           = this->dbObj.jobInfoObj.getJobName();
        jobMap["jobtype"]           = this->diskIOModule.jobId;
        jobMap["transfermode"]      = this->log->transfer_mode;
        jobMap["speed"]             = this->dbObj.jobInfoObj.getSpeed();
        jobMap["transferedsectors"] = this->dbObj.jobInfoObj.getTotalDataTranfer();
        jobMap["generator"]         = this->dbObj.jobInfoObj.getGenerator();
        jobMap["enableddisks"]      = this->log->targetEnable;
        jobMap["faileddisks"]       = this->log->targetFailed;
        jobMap["starttime"]         = this->dbObj.jobInfoObj.getStartTime();
        jobMap["endtime"]           = QDateTime::currentDateTime().toString("yyyy-MM-dd HH:mm:ss");

        for(short diskIdx = 0; diskIdx < MAX_DISKS; diskIdx++)
        {
            if(diskInfo[diskIdx].active == TRUE)
            {
                QVariantList diskStepDetailMapList;
                QVariantMap diskMapItem;
                //Create disk item
                diskMapItem["diskindex"]        = diskIdx;
                diskMapItem["model"]            = this->dbObj.diskInfoObj[diskIdx].getModel();
                diskMapItem["serialnumber"]     = this->dbObj.diskInfoObj[diskIdx].getSerialNumber();
                diskMapItem["capacity"]         = this->dbObj.diskInfoObj[diskIdx].getCapacity();
                diskMapItem["maxaddress"]       = this->dbObj.diskInfoObj[diskIdx].getNativeMaxAddress();
                diskMapItem["firmwarerev"]      = this->dbObj.diskInfoObj[diskIdx].getFirmwareRev();
                diskMapItem["cylynder"]         = this->dbObj.diskInfoObj[diskIdx].getCylinder();
                diskMapItem["head"]             = this->dbObj.diskInfoObj[diskIdx].getHead();
                diskMapItem["HPAsupport"]       = this->dbObj.diskInfoObj[diskIdx].getHPA_Support();
                diskMapItem["sectorpertrack"]   = this->dbObj.diskInfoObj[diskIdx].getSectorPerTract();
                diskMapItem["disktype"]         = this->dbObj.diskInfoObj[diskIdx].getType();
                diskMapItem["UDMAmode"]         = get_udma_mode(this->gDriveInfo[diskIdx].Flags53, this->gDriveInfo[diskIdx].UltraDmaMode);;
                diskMapItem["PIOmode"]          = get_pio_mode(this->gDriveInfo[diskIdx].Flags53, this->gDriveInfo[diskIdx].PIOmodes);;
                diskMapItem["status"]           = diskInfo[diskIdx].status;
                diskMapItem["message"]          = this->dbObj.errMsgObj.getErrorMessage();

                //Create step item of disk
                for(int diskStepIdx = 0; diskStepIdx < this->dbObj.resultCopyObj[diskIdx].diskStepList.count(); diskStepIdx++)
                {
                    QVariantMap diskDetailMapItem;
                    DISK_STEP_INFO diskStepItem     = this->dbObj.resultCopyObj[diskIdx].diskStepList.at(diskStepIdx);
                    diskDetailMapItem["result"]     = diskStepItem.result;
                    diskDetailMapItem["starttime"]  = diskStepItem.startTime;
                    if(diskStepItem.startTime == "N/A"){
                        diskDetailMapItem["speed"] = 0;
                        diskDetailMapItem["elapsedtime"] = 0;
                    }
                    else{
                        if(diskStepItem.result == "Failed"){
                            diskDetailMapItem["speed"]  = this->dbObj.jobInfoObj.getSpeed();
                        }
                        else{
                            diskDetailMapItem["speed"]  = diskStepItem.speed;
                        }
                        diskDetailMapItem["elapsedtime"]    = diskStepItem.elapsedTime;
                    }
                    diskDetailMapItem["stepname"]   = diskStepItem.stepName;
                    if (this->diskIOModule.jobId != CORE_MIRROR_COPY_JOB &&
                        this->diskIOModule.jobId != CORE_SMART_COPY_JOB  &&
                        this->diskIOModule.jobId != CORE_TWIN_COPY_JOB){
                        diskDetailMapItem["writepattern"]   = (quint32)diskStepItem.writePattern;
                    }
                    //Add disk step to disk step list
                    diskStepDetailMapList.append(diskDetailMapItem);
                }
                //Add disk step detail list to disk Item
                diskMapItem["stepdetaillist"] = diskStepDetailMapList;

                //Add disk item to disk list
                diskMapList.append(diskMapItem);

                this->dbObj.resultCopyObj[diskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                this->dbObj.resultCopyObj[diskIdx].setDiskSerial(diskInfo[diskIdx].serial_number);
                this->dbObj.resultCopyObj[diskIdx].setDiskIndex((unsigned int)diskIdx);
                this->dbObj.resultCopyObj[diskIdx].setResult(diskInfo[diskIdx].status);
                this->dbObj.insertTbResultCopy(diskIdx);
            }
        }
        //Add disk map list to job map
        jobMap["disklist"] = diskMapList;
        QString jsonString = jsonObj.encodeJsonString(jobMap);
        fprintf(stderr, "Json String: %s\n", jsonString.toUtf8().data());
        DATABASE_JOB_DETAIL jobRec;
        jobRec.detailinfo = jsonString;
        jobRec.usercreate = "Machine";
        jobRec.dateupdate = QDateTime::currentDateTime();
        this->dbObj.insertTbJobDetail(&jobRec);
    }
    else
    {
        fprintf(stderr, "\n insertJobResultToDatabase > Insert To Database");
        for(short diskIdx = 0; diskIdx < MAX_DISKS; diskIdx++)
        {
            if(diskInfo[diskIdx].active == TRUE)
            {
                this->dbObj.resultCopyObj[diskIdx].setJobId(this->dbObj.jobInfoObj.getId());
                this->dbObj.resultCopyObj[diskIdx].setDiskSerial(diskInfo[diskIdx].serial_number);
                this->dbObj.resultCopyObj[diskIdx].setDiskIndex((unsigned int)diskIdx);
                this->dbObj.resultCopyObj[diskIdx].setResult(diskInfo[diskIdx].status);
                this->dbObj.insertTbResultCopy(diskIdx);
            }
        }

        //Khanh Tran
    }
}
//////////////////////////////////////////////////////////////////////////
//
QString CSystemD105::part_type(PARTITION_STRUCT part_struct)
{
    QString t = NULL;
    unsigned char i = part_struct.partition_ID;

    switch (i)
    {

    case EMPTY_PARTITION:
        t = "EMPTY";
        break;

    case UNFORMATTED_PARTITION:
        t = "Unformatted partition";
        break;

    case DOS_FAT12_PARTITION:

    case HIDDEN_DOS_FAT12_PARTITION:
        t = "FAT12";
        break;

    case WIN9X_FAT16_LBA_PARTITION:

    case DOS_FAT16_SMALLER_32MB_PARTITION:

    case DOS_FAT16_LARGER_32MB_PARTITION:

    case HIDDEN_WIN9X_FAT16_LBA_PARTITION:

    case HIDDEN_DOS_FAT16_LARGER_32MB_PARTITION:

    case HIDDEN_DOS_FAT16_SMALLER_32MB_PARTITION:
        t = "FAT16";
        break;

    case EXTENDED_PARTITION:
        t = "Extended partition";
        break;

    case IFS_PARTITION:
        t = "NTFS";
        break;

    case EXTENDED_LBA_PARTITION:
        t = "Extended LBA Partition";
        break;

    case HIDDEN_EXTENDED_PARTITION:
        t = "Hidden extended";
        break;

    case HIDDEN_IFS_PARTITION:
        t = "NTFS";
        break;

    case WIN9X_FAT32_PARTITION:

    case WIN9X_FAT32_LBA_PARTITION:

    case HIDDEN_WIN9X_FAT32_PARTITION:

    case HIDDEN_WIN9X_FAT32_LBA_PARTITION:
        t = "FAT32";
        break;

    case HIDDEN_EXTENDED_LBA_PARTITION:
        t = "Hidden extended LBA";
        break;

    case LINUX_SWAP_PARTITION:
        t = "SWAP";    //Viet Nguyen updated Oct 25 2007
        break;

    case LINUX_RAID_PARTITION:      //VietNguyen added Dec 27 2007

        if (part_struct.partition_type == PAR_TYPE_SWAP)
            t = "SWAP";
        else if (part_struct.partition_type == PAR_TYPE_EXT2_3)
            t = "RAID";

        break;

    case LINUX_NATIVE_PARTITION:
        t = "EXT";

        break;

    case LINUX_LVM_PARTITION:        // Viet Nguyen added on Apr 11 2008
        if (part_struct.partition_type == PAR_TYPE_SWAP)
            t = "SWAP";
        else if (part_struct.partition_type == PAR_TYPE_LVM)
            t = "LVM";

        break;

    case HPA_PARTITION:
        t = "HPA section";

        break;

    default:
        t = "Unknown partition";

        break;
    }

    return t;
}
//////////////////////////////////////////////////////////////////////////
//
QString CSystemD105::Result(int result, short disk)
{
    QString temp;

    if(this->systemOption.enable_smart_mirror == 0 && this->diskIOModule.jobId == CORE_MIRROR_COPY_JOB){
        if(result == DISK_SIZE_NOT_ENOUGH){
            return temp = "TGT LT SRC";//Target capacity Less Than Source capacity and not copy
        }
    }

    if(this->systemOption.enable_smart_mirror == 1 && this->diskIOModule.jobId == CORE_MIRROR_COPY_JOB){
        if(result == GOOD_COPY || result == GOOD_VERIFY){
            if(disk != 0 && this->gCapacityOrigin[disk] < this->gCapacityOrigin[0])
                return temp = "CAPACITY";//Target capacity Less Than Source capacity and copy passed
        }
    }

    switch (result)
    {

    case GOOD_COPY:
        if(this->diskIOModule.jobId == CORE_WIPE_DISK_JOB){
            if(this->systemOption.enable_dod_wipeout == 1)
            {
                return temp = "DoD Wipeout Success";
            }
            else
            {
                return temp = "Wipe Disks Success";
            }
        }else if(this->diskIOModule.jobId == CORE_FAST_PURGE_JOB){
            if(this->isFastPurge == true)
            {
                return temp = "Purge Success";
            }
            else
            {
                return temp = "Wipe Disks Success";
            }
        }
        return temp = "Good Copy";

    case GOOD_VERIFY:
        return temp = "Good Verify";

    case BAD_TEST:
        return temp = "Bad Test";

    case BAD_VERIFY:
        return temp = "Bad Verify";

    case BAD_READ:
        return temp = "Bad Read";

    case BAD_WRITE:
        return temp = "Bad Write";

    case COPY_ABORTED:
        return temp = "Copy Aborted";

    case INCOMPLETE:
        return temp = "Incomplete";

    case DISK_SIZE_NOT_ENOUGH:
        return temp = "Not Enough Space";

    case MEMORY_NOT_ENOUGH:
        return temp = "Not Enough Memory";

    case OVER_FLOW_CAPACITY:
        return temp = "Unsuccess";

    case SETUP_BOOT_LOADER_ERROR:
        return temp = "Setup boot loader unsuccessfully";

    case CANCELLED:
        return temp = "Cancelled";
    default:
        return temp = "Incomplete";
    }
}
/************************************************************************
 ********TamHo added to estimate copy time (Oct, 12, 2010)***************
 ************************************************************************/

/**************************************************************************************
  Function    : guessTimeCopy()
  Description : Guess time copy for Mirror/Smart copy
  Input       : None
  OutPut      : hourMirror, minMirror, secMirror ; hourSmart, minSmart, secSmart
***************************************************************************************/
void CSystemD105::guessTimeCopy()
{
    int hourMirror, minMirror, secMirror;
    int hourSmart, minSmart, secSmart;
    int hourCalTime, minCalTime, secCalTime;

    unsigned int Exec_Time;
    unsigned int timeElapsed;

    this->isFinishCalTimeCopy   = false;
    this->continueCopy          = false;

    QDateTime date_time = QDateTime::currentDateTime();
    Exec_Time = date_time.toTime_t();

    unsigned long capacity = this->getNativeMaxAddTarget();

    unsigned long timeElapsedMirror = 0;
    unsigned long timeElapsedSmart  = 0;

    if(this->calTimeCopyType == 1)
    {
        printDFXLog (PRI_INFO, "Begin to estimate time for mirror copy");
        this->setMirrorCopy();
        this->initializeCopy();
        printDFXLog (PRI_INFO, "Begin to estimate time for mirror copy");
        timeElapsedMirror =  this->avgTimeMirrorCopyHDD(capacity);
    }
    else if(this->calTimeCopyType == 2)
    {
        this->setSmartCopy();
        this->initializeCopy();
        timeElapsedSmart =  this->avgTimeSmartCopyHDD();
    }
    else if(this->userCopyMode == DISK_TEST)
    {
        printDFXLog (PRI_INFO, "Begin to estimate time for test disk");
        this->setTestCopy();
        this->initializeCopy();
        timeElapsedMirror =  this->avgTimeMirrorCopyHDD(capacity);
    }
    else if(this->userCopyMode == DISK_WIPE)
    {
        printDFXLog (PRI_INFO, "Begin to estimate time for wipe copy");
        this->setWipeCopy();
        this->initializeCopy();
        timeElapsedMirror =  this->avgTimeMirrorCopyHDD(capacity);
    }
    else
    {
        printDFXLog (PRI_INFO, "Begin to estimate time for mirror copy");
        this->setMirrorCopy();
        this->initializeCopy();
        timeElapsedMirror =  this->avgTimeMirrorCopyHDD(capacity);

        this->setSmartCopy();
        this->initializeCopy();
        timeElapsedSmart =  this->avgTimeSmartCopyHDD();
    }

    hourMirror =  timeElapsedMirror / 3600;
    minMirror  =  (timeElapsedMirror % 3600) / 60;
    secMirror  =  (timeElapsedMirror % 3600) % 60;

    hourSmart =  timeElapsedSmart / 3600;
    minSmart  =  (timeElapsedSmart % 3600) / 60;
    secSmart  =  (timeElapsedSmart % 3600) % 60;

    QDateTime dt = QDateTime::currentDateTime();
    timeElapsed = dt.toTime_t() - Exec_Time;

    hourCalTime =  timeElapsed / 3600;
    minCalTime  =  (timeElapsed % 3600) / 60;
    secCalTime  =  (timeElapsed % 3600) % 60;

    this->timeSmart.sprintf("%02dh:%02dm:%02ds", hourSmart, minSmart, secSmart);
    this->timeMirror.sprintf("%02dh:%02dm:%02ds", hourMirror, minMirror, secMirror);
    this->timeCalTime.sprintf("%02dh:%02dm:%02ds", hourCalTime, minCalTime, secCalTime);

    this->setIsCalTimeCopy(false);
    this->isFinishCalTimeCopy   = true;
}
/**************************************************************************************
  Function    : avgTimeMirrorCopyHDD()
  Description : Calculate time copy for Mirror copy /Test Disk / Wipe Disk
  Input       : None
  OutPut      : time for Mirror copy in second
***************************************************************************************/
unsigned long CSystemD105::avgTimeMirrorCopyHDD(unsigned long numOfSecs)
{
    double 			result                  = 0;
    double 			totaTimeGetTemplate   	= 0;		//Total time get template in ms
    unsigned long 	sectorCountCopied 		= 0;
    unsigned long 	sectorCountCopiedOld 		= 0;
    unsigned long 	secPerStep 			= 0;
    unsigned long   step = 1;
    float nTemplate ;
    unsigned long templatePerStep = 0;
    if(numOfSecs > 625142448 ) //Native Max Address > 320 GB
    {
        nTemplate = TEMPLATE_MIRROR_MAX;
        templatePerStep = 1000;
    }
    else if(numOfSecs > 20971020) //Native Max Address > 10 GB
    {
        nTemplate = TEMPLATE_MIRROR_MIN;
        templatePerStep = 500;
    }
    else
    {
        nTemplate = (numOfSecs * 10 / 100) / MAX_SECTOR_COUNT_ONE_TRANFERS;
        templatePerStep = 100;
    }

    
    if(nTemplate > templatePerStep)
    {
        secPerStep = (unsigned long)(numOfSecs / (nTemplate / templatePerStep)) ; //khoang cach giua cac mau
    }

    unsigned long stepCount = (unsigned long)(nTemplate / templatePerStep);
    for(unsigned long i = 1; i <= nTemplate; i++)
    {
        if(this->isCancelCalTimeCopy == true)
        {
            this->restoreCopyMode();
            this->mode_S_E = 2;
            return UNSUCCESS;
        }

        QTime date_time;
        date_time.start();

        this->standbyHandleCopy();
        unsigned int timeElapsed = date_time.elapsed();

        //fprintf(stderr, "\n Template[%d] => Elapsed time get template: %d\n", i, timeElapsed);
        if(this->diskIOModule.transfer_mode >= UDMA_MODE_MIN)
        {
            if((step > 1 && i == templatePerStep * step + 1) || timeElapsed > 100)
            {
                timeElapsed = 2;
            }
        }

        totaTimeGetTemplate += timeElapsed;

        if(i == (templatePerStep * step)  && stepCount != 0)
        {
            sectorCountCopied = this->getSectorCountCopied();
            this->addStepBetweenTemplate(secPerStep, sectorCountCopied - sectorCountCopiedOld);
            result += ((totaTimeGetTemplate /1000) * secPerStep) /(sectorCountCopied - sectorCountCopiedOld);
            if(step == (unsigned long)(nTemplate / templatePerStep))
            {
                result += (numOfSecs - secPerStep * step) * (totaTimeGetTemplate / (sectorCountCopied - sectorCountCopiedOld)) / 1000;
            }

            //fprintf(stderr, "\n Max Capacity--> %lu    Sectors per step --> %lu ", numOfSecs, secPerStep);
            //fprintf(stderr, "\n Sector count copied--> %lu    Sector count copied old --> %lu ", sectorCountCopied, sectorCountCopiedOld);
            //fprintf(stderr, "\n Step [ %d]: Time Get Template-->%f (s)   Time Copy Current-->%f (s)", j , totaTimeGetTemplate /1000, result);
            sectorCountCopiedOld = sectorCountCopied;
            totaTimeGetTemplate = 0;
            step++;
            if(step > stepCount)
            {
                break;
            }
        }
    }

    if(stepCount == 0)
    {
        sectorCountCopied = this->getSectorCountCopied();
        result += (secPerStep * (totaTimeGetTemplate / sectorCountCopied) / 1000);
        //fprintf(stderr, "\n Max Capacity--> %lu    Sectors per step --> %lu ", numOfSecs, secPerStep);
    }
    this->setFinishTask();

    if(numOfSecs > 625142448 ) //Native Max Address > 300000 (320G)
    {
        result -= (7 * result / 200); //tru ket qua du doan di 3.5%
    }
    else
    {
        result -= (5 * result / 200); //tru ket qua du doan di 2.5%
    }
    //fprintf(stderr, "\n Ket qua cuoi cung %lu", result);
    return (unsigned long)result;
}
/**************************************************************************************
  Function    : avgTimeSmartCopyHDD()
  Description : Calculate time copy for Smart copy
  Input       : None
  OutPut      : time for Smart copy in second
***************************************************************************************/
unsigned long CSystemD105::avgTimeSmartCopyHDD()
{
    unsigned long result = 0;
    double        timeTemplate, oddTimeForFAT32 = 0;                     //total time get template in ms
    short         parIndex = 0;

    unsigned long timePar[this->diskStruct[0].partition_list.number_of_partitions];    //avarage time copy partitions in s

    for(parIndex = 0; parIndex < this->diskStruct[0].partition_list.number_of_partitions; parIndex++)
    {
        if (this->gTaskList[currentTask].action != NULL_PAR && this->gTaskList[currentTask].action != MIRROR_PAR)
        {
            if(gTaskList[currentTask].action == FAT_32_PAR_SMART)
            {
                printDFXLog (PRI_INFO, "Begin to estimate time for FAT32 smart copy");
            }
            else if(gTaskList[currentTask].action == NTFS_PAR)
            {
                printDFXLog (PRI_INFO, "Begin to estimate time for NTFS smart copy");
            }
            else if(gTaskList[currentTask].action == EXT2_PAR_SMART)
            {
                printDFXLog (PRI_INFO, "Begin to estimate time for EXTX smart copy");
            }
            partitionTemp = this->diskStruct[0].partition_list.partition[parIndex];
            timeTemplate 		= 0;
            timePar[parIndex]      	= 0;

            int nTemplate 		= TEMPLATE_SMART_MIN;

            for(int i = 0 ; i < nTemplate; i++)
            {
                if(this->isCancelCalTimeCopy == true)
                {
                    this->restoreCopyMode();
                    this->mode_S_E = 2;
                    return 0;
                }

                QTime date_time;

                date_time.start();
                this->standbyHandleCopy();
                unsigned int timeElapsed = date_time.elapsed();
                //fprintf(stderr, "\n Template[ %d]--->Esclap time %lu", i, timeElapsed);
                //If copy in mirror => nTemplate = 10
                if(this->gExt2Smart != NULL && this->gExt2Smart->isCopyInSameCapacity() == true)
                {
                    nTemplate = TEMPLATE_SMART_IN_MIRROR;
                }

                //If partition was NTFS partition
                else if(this->gNtfsCopy != NULL)
                {
                    i = nTemplate - 1;
                }

                if(gTaskList[currentTask].action == FAT_32_PAR_SMART)
                {
                    if(i == 0)
                    {
                        //fprintf(stderr, "\n Esclap odd time %lu", i, timeElapsed);
                        oddTimeForFAT32 = timeElapsed;
                    }
                }

                timeTemplate  += timeElapsed;

                if((i == nTemplate - 1) && this->getSectorCountCopied() == 0 && this->isFinishCopyData() == false)
                {
                    nTemplate += TEMPLATE_SMART_MIN;
                }
                if(i == (nTemplate - 1) || this->isFinishCopyData() == true)
                {
                    //fprintf(stderr, "\n Begin: Compute time smart copy");
                    ACTION_TYPE action = gTaskList[currentTask].action;

                    if(action == EXT2_PAR_SMART)
                    {
                        //Compute total time copy partition
                        unsigned long estimateCopyTimeTotal = this->gExt2Smart->estimateCopyTimeTotal();

                        timePar[parIndex] = estimateCopyTimeTotal;
                        //fprintf(stderr, "\n Avarage Time Copy Partition-->%lu", timePar[parIndex]);
                    }
                    else if(action == FAT_32_PAR_SMART)
                    {
                        //fprintf(stderr, "\n Getting template for copy FAT_PAR");
                        unsigned long sectorCountCopy =  this->getSectorCountCopy();
                        unsigned long sectorCountCopied = this->getSectorCountCopied();

                        //fprintf(stderr, "\n Sector count copy-->%lu", sectorCountCopy);
                        //fprintf(stderr, "\n Sector count copied-->%lu", sectorCountCopied);
                        //fprintf(stderr, "\n Time get template-->%f", timeTemplate);

                        if(sectorCountCopied != 0)
                        {
                            timePar[parIndex] = (unsigned long)(sectorCountCopy *((timeTemplate - oddTimeForFAT32)/ sectorCountCopied) / 1000);
                        }
                        else
                        {
                            timePar[parIndex] = 0;
                        }
                        timePar[parIndex] += (unsigned long)(oddTimeForFAT32 / 1000);
                        //fprintf(stderr, "\n Avarage Time Copy Partition-->%lu", timePar[parIndex]);
                    }
                    else if(action == NTFS_PAR_SOURCE_SMALLER_TARGET)
                    {
                        //fprintf(stderr, "\n Getting template for copy NTFS_PAR");
                        unsigned long sectorCountCopy =  this->getSectorCountCopy();
                        unsigned long sectorCountCopied = this->getSectorCountCopied();

                        //fprintf(stderr, "\n Sector count copy-->%lu", sectorCountCopy);
                        //fprintf(stderr, "\n Sector count copied-->%lu", sectorCountCopied);
                        //fprintf(stderr, "\n Time get template-->%f", timeTemplate);

                        timePar[parIndex] = (unsigned long)(sectorCountCopy * (timeTemplate / sectorCountCopied) / 1000);
                        //fprintf(stderr, "\n Avarage Time Copy Partition-->%lu", timePar[parIndex]);
                    }
                    this->setFinishTask();
                    break;
                }
            }
        }
        else if(this->gTaskList[currentTask].action == MIRROR_PAR)
        {
            printDFXLog (PRI_INFO, "Begin to estimate time for mirror copy");
            //fprintf(stderr, "\n Begin: Compute time mirror copy");
            timePar[parIndex] = this->avgTimeMirrorCopyHDD(this->diskStruct[0].partition_list.partition[parIndex].number_of_sectors);
            //fprintf(stderr, "\n Avarage Time Copy Partition-->%lu", timePar[parIndex]);
        }
    }

    for(parIndex = 0; parIndex < this->diskStruct[0].partition_list.number_of_partitions; parIndex++)
    {
        result += timePar[parIndex];
    }

    return result;
}
/**************************************************************************************
  Function    : setMirrorCopyMode()
  Description : Set mode copy is MirrorCopy
  Input       : None
  OutPut      : None
***************************************************************************************/
void CSystemD105::setMirrorCopyMode()
{
    this->continueCopy  = true;
    this->setMirrorCopy();
    this->initializeCopy();
}
/**************************************************************************************
  Function    : setSmartCopyMode()
  Description : Set mode copy is SmartCopy
  Input       : None
  OutPut      : None
***************************************************************************************/
void CSystemD105::setSmartCopyMode()
{
    this->continueCopy  = true;
    this->setSmartCopy();
    this->initializeCopy();
}
/**************************************************************************************
  Function    : restoreCopyMode()
  Description : Restore mode copy to original mode that user chosen
  Input       : None
  OutPut      : None
***************************************************************************************/
void CSystemD105::restoreCopyMode()
{
    if(this->userCopyMode == DISK_SMART)
    {
        this->setSmartCopy();
        this->mode_S_E = 2;
        // this->initializeCopy();
    }
    else if(this->userCopyMode == DISK_MIRROR)
    {
        this->setMirrorCopy();
        this->mode_S_E = 2;
        //this->initializeCopy();
    }
    else if(this->userCopyMode == DISK_TEST)
    {
        this->setTestCopy();
        this->mode_S_E = 2;
        //this->initializeCopy();
    }
    else
    {
        this->setWipeCopy();
        this->mode_S_E = 2;
        // this->initializeCopy();
    }

    this->setIsCalTimeCopy(false);
}
/**************************************************************************************
  Function    : setMirrorCopy()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
void  CSystemD105::setMirrorCopy()
{
    //fprintf(stderr, "\nSetup MIRROR copy....\n");
    this->BUILD_IN_MODE = 0 ;
    this->diskIOModule.clearSectorCountCopied();

    //JOB_STRUCT qtemp;
    this->log->job_name = "Mirror Copy";
    for (int i = 0;i < MAX_DISKS ;i++)
    {
        this->gTarget[i].enable = 1;
        this->gTarget[i].disk_mode = DISK_MIRROR;
    }

    //this->user_option = 0;
    this->setresult();
}
/**************************************************************************************
  Function    : setSmartCopy()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
void  CSystemD105::setSmartCopy()
{
    //fprintf(stderr, "\nSetup SMART copy....\n");
    this->BUILD_IN_MODE = 0 ;
    this->diskIOModule.clearSectorCountCopied();

    //JOB_STRUCT qtemp;

    this->log->job_name = "Smart Copy";
    for (int i = 0;i < MAX_DISKS ;i++)
    {
        this->gTarget[i].enable = 1;
        this->gTarget[i].disk_mode = DISK_SMART;
    }

    //this->user_option = 0;
    this->setresult();
}
/**************************************************************************************
  Function    : setTestCopy()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
void  CSystemD105::setTestCopy()
{
    //fprintf(stderr, "\nSetup TEST Copy....\n");
    this->log->job_name = "Test Copy";
    this->BUILD_IN_MODE = 0 ;
    this->diskIOModule.clearSectorCountCopied();
    //this->user_option = 0;
    this->setresult();
}
/**************************************************************************************
  Function    : setWipeCopy()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
void  CSystemD105::setWipeCopy()
{
    //fprintf(stderr, "\nSetup WIPE Copy....\n");
    this->log->job_name = "Wipe Copy";
    this->BUILD_IN_MODE = 0 ;
    this->diskIOModule.clearSectorCountCopied();
    //this->user_option = 0;
    this->setresult();
}
/**************************************************************************************
  Function    : jobstruct_standard()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
JOB_STRUCT CSystemD105::jobstruct_standard(short ena, DISK_MODE mode, short clear, short test)
{
    JOB_STRUCT q;
    q.standardOption = 1;
    q.enable = ena;
    q.disk_mode = mode;
    q.clearMode = clear;
    q.testMode = test;
    return q;
}
/**************************************************************************************
  Function    : setFinishTask()
  Description : Set TASK_FINISH_COPY flag when complete one task.
  Input       : None
  OutPut      : None
***************************************************************************************/
void CSystemD105::setFinishTask()
{
    gTaskList[currentTask].state = TASK_FINISH_COPY;
    for(short i = 0; i< 2; i++)
    {
        this->standbyHandleCopy();
    }
    printDFXLog (PRI_INFO, "Finish for estimating");
}
/**************************************************************************************
  Function    : getSectorCountCopied()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
unsigned long CSystemD105::getSectorCountCopied()
{
    switch (gTaskList[currentTask].action)
    {
    case FAT_32_PAR_SMART:
        return this->gFAT32Smart->getSectorCountCopied();

    case EXT2_PAR_SMART:
        return this->gExt2Smart->getDataBlockCopied();

    case NTFS_PAR_SOURCE_SMALLER_TARGET:
        return this->gNtfsCopy->getSectorCountCopied();

    case MIRROR_PAR:
        return this->gMirrorOperation->getNumberSectorCopy();

    case CLEAR_PAR:
        return this->gMirrorOperation->getNumberSectorCopy();

    case FAST_PURGE_PAR:
        return this->gFASTPurgeOperation->getNumberSectorCopy();

    case TEST_PAR:
        return this->gTestDiskOperation->getSectorCountCopied();

    default:
        return 0;
    }
}
/**************************************************************************************
  Function    : getSectorCountCopy()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
unsigned long CSystemD105::getSectorCountCopy()
{
    switch (gTaskList[currentTask].action)
    {
    case FAT_32_PAR_SMART:
        return gFAT32Smart->getSectorCountCopy();

    case EXT2_PAR_SMART:
        return gExt2Smart->getDataBlockCopy();

    case NTFS_PAR_SOURCE_SMALLER_TARGET:
        return gNtfsCopy->getSectorCountCopy();

    case MIRROR_PAR:
        //return gMirrorOperation->getTotalSector(0);

    default:
        return 0;
    }
}
/**************************************************************************************
  Function    : getNativeMaxAddTarget()
  Description : Get max LBA address of targets.
  Input       : None
  OutPut      : Max NativeAddress of targets
***************************************************************************************/
unsigned long CSystemD105::getNativeMaxAddTarget()
{
    unsigned long sourAdd = this->gNativeMaxAddress[0];
    unsigned long tagAddMax = 0x00000000;
    for (short disk = 1;disk < MAX_DISKS;disk++)
    {
        if (gTaskList[currentTask].target.item[disk])
        {
            if (tagAddMax < this->gNativeMaxAddress[disk])
            {
                tagAddMax = this->gNativeMaxAddress[disk];
                //fprintf(stderr, "\n Target[ %d] Max Address--> %lu",disk, this->gNativeMaxAddress[disk]);
            }
        }
    }

    if(this->userCopyMode == DISK_TEST || this->userCopyMode == DISK_WIPE)
    {
        return tagAddMax;
    }
    else if(tagAddMax < sourAdd )
    {
        return tagAddMax;
    }

    return sourAdd;
}
/**************************************************************************************
  Function    : isFinishCopyData()
  Description : Finished get template on a task
  Input       : None
  OutPut      : return TRUE if finish, else return false
***************************************************************************************/
bool CSystemD105::isFinishCopyData()
{
    if((gExt2Smart != NULL && gExt2Smart->isFinishCopy() == true) ||
            (gMirrorOperation != NULL && gMirrorOperation->isFinishCopy() == true) ||
            (gFAT32Smart != NULL && gFAT32Smart->isFinishCopy() == true) ||
            (gNtfsCopy != NULL && gNtfsCopy->isFinish == true))
    {
        return true;
    }
    return false;
}
/**************************************************************************************
  Function    : addStepBetweenTemplate()
  Description : Plus discount between templates
  Input       : None
  OutPut      : None
***************************************************************************************/
void CSystemD105::addStepBetweenTemplate(unsigned long step, unsigned long copiedTemplate)
{
    if(this->gMirrorOperation != NULL)
    {
        this->gMirrorOperation->addDisTemplate(step, copiedTemplate);
    }
    if(this->gTestDiskOperation != NULL)
    {
        this->gTestDiskOperation->addDisTemplate(step);
    }
}
/**************************************************************************************
  Function    : setIsCalTimeCopy()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
void CSystemD105::setIsCalTimeCopy(bool flag)
{
    this->isCalTimeCopy = flag;
}
/**************************************************************************************
  Function    : getJobName()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
QString CSystemD105::getJobName()
{
    return this->log->job_name;
}
/**************************************************************************************
  Function    : setBriefCopy()
  Description :
  Input       : None
  OutPut      : None
***************************************************************************************/
void CSystemD105::setBriefCopy(bool status)
{
    this->isBriefCopy = status;
}
//////////////////////////////////////////////////////////////////////////
//
void CSystemD105::setCurrentElapseTimeCopy(QString currentElapseTime)
{
    this->currentElapseTimeCopy = currentElapseTime;
}
//////////////////////////////////////////////////////////////////////////
//
QString CSystemD105::getCurrentElapseTimeCopy()
{
    return this->currentElapseTimeCopy;
}
